/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.DeleteTransformer;
import org.netbeans.modules.refactoring.java.plugins.OverriddenAbsMethodFinder;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class SafeDeleteRefactoringPlugin
extends JavaRefactoringPlugin {
    private SafeDeleteRefactoring refactoring;
    private WhereUsedQuery[] whereUsedQueries;
    private static final String DOT = ".";
    private static final String JAVA_EXTENSION = "java";
    private ArrayList<TreePathHandle> grips = new ArrayList();

    public SafeDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        RefactoringSession inner = RefactoringSession.create((String)"delete");
        ArrayList<ElementGrip> abstractMethHandles = new ArrayList<ElementGrip>();
        HashSet<Object> refactoredObjects = new HashSet<Object>();
        Collection<? extends FileObject> files = this.lookupJavaFileObjects();
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            Object refactoredObject = this.whereUsedQueries[i].getRefactoringSource().lookup(Object.class);
            refactoredObjects.add(refactoredObject);
            this.whereUsedQueries[i].prepare(inner);
            TreePathHandle treePathHandle = this.grips.get(i);
            if (Tree.Kind.METHOD == treePathHandle.getKind()) {
                JavaSource javaSrc = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
                try {
                    javaSrc.runUserActionTask((Task)new OverriddenAbsMethodFinder(treePathHandle, abstractMethHandles), true);
                }
                catch (IOException ioException) {
                    ErrorManager.getDefault().notify(this.cancelRequest ? 1 : 0, (Throwable)ioException);
                }
            }
            if (!files.contains(treePathHandle.getFileObject())) {
                JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, new DeleteTransformer(), this.grips.get(i));
                Problem problem = this.createAndAddElements(Collections.singleton(this.grips.get(i).getFileObject()), task, refactoringElements, (AbstractRefactoring)this.refactoring);
                if (problem != null) {
                    this.fireProgressListenerStop();
                    return problem;
                }
            }
            this.fireProgressListenerStep();
        }
        Problem problemFromWhereUsed = null;
        Problem problemImplemented = null;
        for (RefactoringElement refacElem : inner.getRefactoringElements()) {
            final ElementGrip elem = (ElementGrip)refacElem.getLookup().lookup(ElementGrip.class);
            if (files.contains(refacElem.getParentFile()) || SafeDeleteRefactoringPlugin.isPendingDelete(elem, refactoredObjects)) continue;
            final AtomicBoolean override = new AtomicBoolean(false);
            if (elem != null) {
                JavaSource src = JavaSource.forFileObject((FileObject)elem.getFileObject());
                try {
                    src.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.PARSED);
                            TreePath resolve = elem.getHandle().resolve((CompilationInfo)parameter);
                            if (resolve.getLeaf().getKind() == Tree.Kind.METHOD) {
                                MethodTree method = (MethodTree)resolve.getLeaf();
                                List<? extends AnnotationTree> annotations = method.getModifiers().getAnnotations();
                                boolean hasOverride = false;
                                for (AnnotationTree annotationTree : annotations) {
                                    if (!annotationTree.toString().equals("@Override()")) continue;
                                    hasOverride = true;
                                }
                                if (!hasOverride) {
                                    override.set(true);
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (override.get()) {
                problemImplemented = new Problem(false, SafeDeleteRefactoringPlugin.getString("WRN_ImplementsFound"), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen(new WhereUsedQueryUI(elem != null ? elem.getHandle() : null, this.getWhereUsedItemNames(), (AbstractRefactoring)this.refactoring), inner)));
                break;
            }
            problemFromWhereUsed = new Problem(false, SafeDeleteRefactoringPlugin.getString("ERR_ReferencesFound"), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen(new WhereUsedQueryUI(elem != null ? elem.getHandle() : null, this.getWhereUsedItemNames(), (AbstractRefactoring)this.refactoring), inner)));
            break;
        }
        if (problemFromWhereUsed != null && problemImplemented != null) {
            problemFromWhereUsed.setNext(problemImplemented);
        } else if (problemImplemented != null) {
            problemFromWhereUsed = problemImplemented;
        }
        for (ElementGrip absMethodGrip : abstractMethHandles) {
            if (SafeDeleteRefactoringPlugin.isPendingDelete(absMethodGrip, refactoredObjects)) continue;
            Problem probAbsMethod = new Problem(false, SafeDeleteRefactoringPlugin.getParameterizedString("ERR_OverridesAbstractMethod", SafeDeleteRefactoringPlugin.getMethodName(absMethodGrip.getHandle())));
            if (problemFromWhereUsed != null) {
                problemFromWhereUsed.setNext(probAbsMethod);
                break;
            }
            problemFromWhereUsed = probAbsMethod;
            break;
        }
        if (problemFromWhereUsed != null) {
            this.fireProgressListenerStop();
            return problemFromWhereUsed;
        }
        ArrayList importStmts = new ArrayList();
        if (importStmts.size() > 0) {
            for (RefactoringElementImplementation refacElem : importStmts) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, refacElem);
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    private String getWhereUsedItemNames() {
        final StringBuilder b = new StringBuilder();
        for (final TreePathHandle handle : this.grips) {
            try {
                JavaSource.forFileObject((FileObject)handle.getFileObject()).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (b.length() > 0) {
                            b.append(", ");
                        }
                        b.append(handle.resolveElement((CompilationInfo)parameter).getSimpleName());
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return b.toString();
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Problem checkParameters() {
        void var2_6;
        this.grips.clear();
        for (FileObject fileObject : this.lookupJavaFileObjects()) {
            JavaSource source = JavaSource.forFileObject((FileObject)fileObject);
            if (source == null) continue;
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController co) throws Exception {
                        co.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree cut = co.getCompilationUnit();
                        for (Tree tree : cut.getTypeDecls()) {
                            TreePathHandle handle = TreePathHandle.create((TreePath)TreePath.getPath(cut, tree), (CompilationInfo)co);
                            if (SafeDeleteRefactoringPlugin.this.containsHandle(handle, (CompilationInfo)co)) continue;
                            SafeDeleteRefactoringPlugin.this.grips.add(handle);
                        }
                    }
                }, true);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.grips.addAll(this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        this.whereUsedQueries = new WhereUsedQuery[this.grips.size()];
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            this.whereUsedQueries[i] = this.createQuery(this.grips.get(i));
            this.whereUsedQueries[i].putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.refactoring.isCheckInComments());
            if (!Tree.Kind.METHOD.equals((Object)this.grips.get(i).getKind())) continue;
            this.whereUsedQueries[i].putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)true);
        }
        Problem problemFromUsage = null;
        boolean bl = false;
        while (var2_6 < this.whereUsedQueries.length) {
            problemFromUsage = this.whereUsedQueries[var2_6].checkParameters();
            if (problemFromUsage != null) {
                return problemFromUsage;
            }
            ++var2_6;
        }
        return null;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return null;
    }

    private boolean containsHandle(TreePathHandle handle, CompilationInfo info) {
        Element wanted = handle.resolveElement(info);
        for (TreePathHandle current : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            if (wanted != current.resolveElement(info)) continue;
            return true;
        }
        return false;
    }

    private WhereUsedQuery createQuery(TreePathHandle tph) {
        WhereUsedQuery q = new WhereUsedQuery(Lookups.singleton((Object)tph));
        for (Object o : this.refactoring.getContext().lookupAll(Object.class)) {
            q.getContext().add(o);
        }
        q.getContext().add((Object)this.refactoring);
        q.getContext().add((Object)this);
        return q;
    }

    private Collection<? extends FileObject> lookupJavaFileObjects() {
        Lookup lkp = this.refactoring.getRefactoringSource();
        Collection<FileObject> javaFiles = null;
        NonRecursiveFolder folder = (NonRecursiveFolder)lkp.lookup(NonRecursiveFolder.class);
        if (folder != null) {
            javaFiles = SafeDeleteRefactoringPlugin.getJavaFileObjects(folder.getFolder(), false);
        } else {
            ArrayList<FileObject> javaFileObjects = new ArrayList<FileObject>();
            for (FileObject fileObject : lkp.lookupAll(FileObject.class)) {
                if (fileObject.isFolder()) {
                    javaFileObjects.addAll(SafeDeleteRefactoringPlugin.getJavaFileObjects(fileObject, true));
                    continue;
                }
                if (!RetoucheUtils.isRefactorable(fileObject)) continue;
                javaFileObjects.add(fileObject);
            }
            javaFiles = javaFileObjects;
        }
        return javaFiles;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)key);
    }

    private static boolean isPendingDelete(ElementGrip elementGrip, Set<Object> refactoredObjects) {
        ElementGrip parent = elementGrip;
        if (parent != null) {
            do {
                if (!refactoredObjects.contains(parent.getHandle())) continue;
                return true;
            } while ((parent = parent.getParent()) != null);
        }
        return false;
    }

    private static String getParameterizedString(String key, Object parameter) {
        return NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)key, (Object)parameter);
    }

    private static String getMethodName(final TreePathHandle methodHandle) {
        JavaSource javaSrc = JavaSource.forFileObject((FileObject)methodHandle.getFileObject());
        final String[] methodNameString = new String[1];
        try {
            javaSrc.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    ExecutableElement execElem = (ExecutableElement)methodHandle.resolveElement((CompilationInfo)compilationController);
                    TypeElement type = (TypeElement)execElem.getEnclosingElement();
                    methodNameString[0] = type.getQualifiedName() + SafeDeleteRefactoringPlugin.DOT + execElem.toString();
                }
            }, true);
        }
        catch (IOException ioException) {
            ErrorManager.getDefault().notify((Throwable)ioException);
        }
        return methodNameString[0];
    }

    private static Collection<FileObject> getJavaFileObjects(FileObject dirFileObject, boolean isRecursive) {
        ArrayList<FileObject> javaSrcFiles = new ArrayList<FileObject>();
        SafeDeleteRefactoringPlugin.addSourcesInDir(dirFileObject, isRecursive, javaSrcFiles);
        return javaSrcFiles;
    }

    private static void addSourcesInDir(FileObject dirFileObject, boolean isRecursive, Collection<FileObject> javaSrcFiles) {
        for (FileObject childFileObject : dirFileObject.getChildren()) {
            if (childFileObject.isData() && JAVA_EXTENSION.equalsIgnoreCase(childFileObject.getExt())) {
                javaSrcFiles.add(childFileObject);
                continue;
            }
            if (!childFileObject.isFolder() || !isRecursive) continue;
            SafeDeleteRefactoringPlugin.addSourcesInDir(childFileObject, true, javaSrcFiles);
        }
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI ui, RefactoringSession rs) {
            this.ui = ui;
            this.rs = rs;
        }

        public void showDetails(Action callback, Cancellable parent) {
            parent.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)callback);
        }

        public String getDetailsHint() {
            return SafeDeleteRefactoringPlugin.getString("LBL_ShowUsages");
        }
    }
}

