/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.Pair;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.InlineAbstractTransformer;
import org.netbeans.modules.refactoring.java.plugins.InlineRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.OperatorPrecedence;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.util.NbBundle;

public class InlineMethodTransformer
extends RefactoringVisitor {
    private Trees trees;
    private BlockTree body;
    private MethodTree methodTree;
    private Tree returnType;
    private boolean hasReturn;
    private boolean hasParameters;
    private IdentityHashMap<Tree, Tree> changes = new IdentityHashMap();
    private boolean initialized = false;
    private InlineAbstractTransformer imtv;
    private Problem problem;

    @Override
    public Tree scan(Tree tree, Element p) {
        if (!this.initialized) {
            this.initialized = true;
            this.trees = this.workingCopy.getTrees();
            this.methodTree = (MethodTree)this.trees.getTree(p);
            this.returnType = this.methodTree.getReturnType();
            this.hasReturn = true;
            if (this.returnType.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && ((PrimitiveTypeTree)this.returnType).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
                this.hasReturn = false;
            }
            this.hasParameters = this.methodTree.getParameters().size() > 0;
            this.imtv = new InlineAbstractTransformer(this.make){

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected List<StatementTree> replaceStatement(StatementTree statementTree, ExpressionTree node, boolean needBlock) {
                    LinkedList<StatementTree> newStatementList = new LinkedList<StatementTree>();
                    if (InlineMethodTransformer.this.hasReturn) {
                        for (int i = 0; i < InlineMethodTransformer.this.body.getStatements().size() - 1; ++i) {
                            newStatementList.add(InlineMethodTransformer.this.body.getStatements().get(i));
                        }
                        switch (statementTree.getKind()) {
                            case ASSERT: {
                                void var6_12;
                                ExpressionTree assertDetail;
                                AssertTree assertTree = (AssertTree)statementTree;
                                ExpressionTree expressionTree = assertTree.getCondition();
                                if (expressionTree != null) {
                                    if (expressionTree.equals(node)) {
                                        ExpressionTree expressionTree2 = this.replaceExpression(expressionTree);
                                    } else {
                                        ExpressionTree expressionTree3 = this.replacesExpression(expressionTree, node);
                                    }
                                }
                                if ((assertDetail = assertTree.getDetail()) != null) {
                                    assertDetail = assertDetail.equals(node) ? this.replaceExpression(assertDetail) : this.replacesExpression(assertDetail, node);
                                }
                                newStatementList.add(this.make.Assert((ExpressionTree)var6_12, assertDetail));
                                break;
                            }
                            case DO_WHILE_LOOP: {
                                DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)statementTree;
                                ExpressionTree doWhileCondition = doWhileLoopTree.getCondition();
                                if (doWhileCondition != null) {
                                    doWhileCondition = doWhileCondition.equals(node) ? this.replaceExpression(doWhileCondition) : this.replacesExpression(doWhileCondition, node);
                                }
                                newStatementList.add(this.make.DoWhileLoop(doWhileCondition, doWhileLoopTree.getStatement()));
                                break;
                            }
                            case ENHANCED_FOR_LOOP: {
                                EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)statementTree;
                                ExpressionTree enhancedForLoopExpression = enhancedForLoopTree.getExpression();
                                if (enhancedForLoopExpression != null) {
                                    enhancedForLoopExpression = enhancedForLoopExpression.equals(node) ? this.replaceExpression(enhancedForLoopExpression) : this.replacesExpression(enhancedForLoopExpression, node);
                                }
                                newStatementList.add(this.make.EnhancedForLoop(enhancedForLoopTree.getVariable(), enhancedForLoopExpression, enhancedForLoopTree.getStatement()));
                                break;
                            }
                            case EXPRESSION_STATEMENT: {
                                ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
                                ExpressionTree expression = expressionStatementTree.getExpression();
                                if (expression != null) {
                                    expression = expression.equals(node) ? this.replaceExpression(expression) : this.replacesExpression(expression, node);
                                }
                                newStatementList.add(this.make.ExpressionStatement(expression));
                                break;
                            }
                            case FOR_LOOP: {
                                ForLoopTree forLoopTree = (ForLoopTree)statementTree;
                                ExpressionTree forLoopCondition = forLoopTree.getCondition();
                                if (forLoopCondition != null) {
                                    forLoopCondition = forLoopCondition.equals(node) ? this.replaceExpression(forLoopCondition) : this.replacesExpression(forLoopCondition, node);
                                }
                                newStatementList.add(this.make.ForLoop(forLoopTree.getInitializer(), forLoopCondition, forLoopTree.getUpdate(), forLoopTree.getStatement()));
                                break;
                            }
                            case IF: {
                                IfTree ifTree = (IfTree)statementTree;
                                ExpressionTree ifTreeCondition = ifTree.getCondition();
                                if (ifTreeCondition != null) {
                                    ifTreeCondition = ifTreeCondition.equals(node) ? this.replaceExpression(ifTreeCondition) : this.replacesExpression(ifTreeCondition, node);
                                }
                                newStatementList.add(this.make.If(ifTreeCondition, ifTree.getThenStatement(), ifTree.getElseStatement()));
                                break;
                            }
                            case RETURN: {
                                ReturnTree returnTree = (ReturnTree)statementTree;
                                ExpressionTree returnExpression = returnTree.getExpression();
                                if (returnExpression != null) {
                                    returnExpression = returnExpression.equals(node) ? this.replaceExpression(returnExpression) : this.replacesExpression(returnExpression, node);
                                }
                                newStatementList.add(this.make.Return(returnExpression));
                                break;
                            }
                            case SWITCH: {
                                SwitchTree switchTree = (SwitchTree)statementTree;
                                ExpressionTree switchTreeExpression = switchTree.getExpression();
                                if (switchTreeExpression != null) {
                                    switchTreeExpression = switchTreeExpression.equals(node) ? this.replaceExpression(switchTreeExpression) : this.replacesExpression(switchTreeExpression, node);
                                }
                                newStatementList.add(this.make.Switch(switchTreeExpression, switchTree.getCases()));
                                break;
                            }
                            case SYNCHRONIZED: {
                                SynchronizedTree synchronizedTree = (SynchronizedTree)statementTree;
                                ExpressionTree synchronizedTreeExpression = synchronizedTree.getExpression();
                                if (synchronizedTreeExpression != null) {
                                    synchronizedTreeExpression = synchronizedTreeExpression.equals(node) ? this.replaceExpression(synchronizedTreeExpression) : this.replacesExpression(synchronizedTreeExpression, node);
                                }
                                newStatementList.add(this.make.Synchronized(synchronizedTreeExpression, synchronizedTree.getBlock()));
                                break;
                            }
                            case THROW: {
                                ThrowTree throwTree = (ThrowTree)statementTree;
                                ExpressionTree throwExpression = throwTree.getExpression();
                                if (throwExpression != null) {
                                    throwExpression = throwExpression.equals(node) ? this.replaceExpression(throwExpression) : this.replacesExpression(throwExpression, node);
                                }
                                newStatementList.add(this.make.Throw(throwExpression));
                                break;
                            }
                            case VARIABLE: {
                                VariableTree variableTree = (VariableTree)statementTree;
                                ExpressionTree variableInitializer = variableTree.getInitializer();
                                if (variableInitializer != null) {
                                    variableInitializer = variableInitializer.equals(node) ? this.replaceExpression(variableInitializer) : this.replacesExpression(variableInitializer, node);
                                }
                                newStatementList.add(this.make.Variable(variableTree.getModifiers(), (CharSequence)variableTree.getName(), variableTree.getType(), variableInitializer));
                                break;
                            }
                            case WHILE_LOOP: {
                                WhileLoopTree whileLoopTree = (WhileLoopTree)statementTree;
                                ExpressionTree whileLoopCondition = whileLoopTree.getCondition();
                                if (whileLoopCondition != null) {
                                    whileLoopCondition = whileLoopCondition.equals(node) ? this.replaceExpression(whileLoopCondition) : this.replacesExpression(whileLoopCondition, node);
                                }
                                newStatementList.add(this.make.WhileLoop(whileLoopCondition, whileLoopTree.getStatement()));
                            }
                        }
                    } else {
                        switch (statementTree.getKind()) {
                            case EXPRESSION_STATEMENT: {
                                for (StatementTree statementTree2 : InlineMethodTransformer.this.body.getStatements()) {
                                    newStatementList.add(statementTree2);
                                }
                                break;
                            }
                        }
                    }
                    if (needBlock) {
                        BlockTree block = this.make.Block(newStatementList, false);
                        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>(1);
                        arrayList.add(block);
                        return arrayList;
                    }
                    return newStatementList;
                }

                @Override
                protected ExpressionTree replaceExpression(ExpressionTree expressionTree) {
                    ExpressionTree expressionBody = ((ReturnTree)InlineMethodTransformer.this.body.getStatements().get(InlineMethodTransformer.this.body.getStatements().size() - 1)).getExpression();
                    boolean parenthesize = OperatorPrecedence.needsParentheses(InlineMethodTransformer.this.getCurrentPath(), expressionTree, expressionBody, InlineMethodTransformer.this.workingCopy);
                    if (parenthesize) {
                        expressionBody = this.make.Parenthesized(expressionBody);
                    }
                    return expressionBody;
                }
            };
        }
        return (Tree)super.scan(tree, p);
    }

    @Override
    public Tree visitMethod(MethodTree node, Element p) {
        Tree parent;
        ClassTree removeClassMember;
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        if (((Object)p).equals(el) && (removeClassMember = this.make.removeClassMember((ClassTree)(parent = this.getCurrentPath().getParentPath().getLeaf()), (Tree)node)) != null) {
            this.rewrite(parent, removeClassMember);
        }
        return (Tree)super.visitMethod(node, p);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Element p) {
        final TreePath currentPath = this.getCurrentPath();
        Element el = this.trees.getElement(currentPath);
        if (((Object)p).equals(el)) {
            TreePath statementPath = currentPath;
            boolean foundStatement = false;
            while (!foundStatement) {
                statementPath = statementPath.getParentPath();
                switch (statementPath.getLeaf().getKind()) {
                    case ASSERT: 
                    case DO_WHILE_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case EXPRESSION_STATEMENT: 
                    case FOR_LOOP: 
                    case IF: 
                    case RETURN: 
                    case SWITCH: 
                    case SYNCHRONIZED: 
                    case THROW: 
                    case VARIABLE: 
                    case WHILE_LOOP: 
                    case BLOCK: 
                    case BREAK: 
                    case CLASS: 
                    case CONTINUE: 
                    case EMPTY_STATEMENT: 
                    case LABELED_STATEMENT: 
                    case TRY: {
                        foundStatement = true;
                    }
                }
            }
            TreePath blockPath = statementPath;
            boolean foundEnclosingBlock = false;
            while (!foundEnclosingBlock) {
                switch (blockPath.getLeaf().getKind()) {
                    case DO_WHILE_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case FOR_LOOP: 
                    case IF: 
                    case WHILE_LOOP: 
                    case BLOCK: {
                        foundEnclosingBlock = true;
                    }
                }
                if (foundEnclosingBlock) continue;
                blockPath = blockPath.getParentPath();
            }
            TreePath upperBlockPath = blockPath;
            boolean foundUpperBlock = false;
            while (!foundUpperBlock) {
                switch (upperBlockPath.getLeaf().getKind()) {
                    case METHOD: {
                        foundUpperBlock = true;
                    }
                }
                if (foundUpperBlock) continue;
                upperBlockPath = upperBlockPath.getParentPath();
            }
            BlockTree upperBlock = ((MethodTree)upperBlockPath.getLeaf()).getBody();
            BlockTree cachedBlock = (BlockTree)this.changes.get(upperBlock);
            if (cachedBlock == null) {
                cachedBlock = upperBlock;
                this.changes.put(upperBlock, cachedBlock);
            }
            this.body = this.methodTree.getBody();
            TreeScanner<Void, ExecutableElement> nameClashScanner = new TreeScanner<Void, ExecutableElement>(){

                @Override
                public Void visitVariable(VariableTree node, ExecutableElement p) {
                    String msg;
                    Element variable = InlineMethodTransformer.this.trees.getElement(InlineMethodTransformer.this.trees.getPath(InlineMethodTransformer.this.workingCopy.getCompilationUnit(), node));
                    if (!(variable.getKind() == ElementKind.PARAMETER && p.getParameters().contains((VariableElement)variable) || (msg = RetoucheUtils.variableClashes(node.getName().toString(), currentPath, (CompilationInfo)InlineMethodTransformer.this.workingCopy)) == null)) {
                        InlineMethodTransformer.this.problem = MoveTransformer.createProblem(InlineMethodTransformer.this.problem, true, NbBundle.getMessage(InlineRefactoringPlugin.class, (String)"ERR_InlineMethodNameClash", (Object)msg));
                    }
                    return (Void)super.visitVariable(node, p);
                }
            };
            nameClashScanner.scan(this.body, (ExecutableElement)p);
            if (this.hasParameters) {
                final HashMap original2Translated = new HashMap();
                TreeScanner<Void, Pair<Element, ExpressionTree>> idScan = new TreeScanner<Void, Pair<Element, ExpressionTree>>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree node, Pair<Element, ExpressionTree> p) {
                        TreePath currentPath = InlineMethodTransformer.this.trees.getPath(InlineMethodTransformer.this.workingCopy.getCompilationUnit(), node);
                        Element el = InlineMethodTransformer.this.trees.getElement(currentPath);
                        if (((Object)((Element)p.first)).equals(el)) {
                            original2Translated.put(node, p.second);
                        }
                        return (Void)super.visitIdentifier(node, p);
                    }
                };
                for (int i = 0; i < this.methodTree.getParameters().size(); ++i) {
                    VariableTree variable = this.methodTree.getParameters().get(i);
                    ExpressionTree argument = node.getArguments().get(i);
                    TreePath path = this.trees.getPath(this.workingCopy.getCompilationUnit(), variable);
                    Element element = this.trees.getElement(path);
                    Pair<Element, ExpressionTree> pair = Pair.of(element, argument);
                    idScan.scan(this.body, pair);
                }
                this.body = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)this.body, original2Translated);
            }
            BlockTree newBlock = this.imtv.replaceStatement(cachedBlock, statementPath, (ExpressionTree)node);
            this.changes.put(upperBlock, newBlock);
            this.rewrite(upperBlock, newBlock);
        }
        return (Tree)super.visitMethodInvocation(node, p);
    }

    public Problem getProblem() {
        return this.problem;
    }
}

