/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.TreeMaker;

public abstract class InlineAbstractTransformer {
    protected TreeMaker make;

    public InlineAbstractTransformer(TreeMaker make) {
        this.make = make;
    }

    protected CaseTree replaceCaseTree(CaseTree caseTree, TreePath statementPath, ExpressionTree node) {
        ArrayList<StatementTree> newStatementList = new ArrayList<StatementTree>(caseTree.getStatements().size());
        for (StatementTree statementTree : caseTree.getStatements()) {
            if (statementTree.equals(statementPath.getLeaf())) {
                List<StatementTree> recStatementList = this.replaceStatement(statementTree, node, false);
                for (StatementTree receivedStatement : recStatementList) {
                    newStatementList.add(receivedStatement);
                }
                continue;
            }
            newStatementList.add(this.replacesStatement(statementTree, statementPath, node));
        }
        CaseTree newCaseTree = this.make.Case(caseTree.getExpression(), newStatementList);
        return newCaseTree;
    }

    protected CatchTree replaceCatchTree(CatchTree catchTree, TreePath statementPath, ExpressionTree node) {
        BlockTree block = catchTree.getBlock();
        if (block != null) {
            block = this.replaceStatement(block, statementPath, node);
        }
        CatchTree newCatchTree = this.make.Catch(catchTree.getParameter(), block);
        return newCatchTree;
    }

    protected abstract ExpressionTree replaceExpression(ExpressionTree var1);

    protected ExpressionTree replaceExpression(ArrayAccessTree arrayAccessTree, ExpressionTree node) {
        ExpressionTree arrayAccesIndex;
        ExpressionTree arrayAccessExpression = arrayAccessTree.getExpression();
        if (arrayAccessExpression != null) {
            arrayAccessExpression = arrayAccessExpression.equals(node) ? this.replaceExpression(arrayAccessExpression) : this.replacesExpression(arrayAccessExpression, node);
        }
        if ((arrayAccesIndex = arrayAccessTree.getIndex()) != null) {
            arrayAccesIndex = arrayAccesIndex.equals(node) ? this.replaceExpression(arrayAccesIndex) : this.replacesExpression(arrayAccesIndex, node);
        }
        ArrayAccessTree newArrayAccess = this.make.ArrayAccess(arrayAccessExpression, arrayAccesIndex);
        return newArrayAccess;
    }

    protected ExpressionTree replaceExpression(AssignmentTree assignmentTree, ExpressionTree node) {
        ExpressionTree assignmentVariable;
        ExpressionTree assignmentExpression = assignmentTree.getExpression();
        if (assignmentExpression != null) {
            assignmentExpression = assignmentExpression.equals(node) ? this.replaceExpression(assignmentExpression) : this.replacesExpression(assignmentExpression, node);
        }
        if ((assignmentVariable = assignmentTree.getVariable()) != null) {
            assignmentVariable = assignmentVariable.equals(node) ? this.replaceExpression(assignmentVariable) : this.replacesExpression(assignmentVariable, node);
        }
        AssignmentTree newAssignment = this.make.Assignment(assignmentVariable, assignmentExpression);
        return newAssignment;
    }

    protected ExpressionTree replaceExpression(BinaryTree binaryTree, ExpressionTree node) {
        ExpressionTree binaryRightOperand;
        ExpressionTree binaryLeftOperand = binaryTree.getLeftOperand();
        if (binaryLeftOperand != null) {
            binaryLeftOperand = binaryLeftOperand.equals(node) ? this.replaceExpression(binaryLeftOperand) : this.replacesExpression(binaryLeftOperand, node);
        }
        if ((binaryRightOperand = binaryTree.getRightOperand()) != null) {
            binaryRightOperand = binaryRightOperand.equals(node) ? this.replaceExpression(binaryRightOperand) : this.replacesExpression(binaryRightOperand, node);
        }
        BinaryTree newBinary = this.make.Binary(binaryTree.getKind(), binaryLeftOperand, binaryRightOperand);
        return newBinary;
    }

    protected ExpressionTree replaceExpression(CompoundAssignmentTree compoundAssignmentTree, ExpressionTree node) {
        ExpressionTree assignmentVariable;
        ExpressionTree assignmentExpression = compoundAssignmentTree.getExpression();
        if (assignmentExpression != null) {
            assignmentExpression = assignmentExpression.equals(node) ? this.replaceExpression(assignmentExpression) : this.replacesExpression(assignmentExpression, node);
        }
        if ((assignmentVariable = compoundAssignmentTree.getVariable()) != null) {
            assignmentVariable = assignmentVariable.equals(node) ? this.replaceExpression(assignmentVariable) : this.replacesExpression(assignmentVariable, node);
        }
        CompoundAssignmentTree newAssignment = this.make.CompoundAssignment(compoundAssignmentTree.getKind(), assignmentVariable, assignmentExpression);
        return newAssignment;
    }

    protected ExpressionTree replaceExpression(ConditionalExpressionTree conditionalExpressionTree, ExpressionTree node) {
        ExpressionTree conditionalFalseExpression;
        ExpressionTree conditionalTrueExpression;
        ExpressionTree conditionalExpressionCondition = conditionalExpressionTree.getCondition();
        if (conditionalExpressionCondition != null) {
            conditionalExpressionCondition = conditionalExpressionCondition.equals(node) ? this.replaceExpression(conditionalExpressionCondition) : this.replacesExpression(conditionalExpressionCondition, node);
        }
        if ((conditionalTrueExpression = conditionalExpressionTree.getTrueExpression()) != null) {
            conditionalTrueExpression = conditionalTrueExpression.equals(node) ? this.replaceExpression(conditionalTrueExpression) : this.replacesExpression(conditionalTrueExpression, node);
        }
        if ((conditionalFalseExpression = conditionalExpressionTree.getFalseExpression()) != null) {
            conditionalFalseExpression = conditionalFalseExpression.equals(node) ? this.replaceExpression(conditionalFalseExpression) : this.replacesExpression(conditionalFalseExpression, node);
        }
        ConditionalExpressionTree newConditional = this.make.ConditionalExpression(conditionalExpressionCondition, conditionalTrueExpression, conditionalFalseExpression);
        return newConditional;
    }

    protected ExpressionTree replaceExpression(InstanceOfTree instanceOfTree, ExpressionTree node) {
        ExpressionTree instanceOfExpression = instanceOfTree.getExpression();
        if (instanceOfExpression != null) {
            instanceOfExpression = instanceOfExpression.equals(node) ? this.replaceExpression(instanceOfExpression) : this.replacesExpression(instanceOfExpression, node);
        }
        InstanceOfTree newInstanceOf = this.make.InstanceOf(instanceOfExpression, instanceOfTree.getType());
        return newInstanceOf;
    }

    protected ExpressionTree replaceExpression(MemberSelectTree memberSelectTree, ExpressionTree node) {
        ExpressionTree memberSelectExpression = memberSelectTree.getExpression();
        if (memberSelectExpression != null) {
            memberSelectExpression = memberSelectExpression.equals(node) ? this.replaceExpression(memberSelectExpression) : this.replacesExpression(memberSelectExpression, node);
        }
        MemberSelectTree newMemberSelect = this.make.MemberSelect(memberSelectExpression, (CharSequence)memberSelectTree.getIdentifier());
        return newMemberSelect;
    }

    protected ExpressionTree replaceExpression(MethodInvocationTree methodInvocationTree, ExpressionTree node) {
        ExpressionTree methodInvocationMethodSelect = methodInvocationTree.getMethodSelect();
        if (methodInvocationMethodSelect != null) {
            methodInvocationMethodSelect = methodInvocationMethodSelect.equals(node) ? this.replaceExpression(methodInvocationMethodSelect) : this.replacesExpression(methodInvocationMethodSelect, node);
        }
        ArrayList<ExpressionTree> newArguments = new ArrayList<ExpressionTree>(methodInvocationTree.getArguments().size());
        for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
            if (expressionTree.equals(node)) {
                newArguments.add(this.replaceExpression(expressionTree));
                continue;
            }
            newArguments.add(this.replacesExpression(expressionTree, node));
        }
        MethodInvocationTree newMethodInvocationTree = this.make.MethodInvocation(methodInvocationTree.getTypeArguments(), methodInvocationMethodSelect, newArguments);
        return newMethodInvocationTree;
    }

    protected ExpressionTree replaceExpression(NewArrayTree newArrayTree, ExpressionTree node) {
        ArrayList<ExpressionTree> newDimensions = new ArrayList<ExpressionTree>(newArrayTree.getDimensions().size());
        for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
            if (expressionTree == null) continue;
            if (expressionTree.equals(node)) {
                newDimensions.add(this.replaceExpression(expressionTree));
                continue;
            }
            newDimensions.add(this.replacesExpression(expressionTree, node));
        }
        ArrayList<ExpressionTree> newInitializers = new ArrayList<ExpressionTree>(newArrayTree.getInitializers().size());
        for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
            if (expressionTree == null) continue;
            if (expressionTree.equals(node)) {
                newInitializers.add(this.replaceExpression(expressionTree));
                continue;
            }
            newInitializers.add(this.replacesExpression(expressionTree, node));
        }
        NewArrayTree newArrayTree2 = this.make.NewArray(newArrayTree.getType(), newDimensions, newInitializers);
        return newArrayTree2;
    }

    protected ExpressionTree replaceExpression(NewClassTree newClassTree, ExpressionTree node) {
        ArrayList<ExpressionTree> newArguments = new ArrayList<ExpressionTree>(newClassTree.getArguments().size());
        for (ExpressionTree expressionTree : newClassTree.getArguments()) {
            if (expressionTree == null) continue;
            if (expressionTree.equals(node)) {
                newArguments.add(this.replaceExpression(expressionTree));
                continue;
            }
            newArguments.add(this.replacesExpression(expressionTree, node));
        }
        ExpressionTree enclosingExpression = newClassTree.getEnclosingExpression();
        if (enclosingExpression != null) {
            enclosingExpression = enclosingExpression.equals(node) ? this.replaceExpression(enclosingExpression) : this.replacesExpression(enclosingExpression, node);
        }
        ClassTree classTree = newClassTree.getClassBody();
        ClassTree newClassBody = null;
        if (classTree != null) {
            ArrayList<ExpressionTree> newMembers = new ArrayList<ExpressionTree>(classTree.getMembers().size());
            for (ExpressionTree expressionTree : newClassTree.getArguments()) {
                if (expressionTree == null) continue;
                if (expressionTree.equals(node)) {
                    newMembers.add(this.replaceExpression(expressionTree));
                    continue;
                }
                newMembers.add(this.replacesExpression(expressionTree, node));
            }
            newClassBody = this.make.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), newMembers);
        }
        return this.make.NewClass(enclosingExpression, newClassTree.getTypeArguments(), newClassTree.getIdentifier(), newArguments, newClassBody);
    }

    protected ExpressionTree replaceExpression(ParenthesizedTree parenthesizedTree, ExpressionTree node) {
        ExpressionTree parenthesizedExpression = parenthesizedTree.getExpression();
        if (parenthesizedExpression != null) {
            parenthesizedExpression = parenthesizedExpression.equals(node) ? this.replaceExpression(parenthesizedExpression) : this.replacesExpression(parenthesizedExpression, node);
        }
        ParenthesizedTree newParenthesizedTree = this.make.Parenthesized(parenthesizedExpression);
        return newParenthesizedTree;
    }

    protected ExpressionTree replaceExpression(TypeCastTree typeCastTree, ExpressionTree node) {
        ExpressionTree typeCastExpression = typeCastTree.getExpression();
        if (typeCastExpression != null) {
            typeCastExpression = typeCastExpression.equals(node) ? this.replaceExpression(typeCastExpression) : this.replacesExpression(typeCastExpression, node);
        }
        TypeCastTree newTypeCast = this.make.TypeCast(typeCastTree.getType(), typeCastExpression);
        return newTypeCast;
    }

    protected ExpressionTree replaceExpression(UnaryTree unaryTree, ExpressionTree node) {
        ExpressionTree unaryExpression = unaryTree.getExpression();
        if (unaryExpression != null) {
            unaryExpression = unaryExpression.equals(node) ? this.replaceExpression(unaryExpression) : this.replacesExpression(unaryExpression, node);
        }
        UnaryTree newUnary = this.make.Unary(unaryTree.getKind(), unaryExpression);
        return newUnary;
    }

    protected BlockTree replaceStatement(BlockTree blockTree, TreePath statementPath, ExpressionTree node) {
        ArrayList<StatementTree> newStatementList = new ArrayList<StatementTree>(blockTree.getStatements().size());
        for (StatementTree statementTree : blockTree.getStatements()) {
            if (statementTree.equals(statementPath.getLeaf())) {
                List<StatementTree> recStatementList = this.replaceStatement(statementTree, node, false);
                for (StatementTree receivedStatement : recStatementList) {
                    newStatementList.add(receivedStatement);
                }
                continue;
            }
            newStatementList.add(this.replacesStatement(statementTree, statementPath, node));
        }
        BlockTree newBlock = this.make.Block(newStatementList, false);
        return newBlock;
    }

    protected SynchronizedTree replaceStatement(SynchronizedTree synchronizedTree, TreePath statementPath, ExpressionTree node) {
        BlockTree blockStatement = synchronizedTree.getBlock();
        if (blockStatement != null) {
            blockStatement = this.replaceStatement(blockStatement, statementPath, node);
        }
        SynchronizedTree newSynchronized = this.make.Synchronized(synchronizedTree.getExpression(), blockStatement);
        return newSynchronized;
    }

    /*
     * WARNING - void declaration
     */
    protected TryTree replaceStatement(TryTree tryTree, TreePath statementPath, ExpressionTree node) {
        void var6_9;
        BlockTree blockTree;
        ArrayList<CatchTree> newCatches = new ArrayList<CatchTree>(tryTree.getCatches().size());
        for (CatchTree catchTree : tryTree.getCatches()) {
            newCatches.add(this.replaceCatchTree(catchTree, statementPath, node));
        }
        BlockTree tryBlock = tryTree.getBlock();
        if (tryBlock != null) {
            tryBlock = this.replaceStatement(tryBlock, statementPath, node);
        }
        if ((blockTree = tryTree.getFinallyBlock()) != null) {
            BlockTree blockTree2 = this.replaceStatement(blockTree, statementPath, node);
        }
        TryTree newTry = this.make.Try(tryBlock, newCatches, (BlockTree)var6_9);
        return newTry;
    }

    protected IfTree replaceStatement(IfTree ifTree, TreePath statementPath, ExpressionTree node) {
        StatementTree elseStatement;
        StatementTree thenStatement = ifTree.getThenStatement();
        if (thenStatement != null) {
            thenStatement = thenStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(thenStatement, node, true).get(0) : this.replacesStatement(thenStatement, statementPath, node);
        }
        if ((elseStatement = ifTree.getElseStatement()) != null) {
            elseStatement = elseStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(elseStatement, node, true).get(0) : this.replacesStatement(elseStatement, statementPath, node);
        }
        IfTree newIf = this.make.If(ifTree.getCondition(), thenStatement, elseStatement);
        return newIf;
    }

    protected SwitchTree replaceStatement(SwitchTree switchTree, TreePath statementPath, ExpressionTree node) {
        ArrayList<CaseTree> newCases = new ArrayList<CaseTree>(switchTree.getCases().size());
        for (CaseTree caseTree : switchTree.getCases()) {
            newCases.add(this.replaceCaseTree(caseTree, statementPath, node));
        }
        SwitchTree newSwitch = this.make.Switch(switchTree.getExpression(), newCases);
        return newSwitch;
    }

    protected ForLoopTree replaceStatement(ForLoopTree forLoopTree, TreePath statementPath, ExpressionTree node) {
        StatementTree forLoopStatement = forLoopTree.getStatement();
        if (forLoopStatement != null) {
            forLoopStatement = forLoopStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(forLoopStatement, node, true).get(0) : this.replacesStatement(forLoopStatement, statementPath, node);
        }
        ForLoopTree newFor = this.make.ForLoop(forLoopTree.getInitializer(), forLoopTree.getCondition(), forLoopTree.getUpdate(), forLoopStatement);
        return newFor;
    }

    protected EnhancedForLoopTree replaceStatement(EnhancedForLoopTree enhancedForLoop, TreePath statementPath, ExpressionTree node) {
        StatementTree forLoopStatement = enhancedForLoop.getStatement();
        if (forLoopStatement != null) {
            forLoopStatement = forLoopStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(forLoopStatement, node, true).get(0) : this.replacesStatement(forLoopStatement, statementPath, node);
        }
        EnhancedForLoopTree newFor = this.make.EnhancedForLoop(enhancedForLoop.getVariable(), enhancedForLoop.getExpression(), forLoopStatement);
        return newFor;
    }

    protected WhileLoopTree replaceStatement(WhileLoopTree whileLoopTree, TreePath statementPath, ExpressionTree node) {
        StatementTree whileLoopStatement = whileLoopTree.getStatement();
        if (whileLoopStatement != null) {
            whileLoopStatement = whileLoopStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(whileLoopStatement, node, true).get(0) : this.replacesStatement(whileLoopStatement, statementPath, node);
        }
        WhileLoopTree newWhile = this.make.WhileLoop(whileLoopTree.getCondition(), whileLoopStatement);
        return newWhile;
    }

    protected DoWhileLoopTree replaceStatement(DoWhileLoopTree doWhileLoopTree, TreePath statementPath, ExpressionTree node) {
        StatementTree doWhileLoopStatement = doWhileLoopTree.getStatement();
        if (doWhileLoopStatement != null) {
            doWhileLoopStatement = doWhileLoopStatement.equals(statementPath.getLeaf()) ? this.replaceStatement(doWhileLoopStatement, node, true).get(0) : this.replacesStatement(doWhileLoopStatement, statementPath, node);
        }
        DoWhileLoopTree newWhile = this.make.DoWhileLoop(doWhileLoopTree.getCondition(), doWhileLoopStatement);
        return newWhile;
    }

    protected abstract List<StatementTree> replaceStatement(StatementTree var1, ExpressionTree var2, boolean var3);

    protected ExpressionTree replacesExpression(ExpressionTree expressionTree, ExpressionTree node) {
        ExpressionTree returnExpression;
        switch (expressionTree.getKind()) {
            case ARRAY_ACCESS: {
                returnExpression = this.replaceExpression((ArrayAccessTree)expressionTree, node);
                break;
            }
            case ASSIGNMENT: {
                returnExpression = this.replaceExpression((AssignmentTree)expressionTree, node);
                break;
            }
            case AND: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                returnExpression = this.replaceExpression((BinaryTree)expressionTree, node);
                break;
            }
            case AND_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case XOR_ASSIGNMENT: {
                returnExpression = this.replaceExpression((CompoundAssignmentTree)expressionTree, node);
                break;
            }
            case CONDITIONAL_EXPRESSION: {
                returnExpression = this.replaceExpression((ConditionalExpressionTree)expressionTree, node);
                break;
            }
            case INSTANCE_OF: {
                returnExpression = this.replaceExpression((InstanceOfTree)expressionTree, node);
                break;
            }
            case MEMBER_SELECT: {
                returnExpression = this.replaceExpression((MemberSelectTree)expressionTree, node);
                break;
            }
            case METHOD_INVOCATION: {
                returnExpression = this.replaceExpression((MethodInvocationTree)expressionTree, node);
                break;
            }
            case NEW_ARRAY: {
                returnExpression = this.replaceExpression((NewArrayTree)expressionTree, node);
                break;
            }
            case NEW_CLASS: {
                returnExpression = this.replaceExpression((NewClassTree)expressionTree, node);
                break;
            }
            case PARENTHESIZED: {
                returnExpression = this.replaceExpression((ParenthesizedTree)expressionTree, node);
                break;
            }
            case TYPE_CAST: {
                returnExpression = this.replaceExpression((TypeCastTree)expressionTree, node);
                break;
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                returnExpression = this.replaceExpression((UnaryTree)expressionTree, node);
                break;
            }
            default: {
                returnExpression = expressionTree;
            }
        }
        return returnExpression;
    }

    protected StatementTree replacesStatement(StatementTree statement, TreePath statementPath, ExpressionTree node) {
        StatementTree returnStatement;
        switch (statement.getKind()) {
            case BLOCK: {
                returnStatement = this.replaceStatement((BlockTree)statement, statementPath, node);
                break;
            }
            case IF: {
                returnStatement = this.replaceStatement((IfTree)statement, statementPath, node);
                break;
            }
            case FOR_LOOP: {
                returnStatement = this.replaceStatement((ForLoopTree)statement, statementPath, node);
                break;
            }
            case ENHANCED_FOR_LOOP: {
                returnStatement = this.replaceStatement((EnhancedForLoopTree)statement, statementPath, node);
                break;
            }
            case WHILE_LOOP: {
                returnStatement = this.replaceStatement((WhileLoopTree)statement, statementPath, node);
                break;
            }
            case DO_WHILE_LOOP: {
                returnStatement = this.replaceStatement((DoWhileLoopTree)statement, statementPath, node);
                break;
            }
            case SWITCH: {
                returnStatement = this.replaceStatement((SwitchTree)statement, statementPath, node);
                break;
            }
            case SYNCHRONIZED: {
                returnStatement = this.replaceStatement((SynchronizedTree)statement, statementPath, node);
                break;
            }
            case TRY: {
                returnStatement = this.replaceStatement((TryTree)statement, statementPath, node);
                break;
            }
            default: {
                returnStatement = statement;
            }
        }
        return returnStatement;
    }
}

