/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JButton;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.IntToStringCache;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Places;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;

final class UnitsCache {
    private static final String PROJECT_INDEX_FILE_NAME = "project-index";
    private static final File MASTER_INDEX_FILE = Places.getCacheSubfile((String)"cnd/model/index");
    private final List<CharSequence> cache = new ArrayList<CharSequence>();
    private final long timestamp;
    private final ArrayList<IntToStringCache> fileNamesCaches = new ArrayList();
    private final Map<CharSequence, Long> unit2timestamp = new ConcurrentHashMap<CharSequence, Long>();
    private final Map<CharSequence, Collection<RequiredUnit>> unit2requnint = new ConcurrentHashMap<CharSequence, Collection<RequiredUnit>>();
    private final Object oneItemCacheLock = new Lock();
    private CharSequence oneItemCacheString;
    private int oneItemCacheInt;
    private RandomAccessFile randomAccessFile;
    private FileChannel channel;
    private FileLock masterIndexLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnitsCache() {
        this.timestamp = System.currentTimeMillis();
        boolean inited = false;
        try {
            this.randomAccessFile = new RandomAccessFile(MASTER_INDEX_FILE, "rw");
            this.channel = this.randomAccessFile.getChannel();
            this.masterIndexLock = this.channel.tryLock();
            if (this.masterIndexLock == null) {
                String message = NbBundle.getMessage(UnitsCache.class, (String)"IDE_Already_Running");
                IOException exception = new IOException(message);
                if (!CndUtils.isStandalone() && !CndUtils.isUnitTestMode()) {
                    while (this.masterIndexLock == null) {
                        JButton reload = new JButton(NbBundle.getMessage(UnitsCache.class, (String)"Yes_Button"));
                        JButton cancel = new JButton(NbBundle.getMessage(UnitsCache.class, (String)"No_Button"));
                        String question = NbBundle.getMessage(UnitsCache.class, (String)"Retry_Load");
                        NotifyDescriptor nd = new NotifyDescriptor((Object)question, message, 0, 3, new Object[]{reload, cancel}, (Object)reload);
                        Object ret = DialogDisplayer.getDefault().notify(nd);
                        if (ret == reload) {
                            this.masterIndexLock = this.channel.tryLock();
                            continue;
                        }
                        exception.printStackTrace(System.err);
                        throw exception;
                    }
                } else {
                    exception.printStackTrace(System.err);
                    throw exception;
                }
            }
            this.loadMasterIndex(this.randomAccessFile);
            inited = true;
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace(System.err);
            }
        }
        finally {
            if (!inited) {
                this.cache.clear();
                this.fileNamesCaches.clear();
                this.unit2timestamp.clear();
                this.unit2requnint.clear();
                this.fileNamesCaches.clear();
            }
        }
    }

    private void loadMasterIndex(DataInput stream) throws IOException {
        this.cache.clear();
        this.fileNamesCaches.clear();
        stream.readInt();
        stream.readLong();
        int size = stream.readInt();
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            this.trace("Reading master index (%d) elements\n", size);
        }
        for (int i = 0; i < size; ++i) {
            String v = stream.readUTF();
            CharSequence value = this.getFileKey(CharSequences.create((CharSequence)v));
            this.cache.add(value);
            long ts = stream.readLong();
            this.unit2timestamp.put(value, ts);
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                this.trace("\tRead %s ts=%d\n", value, ts);
            }
            this.unit2requnint.put(value, this.readRequiredUnits(stream));
            this.fileNamesCaches.add(new IntToStringCache(ts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeMasterIndex() {
        try {
            if (this.randomAccessFile == null) {
                this.randomAccessFile = new RandomAccessFile(MASTER_INDEX_FILE, "rw");
            }
            this.randomAccessFile.seek(0L);
            this.randomAccessFile.setLength(0L);
            this.write(this.randomAccessFile);
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace(System.err);
            }
        }
        finally {
            try {
                if (this.masterIndexLock != null) {
                    this.masterIndexLock.release();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadUnitIndex(CharSequence unitName, String unitIndexFileName, Set<CharSequence> antiLoop) {
        FilterInputStream dis = null;
        boolean indexLoaded = false;
        try {
            if (new File(unitIndexFileName).exists()) {
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(unitIndexFileName)));
                indexLoaded = this.readUnitFilesCache(unitName, (DataInput)((Object)dis), antiLoop);
            }
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace(System.err);
            }
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                    new File(unitIndexFileName).delete();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return indexLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeUnitIndex(CharSequence unitName) {
        FilterOutputStream dos = null;
        String unitIndexFileName = this.getUnitIndexName(unitName);
        boolean indexStored = false;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(unitIndexFileName, false)));
            assert (unitName != null);
            int unitId = this.getId(unitName);
            IntToStringCache filesCache = this.getFileNames(unitId);
            filesCache.write((DataOutput)((Object)dos));
            indexStored = true;
        }
        catch (FileNotFoundException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable tr) {
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                tr.printStackTrace(System.err);
            }
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        if (!indexStored) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
        }
    }

    void removeUnit(CharSequence unitName) {
        File file = new File(this.getUnitIndexName(unitName));
        file.delete();
    }

    private String getUnitIndexName(CharSequence unitName) {
        return StorageAllocator.getInstance().getUnitStorageName(unitName) + PROJECT_INDEX_FILE_NAME;
    }

    private boolean readUnitFilesCache(CharSequence name, DataInput stream, Set<CharSequence> antiLoop) throws IOException {
        assert (name != null);
        assert (stream != null);
        IntToStringCache filesCache = new IntToStringCache(stream);
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            this.trace("Read unit files cache for %s ts=%d\n", name, filesCache.getTimestamp());
        }
        if (filesCache.getVersion() == RepositoryTranslatorImpl.getVersion() && this.validateReqUnits(name, antiLoop)) {
            this.insertUnitFileCache(name, filesCache);
            return true;
        }
        filesCache = new IntToStringCache();
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            this.trace("Req. units validation failed for %s. Setting ts=%d\n", name, filesCache.getTimestamp());
        }
        this.insertUnitFileCache(name, filesCache);
        return false;
    }

    void updateReqUnitInfo(CharSequence unitName, Set<CharSequence> reqUnits) {
        for (int i = 0; i < this.cache.size(); ++i) {
            CharSequence uName = this.cache.get(i);
            long uTs = this.fileNamesCaches.get(i).getTimestamp();
            this.unit2timestamp.put(uName, uTs);
        }
        CopyOnWriteArraySet<RequiredUnit> unitReqUnits = new CopyOnWriteArraySet<RequiredUnit>();
        if (reqUnits != null) {
            for (CharSequence rUnitName : reqUnits) {
                long ts = this.unit2timestamp.get(rUnitName);
                RequiredUnit rU = new RequiredUnit(rUnitName, ts);
                unitReqUnits.add(rU);
            }
        }
        this.unit2requnint.put(unitName, unitReqUnits);
    }

    private boolean validateReqUnits(CharSequence unitName, Set<CharSequence> antiLoop) {
        if (antiLoop.contains(unitName)) {
            return true;
        }
        antiLoop.add(unitName);
        boolean result = true;
        Collection<RequiredUnit> reqUnits = this.unit2requnint.get(unitName);
        for (RequiredUnit rU : reqUnits) {
            Long tsL;
            if (!this.isUnitIndexLoaded(rU.getName())) {
                this.loadUnitIndex(rU.getName(), antiLoop);
            }
            if ((tsL = this.unit2timestamp.get(rU.getName())) != null) {
                long ts = tsL;
                if (ts == rU.getTimestamp()) continue;
                if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                    this.trace("Req. unit validation FAILED for %s: ts(unit2timestamp)=%d, ts(unit2requnint)=%s \n", unitName, ts, rU.getTimestamp());
                }
                result = false;
                break;
            }
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                this.trace("Req. unit validation FAILED for %s: ts=NULL\n", unitName);
            }
            result = false;
            break;
        }
        return result;
    }

    void loadUnitIndex(CharSequence unitName, Set<CharSequence> antiLoop) {
        if (this.isUnitIndexLoaded(unitName)) {
            return;
        }
        String unitIndexFileName = this.getUnitIndexName(unitName);
        boolean indexLoaded = this.loadUnitIndex(unitName, unitIndexFileName, antiLoop);
        if (!indexLoaded) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
            this.cleanUnitData(unitName);
        }
    }

    private void writeRequiredUnits(CharSequence unitName, DataOutput stream) throws IOException {
        assert (unitName != null);
        assert (stream != null);
        Collection<RequiredUnit> rUnits = this.unit2requnint.get(unitName);
        assert (rUnits != null);
        int size = rUnits.size();
        stream.writeInt(size);
        for (RequiredUnit unit : rUnits) {
            unit.write(stream);
            if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
            this.trace("\t\treq.unit %s ts=%d\n", unit.getName(), unit.getTimestamp());
        }
    }

    private Collection<RequiredUnit> readRequiredUnits(DataInput stream) throws IOException {
        assert (stream != null);
        CopyOnWriteArraySet<RequiredUnit> units = new CopyOnWriteArraySet<RequiredUnit>();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            RequiredUnit unit = new RequiredUnit(stream);
            units.add(unit);
            if (!Stats.TRACE_REPOSITORY_TRANSLATOR) continue;
            this.trace("\t\tRead req. unit %s ts=%d\n", unit.getName(), unit.getTimestamp());
        }
        return units;
    }

    private void write(DataOutput stream) throws IOException {
        assert (this.cache != null);
        assert (stream != null);
        stream.writeInt(RepositoryTranslatorImpl.getVersion());
        stream.writeLong(this.timestamp);
        int size = this.cache.size();
        stream.writeInt(size);
        if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
            this.trace("Storing master index; size=%d\n", size);
        }
        for (int i = 0; i < size; ++i) {
            CharSequence value = this.cache.get(i);
            stream.writeUTF(((Object)value).toString());
            stream.writeLong(this.unit2timestamp.get(value));
            if (Stats.TRACE_REPOSITORY_TRANSLATOR) {
                this.trace("\tUnit %s ts=%d\n", value, this.unit2timestamp.get(value));
            }
            this.writeRequiredUnits(value, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getId(CharSequence value) {
        Object object;
        CharSequence prevString = null;
        int prevInt = 0;
        Object object2 = this.oneItemCacheLock;
        synchronized (object2) {
            prevString = this.oneItemCacheString;
            prevInt = this.oneItemCacheInt;
        }
        if (value.equals(prevString)) {
            return prevInt;
        }
        int id = this.cache.indexOf(value);
        if (id == -1) {
            object = this.cache;
            synchronized (object) {
                id = this.cache.indexOf(value);
                if (id == -1) {
                    id = this.makeId(value);
                }
            }
        }
        object = this.oneItemCacheLock;
        synchronized (object) {
            this.oneItemCacheString = value;
            this.oneItemCacheInt = id;
        }
        return id;
    }

    private boolean isUnitIndexLoaded(CharSequence unitName) {
        if (!this.cache.contains(unitName)) {
            return false;
        }
        int id = this.cache.indexOf(unitName);
        return this.fileNamesCaches.get(id).size() != 0;
    }

    private void insertUnitFileCache(CharSequence name, IntToStringCache filesCache) {
        int index = this.cache.indexOf(name);
        if (index == -1) {
            this.cache.add(name);
            index = this.cache.indexOf(name);
        }
        this.fileNamesCaches.set(index, filesCache);
        this.unit2timestamp.put(name, filesCache.getTimestamp());
        this.unit2requnint.put(name, new CopyOnWriteArraySet());
    }

    IntToStringCache removeFileNames(CharSequence unitName) {
        IntToStringCache fileNames = null;
        int index = this.cache.indexOf(unitName);
        if (index != -1) {
            fileNames = this.fileNamesCaches.get(index);
            long ts = fileNames.getTimestamp();
            this.unit2timestamp.put(unitName, ts);
            this.fileNamesCaches.set(index, new IntToStringCache(ts));
        }
        return fileNames;
    }

    private int makeId(CharSequence unitName) {
        unitName = this.getFileKey(unitName);
        int id = this.cache.indexOf(null);
        IntToStringCache fileCache = new IntToStringCache();
        if (id == -1) {
            this.cache.add(unitName);
            id = this.cache.indexOf(unitName);
            this.fileNamesCaches.add(fileCache);
        } else {
            this.cache.set(id, unitName);
            this.fileNamesCaches.set(id, fileCache);
        }
        assert (this.fileNamesCaches.size() == this.cache.size());
        this.unit2requnint.put(unitName, new CopyOnWriteArraySet());
        this.unit2timestamp.put(unitName, fileCache.getTimestamp());
        return id;
    }

    CharSequence getValueById(int id) {
        return this.cache.get(id);
    }

    boolean containsId(int id) {
        return 0 <= id && id < this.cache.size();
    }

    boolean containsValue(CharSequence value) {
        return this.cache.contains(value);
    }

    IntToStringCache getFileNames(int unitId) {
        return this.fileNamesCaches.get(unitId);
    }

    private void cleanUnitData(CharSequence unitName) {
        IntToStringCache fileCache = new IntToStringCache();
        this.unit2requnint.put(unitName, new CopyOnWriteArraySet());
        this.unit2timestamp.put(unitName, fileCache.getTimestamp());
    }

    private CharSequence getFileKey(CharSequence str) {
        return str;
    }

    private void trace(String format, Object ... args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = System.currentTimeMillis();
        System.arraycopy(args, 0, newArgs, 1, args.length);
        System.err.printf("RepositoryTranslator [%d] " + format, newArgs);
    }

    private static final class RequiredUnit {
        private CharSequence unitName;
        private long timestamp;

        public RequiredUnit(CharSequence name, long time) {
            this.unitName = name;
            this.timestamp = time;
        }

        public RequiredUnit(DataInput stream) throws IOException {
            this.unitName = CharSequences.create((CharSequence)stream.readUTF());
            this.timestamp = stream.readLong();
        }

        public void write(DataOutput stream) throws IOException {
            stream.writeUTF(((Object)this.unitName).toString());
            stream.writeLong(this.timestamp);
        }

        public CharSequence getName() {
            return this.unitName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

