/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.translator;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.repository.api.RepositoryTranslation;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.translator.UnitsCache;
import org.netbeans.modules.cnd.repository.util.IntToStringCache;

public class RepositoryTranslatorImpl
implements RepositoryTranslation {
    private static UnitsCache unitNamesCache = null;
    private static final Object initLock = new Object();
    private static boolean loaded = false;
    private static final int DEFAULT_VERSION_OF_PERSISTENCE_MECHANIZM = 0;
    private static int version = 0;

    public int getFileIdByName(int unitId, CharSequence fileName) {
        assert (fileName != null);
        IntToStringCache unitFileNames = this.getUnitFileNames(unitId);
        return unitFileNames.getId(fileName);
    }

    public CharSequence getFileNameById(int unitId, int fileId) {
        IntToStringCache fileNames = this.getUnitFileNames(unitId);
        CharSequence fileName = fileNames.getValueById(fileId);
        return fileName;
    }

    public CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        IntToStringCache fileNames = this.getUnitFileNames(unitId);
        String fileName = fileNames.containsId(fileId) ? fileNames.getValueById(fileId) : "?";
        return fileName;
    }

    public int getUnitId(CharSequence unitName) {
        if (!unitNamesCache.containsValue(unitName)) {
            StorageAllocator.getInstance().deleteUnitFiles(unitName, false);
        }
        return unitNamesCache.getId(unitName);
    }

    public CharSequence getUnitName(int unitId) {
        return unitNamesCache.getValueById(unitId);
    }

    public CharSequence getUnitNameSafe(int unitId) {
        return unitNamesCache.containsId(unitId) ? unitNamesCache.getValueById(unitId) : "No Index " + unitId + " in " + unitNamesCache;
    }

    public static int getVersion() {
        return version;
    }

    public void closeUnit(CharSequence unitName, Set<CharSequence> requiredUnits) {
        if (requiredUnits != null) {
            unitNamesCache.updateReqUnitInfo(unitName, requiredUnits);
        }
        unitNamesCache.storeUnitIndex(unitName);
        unitNamesCache.removeFileNames(unitName);
    }

    public void shutdown() {
        unitNamesCache.storeMasterIndex();
        StorageAllocator.getInstance().purgeCaches();
    }

    public void loadUnitIndex(CharSequence unitName) {
        unitNamesCache.loadUnitIndex(unitName, new HashSet<CharSequence>());
    }

    public void removeUnit(CharSequence unitName) {
        unitNamesCache.removeUnit(unitName);
    }

    public void startup(int newVersion) {
        version = newVersion;
        this.init();
    }

    private IntToStringCache getUnitFileNames(int unitId) {
        return unitNamesCache.getFileNames(unitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        boolean aLoaded = loaded;
        if (!aLoaded) {
            Object object = initLock;
            synchronized (object) {
                if (!loaded) {
                    unitNamesCache = new UnitsCache();
                    loaded = true;
                }
            }
        }
    }
}

