/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.JBItemNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    public static final String WAIT_NODE = "wait_node";
    public static final String INFO_NODE = "info_node";
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    public static MBeanServerConnection getRMIServer(Lookup lookup) {
        return Util.getRMIServer((JBDeploymentManager)lookup.lookup(JBDeploymentManager.class));
    }

    public static MBeanServerConnection getRMIServer(JBDeploymentManager manager) {
        return manager.getRMIServer();
    }

    public static Node createWaitNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_WaitNode_DisplayName"));
        n.setIconBaseWithExtension("org/netbeans/modules/j2ee/jboss4/resources/wait.gif");
        return n;
    }

    public static Node createInfoNode() {
        AbstractNode n = new AbstractNode(Children.LEAF);
        n.setName(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_DisplayName"));
        n.setShortDescription(NbBundle.getMessage(JBItemNode.class, (String)"LBL_InfoNode_ToolTip"));
        n.setIconBaseWithExtension("org/netbeans/core/resources/exception.gif");
        return n;
    }

    public static Method fixJava4071957(Method method) {
        try {
            method.setAccessible(true);
            return method;
        }
        catch (SecurityException ex) {
            while (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                try {
                    method = method.getDeclaringClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
            return method;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRemoteManagementSupported(Lookup lookup) {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            MBeanServerConnection server = Util.getRMIServer(lookup);
            Thread.currentThread().setContextClassLoader(server.getClass().getClassLoader());
            ObjectName searchPattern = new ObjectName("jboss.management.local:*");
            Method method = server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
            method = Util.fixJava4071957(method);
            Set managedObj = (Set)method.invoke((Object)server, searchPattern, null);
            if (managedObj.isEmpty()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (SecurityException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (MalformedObjectNameException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (NullPointerException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isObjectDeployed(Object server, ObjectName searchPattern) {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(server.getClass().getClassLoader());
            Method method = server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
            method = Util.fixJava4071957(method);
            Set managedObj = (Set)method.invoke(server, searchPattern, null);
            if (managedObj.size() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger("global").log(Level.INFO, null, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        return false;
    }

    public static String getModuleTypeString(ModuleType mt) {
        if (mt.equals(ModuleType.EAR)) {
            return "J2EEApplication";
        }
        if (mt.equals(ModuleType.WAR)) {
            return "WebModule";
        }
        if (mt.equals(ModuleType.EJB)) {
            return "EJBModule";
        }
        return "undefined";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getMBeanParameter(JBDeploymentManager dm, String name, String targetObject) {
        Object retval = null;
        MBeanServerConnection server = dm.refreshRMIServer();
        if (server == null) {
            return retval;
        }
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(server.getClass().getClassLoader());
            retval = server.getAttribute(new ObjectName(targetObject), name);
        }
        catch (InstanceNotFoundException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (AttributeNotFoundException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (MalformedObjectNameException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (NullPointerException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (ReflectionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (MBeanException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        return retval;
    }

    public static String getWebContextRoot(String descriptor, String warName) {
        String context = Util.getDescriptorContextRoot(descriptor);
        if (context == null) {
            context = Util.getWarContextRoot(warName);
        }
        if ("/ROOT".equals(context)) {
            return "/";
        }
        return context;
    }

    private static String getDescriptorContextRoot(String descriptor) {
        if (descriptor == null || "".equals(descriptor.trim())) {
            return null;
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(descriptor)));
        }
        catch (SAXException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        catch (ParserConfigurationException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        org.w3c.dom.Node node = doc.getElementsByTagName("context-root").item(0);
        if (node == null || node.getTextContent() == null) {
            return null;
        }
        String text = node.getTextContent();
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        return text;
    }

    private static String getWarContextRoot(String warName) {
        if (warName == null) {
            return null;
        }
        if (!warName.endsWith(".war")) {
            return "/" + warName;
        }
        return "/" + warName.substring(0, warName.lastIndexOf(".war"));
    }
}

