/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.beans.CdiUtil;
import org.netbeans.modules.web.beans.analysis.BeansXmlFix;
import org.netbeans.modules.web.beans.analysis.CdiEditorAnalysisFactory;
import org.netbeans.modules.web.beans.analysis.CdiEditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.web.beans.hints.CDIAnnotation;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CdiAnalysisResult {
    private CompilationInfo myInfo;
    private List<ErrorDescription> myProblems;
    private boolean isCdiRequired;
    private List<CDIAnnotation> myCollectedAnnotations;
    private CdiEditorAnalysisFactory myFactory;

    public CdiAnalysisResult(CompilationInfo info, CdiEditorAwareJavaSourceTaskFactory factory) {
        this.myInfo = info;
        this.myProblems = new LinkedList<ErrorDescription>();
        this.myCollectedAnnotations = new LinkedList<CDIAnnotation>();
    }

    public void addError(Element subject, String message) {
        this.addNotification(Severity.ERROR, subject, message);
    }

    public void addError(Element subject, String message, Fix fix) {
        this.addNotification(Severity.ERROR, subject, message, fix);
    }

    public void addNotification(Severity severity, Element element, String message) {
        this.addNotification(severity, element, message, null);
    }

    public void addNotification(Severity severity, Element element, String message, Fix fix) {
        ErrorDescription description = CdiEditorAnalysisFactory.createNotification(severity, element, this.myInfo, message, fix);
        if (description == null) {
            return;
        }
        this.getProblems().add(description);
    }

    public CompilationInfo getInfo() {
        return this.myInfo;
    }

    public List<ErrorDescription> getProblems() {
        return this.myProblems;
    }

    public void requireCdiEnabled(Element element) {
        if (this.isCdiRequired) {
            return;
        }
        this.isCdiRequired = true;
        FileObject fileObject = this.getInfo().getFileObject();
        if (fileObject == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return;
        }
        CdiUtil lookup = (CdiUtil)project.getLookup().lookup(CdiUtil.class);
        boolean needFix = false;
        if (lookup == null) {
            needFix = !CdiUtil.hasBeansXml(project);
        } else {
            boolean bl = needFix = !lookup.isCdiEnabled();
        }
        if (needFix) {
            BeansXmlFix fix = new BeansXmlFix(project, fileObject, this.myFactory);
            this.addError(element, NbBundle.getMessage(CdiAnalysisResult.class, (String)"ERR_RequireWebBeans"), fix);
        }
    }

    public boolean requireBeansXml() {
        return this.isCdiRequired;
    }

    public void addAnnotation(CDIAnnotation annotation) {
        this.myCollectedAnnotations.add(annotation);
    }

    public List<CDIAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.myCollectedAnnotations);
    }
}

