/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.AbstractRule;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPHintsProvider;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class MethodRedeclarationHint
extends AbstractRule {
    private static final String HINT_ID = "Method.Redeclaration.Hint";
    private FileObject fileObject;
    private List<Hint> hints;

    @Override
    void computeHintsImpl(PHPRuleContext context, List<Hint> hints, PHPHintsProvider.Kind kind) throws BadLocationException {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = context.parserResult.getSnapshot().getSource().getFileObject();
        this.hints = hints;
        this.checkTypeScopes(ModelUtils.getDeclaredClasses(fileScope));
        this.checkTypeScopes(ModelUtils.getDeclaredInterfaces(fileScope));
        this.checkDeclaredFunctions(ModelUtils.getDeclaredFunctions(fileScope));
    }

    private void checkTypeScopes(Collection<? extends TypeScope> typeScopes) {
        for (TypeScope typeScope : typeScopes) {
            this.checkDeclaredFunctions(typeScope.getDeclaredMethods());
        }
    }

    private void checkDeclaredFunctions(Collection<? extends FunctionScope> declaredFunctions) {
        HashSet<String> declaredMethodNames = new HashSet<String>();
        for (FunctionScope functionScope : declaredFunctions) {
            String methodName = functionScope.getName();
            if (declaredMethodNames.contains(methodName)) {
                this.hints.add(new Hint((Rule)this, Bundle.MethodRedeclarationCustom(methodName), this.fileObject, functionScope.getNameRange(), null, 500));
                continue;
            }
            declaredMethodNames.add(methodName);
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.MethodRedeclarationHintDesc();
    }

    public String getDisplayName() {
        return Bundle.MethodRedeclarationHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.ERROR;
    }
}

