/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.php.editor.indent.FormatToken;
import org.netbeans.modules.php.editor.indent.TokenFormatter;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CastExpression;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.util.Exceptions;

public class FormatVisitor
extends DefaultVisitor {
    private static final Logger LOGGER = Logger.getLogger(FormatVisitor.class.getName());
    private BaseDocument document;
    private final List<FormatToken> formatTokens;
    TokenSequence<PHPTokenId> ts;
    private LinkedList<ASTNode> path;
    private int indentLevel;
    private final int tsTokenCount;
    private final int maxFormattingRules;
    private TokenFormatter.DocumentOptions options;
    private boolean includeWSBeforePHPDoc;
    private boolean isCurly;
    private boolean isMethodInvocationShifted;
    private boolean isFirstUseStatementPart;
    private FormatToken.AssignmentAnchorToken previousGroupToken = null;
    private int lastIndex = -1;

    public FormatVisitor(BaseDocument document) {
        this.document = document;
        this.ts = LexUtilities.getPHPTokenSequence((Document)document, 0);
        this.path = new LinkedList();
        this.indentLevel = 0;
        this.options = new TokenFormatter.DocumentOptions(document);
        this.includeWSBeforePHPDoc = true;
        this.tsTokenCount = this.ts == null ? 1 : this.ts.tokenCount();
        this.formatTokens = new ArrayList<FormatToken>(this.tsTokenCount * 2);
        this.maxFormattingRules = this.tsTokenCount * 3;
        this.formatTokens.add(new FormatToken.InitToken());
        this.isMethodInvocationShifted = false;
    }

    public List<FormatToken> getFormatTokens() {
        return this.formatTokens;
    }

    private void showAssertionFor185063() {
        boolean showAssertFor185063 = false;
        if (!$assertionsDisabled) {
            showAssertFor185063 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (showAssertFor185063) {
            try {
                assert (false) : "Too many formatting rules.\nPlease report this to help fix issue 185063.\n\n" + this.document.getText(0, this.document.getLength() - 1);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        assert (false);
    }

    @Override
    public void scan(ASTNode node) {
        if (node == null) {
            return;
        }
        int indent = this.path.size();
        if (this.formatTokens.size() > this.maxFormattingRules) {
            this.showAssertionFor185063();
        }
        ArrayList<FormatToken> beforeTokens = new ArrayList<FormatToken>(30);
        int indexBeforeLastComment = -1;
        while (this.moveNext() && this.ts.offset() < node.getStartOffset() && this.lastIndex < this.ts.index() && (this.ts.offset() + this.ts.token().length() <= node.getStartOffset() || this.ts.token().id() == PHPTokenId.PHP_CLOSETAG)) {
            if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE && this.path.size() > 1 && this.path.get(1) instanceof NamespaceDeclaration) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_RIGHT_BRACE, this.ts.offset()));
            }
            this.addFormatToken(beforeTokens);
            if (this.ts.token().id() != PHPTokenId.PHPDOC_COMMENT_START && (this.ts.token().id() != PHPTokenId.PHP_LINE_COMMENT || !"//".equals(((Object)this.ts.token().text()).toString()) || indexBeforeLastComment != -1)) continue;
            if (this.ts.movePrevious() && this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) > 0) {
                indexBeforeLastComment = beforeTokens.size() - 1;
            }
            this.ts.moveNext();
        }
        this.includeWSBeforePHPDoc = true;
        if (indexBeforeLastComment > 0) {
            int i;
            for (i = 0; i < indexBeforeLastComment; ++i) {
                this.formatTokens.add((FormatToken)beforeTokens.get(i));
            }
            if (node instanceof ClassDeclaration || node instanceof InterfaceDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
                this.includeWSBeforePHPDoc = false;
            } else if (node instanceof FunctionDeclaration || node instanceof MethodDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
                this.includeWSBeforePHPDoc = false;
            } else if (node instanceof FieldsDeclaration) {
                if (this.isPreviousNodeTheSameInBlock(this.path.get(0), (Statement)node)) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
                }
                this.includeWSBeforePHPDoc = false;
            } else if (node instanceof UseStatement) {
                if (this.isPreviousNodeTheSameInBlock(this.path.get(0), (Statement)node)) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE, this.ts.offset()));
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE, this.ts.offset()));
                }
                this.includeWSBeforePHPDoc = false;
            }
            for (i = indexBeforeLastComment; i < beforeTokens.size(); ++i) {
                this.formatTokens.add((FormatToken)beforeTokens.get(i));
            }
        } else {
            this.formatTokens.addAll(beforeTokens);
        }
        this.ts.movePrevious();
        this.path.addFirst(node);
        super.scan(node);
        this.path.removeFirst();
        while (this.moveNext() && this.lastIndex < this.ts.index() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    @Override
    public void scan(Iterable<? extends ASTNode> nodes) {
        super.scan(nodes);
    }

    @Override
    public void visit(ArrayCreation node) {
        int delta = this.options.indentArrayItems - this.options.continualIndentSize;
        if (this.ts.token().id() != PHPTokenId.PHP_ARRAY && this.lastIndex <= this.ts.index()) {
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ARRAY && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.formatTokens.get(this.formatTokens.size() - 1).getId() == FormatToken.Kind.WHITESPACE_INDENT || this.path.get(1) instanceof ArrayElement || this.path.get(1) instanceof FormalParameter || this.path.get(1) instanceof CastExpression) {
                delta = this.options.indentArrayItems;
            }
            if (this.path.get(1) instanceof FunctionInvocation && ((FunctionInvocation)this.path.get(1)).getParameters().size() == 1) {
                int hindex;
                for (hindex = this.formatTokens.size() - 1; hindex > 0 && this.formatTokens.get(hindex).getId() != FormatToken.Kind.TEXT && this.formatTokens.get(hindex).getId() != FormatToken.Kind.WHITESPACE_INDENT && this.lastIndex < this.ts.index(); --hindex) {
                }
                if (hindex > 0 && this.formatTokens.get(hindex).getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                    delta = this.options.indentArrayItems;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), delta));
        this.previousGroupToken = null;
        super.visit(node);
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * delta));
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(ArrayElement node) {
        if (node.getKey() != null && node.getValue() != null) {
            this.scan(node.getKey());
            while (this.ts.moveNext() && this.ts.offset() < node.getValue().getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_OPERATOR && "=>".equals(((Object)this.ts.token().text()).toString())) {
                    this.handleGroupAlignment(node.getKey());
                    this.addFormatToken(this.formatTokens);
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.scan(node.getValue());
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(Assignment node) {
        this.scan(node.getLeftHandSide());
        while (this.ts.moveNext() && this.ts.offset() + this.ts.token().length() < node.getRightHandSide().getStartOffset() && this.ts.token().id() != PHPTokenId.PHP_TOKEN) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_TOKEN) {
            if (node.getLeftHandSide() instanceof Variable) {
                this.handleGroupAlignment(node.getLeftHandSide());
            }
            this.addFormatToken(this.formatTokens);
        } else {
            this.ts.movePrevious();
        }
        this.scan(node.getRightHandSide());
    }

    @Override
    public void visit(Block node) {
        this.previousGroupToken = null;
        if (this.path.size() > 1 && this.path.get(1) instanceof NamespaceDeclaration && !((NamespaceDeclaration)this.path.get(1)).isBracketed()) {
            super.visit(node);
            return;
        }
        this.isCurly = node.isCurly();
        while (this.ts.moveNext() && node.isCurly() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN && this.ts.offset() < node.getStartOffset() && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        ASTNode parent = this.path.get(1);
        if (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
            if (parent instanceof ClassDeclaration || parent instanceof InterfaceDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof IfStatement) {
                IfStatement ifStatement = (IfStatement)parent;
                if (ifStatement.getFalseStatement() != null && ifStatement.getFalseStatement().getStartOffset() <= node.getStartOffset()) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ELSE_LEFT_BRACE, this.ts.offset()));
                } else {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_LEFT_BRACE, this.ts.offset()));
                }
            } else if (parent instanceof ForStatement || parent instanceof ForEachStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof WhileStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof DoStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_DO_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof SwitchStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_LEFT_BACE, this.ts.offset()));
            } else if (parent instanceof TryStatement) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_TRY_LEFT_BRACE, this.ts.offset()));
            } else if (parent instanceof CatchClause) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_LEFT_BRACE, this.ts.offset()));
            } else {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_LEFT_BRACE, this.ts.offset()));
            }
            this.addFormatToken(this.formatTokens);
            boolean indentationIncluded = false;
            while (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.isComment((Token<? extends PHPTokenId>)this.ts.token())) {
                if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && !indentationIncluded) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
                    indentationIncluded = true;
                }
                this.addFormatToken(this.formatTokens);
            }
            if (!indentationIncluded) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
            }
            if (parent instanceof ClassDeclaration || parent instanceof InterfaceDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLASS_LEFT_BRACE, this.ts.offset()));
            } else {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_OTHER_LEFT_BRACE, this.ts.offset()));
            }
        }
        this.ts.movePrevious();
        super.visit(node);
        if (node.isCurly() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            while (this.ts.moveNext() && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE) {
                    FormatToken lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
                    if (lastToken.getId() == FormatToken.Kind.WHITESPACE || lastToken.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                        this.formatTokens.remove(this.formatTokens.size() - 1);
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                        this.formatTokens.add(lastToken);
                    } else {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
                    }
                    boolean includeWBC = false;
                    if (this.ts.movePrevious() && (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN || this.ts.token().id() == PHPTokenId.WHITESPACE)) {
                        if (this.ts.token().id() == PHPTokenId.WHITESPACE) {
                            if (this.ts.movePrevious() && this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                                includeWBC = true;
                            }
                            this.ts.moveNext();
                        }
                        if (this.ts.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                            includeWBC = true;
                        }
                    }
                    this.ts.moveNext();
                    if (includeWBC) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_OPEN_CLOSE_BRACES, this.ts.offset()));
                    }
                    if (parent instanceof ClassDeclaration || parent instanceof InterfaceDeclaration) {
                        if (this.includeWSBeforePHPDoc) {
                            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS_RIGHT_BRACE, this.ts.offset()));
                        }
                        this.addFormatToken(this.formatTokens);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLASS, this.ts.offset() + this.ts.token().length()));
                        continue;
                    }
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FUNCTION, this.ts.offset() + this.ts.token().length()));
                        continue;
                    }
                    if (parent instanceof IfStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof ForStatement || parent instanceof ForEachStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof SwitchStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_RIGHT_BACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    if (parent instanceof CatchClause || parent instanceof TryStatement) {
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_RIGHT_BRACE, this.ts.offset()));
                        this.addFormatToken(this.formatTokens);
                        continue;
                    }
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OTHER_RIGHT_BRACE, this.ts.offset()));
                    this.addFormatToken(this.formatTokens);
                    continue;
                }
                FormatToken lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
                if (lastToken.getId() == FormatToken.Kind.TEXT && lastToken.getOffset() >= this.ts.offset() || this.lastIndex >= this.ts.index()) continue;
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
        }
    }

    @Override
    public void visit(CastExpression node) {
        super.visit(node);
    }

    @Override
    public void visit(ClassDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLASS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        block4: while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_CURLY_OPEN) {
            switch ((PHPTokenId)this.ts.token().id()) {
                case PHP_IMPLEMENTS: {
                    if (node.getInterfaes().size() <= 0) continue block4;
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    Expression inter = node.getInterfaes().get(0);
                    this.ts.movePrevious();
                    this.addUnbreakalbeSequence(inter, true);
                    for (int i = 1; i < node.getInterfaes().size(); ++i) {
                        if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE) {
                            this.addFormatToken(this.formatTokens);
                        }
                        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_INTERFACE_LIST, this.ts.offset()));
                        inter = node.getInterfaes().get(i);
                        this.addUnbreakalbeSequence(inter, false);
                    }
                    continue block4;
                }
                case PHP_EXTENDS: {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_EXTENDS_IMPLEMENTS, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    this.addFormatToken(this.formatTokens);
                    continue block4;
                }
            }
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        super.visit(node);
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        this.scan(node.getClassName());
        if (node.ctorParams() != null && node.ctorParams().size() > 0) {
            this.formatTokens.add(new FormatToken.IndentToken(node.getClassName().getEndOffset(), this.options.continualIndentSize));
            this.scan(node.ctorParams());
            this.formatTokens.add(new FormatToken.IndentToken(node.ctorParams().get(node.ctorParams().size() - 1).getEndOffset(), -1 * this.options.continualIndentSize));
            this.addAllUntilOffset(node.getEndOffset());
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(ConditionalExpression node) {
        int start;
        boolean putContinualIndent;
        this.scan(node.getCondition());
        boolean wrap = node.getIfTrue() != null;
        ASTNode astNode = this.path.get(1);
        boolean bl = putContinualIndent = !(astNode instanceof Assignment) && !(astNode instanceof ReturnStatement);
        if (wrap) {
            while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !"?".equals(((Object)this.ts.token().text()).toString())) && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            start = this.ts.offset();
            if (putContinualIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            }
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_TERNARY_OP, start));
            this.ts.movePrevious();
            this.addAllUntilOffset(node.getIfTrue().getStartOffset());
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getIfTrue());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getIfTrue().getEndOffset());
            if (putContinualIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
            }
        }
        boolean bl2 = wrap = node.getIfFalse() != null;
        if (wrap) {
            while (this.ts.moveNext() && (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !":".equals(((Object)this.ts.token().text()).toString())) && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            start = this.ts.offset();
            if (putContinualIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            }
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_TERNARY_OP, start));
            this.ts.movePrevious();
            this.addAllUntilOffset(node.getIfFalse().getStartOffset());
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getIfFalse());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getIfFalse().getEndOffset());
            if (putContinualIndent) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
            }
        }
    }

    @Override
    public void visit(ConstantDeclaration node) {
        if (this.path.size() > 1 && this.path.get(1) instanceof Block) {
            int index;
            Block block = (Block)this.path.get(1);
            List<Statement> statements = block.getStatements();
            for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
            }
            this.addAllUntilOffset(node.getStartOffset());
            if (this.includeWSBeforePHPDoc && index < statements.size() && index > 0 && statements.get(index - 1) instanceof ConstantDeclaration) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
            } else if (this.includeWSBeforePHPDoc) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
            } else {
                this.includeWSBeforePHPDoc = true;
            }
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
            this.scan(node.getNames());
            if (node.getNames().size() == 1) {
                while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_TOKEN) {
                    this.addFormatToken(this.formatTokens);
                }
                if (this.ts.token().id() == PHPTokenId.PHP_TOKEN) {
                    this.handleGroupAlignment(node.getNames().get(0));
                    this.addFormatToken(this.formatTokens);
                } else {
                    this.ts.movePrevious();
                }
            }
            this.scan(node.getInitializers());
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize * -1));
            if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof ConstantDeclaration)) {
                this.addRestOfLine();
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FIELDS, this.ts.offset() + this.ts.token().length()));
            }
        } else {
            this.addAllUntilOffset(node.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
            super.visit(node);
            this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), this.options.continualIndentSize * -1));
        }
    }

    @Override
    public void visit(DoStatement node) {
        Statement body = node.getBody();
        if (body != null && !(body instanceof Block)) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_DO_STATEMENT, this.ts.offset()));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
            this.scan(body);
            this.addEndOfUnbreakableSequence(body.getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else {
            this.scan(body);
        }
        this.scan(node.getCondition());
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(ExpressionStatement node) {
        if (node.getExpression() instanceof FunctionInvocation) {
            super.visit(node);
        } else {
            this.addAllUntilOffset(node.getStartOffset());
            if (this.moveNext() && this.lastIndex < this.ts.index()) {
                boolean addIndent;
                this.addFormatToken(this.formatTokens);
                Expression expression = node.getExpression();
                boolean bl = addIndent = !(expression instanceof MethodInvocation) && !(expression instanceof StaticMethodInvocation);
                if (addIndent) {
                    this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                    super.visit(node);
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                } else {
                    super.visit(node);
                }
            }
        }
    }

    @Override
    public void visit(FieldsDeclaration node) {
        int index;
        Block block = (Block)this.path.get(1);
        List<Statement> statements = block.getStatements();
        for (index = 0; index < statements.size() && statements.get(index).getStartOffset() < node.getStartOffset(); ++index) {
        }
        this.addAllUntilOffset(node.getStartOffset());
        if (this.includeWSBeforePHPDoc && index < statements.size() && index > 0 && statements.get(index - 1) instanceof FieldsDeclaration) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_FIELDS, this.ts.offset()));
        } else if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FIELDS, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        if (node.getFields().size() > 1) {
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize));
            super.visit(node);
            this.formatTokens.add(new FormatToken.IndentToken(node.getStartOffset(), this.options.continualIndentSize * -1));
        } else {
            super.visit(node);
        }
        if (index == statements.size() - 1 || index < statements.size() - 1 && !(statements.get(index + 1) instanceof FieldsDeclaration)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_FIELDS, this.ts.offset() + this.ts.token().length()));
        }
    }

    @Override
    public void visit(ForEachStatement node) {
        this.scan(node.getExpression());
        this.scan(node.getKey());
        this.scan(node.getValue());
        Statement body = node.getStatement();
        if (body != null && body instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getStatement());
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML) {
                while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ENDFOREACH) {
                    this.addFormatToken(this.formatTokens);
                }
                this.ts.movePrevious();
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_FOR_STATEMENT);
        } else {
            this.scan(node.getStatement());
        }
    }

    @Override
    public void visit(ForStatement node) {
        Statement body;
        int start;
        boolean wrap;
        this.scan(node.getInitializers());
        boolean bl = wrap = node.getConditions() != null && node.getConditions().size() > 0;
        if (wrap) {
            start = node.getConditions().get(0).getStartOffset();
            this.addAllUntilOffset(start);
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getConditions());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getConditions().get(node.getConditions().size() - 1).getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        boolean bl2 = wrap = node.getUpdaters() != null && node.getUpdaters().size() > 0;
        if (wrap) {
            start = node.getUpdaters().get(0).getStartOffset();
            this.addAllUntilOffset(start);
            this.formatTokens.add(new FormatToken.IndentToken(start, this.options.continualIndentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_FOR, start));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(start, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        }
        this.scan(node.getUpdaters());
        if (wrap) {
            this.addEndOfUnbreakableSequence(node.getUpdaters().get(node.getUpdaters().size() - 1).getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
        if ((body = node.getBody()) != null && body instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getBody());
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_FOR_STATEMENT);
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(FunctionDeclaration node) {
        if (this.path.size() <= 1 || !(this.path.get(1) instanceof MethodDeclaration)) {
            while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()))) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.includeWSBeforePHPDoc) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
            } else {
                this.includeWSBeforePHPDoc = true;
            }
            this.ts.movePrevious();
        }
        this.scan(node.getFunctionName());
        List<FormalParameter> parameters = node.getFormalParameters();
        if (parameters != null && parameters.size() > 0) {
            while (this.ts.moveNext() && this.ts.offset() < parameters.get(0).getStartOffset() && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.addUnbreakalbeSequence(parameters.get(0), true);
            for (int i = 1; i < parameters.size(); ++i) {
                if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE) {
                    this.addFormatToken(this.formatTokens);
                } else {
                    this.ts.movePrevious();
                }
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_PARAMETER_LIST, this.ts.offset() + this.ts.token().length()));
                this.addUnbreakalbeSequence(parameters.get(i), false);
            }
        }
        this.scan(node.getBody());
    }

    @Override
    public void visit(FunctionInvocation node) {
        if (this.path.size() > 1 && this.path.get(1) instanceof MethodInvocation) {
            while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_OBJECT_OPERATOR && this.ts.offset() + this.ts.token().length() < node.getStartOffset()) {
                this.addFormatToken(this.formatTokens);
            }
            if (this.ts.token().id() == PHPTokenId.PHP_OBJECT_OPERATOR) {
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_CHAINED_METHOD_CALLS, this.ts.offset()));
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
        }
        this.scan(node.getFunctionName());
        List<Expression> parameters = node.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean addIndentation;
            boolean bl = addIndentation = !(this.path.get(1) instanceof Assignment) && (this.path.size() <= 2 || !(this.path.get(1) instanceof MethodInvocation) || !(this.path.get(2) instanceof Assignment));
            if (addIndentation) {
                this.formatTokens.add(new FormatToken.IndentToken(node.getFunctionName().getEndOffset(), this.options.continualIndentSize));
            }
            while (this.ts.moveNext() && this.ts.offset() < parameters.get(0).getStartOffset() && this.lastIndex < this.ts.index()) {
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.addUnbreakalbeSequence(parameters.get(0), true);
            for (int i = 1; i < parameters.size(); ++i) {
                if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.WHITESPACE) {
                    this.addFormatToken(this.formatTokens);
                } else {
                    this.ts.movePrevious();
                }
                this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_IN_ARGUMENT_LIST, this.ts.offset() + this.ts.token().length()));
                this.addUnbreakalbeSequence(parameters.get(i), false);
            }
            if (addIndentation) {
                ArrayList<FormatToken> removed = new ArrayList<FormatToken>();
                FormatToken ftoken = this.formatTokens.get(this.formatTokens.size() - 1);
                while (ftoken.getId() == FormatToken.Kind.UNBREAKABLE_SEQUENCE_END || ftoken.isWhitespace() && ftoken.getId() != FormatToken.Kind.WHITESPACE_INDENT || ftoken.getId() == FormatToken.Kind.COMMENT || ftoken.getId() == FormatToken.Kind.COMMENT_START || ftoken.getId() == FormatToken.Kind.COMMENT_END || ftoken.getId() == FormatToken.Kind.TEXT && ")".equals(ftoken.getOldText().toString())) {
                    this.formatTokens.remove(this.formatTokens.size() - 1);
                    removed.add(ftoken);
                    ftoken = this.formatTokens.get(this.formatTokens.size() - 1);
                }
                if (ftoken.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                    for (int i = removed.size() - 1; i > -1; --i) {
                        this.formatTokens.add((FormatToken)removed.get(i));
                    }
                } else {
                    for (int i = removed.size() - 1; i > -1; --i) {
                        this.formatTokens.add((FormatToken)removed.get(i));
                    }
                    this.formatTokens.add(new FormatToken.IndentToken(node.getEndOffset(), -1 * this.options.continualIndentSize));
                }
            }
        }
        this.addAllUntilOffset(node.getEndOffset());
    }

    @Override
    public void visit(InfixExpression node) {
        this.scan(node.getLeft());
        FormatToken.Kind whitespace = FormatToken.Kind.WHITESPACE_AROUND_BINARY_OP;
        if (node.getOperator() == InfixExpression.OperatorType.CONCAT) {
            whitespace = FormatToken.Kind.WHITESPACE_AROUND_CONCAT_OP;
        }
        while (this.ts.moveNext() && this.ts.offset() < node.getRight().getStartOffset() && this.ts.token().id() != PHPTokenId.PHP_TOKEN && this.ts.token().id() != PHPTokenId.PHP_OPERATOR && this.lastIndex < this.ts.index()) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_TOKEN || this.ts.token().id() == PHPTokenId.PHP_OPERATOR) {
            this.formatTokens.add(new FormatToken(whitespace, this.ts.offset()));
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken(whitespace, this.ts.offset() + this.ts.token().length()));
        } else {
            this.ts.movePrevious();
        }
        this.scan(node.getRight());
    }

    @Override
    public void visit(IfStatement node) {
        this.addAllUntilOffset(node.getCondition().getStartOffset());
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
        this.scan(node.getCondition());
        Statement body = node.getTrueStatement();
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        if (body != null && body instanceof Block && !((Block)body).isCurly()) {
            this.isCurly = false;
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(body);
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.isCurly = false;
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_IF_ELSE_STATEMENT);
        } else {
            this.scan(node.getTrueStatement());
        }
        body = node.getFalseStatement();
        if (body != null && body instanceof Block && !((Block)body).isCurly() && !(body instanceof IfStatement)) {
            this.isCurly = false;
            while (this.ts.moveNext() && this.ts.offset() < body.getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_ELSE || this.ts.token().id() == PHPTokenId.PHP_ELSEIF) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.ts.movePrevious();
            this.scan(node.getFalseStatement());
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block) && !(body instanceof IfStatement)) {
            this.isCurly = false;
            while (this.ts.moveNext() && this.ts.offset() < body.getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_ELSE || this.ts.token().id() == PHPTokenId.PHP_ELSEIF) {
                    this.formatTokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_ELSE_STATEMENT, this.ts.offset()));
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
            this.scan(body);
            this.addEndOfUnbreakableSequence(body.getEndOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else {
            this.scan(node.getFalseStatement());
        }
    }

    @Override
    public void visit(MethodDeclaration node) {
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()))) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FUNCTION, this.ts.offset()));
        } else {
            this.includeWSBeforePHPDoc = true;
        }
        this.ts.movePrevious();
        super.visit(node);
    }

    @Override
    public void visit(MethodInvocation node) {
        boolean shift = false;
        if (!this.isMethodInvocationShifted) {
            try {
                int startText = node.getDispatcher().getEndOffset();
                int endText = node.getMethod().getStartOffset();
                if (this.document.getText(startText, endText - startText).contains("\n")) {
                    boolean addIndent;
                    shift = true;
                    this.addAllUntilOffset(node.getStartOffset());
                    boolean bl = addIndent = this.path.size() <= 1 || !(this.path.get(1) instanceof Assignment);
                    if (addIndent) {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                    }
                    this.isMethodInvocationShifted = true;
                    super.visit(node);
                    this.addAllUntilOffset(this.indentLevel);
                    if (addIndent) {
                        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * this.options.continualIndentSize));
                    }
                    this.isMethodInvocationShifted = false;
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Exception in scanning method invocation", ex);
                shift = false;
            }
        }
        if (!shift) {
            super.visit(node);
        }
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        this.addAllUntilOffset(node.getStartOffset());
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_NAMESPACE, node.getStartOffset()));
        this.scan(node.getName());
        this.addRestOfLine();
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_NAMESPACE, this.ts.offset() + this.ts.token().length()));
        this.scan(node.getBody());
    }

    @Override
    public void visit(Program program) {
        if (this.ts != null) {
            FormatToken lastToken;
            this.path.addFirst(program);
            this.ts.move(0);
            this.ts.moveNext();
            this.ts.movePrevious();
            this.addFormatToken(this.formatTokens);
            super.visit(program);
            FormatToken formatToken = lastToken = this.formatTokens.size() > 0 ? this.formatTokens.get(this.formatTokens.size() - 1) : null;
            while (this.ts.moveNext()) {
                if (lastToken != null && !lastToken.isWhitespace() && lastToken.getOffset() <= this.ts.offset() || this.lastIndex >= this.ts.index()) continue;
                this.addFormatToken(this.formatTokens);
                lastToken = this.formatTokens.get(this.formatTokens.size() - 1);
            }
            this.path.removeFirst();
        }
    }

    @Override
    public void visit(ReturnStatement node) {
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_RETURN && this.ts.offset() + this.ts.token().length() <= node.getEndOffset()) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_RETURN) {
            this.addFormatToken(this.formatTokens);
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.continualIndentSize));
            super.visit(node);
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.continualIndentSize));
        }
    }

    @Override
    public void visit(SingleFieldDeclaration node) {
        this.scan(node.getName());
        if (node.getValue() != null) {
            while (this.ts.moveNext() && this.ts.offset() < node.getValue().getStartOffset()) {
                if (this.ts.token().id() == PHPTokenId.PHP_TOKEN && "=".equals(((Object)this.ts.token().text()).toString())) {
                    this.handleGroupAlignment(node.getName());
                    this.addFormatToken(this.formatTokens);
                    continue;
                }
                this.addFormatToken(this.formatTokens);
            }
            this.ts.movePrevious();
            if (node.getValue() != null) {
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), this.options.continualIndentSize));
                this.scan(node.getValue());
                this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset() + this.ts.token().length(), -1 * this.options.continualIndentSize));
            }
        }
    }

    @Override
    public void visit(SwitchCase node) {
        if (node.getValue() == null) {
            this.ts.moveNext();
            this.addFormatToken(this.formatTokens);
        } else {
            this.scan(node.getValue());
        }
        this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), this.options.indentSize));
        if (node.getActions() != null) {
            this.scan(node.getActions());
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
        }
    }

    @Override
    public void visit(SwitchStatement node) {
        this.scan(node.getExpression());
        if (node.getBody() != null && node.getBody() instanceof Block && !node.getBody().isCurly()) {
            this.addAllUntilOffset(node.getBody().getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(node.getBody().getStartOffset(), this.options.indentSize));
            if (node.getBody().getStatements().size() > 0) {
                this.scan(node.getBody());
                Statement lastOne = node.getBody().getStatements().get(node.getBody().getStatements().size() - 1);
                while (lastOne.getEndOffset() < this.formatTokens.get(this.formatTokens.size() - 1).getOffset()) {
                    this.formatTokens.remove(this.formatTokens.size() - 1);
                }
                while (lastOne.getEndOffset() < this.ts.offset()) {
                    this.ts.movePrevious();
                }
            } else {
                while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_ENDSWITCH && this.ts.offset() < node.getBody().getEndOffset()) {
                    this.addFormatToken(this.formatTokens);
                }
                this.ts.movePrevious();
            }
            this.formatTokens.add(new FormatToken.IndentToken(this.ts.offset(), -1 * this.options.indentSize));
            this.addAllUntilOffset(node.getEndOffset());
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(TryStatement node) {
        this.scan(node.getBody());
        this.scan(node.getCatchClauses());
    }

    @Override
    public void visit(WhileStatement node) {
        this.scan(node.getCondition());
        Statement body = node.getBody();
        if (body != null && body instanceof Block && !((Block)body).isCurly()) {
            this.addAllUntilOffset(body.getStartOffset());
            this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
            this.scan(node.getBody());
            if (this.ts.token().id() == PHPTokenId.T_INLINE_HTML && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_OPENTAG) {
                this.addFormatToken(this.formatTokens);
            }
            this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
        } else if (body != null && !(body instanceof Block)) {
            this.addNoCurlyBody(body, FormatToken.Kind.WHITESPACE_BEFORE_WHILE_STATEMENT);
        } else {
            this.scan(node.getBody());
        }
    }

    @Override
    public void visit(UseStatement node) {
        if (this.isPreviousNodeTheSameInBlock(this.path.get(1), node)) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_USE, this.ts.offset()));
        } else if (this.includeWSBeforePHPDoc) {
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USE, this.ts.offset()));
        }
        this.includeWSBeforePHPDoc = true;
        this.isFirstUseStatementPart = true;
        super.visit(node);
        if (this.isNextNodeTheSameInBlock(this.path.get(1), node)) {
            this.addRestOfLine();
            this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_USE, this.ts.offset() + this.ts.token().length()));
        }
    }

    @Override
    public void visit(UseStatementPart statementPart) {
        FormatToken lastFormatToken = this.formatTokens.get(this.formatTokens.size() - 1);
        boolean lastRemoved = false;
        if (this.ts.token().id() == PHPTokenId.PHP_NS_SEPARATOR && lastFormatToken.getId() == FormatToken.Kind.TEXT && "\\".equals(lastFormatToken.getOldText())) {
            this.formatTokens.remove(this.formatTokens.size() - 1);
            lastRemoved = true;
        }
        if (this.isFirstUseStatementPart) {
            this.formatTokens.add(new FormatToken.AnchorToken(this.ts.offset()));
            this.isFirstUseStatementPart = false;
        }
        this.formatTokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_USES_PART, this.ts.offset()));
        if (lastRemoved) {
            this.formatTokens.add(lastFormatToken);
        }
        super.visit(statementPart);
    }

    private void showAssertionFor188809() {
        boolean showAssertFor188809 = false;
        if (!$assertionsDisabled) {
            showAssertFor188809 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (showAssertFor188809) {
            try {
                assert (false) : "The same token (index: " + this.ts.index() + " - " + this.ts.token().id() + ", format tokens: " + this.formatTokens.size() + ")  was precessed before.\nPlease report this to help fix issue 188809.\n\n" + this.document.getText(0, this.document.getLength() - 1);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        assert (false);
    }

    private void addFormatToken(List<FormatToken> tokens) {
        if (this.lastIndex == this.ts.index()) {
            this.showAssertionFor188809();
            this.ts.moveNext();
            return;
        }
        this.lastIndex = this.ts.index();
        switch ((PHPTokenId)this.ts.token().id()) {
            case WHITESPACE: {
                int countNewLines = this.countOfNewLines(this.ts.token().text());
                if (countNewLines > 1) {
                    this.previousGroupToken = null;
                }
                tokens.add(countNewLines > 0 ? new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, this.ts.offset(), ((Object)this.ts.token().text()).toString()) : new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_LINE_COMMENT: {
                String text = ((Object)this.ts.token().text()).toString();
                if (this.ts.token().text().charAt(this.ts.token().length() - 1) == '\n') {
                    text = text.substring(0, text.length() - 1);
                    int newOffset = this.ts.offset() + this.ts.token().length() - 1;
                    if (text.length() > 0) {
                        tokens.add(new FormatToken(FormatToken.Kind.LINE_COMMENT, this.ts.offset(), text));
                    }
                    if (this.ts.moveNext()) {
                        if (this.ts.token().id() == PHPTokenId.WHITESPACE) {
                            int countNewLines = this.countOfNewLines(this.ts.token().text());
                            if (countNewLines > 0) {
                                this.previousGroupToken = null;
                            }
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n" + ((Object)this.ts.token().text()).toString()));
                            if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BETWEEN_LINE_COMMENTS, this.ts.offset()));
                                break;
                            }
                            this.ts.movePrevious();
                            break;
                        }
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n"));
                        this.ts.movePrevious();
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_INDENT, newOffset, "\n"));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.LINE_COMMENT, this.ts.offset(), text));
                break;
            }
            case PHP_OPENTAG: 
            case T_OPEN_TAG_WITH_ECHO: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_OPEN_PHP_TAG, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.OPEN_TAG, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_OPEN_PHP_TAG, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CLOSETAG: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CLOSE_PHP_TAG, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.CLOSE_TAG, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_CLOSE_PHP_TAG, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_COMMENT_START: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT_START, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_COMMENT_END: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT_END, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_COMMENT: {
                tokens.add(new FormatToken(FormatToken.Kind.COMMENT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHPDOC_COMMENT: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHPDOC_COMMENT_START: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT_START, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHPDOC_COMMENT_END: {
                tokens.add(new FormatToken(FormatToken.Kind.DOC_COMMENT_END, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_OBJECT_OPERATOR: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_OBJECT_OP, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_OBJECT_OP, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CASTING: {
                int index;
                String text = ((Object)this.ts.token().text()).toString();
                String part1 = text.substring(0, text.indexOf(40) + 1);
                String part2 = text.substring(part1.length(), text.indexOf(41));
                String part3 = text.substring(part1.length() + part2.length());
                String ws1 = "";
                String ws2 = "";
                for (index = 0; index < part2.length() && part2.charAt(index) == ' '; ++index) {
                    ws1 = ws1 + ' ';
                }
                for (index = part2.length() - 1; index > 0 && part2.charAt(index) == ' '; --index) {
                    ws2 = ws2 + ' ';
                }
                part2 = part2.trim();
                int length = 0;
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), part1));
                length += part1.length();
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_TYPE_CAST_PARENS, this.ts.offset() + part1.length()));
                if (ws1.length() > 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset() + length, ws1));
                    length += ws1.length();
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset() + length, part2));
                length += part2.length();
                if (ws2.length() > 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE, this.ts.offset() + length, ws2));
                    length += ws2.length();
                }
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_TYPE_CAST_PARENS, this.ts.offset() + length));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset() + length, part3));
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_TYPE_CAST, this.ts.offset() + (length += part3.length())));
                break;
            }
            case PHP_TOKEN: {
                String text = ((Object)this.ts.token().text()).toString();
                ASTNode parent = this.path.get(0);
                if ("(".equals(text)) {
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_METHOD_DEC_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof FunctionInvocation || parent instanceof MethodInvocation || parent instanceof ClassInstanceCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_METHOD_CALL_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof IfStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_IF_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_IF_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof ForEachStatement || parent instanceof ForStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_FOR_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_FOR_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_WHILE_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof SwitchStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SWITCH_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_SWITCH_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof CatchClause) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_CATCH_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ARRAY_DECL_PAREN, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_DECL_PARENS, this.ts.offset() + this.ts.token().length()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    break;
                }
                if (")".equals(text)) {
                    if (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_DECL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof FunctionInvocation || parent instanceof MethodInvocation || parent instanceof ClassInstanceCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_METHOD_CALL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof IfStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_IF_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof ForEachStatement || parent instanceof ForStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_FOR_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof WhileStatement || parent instanceof DoStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_WHILE_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof SwitchStatement) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_SWITCH_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof CatchClause) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_CATCH_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    if (parent instanceof ArrayCreation) {
                        tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_DECL_PARENS, this.ts.offset()));
                        tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                        break;
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    break;
                }
                if ("[".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_BRACKETS_PARENS, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if ("]".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_WITHIN_ARRAY_BRACKETS_PARENS, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    break;
                }
                if (parent instanceof ConditionalExpression && ("?".equals(text) || ":".equals(text))) {
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_TERNARY_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if (",".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_COMMA, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_COMMA, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if ("!".equals(text)) {
                    int origOffset = this.ts.offset();
                    if (this.ts.movePrevious()) {
                        Token<? extends PHPTokenId> previous = LexUtilities.findPrevious(this.ts, Arrays.asList(PHPTokenId.WHITESPACE));
                        if (previous.id() == PHPTokenId.PHP_RETURN) {
                            tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_KEYWORD, origOffset));
                        }
                        this.ts.move(origOffset);
                        this.ts.moveNext();
                    }
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), text));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if ("=".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_ASSIGN_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), text));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_ASSIGN_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_OPERATOR: {
                String text = ((Object)this.ts.token().text()).toString();
                if ("=>".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_KEY_VALUE_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_KEY_VALUE_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                if ("++".equals(text) || "--".equals(text)) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset()));
                    tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), text));
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AROUND_UNARY_OP, this.ts.offset() + this.ts.token().length()));
                    break;
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_WHILE: {
                if (this.path.get(0) instanceof DoStatement && this.isCurly) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_WHILE, this.ts.offset()));
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_ELSE: 
            case PHP_ELSEIF: {
                if (this.isCurly) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_ELSE, this.ts.offset()));
                }
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case PHP_SEMICOLON: {
                if (!this.ts.movePrevious() || this.ts.token().id() != PHPTokenId.WHITESPACE || this.countOfNewLines(this.ts.token().text()) <= 0) {
                    tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_SEMI, this.ts.offset() + this.ts.token().length()));
                }
                this.ts.moveNext();
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                if (this.path.size() <= 0 || this.path.get(0) instanceof ForStatement) break;
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_AFTER_SEMI, this.ts.offset() + this.ts.token().length()));
                break;
            }
            case PHP_CATCH: {
                tokens.add(new FormatToken(FormatToken.Kind.WHITESPACE_BEFORE_CATCH, this.ts.offset()));
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
                break;
            }
            case T_INLINE_HTML: {
                FormatToken.InitToken token = (FormatToken.InitToken)this.formatTokens.get(0);
                if (!token.hasHTML() && !FormatVisitor.isWhitespace(this.ts.token().text())) {
                    token.setHasHTML(true);
                }
                int startOffset = this.ts.offset();
                StringBuilder sb = new StringBuilder(this.ts.token().text());
                while (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.T_INLINE_HTML) {
                    sb.append(this.ts.token().text());
                }
                if (this.ts.moveNext()) {
                    this.ts.movePrevious();
                    this.ts.movePrevious();
                    tokens.add(new FormatToken(FormatToken.Kind.HTML, startOffset, sb.toString()));
                    break;
                }
                --this.lastIndex;
                break;
            }
            default: {
                tokens.add(new FormatToken(FormatToken.Kind.TEXT, this.ts.offset(), ((Object)this.ts.token().text()).toString()));
            }
        }
    }

    private void addAllUntilOffset(int offset) {
        while (this.moveNext() && this.ts.offset() < offset && this.ts.offset() + this.ts.token().length() <= offset) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
    }

    private void addRestOfLine() {
        while (this.ts.moveNext() && this.ts.token().id() != PHPTokenId.PHP_LINE_COMMENT && (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.isComment((Token<? extends PHPTokenId>)this.ts.token()) || this.ts.token().id() == PHPTokenId.PHP_SEMICOLON)) {
            this.addFormatToken(this.formatTokens);
        }
        if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT || this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0) {
            this.addFormatToken(this.formatTokens);
            if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT) {
                this.addFormatToken(this.formatTokens);
            } else {
                this.ts.movePrevious();
            }
        } else {
            this.ts.movePrevious();
        }
    }

    private int getIndentSize() {
        return this.options.initialIndent + this.indentLevel * this.options.indentSize;
    }

    private int countOfNewLines(CharSequence chs) {
        int count = 0;
        for (int i = 0; i < chs.length(); ++i) {
            if (chs.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private void addEndOfUnbreakableSequence(int endOffset) {
        boolean wasLastLineComment = false;
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0 || this.isComment((Token<? extends PHPTokenId>)this.ts.token()))) {
            if (this.ts.token().id() == PHPTokenId.PHP_LINE_COMMENT && !"//".equals(((Object)this.ts.token().text()).toString())) {
                this.addFormatToken(this.formatTokens);
                wasLastLineComment = true;
                break;
            }
            this.addFormatToken(this.formatTokens);
        }
        if (wasLastLineComment) {
            FormatToken last = this.formatTokens.remove(this.formatTokens.size() - 1);
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length() - 1, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(last);
        } else {
            this.ts.movePrevious();
            if (this.ts.token().id() == PHPTokenId.WHITESPACE && this.countOfNewLines(this.ts.token().text()) == 0) {
                FormatToken removedWS = this.formatTokens.remove(this.formatTokens.size() - 1);
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
                this.formatTokens.add(removedWS);
            } else {
                this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            }
        }
    }

    private void addUnbreakalbeSequence(ASTNode node, boolean addAnchor) {
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.addAllUntilOffset(node.getStartOffset());
        if (addAnchor) {
            this.formatTokens.add(new FormatToken.AnchorToken(this.ts.offset() + this.ts.token().length()));
        }
        this.scan(node);
        while (this.ts.moveNext() && (this.ts.token().id() == PHPTokenId.WHITESPACE || this.isComment((Token<? extends PHPTokenId>)this.ts.token()) || this.ts.token().id() == PHPTokenId.PHP_TOKEN && ",".equals(((Object)this.ts.token().text()).toString()))) {
            this.addFormatToken(this.formatTokens);
        }
        this.ts.movePrevious();
        int index = this.formatTokens.size() - 1;
        FormatToken lastToken = this.formatTokens.get(index);
        FormatToken removedWS = null;
        if (lastToken.getId() == FormatToken.Kind.WHITESPACE || lastToken.getId() == FormatToken.Kind.WHITESPACE_INDENT) {
            removedWS = this.formatTokens.remove(this.formatTokens.size() - 1);
            lastToken = this.formatTokens.get(--index);
        }
        if (lastToken.getId() == FormatToken.Kind.WHITESPACE_AFTER_COMMA) {
            this.formatTokens.remove(index);
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(lastToken);
            if (removedWS != null) {
                this.formatTokens.add(removedWS);
            }
        } else if (lastToken.getId() == FormatToken.Kind.LINE_COMMENT && removedWS != null) {
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length() - 1, null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            this.formatTokens.add(removedWS);
        } else {
            this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(this.ts.offset() + this.ts.token().length(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_END));
            if (removedWS != null) {
                this.formatTokens.add(removedWS);
            }
        }
    }

    private boolean isComment(Token<? extends PHPTokenId> token) {
        return token.id() == PHPTokenId.PHPDOC_COMMENT || token.id() == PHPTokenId.PHPDOC_COMMENT_END || token.id() == PHPTokenId.PHPDOC_COMMENT_START || token.id() == PHPTokenId.PHP_COMMENT || token.id() == PHPTokenId.PHP_COMMENT_END || token.id() == PHPTokenId.PHP_COMMENT_START || token.id() == PHPTokenId.PHP_LINE_COMMENT;
    }

    private boolean isPreviousNodeTheSameInBlock(ASTNode astNode, Statement statement) {
        int index = 0;
        List<Statement> statements = null;
        if (astNode instanceof Block) {
            statements = ((Block)astNode).getStatements();
        } else if (astNode instanceof Program) {
            statements = ((Program)astNode).getStatements();
        }
        if (statements != null) {
            while (index < statements.size() && statements.get(index).getStartOffset() < statement.getStartOffset()) {
                ++index;
            }
            return index < statements.size() && index > 0 && statements.get(index - 1).getClass().equals(statement.getClass());
        }
        return false;
    }

    private boolean isNextNodeTheSameInBlock(ASTNode astNode, Statement statement) {
        int index = 0;
        List<Statement> statements = null;
        if (astNode instanceof Block) {
            statements = ((Block)astNode).getStatements();
        } else if (astNode instanceof Program) {
            statements = ((Program)astNode).getStatements();
        }
        if (statements != null) {
            while (index < statements.size() && statements.get(index).getStartOffset() < statement.getStartOffset()) {
                ++index;
            }
            return index == statements.size() - 1 || index >= statements.size() - 1 || !statements.get(index + 1).getClass().equals(statement.getClass());
        }
        return false;
    }

    private void addNoCurlyBody(ASTNode body, FormatToken.Kind before) {
        this.addAllUntilOffset(body.getStartOffset());
        if (this.ts.moveNext() && this.ts.token().id() == PHPTokenId.PHP_TOKEN && ")".equals(((Object)this.ts.token().text()).toString())) {
            this.addFormatToken(this.formatTokens);
        } else {
            this.ts.movePrevious();
        }
        this.formatTokens.add(new FormatToken.IndentToken(body.getStartOffset(), this.options.indentSize));
        if (!(body instanceof ASTError)) {
            this.formatTokens.add(new FormatToken(before, body.getStartOffset()));
        }
        this.formatTokens.add(new FormatToken.UnbreakableSequenceToken(body.getStartOffset(), null, FormatToken.Kind.UNBREAKABLE_SEQUENCE_START));
        this.scan(body);
        this.addEndOfUnbreakableSequence(body.getEndOffset());
        this.formatTokens.add(new FormatToken.IndentToken(body.getEndOffset(), -1 * this.options.indentSize));
    }

    private boolean moveNext() {
        boolean value = this.ts.moveNext();
        if (value) {
            FormatToken last = this.formatTokens.get(this.formatTokens.size() - 1);
            value = last.getId() != FormatToken.Kind.TEXT || last.getOffset() < this.ts.offset();
        }
        return value;
    }

    private void handleGroupAlignment(ASTNode node) {
        int length = node.getEndOffset() - node.getStartOffset();
        if (this.previousGroupToken == null) {
            this.previousGroupToken = new FormatToken.AssignmentAnchorToken(this.ts.offset());
            this.previousGroupToken.setLenght(length);
            this.previousGroupToken.setMaxLength(length);
        } else {
            FormatToken.AssignmentAnchorToken aaToken = new FormatToken.AssignmentAnchorToken(this.ts.offset());
            aaToken.setLenght(length);
            aaToken.setPrevious(this.previousGroupToken);
            if (this.previousGroupToken.getMaxLength() < length) {
                this.previousGroupToken = aaToken;
                do {
                    aaToken.setMaxLength(length);
                } while ((aaToken = aaToken.getPrevious()) != null);
            } else {
                aaToken.setMaxLength(this.previousGroupToken.getMaxLength());
                this.previousGroupToken = aaToken;
            }
        }
        this.formatTokens.add(this.previousGroupToken);
    }

    protected static boolean isWhitespace(CharSequence text) {
        int index;
        for (index = 0; index < text.length() && Character.isWhitespace(text.charAt(index)); ++index) {
        }
        return index == text.length();
    }
}

