/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.ConstructorPanel;
import org.netbeans.modules.php.editor.codegen.ui.MethodPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CGSGenerator
implements CodeGenerator {
    protected static final String START_OF_GETTER = "get";
    protected static final String START_OF_SETTER = "set";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PROPERTY = "${PROPERTY}";
    private static final String CURSOR = "${cursor}";
    private static final String PARAM_NAME = "${PARAM_NAME}";
    private static final String UP_FIRST_LETTER_PROPERTY = "${UpFirstLetterProperty}";
    private static final String UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE = "${UpFirstLetterPropertyWithoutUnderscore}";
    private static final String PARAMS = "${PARAMS}";
    private static final String ASSIGNMENTS = "${ASSIGNMENT}";
    private static final String TEMPLATE_NAME = "${TEMPLATE_NAME}";
    private static final String CONSTRUCTOR_TEMPLATE = "function __construct(${PARAMS}) {${ASSIGNMENT}${cursor}" + NEW_LINE + "}" + NEW_LINE;
    private static final String ASSIGNMENT_TEMPLATE = NEW_LINE + "$this->" + "${PROPERTY}" + " = $" + "${PARAM_NAME}" + ";";
    private static final String GETTER_TEMPLATE = "public function ${TEMPLATE_NAME}() {" + NEW_LINE + "return $$this->" + "${PROPERTY}" + ";" + NEW_LINE + "}" + NEW_LINE;
    private static final String SETTER_TEMPLATE = "public function ${TEMPLATE_NAME}($$${PARAM_NAME}) {" + ASSIGNMENT_TEMPLATE + NEW_LINE + "}" + NEW_LINE;
    private final GenType type;
    private final CGSInfo cgsInfo;
    private final JTextComponent component;
    private static final String GETTER_SETTER_PROJECT_PROPERTY = "getter.setter.method.name.generation";

    private CGSGenerator(JTextComponent component, CGSInfo cgsInfo, GenType type) {
        this.type = type;
        this.cgsInfo = cgsInfo;
        this.component = component;
    }

    public void invoke() {
        String dialogTitle = null;
        ConstructorPanel panel = null;
        String methodGenerationWay = null;
        AntProjectHelper helper = null;
        EditableProperties properties = null;
        FileObject fo = NbEditorUtilities.getFileObject((Document)this.component.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
            properties = helper.getProperties("nbproject/private/private.properties");
            methodGenerationWay = properties.getProperty(GETTER_SETTER_PROJECT_PROPERTY);
        }
        if (methodGenerationWay != null) {
            try {
                this.cgsInfo.setHowToGenerate(GenWay.valueOf(methodGenerationWay));
            }
            catch (IllegalArgumentException exception) {
                this.cgsInfo.setHowToGenerate(GenWay.AS_JAVA);
            }
        } else {
            this.cgsInfo.setHowToGenerate(GenWay.AS_JAVA);
        }
        switch (this.type) {
            case CONSTRUCTOR: {
                dialogTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_CONSTRUCTOR");
                panel = new ConstructorPanel(this.type, this.cgsInfo);
                break;
            }
            case GETTER: {
                dialogTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS");
                panel = new ConstructorPanel(this.type, this.cgsInfo);
                break;
            }
            case SETTER: {
                dialogTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_SETTERS");
                panel = new ConstructorPanel(this.type, this.cgsInfo);
                break;
            }
            case GETTER_AND_SETTER: {
                dialogTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS_AND_SETTERS");
                panel = new ConstructorPanel(this.type, this.cgsInfo);
                break;
            }
            case METHODS: {
                dialogTitle = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_METHODS");
                panel = new MethodPanel(this.cgsInfo);
            }
        }
        DialogDescriptor desc = new DialogDescriptor(panel, dialogTitle);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.setVisible(true);
        dialog.dispose();
        if (desc.getValue() == DialogDescriptor.OK_OPTION) {
            CodeTemplateManager manager = CodeTemplateManager.get((Document)this.component.getDocument());
            CodeTemplate template = manager.createTemporary(this.getTemplateText());
            template.insert(this.component);
            if (project != null) {
                properties.put(GETTER_SETTER_PROJECT_PROPERTY, this.cgsInfo.getHowToGenerate().name());
                helper.putProperties("nbproject/private/private.properties", properties);
            }
        }
    }

    public String getDisplayName() {
        String name = null;
        switch (this.type) {
            case CONSTRUCTOR: {
                name = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_CONSTRUCTOR");
                break;
            }
            case GETTER: {
                name = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER");
                break;
            }
            case SETTER: {
                name = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_SETTER");
                break;
            }
            case GETTER_AND_SETTER: {
                name = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER_AND_SETTER");
                break;
            }
            case METHODS: {
                name = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_METHOD");
            }
        }
        return name;
    }

    private String getTemplateText() {
        String text = null;
        String getterTemplate = GETTER_TEMPLATE.replace(TEMPLATE_NAME, this.cgsInfo.getHowToGenerate().getGetterTemplate());
        String setterTemplate = SETTER_TEMPLATE.replace(TEMPLATE_NAME, this.cgsInfo.getHowToGenerate().getSetterTemplate());
        ArrayList<String> createdMethods = new ArrayList<String>();
        switch (this.type) {
            case CONSTRUCTOR: {
                StringBuilder params = new StringBuilder();
                StringBuilder assignments = new StringBuilder();
                for (Property property : this.cgsInfo.getProperties()) {
                    String paramName;
                    String name = property.getName();
                    String string = paramName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    if (!property.isSelected()) continue;
                    params.append(", $").append(paramName);
                    assignments.append(ASSIGNMENT_TEMPLATE.replace(PROPERTY, name).replace(PARAM_NAME, paramName));
                }
                if (params.length() == 0) {
                    params.append(", ");
                }
                text = CONSTRUCTOR_TEMPLATE.replace(PARAMS, params.toString().substring(2)).replace(ASSIGNMENTS, assignments);
                break;
            }
            case GETTER: {
                StringBuilder getters = new StringBuilder();
                for (Property property : this.cgsInfo.getPossibleGetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String changedName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = this.getUnusedMethodName(createdMethods, changedName);
                    getters.append(getterTemplate.replace(PROPERTY, name).replace(UP_FIRST_LETTER_PROPERTY, methodName).replace(UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    getters.append(NEW_LINE);
                }
                text = getters.toString();
                break;
            }
            case SETTER: {
                StringBuilder setters = new StringBuilder();
                for (Property property : this.cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String paramName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    String changedName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = this.getUnusedMethodName(createdMethods, changedName);
                    setters.append(setterTemplate.replace(PROPERTY, name).replace(PARAM_NAME, paramName).replace(UP_FIRST_LETTER_PROPERTY, methodName).replace(UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    setters.append(NEW_LINE);
                }
                text = setters.toString();
                break;
            }
            case GETTER_AND_SETTER: {
                StringBuilder gettersAndSetters = new StringBuilder();
                for (Property property : this.cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String name = property.getName();
                    String changedName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.upFirstLetterWithoutUnderscore(name) : CGSGenerator.upFirstLetter(name);
                    String methodName = this.getUnusedMethodName(createdMethods, changedName);
                    String paramName = this.cgsInfo.getHowToGenerate() == GenWay.WITHOUT_UNDERSCORE ? CGSGenerator.withoutUnderscore(name) : name;
                    gettersAndSetters.append(getterTemplate.replace(PROPERTY, name).replace(UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(methodName)).replace(UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    gettersAndSetters.append(NEW_LINE);
                    gettersAndSetters.append(setterTemplate.replace(PROPERTY, name).replace(PARAM_NAME, paramName).replace(UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(methodName)).replace(UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, methodName));
                    gettersAndSetters.append(NEW_LINE);
                }
                text = gettersAndSetters.toString();
                break;
            }
            case METHODS: {
                StringBuilder inheritedMethods = new StringBuilder();
                for (MethodProperty methodProperty : this.cgsInfo.getPossibleMethods()) {
                    if (!methodProperty.isSelected()) continue;
                    MethodElement method = methodProperty.getMethod();
                    if (method.isAbstract() || method.isMagic() || method.getType().isInterface()) {
                        inheritedMethods.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody).replace("abstract ", ""));
                    } else {
                        inheritedMethods.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithParentCallInBody).replace("abstract ", ""));
                    }
                    inheritedMethods.append(NEW_LINE);
                }
                text = inheritedMethods.toString();
            }
        }
        return text;
    }

    private String getUnusedMethodName(List<String> usedMethods, String methodName) {
        if (usedMethods.contains(methodName)) {
            int counter = 1;
            while (usedMethods.contains(methodName + "_" + counter)) {
                ++counter;
            }
            methodName = methodName + "_" + counter;
        }
        usedMethods.add(methodName);
        return methodName;
    }

    private static String upFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String upFirstLetterWithoutUnderscore(String name) {
        return CGSGenerator.upFirstLetter(CGSGenerator.withoutUnderscore(name));
    }

    private static String withoutUnderscore(String name) {
        return name.length() > 0 && name.charAt(0) == '_' ? name.substring(1) : name;
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            JTextComponent textComp = (JTextComponent)context.lookup(JTextComponent.class);
            ArrayList<CGSGenerator> ret = new ArrayList<CGSGenerator>();
            CGSInfo info = CGSInfo.getCGSInfo(textComp);
            if (info.getClassName() != null) {
                if (!info.hasConstructor()) {
                    ret.add(new CGSGenerator(textComp, info, GenType.CONSTRUCTOR));
                }
                if (info.getPossibleGetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.GETTER));
                }
                if (info.getPossibleSetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.SETTER));
                }
                if (info.getPossibleGettersSetters().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.GETTER_AND_SETTER));
                }
                if (info.getPossibleMethods().size() > 0) {
                    ret.add(new CGSGenerator(textComp, info, GenType.METHODS));
                }
            }
            return ret;
        }
    }

    public static enum GenWay {
        AS_JAVA(NbBundle.getMessage(CGSGenerator.class, (String)"JAVA_STYLE"), "get${UpFirstLetterProperty}", "set${UpFirstLetterProperty}"),
        WITH_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"ADD_UNDERSCORE"), "get_${PROPERTY}", "set_${PROPERTY}"),
        WITHOUT_UNDERSCORE(NbBundle.getMessage(CGSGenerator.class, (String)"REMOVE_UNDERSCORE"), "get${UpFirstLetterPropertyWithoutUnderscore}", "set${UpFirstLetterPropertyWithoutUnderscore}");

        private String getterTemplate;
        private String setterTemplate;
        private String simpleDescription;

        private GenWay(String simpleDescription, String getterTemplate, String setterTemplate) {
            this.getterTemplate = getterTemplate;
            this.setterTemplate = setterTemplate;
            this.simpleDescription = simpleDescription;
        }

        public String getGetterTemplate() {
            return this.getterTemplate;
        }

        public String getSetterTemplate() {
            return this.setterTemplate;
        }

        public String getSimpleDescription() {
            return this.simpleDescription;
        }

        public String getGetterExample(String property) {
            return this.createExample(this.getGetterTemplate(), property);
        }

        public String getSetterExample(String property) {
            return this.createExample(this.getSetterTemplate(), property);
        }

        private String createExample(String template, String property) {
            String example = template;
            if (template.contains(CGSGenerator.PROPERTY)) {
                example = example.replace(CGSGenerator.PROPERTY, property);
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY, CGSGenerator.upFirstLetter(property));
            }
            if (template.contains(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE)) {
                example = example.replace(CGSGenerator.UP_FIRST_LETTER_PROPERTY_WITHOUT_UNDERSCORE, CGSGenerator.upFirstLetterWithoutUnderscore(property));
            }
            return example;
        }
    }

    public static enum GenType {
        CONSTRUCTOR,
        GETTER,
        SETTER,
        GETTER_AND_SETTER,
        METHODS;

    }
}

