/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.masterdetail;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.DetailView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Log;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.MasterView;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Validator;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class MasterDetailView
extends TopComponent {
    private final Actions actions;
    private final int button_config;
    private final String okActionName;
    public static final int WITHLIST = 4;
    public static final int CONFIGCURRENT = 8;
    private MasterView masterView;
    private DetailView detailView;
    private Validator validator = new Validator(){

        @Override
        public void fireChanged() {
            if (Log.MasterDetail.debug) {
                System.out.printf("MDV.fireChanged() ...\n", new Object[0]);
            }
            boolean valid = MasterDetailView.this.isValid();
            boolean dirty = this.isDirty();
            MasterDetailView.this.applyButton.setEnabled(true);
            MasterDetailView.this.okButton.setEnabled(true);
        }

        @Override
        public boolean isRecordValid() {
            boolean v;
            boolean valid = true;
            if (MasterDetailView.this.masterView != null) {
                v = MasterDetailView.this.masterView.isValid();
                if (Log.MasterDetail.debug) {
                    System.out.printf("masterView.isValid() -> %s\n", v);
                }
                valid &= v;
            }
            if (MasterDetailView.this.detailView != null) {
                v = MasterDetailView.this.detailView.isValid();
                if (Log.MasterDetail.debug) {
                    System.out.printf("detailView.isValid() -> %s\n", v);
                }
                valid &= v;
            }
            return valid;
        }

        @Override
        public boolean isDirty() {
            boolean d;
            boolean dirty = false;
            if (MasterDetailView.this.masterView != null) {
                d = MasterDetailView.this.masterView.isDirty();
                if (Log.MasterDetail.debug) {
                    System.out.printf("masterView.isDirty() -> %s\n", d);
                }
                dirty |= d;
            }
            if (MasterDetailView.this.detailView != null) {
                d = MasterDetailView.this.detailView.isDirty();
                if (Log.MasterDetail.debug) {
                    System.out.printf("detailView.isDirty() -> %s\n", d);
                }
                dirty |= d;
            }
            return dirty;
        }
    };
    private static final String ESCAPE_COMMAND = "Escape";
    private static final String ENTER_COMMAND = "Enter";
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton applyButton;
    private JButton resetButton;
    private JButton cancelButton;
    private JLabel errorLabel;
    private JButton helpButton;
    private JButton updateButton;

    public MasterDetailView(Actions actions, int button_config, String okActionName) {
        this.actions = actions;
        this.button_config = button_config;
        this.okActionName = okActionName;
        this.initComponents();
        this.resetButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.initAccessibility();
        this.helpButton.setEnabled(this.getHelpCtx() != null);
    }

    public void addMasterView(MasterView masterView) {
        assert (this.masterView == null) : "Can only add masterView to MasterDetailView once";
        this.masterView = masterView;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add(masterView, gbc);
        masterView.setValidator(this.validator);
        this.validator.fireChanged();
    }

    public void addDetailView(DetailView detailView) {
        assert (this.detailView == null) : "Can only add detailView to MasterDetailView once";
        this.detailView = detailView;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add(detailView, gbc);
        detailView.setValidator(this.validator);
        this.validator.fireChanged();
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        context.setAccessibleName(Catalog.get("LISTEDITDIALOG_ACSN"));
        context.setAccessibleDescription(Catalog.get("LISTEDITDIALOG_ACSD"));
        this.resetButton.getAccessibleContext().setAccessibleDescription(this.resetButton.getText());
        this.applyButton.getAccessibleContext().setAccessibleDescription(this.applyButton.getText());
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getText());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getText());
        this.helpButton.getAccessibleContext().setAccessibleDescription(this.helpButton.getText());
    }

    private void initComponents() {
        this.updateButton = new JButton();
        this.resetButton = new JButton();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.helpButton = new JButton();
        this.errorLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 0));
        this.buttonPanel.add(this.okButton);
        if (this.okActionName != null) {
            this.okButton.setText(this.okActionName);
        } else {
            this.okButton.setText(Catalog.get("LISTEDITDIALOG_OK_BUTTON_TXT"));
        }
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterDetailView.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(Catalog.get("LISTEDITDIALOG_CANCEL_BUTTON_TXT"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterDetailView.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.applyButton.setText(Catalog.get("LISTEDITDIALOG_APPLY_BUTTON_TXT"));
        this.applyButton.setMnemonic(Catalog.getMnemonic("MNEM_Apply"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterDetailView.this.applyButtonActionPerformed(evt);
            }
        });
        if ((this.button_config & 4) != 0 || (this.button_config & 8) != 0) {
            this.buttonPanel.add(this.applyButton);
        }
        this.helpButton.setMnemonic(Catalog.get("LISTEDITDIALOG_HELP_BUTTON_MN").charAt(0));
        this.helpButton.setText(Catalog.get("LISTEDITDIALOG_HELP_BUTTON_TXT"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MasterDetailView.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.helpButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 12, 10);
        this.add(this.buttonPanel, gridBagConstraints);
    }

    public void installInDialog(JDialog dialog) {
        JRootPane rp = dialog.getRootPane();
        rp.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), ENTER_COMMAND);
        rp.getActionMap().put(ENTER_COMMAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterDetailView.this.okButtonActionPerformed(e);
            }
        });
        rp.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), ESCAPE_COMMAND);
        rp.getActionMap().put(ESCAPE_COMMAND, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterDetailView.this.cancelButtonActionPerformed(e);
            }
        });
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.doCommit();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.handleClose();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        Help help = (Help)Lookup.getDefault().lookup(Help.class);
        help.showHelp(this.getHelpCtx());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doCommit();
        this.handleClose();
    }

    private void doCommit() {
        if (this.masterView != null) {
            this.masterView.commitPending();
            this.masterView.updateView();
            this.handleCommit();
            this.masterView.setDirty(false);
        } else {
            this.detailView.commit();
            this.handleCommit();
        }
    }

    protected void handleCommit() {
        if (this.actions != null) {
            this.actions.handleCommit();
        }
    }

    protected void handleClose() {
        if (this.actions != null) {
            this.actions.handleClose();
        }
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private class EscapeKeyAction
    extends AbstractAction {
        private EscapeKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    }

    public static interface Actions {
        public void handleCommit();

        public void handleClose();
    }
}

