/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.FormatOption;
import org.netbeans.spi.viewmodel.Models;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MemoryWindow
extends TopComponent
implements ActionListener {
    private static final String preferredID = "MemoryWindow";
    private static MemoryWindow DEFAULT;
    private transient JComponent tree = null;
    private String name;
    private String view_name;
    private NativeDebugger debugger = null;
    private JMenuItem menuItemFollowSelectedPointer;
    private JPopupMenu popup;
    private JTextArea ta;
    private JScrollPane ta_sp;
    private JPanel controlPanel;
    private ArrayList<String> current_addrs;
    private PopupListener popupListener;
    private String memory_start;
    private String memory_length;
    private JTextField controlLengthText;
    private JComboBox controlFormatCombo;
    private FormatListener format_listener;
    private FormatOption memory_format;
    private boolean needInitData = true;
    private JComboBox controlAddressCombo;
    private String selected_text = null;
    private final WeakHashMap<NativeDebugger, Model> models = new WeakHashMap();

    public static synchronized MemoryWindow getDefault() {
        if (DEFAULT == null && (DEFAULT = (MemoryWindow)WindowManager.getDefault().findTopComponent(preferredID)) == null) {
            DEFAULT = new MemoryWindow();
        }
        return DEFAULT;
    }

    private MemoryWindow() {
        this.name = Catalog.get("TITLE_MemoryWindow");
        this.view_name = Catalog.get("TITLE_MemoryView");
        super.setName(this.name);
        String iconDir = "org/netbeans/modules/cnd/debugger/common2/icons/";
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/debugger/common2/icons/memory_browser.png"));
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.needInitData = true;
        this.updateWindow();
        this.connectToDebugger(DebuggerManager.get().currentDebugger());
    }

    protected void componentHidden() {
        if (this.debugger != null) {
            this.debugger.registerMemoryWindow(null);
        }
        super.componentHidden();
    }

    protected void componentClosed() {
        if (this.debugger != null) {
            this.debugger.registerMemoryWindow(null);
        }
        super.componentClosed();
    }

    public void requestActive() {
        super.requestActive();
        this.controlAddressCombo.requestFocusInWindow();
    }

    public FormatOption getMemoryFormat() {
        return this.memory_format;
    }

    public void setDebugger(NativeDebugger debugger) {
        if (this.debugger != null) {
            Model oldModel = this.models.get(this.debugger);
            oldModel.start = this.memory_start;
            oldModel.length = this.memory_length;
            oldModel.format = this.memory_format;
        }
        this.debugger = debugger;
        if (debugger == null) {
            return;
        }
        Model newModel = this.models.get(debugger);
        if (newModel == null) {
            newModel = new Model();
            this.models.put(debugger, newModel);
        }
        this.memory_start = newModel.start;
        this.memory_length = newModel.length;
        this.memory_format = newModel.format;
        this.controlAddressCombo.getEditor().setItem(this.memory_start);
        this.controlLengthText.setText(this.memory_length);
        this.updateFormats();
    }

    private void updateFormats() {
        if (this.debugger != null) {
            this.controlFormatCombo.setModel(new DefaultComboBoxModel<FormatOption>(this.debugger.getMemoryFormats()));
            this.updateSelectedFormat();
        }
    }

    private void updateSelectedFormat() {
        if (this.memory_format != null) {
            this.controlFormatCombo.setSelectedItem(this.memory_format);
            if (this.controlFormatCombo.getSelectedItem() != null) {
                return;
            }
        }
        this.controlFormatCombo.setSelectedIndex(0);
    }

    private void connectToDebugger(NativeDebugger debugger) {
        if (debugger == null) {
            return;
        }
        debugger.registerMemoryWindow(this);
        this.setDebugger(debugger);
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.view_name;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.memory_start = (String)this.controlAddressCombo.getSelectedItem();
        this.updateMems();
    }

    boolean validate(String length) {
        if (this.memory_start == null) {
            return false;
        }
        if (length == null) {
            return false;
        }
        return this.memory_start.length() != 0 && length.length() != 0;
    }

    private void updateMems() {
        this.memory_length = this.controlLengthText.getText();
        this.memory_format = (FormatOption)this.controlFormatCombo.getSelectedItem();
        if (this.validate(this.memory_length) && this.memory_format != null && this.debugger != null) {
            this.debugger.requestMems(this.memory_start, this.memory_length, this.memory_format);
        }
    }

    private int addrMap(String addr) {
        for (int i = 0; i < this.controlAddressCombo.getItemCount(); ++i) {
            if (!addr.equals((String)this.controlAddressCombo.getItemAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void updateData(List<String> memLines) {
        int index = this.addrMap(this.memory_start);
        if (index == -1) {
            this.controlAddressCombo.addItem(this.memory_start);
            this.controlAddressCombo.setSelectedItem(this.memory_start);
        }
        this.current_addrs.clear();
        this.current_addrs.addAll(memLines);
        this.updateWindow();
    }

    private void updateWindow() {
        if (this.tree == null) {
            this.ta = new JTextArea();
            this.ta_sp = new JScrollPane(this.ta);
            this.current_addrs = new ArrayList();
            this.setLayout(new BorderLayout());
            this.tree = Models.createView((Models.CompoundModel)Models.EMPTY_MODEL);
            this.tree.setName(this.view_name);
            this.ta.setEditable(false);
            this.ta.setWrapStyleWord(false);
            Font f = this.ta.getFont();
            this.ta.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
            this.memory_start = "main";
            this.memory_length = "80";
            this.controlPanel = new JPanel(new GridBagLayout());
            this.controlPanel.setToolTipText(Catalog.get("TIP_MemControlPanel"));
            this.controlAddressCombo = new JComboBox();
            this.controlAddressCombo.addItem(this.memory_start);
            this.controlAddressCombo.setEditable(true);
            this.controlAddressCombo.addActionListener(this);
            JLabel controlAddressLabel = new JLabel(Catalog.get("Mem_LBL_Address"));
            controlAddressLabel.setToolTipText(Catalog.get("TIP_MemAddress"));
            JLabel controlLengthLabel = new JLabel(Catalog.get("Mem_LBL_Length"));
            controlLengthLabel.setToolTipText(Catalog.get("TIP_MemLength"));
            this.controlLengthText = new JTextField(6);
            this.controlLengthText.setText(this.memory_length);
            this.controlLengthText.addActionListener(this);
            JLabel controlFormatLabel = new JLabel(Catalog.get("Mem_LBL_Format"));
            controlFormatLabel.setToolTipText(Catalog.get("TIP_MemFormat"));
            this.format_listener = new FormatListener();
            this.controlFormatCombo = new JComboBox();
            this.updateFormats();
            this.controlFormatCombo.addActionListener(this.format_listener);
            int gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            this.controlPanel.add((Component)controlAddressLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            gridBagConstraints.weightx = 1.0;
            this.controlPanel.add((Component)this.controlAddressCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)controlLengthLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)this.controlLengthText, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)controlFormatLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(8, 4, 8, 0);
            this.controlPanel.add((Component)this.controlFormatCombo, gridBagConstraints);
            this.tree.add((Component)this.ta_sp, "Center");
            this.tree.add((Component)this.controlPanel, "South");
            AccessibleContext ac = this.tree.getAccessibleContext();
            ac.setAccessibleDescription(Catalog.get("ACSD_MemoryView"));
            ac.setAccessibleName(Catalog.get("TITLE_MemoryView"));
            this.add(this.tree, "Center");
            this.popup = new JPopupMenu();
            this.popupListener = new PopupListener(this.popup);
            this.menuItemFollowSelectedPointer = new JMenuItem(new FollowSelectedPointerAction());
            this.popup.add(this.menuItemFollowSelectedPointer);
            this.popup.add(new RefreshMemoryAction());
            this.ta.addMouseListener(this.popupListener);
            this.ta.setText(null);
            this.ta.setCaretPosition(0);
        }
        if (this.needInitData) {
            this.needInitData = false;
            this.updateMems();
        }
        int carpos = this.ta.getCaretPosition();
        this.ta.setText(null);
        this.ta.setCaretPosition(0);
        for (String line : this.current_addrs) {
            this.ta.append(line);
        }
        try {
            this.ta.setCaretPosition(carpos);
        }
        catch (IllegalArgumentException e) {
            this.ta.setCaretPosition(0);
        }
        this.invalidate();
    }

    protected void followSelectedPointer(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(i);
        }
        for (i = 0; i < s.length() && s.charAt(i) != ':' && s.charAt(i) != ';' && s.charAt(i) != ' ' && s.charAt(i) != '\t'; ++i) {
        }
        if (i > 0 && i < s.length()) {
            s = s.substring(0, i);
        }
        if (s.length() > 0) {
            this.memory_start = s;
        }
        this.updateMems();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MemoryBrowserWindow");
    }

    private static class Model {
        public String start = "main";
        public String length = "80";
        public FormatOption format = null;

        private Model() {
        }
    }

    class RefreshMemoryAction
    extends AbstractAction {
        public RefreshMemoryAction() {
            super(Catalog.get("Mem_ACT_Refresh"), new ImageIcon("paste.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String s = (String)MemoryWindow.this.controlAddressCombo.getEditor().getItem();
            if (s.length() > 0) {
                MemoryWindow.this.memory_start = s;
            }
            MemoryWindow.this.updateMems();
        }
    }

    class FollowSelectedPointerAction
    extends AbstractAction {
        public FollowSelectedPointerAction() {
            super(Catalog.get("Mem_ACT_Follow_Selected_Pointer"), new ImageIcon("paste.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            MemoryWindow.this.followSelectedPointer(MemoryWindow.this.selected_text);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MemoryWindow.this.selected_text = MemoryWindow.this.ta.getSelectedText();
                if (MemoryWindow.this.selected_text == null) {
                    MemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(false);
                } else {
                    MemoryWindow.this.menuItemFollowSelectedPointer.setEnabled(true);
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class FormatListener
    implements ActionListener {
        private FormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String ac = ev.getActionCommand();
            if (ac.equals("comboBoxChanged")) {
                JComboBox cb = (JComboBox)ev.getSource();
                MemoryWindow.this.memory_format = (FormatOption)cb.getSelectedItem();
                MemoryWindow.this.updateMems();
            }
        }
    }
}

