/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Log;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EditWatchPanel
extends JPanel
implements NativeDebugger.QualifiedExprListener {
    private NativeDebugger debugger;
    private JLabel watchLabel = null;
    private JTextComponent watchText = null;
    private JLabel qWatchLabel = null;
    private JTextField qWatchText = null;
    private JLabel useQLabel = null;
    private JRadioButton restrictedRB;
    private JRadioButton unrestrictedRB;
    private JLabel scopeLabel;
    private JTextField scopeText = null;
    private Watch watch = null;
    private NativeWatch nativeWatch = null;
    private boolean customizing = false;
    private final DocumentListener documentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            EditWatchPanel.this.checkValid();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EditWatchPanel.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            EditWatchPanel.this.checkValid();
        }
    };
    private final WatchController controller = new WatchController(this);

    public EditWatchPanel(NativeDebugger debugger, NativeWatch initialNativeWatch, String scope, Watch initialWatch) {
        this.debugger = debugger;
        if (initialNativeWatch != null) {
            this.nativeWatch = initialNativeWatch;
            this.customizing = true;
        } else if (initialWatch != null) {
            this.watch = initialWatch;
            this.customizing = true;
        }
        this.initComponents();
        this.seed(this.nativeWatch, this.watch);
    }

    public final void seed(NativeWatch nativeWatch, Watch watch) {
        this.watchText.setText(EditorBridge.getCurrentSelection());
        this.watchText.selectAll();
    }

    public Controller getController() {
        return this.controller;
    }

    public void refocus() {
        if (this.watchText != null) {
            this.watchText.requestFocusInWindow();
        }
    }

    private void initComponents() {
        Catalog.setAccessibleDescription(this, "ACSD_NewWatch");
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.watchLabel = new JLabel(Catalog.get("LBL_WatchExpression"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.watchLabel, gbc);
        JComponent[] editorComponents = EditWatchPanel.createEditorComponent();
        this.watchText = (JTextComponent)editorComponents[1];
        this.watchText.setBorder(new CompoundBorder(this.watchText.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)editorComponents[0], gbc);
        Catalog.setAccessibleDescription(this.watchText, "ACSD_WatchExpression");
        this.watchLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_WatchExpression"));
        this.watchLabel.setLabelFor(this.watchText);
        this.qWatchLabel = new JLabel(Catalog.get("LBL_QForm"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.qWatchLabel, gbc);
        this.qWatchText = new JTextField();
        this.qWatchText.setBorder(new CompoundBorder(this.qWatchText.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        this.qWatchText.setEditable(false);
        this.qWatchText.setEnabled(false);
        this.qWatchText.setColumns(25);
        this.qWatchText.selectAll();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)this.qWatchText, gbc);
        this.qWatchLabel.setLabelFor(this.qWatchText);
        this.watchText.getDocument().addDocumentListener(this.documentListener);
        this.refocus();
    }

    protected boolean badField(String err) {
        IllegalArgumentException ex = new IllegalArgumentException();
        ErrorManager.getDefault().annotate((Throwable)ex, err);
        ErrorManager.getDefault().notify(256, (Throwable)ex);
        return false;
    }

    public boolean validateFields() {
        String expr = this.watchText.getText().trim();
        if (expr.equals("")) {
            return this.badField(Catalog.get("MSG_EMPTY_WATCH"));
        }
        return true;
    }

    @Override
    public void qualifiedExpr(String qualifiedForm, boolean ok) {
        if (Log.Watch.dialog) {
            System.out.printf("qualifiedExpr('%s')\n", qualifiedForm);
        }
        if (this.watchText.getText().trim().equals("")) {
            this.qWatchText.setText("");
        } else {
            this.qWatchText.setText(qualifiedForm);
        }
    }

    private void checkValid() {
        if (Log.Watch.dialog) {
            System.out.printf("EditWatchPanel.checkValid()\n", new Object[0]);
        }
        this.controller.validChanged();
    }

    public static JComponent[] createEditorComponent() {
        String fileMimeType;
        FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
        int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
        String mimeType = "text/plain";
        if (file != null && (fileMimeType = FileUtil.getMIMEType((FileObject)file)) != null) {
            mimeType = fileMimeType;
        }
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)mimeType);
        JTextComponent textComponent = (JTextComponent)editorComponents[1];
        if (file != null && line >= 0) {
            DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)textComponent);
        }
        return editorComponents;
    }

    private class WatchController
    implements Controller {
        private final EditWatchPanel owner;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        WatchController(EditWatchPanel owner) {
            this.owner = owner;
        }

        public boolean ok() {
            if (!EditWatchPanel.this.validateFields()) {
                return false;
            }
            DebuggerManager manager = DebuggerManager.get();
            String expr = EditWatchPanel.this.watchText.getText();
            manager.createWatch(expr.trim());
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            if (Log.Watch.dialog) {
                System.out.printf("EditWatchPanel.isValid()\n", new Object[0]);
            }
            String expr = EditWatchPanel.this.watchText.getText().trim();
            if (EditWatchPanel.this.debugger != null) {
                EditWatchPanel.this.debugger.postExprQualify(expr, EditWatchPanel.this);
            }
            return !IpeUtils.isEmpty(expr);
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        private void validChanged() {
            this.pcs.firePropertyChange("valid", null, null);
        }
    }
}

