/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.Constants;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.modules.cnd.debugger.common2.values.VariableValue;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public final class ThreadModel
extends ModelListenerSupport
implements TreeModel,
ExtendedNodeModel,
NodeActionsProvider,
TableModel,
Constants {
    private NativeDebugger debugger;
    private static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common2/icons/";
    private static String ICON_NORMAL = "org/netbeans/modules/cnd/debugger/common2/icons/thread";
    private static String ICON_EVENT = "org/netbeans/modules/cnd/debugger/common2/icons/thread_hit";
    private static String ICON_CURRENT_NORMAL = "org/netbeans/modules/cnd/debugger/common2/icons/thread_current";
    private static String ICON_CURRENT_EVENT = "org/netbeans/modules/cnd/debugger/common2/icons/thread_current_hit";

    public ThreadModel(ContextProvider ctx) {
        super("threads");
        this.debugger = (NativeDebugger)ctx.lookupFirst(null, NativeDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) {
        if (parent == "Root") {
            Object[] o = this.debugger.getThreads();
            for (int i = 0; i < o.length; ++i) {
                if (o[i] != null) continue;
                System.out.printf("ThreadModel.getChildren(): NULL Thread[%d]\n", i);
            }
            return o;
        }
        return null;
    }

    public int getChildrenCount(Object parent) {
        if (parent == "Root") {
            return this.debugger.getThreads().length;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node != "Root";
    }

    private Thread getThread(Object node) throws UnknownTypeException {
        if (node instanceof Thread) {
            return (Thread)node;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return "Root";
        }
        Thread thread = this.getThread(node);
        if (thread.isCurrent()) {
            return VariableValue.bold(thread.getName());
        }
        return thread.getName();
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return ICON_CURRENT_NORMAL;
        }
        Thread t = this.getThread(node);
        if (t.hasEvent()) {
            if (t.isCurrent()) {
                return ICON_CURRENT_EVENT;
            }
            return ICON_EVENT;
        }
        if (t.isCurrent()) {
            return ICON_CURRENT_NORMAL;
        }
        return ICON_NORMAL;
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return "Root";
        }
        return this.getThread(node).getName();
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Thread) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public Transferable clipboardCopy(Object node) throws UnknownTypeException, IOException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Thread) {
            throw new IOException();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Thread) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public Transferable clipboardCut(Object node) throws UnknownTypeException, IOException {
        if (node == "Root") {
            return null;
        }
        if (node instanceof Thread) {
            throw new IOException();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Thread) {
            return false;
        }
        throw new UnknownTypeException(node);
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof Thread) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        if (node == "Root") {
            return new PasteType[0];
        }
        if (node instanceof Thread) {
            return new PasteType[0];
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        return this.getIconBase(node) + ".png";
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        Thread thread = this.getThread(node);
        if (columnID.equals("PROP_THREAD_START_FUNCTION")) {
            return thread.getStartFunction();
        }
        if (columnID.equals("PROP_THREAD_EXECUTING_FUNCTION")) {
            return thread.getCurrentFunction();
        }
        if (columnID.equals("PROP_THREAD_LWP")) {
            return thread.getLWP();
        }
        if (columnID.equals("PROP_THREAD_PRIORITY")) {
            return thread.getPriority();
        }
        if (columnID.equals("PROP_THREAD_STARTUP_FLAGS")) {
            return thread.getStartupFlags();
        }
        if (columnID.equals("PROP_THREAD_ADDRESS")) {
            return thread.getAddress();
        }
        if (columnID.equals("PROP_THREAD_SIZE")) {
            return thread.getStackSize();
        }
        if (columnID.equals("ThreadSuspended")) {
            return new Boolean(thread.getSuspended());
        }
        if (columnID.equals("ThreadState")) {
            return thread.getState();
        }
        if (columnID.equals("PROP_THREAD_FILE")) {
            return thread.getFile();
        }
        if (columnID.equals("PROP_THREAD_LINE")) {
            return thread.getLine();
        }
        return "?" + columnID + "?";
    }

    public boolean isReadOnly(Object node, String columnID) {
        return !columnID.equals("PROP_THREAD_LWP");
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException, NumberFormatException {
        Thread thread = this.getThread(node);
        throw new UnknownTypeException(node);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[0];
        }
        Thread thread = this.getThread(node);
        return new Action[]{new MakeCurrentAction(this.debugger, thread)};
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        this.debugger.makeThreadCurrent(this.getThread(node));
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            this.debugger.registerThreadModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            this.debugger.registerThreadModel(null);
        }
    }

    private static class MakeCurrentAction
    extends AbstractAction {
        private NativeDebugger debugger;
        private Thread thread;

        MakeCurrentAction(NativeDebugger debugger, Thread thread) {
            super(Catalog.get("ACT_Make_Current"));
            this.debugger = debugger;
            this.thread = thread;
            this.setEnabled(!thread.isCurrent());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.debugger.makeThreadCurrent(this.thread);
        }
    }
}

