/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.spi.java.GoToSourceProvider;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;

public final class GoToJavaSourceProvider
extends GoToSourceProvider {
    public boolean openSource(Lookup.Provider project, final String className, final String methodName, final String signature, final int line) {
        FileObject sourceFile;
        final AtomicBoolean result = new AtomicBoolean(false);
        SourceClassInfo ci = ProfilerTypeUtils.resolveClass((String)className, (Lookup.Provider)project);
        FileObject fileObject = sourceFile = ci != null ? ci.getFile() : null;
        if (sourceFile == null) {
            return false;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)sourceFile);
        if (js != null) {
            try {
                js.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        if (!controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).equals((Object)JavaSource.Phase.ELEMENTS_RESOLVED)) {
                            return;
                        }
                        TypeElement parentClass = ElementUtilitiesEx.resolveClassByName(className, controller, true);
                        if (ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)parentClass)) {
                            Document doc = controller.getDocument();
                            if (doc != null && doc instanceof StyledDocument) {
                                ExecutableElement methodElement;
                                if (GoToJavaSourceProvider.openAtLine(controller, doc, methodName, line)) {
                                    result.set(true);
                                    return;
                                }
                                if (methodName != null && (methodElement = ElementUtilitiesEx.resolveMethodByName((CompilationInfo)controller, parentClass, methodName, signature)) != null && ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)methodElement)) {
                                    result.set(true);
                                    return;
                                }
                            }
                            result.set(true);
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                // empty catch block
            }
            return result.get();
        }
        return false;
    }

    public boolean openFile(final FileObject srcFile, final int offset) {
        final boolean[] rslt = new boolean[]{false};
        Runnable action = new Runnable(){

            @Override
            public void run() {
                rslt[0] = UiUtils.open((FileObject)srcFile, (int)offset);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(action);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        return rslt[0];
    }

    private static boolean openAtLine(CompilationController controller, Document doc, String methodName, int line) {
        try {
            if (line > -1) {
                Line l;
                LineCookie lc;
                String offsetMethodName;
                DataObject od = DataObject.find((FileObject)controller.getFileObject());
                int offset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
                ExecutableElement parentMethod = controller.getTreeUtilities().scopeFor(offset).getEnclosingMethod();
                if (parentMethod != null && methodName.equals(offsetMethodName = parentMethod.getSimpleName().toString()) && (lc = (LineCookie)od.getCookie(LineCookie.class)) != null && (l = lc.getLineSet().getCurrent(line - 1)) != null) {
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    });
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(GoToJavaSourceProvider.class.getName()).log(Level.WARNING, "Error accessing dataobject", e);
        }
        return false;
    }
}

