/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public final class GsfHintsProvider
extends ParserResultTask<ParserResult> {
    public static final Logger LOG = Logger.getLogger(GsfHintsProvider.class.getName());
    private FileObject file;
    private static final Map<Severity, org.netbeans.spi.editor.hints.Severity> errorKind2Severity = new EnumMap<Severity, org.netbeans.spi.editor.hints.Severity>(Severity.class);
    private boolean cancel;

    GsfHintsProvider(FileObject file) {
        this.file = file;
    }

    List<ErrorDescription> computeErrors(Document doc, ParserResult result, List<? extends Error> errors, List<ErrorDescription> descs) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "errors = " + errors);
        }
        for (Error error : errors) {
            if (this.isCanceled()) {
                return null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "d = " + error);
            }
            int astOffset = error.getStartPosition();
            int astEndOffset = error.getEndPosition();
            int position = result.getSnapshot().getOriginalOffset(astOffset);
            if (position == -1) continue;
            int endPosition = position + (astEndOffset - astOffset);
            LazyFixList ehm = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "ehm=" + ehm);
            }
            String desc = error.getDisplayName();
            Position[] range = this.getLine(error, doc, position, endPosition);
            if (this.isCanceled()) {
                return null;
            }
            if (range[0] == null || range[1] == null) continue;
            descs.add(ErrorDescriptionFactory.createErrorDescription((org.netbeans.spi.editor.hints.Severity)errorKind2Severity.get((Object)error.getSeverity()), (String)desc, (LazyFixList)ehm, (Document)doc, (Position)range[0], (Position)range[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        return descs;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    private Position[] getLine(Error d, final Document doc, int startOffset, int endOffset) {
        StyledDocument sdoc = (StyledDocument)doc;
        int lineNumber = NbDocument.findLineNumber((StyledDocument)sdoc, (int)startOffset);
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sdoc, (int)lineNumber);
        String text = DataLoadersBridge.getDefault().getLine(doc, lineNumber);
        if (text == null) {
            return new Position[2];
        }
        if (d.isLineError()) {
            int column;
            int length = text.length();
            for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
            }
            while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
                --length;
            }
            startOffset = lineOffset + column;
            endOffset = lineOffset + length;
            if (startOffset > endOffset) {
                startOffset = lineOffset;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "startOffset = " + startOffset);
            LOG.log(Level.FINE, "endOffset = " + endOffset);
        }
        final int startOffsetFinal = startOffset;
        final int endOffsetFinal = endOffset;
        final Position[] result = new Position[2];
        doc.render(new Runnable(){

            @Override
            public void run() {
                if (GsfHintsProvider.this.isCanceled()) {
                    return;
                }
                int len = doc.getLength();
                if (startOffsetFinal > len || endOffsetFinal > len) {
                    if (!GsfHintsProvider.this.isCanceled() && LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "document changed, but not canceled?");
                        LOG.log(Level.WARNING, "len = " + len);
                        LOG.log(Level.WARNING, "startOffset = " + startOffsetFinal);
                        LOG.log(Level.WARNING, "endOffset = " + endOffsetFinal);
                    }
                    GsfHintsProvider.this.cancel();
                    return;
                }
                try {
                    result[0] = NbDocument.createPosition((Document)doc, (int)startOffsetFinal, (Position.Bias)Position.Bias.Forward);
                    result[1] = NbDocument.createPosition((Document)doc, (int)endOffsetFinal, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, null, e);
                }
            }
        });
        return result;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(ParserResult result, SchedulerEvent event) {
        this.resume();
        final Document doc = this.getDocument();
        if (doc == null) {
            LOG.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        final ArrayList descriptions = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(result.getSnapshot().getSource()), (UserTask)new UserTask(){
                private Snapshot topLevelSnapshot = null;

                public void run(ResultIterator resultIterator) throws ParseException {
                    Language language;
                    if (this.topLevelSnapshot == null) {
                        this.topLevelSnapshot = resultIterator.getSnapshot();
                    }
                    if ((language = LanguageRegistry.getInstance().getLanguageByMimeType(resultIterator.getSnapshot().getMimeType())) != null) {
                        if (!(resultIterator.getParserResult() instanceof ParserResult)) {
                            return;
                        }
                        ParserResult r = (ParserResult)resultIterator.getParserResult();
                        List<? extends Error> errors = r.getDiagnostics();
                        List<ErrorDescription> desc = new ArrayList<ErrorDescription>();
                        HintsProvider provider = language.getHintsProvider();
                        GsfHintsManager manager = null;
                        RuleContext ruleContext = null;
                        if (provider != null && (manager = language.getHintsManager()) != null && (ruleContext = manager.createRuleContext(r, language, -1, -1, -1)) != null) {
                            ArrayList<Error> unhandled = new ArrayList<Error>();
                            ArrayList<Hint> hints = new ArrayList<Hint>();
                            provider.computeErrors(manager, ruleContext, hints, unhandled);
                            errors = unhandled;
                            boolean allowDisableEmpty = true;
                            for (int i = 0; i < hints.size(); ++i) {
                                Hint hint = (Hint)hints.get(i);
                                OffsetRange range = hint.getRange();
                                if (range != null && range.getStart() >= 0 && range.getStart() <= this.topLevelSnapshot.getText().length() && range.getEnd() >= 0 && range.getEnd() <= this.topLevelSnapshot.getText().length() && range.getStart() <= range.getEnd()) {
                                    ErrorDescription errorDesc = manager.createDescription(hint, ruleContext, allowDisableEmpty, i == hints.size() - 1);
                                    descriptions.add(errorDesc);
                                    continue;
                                }
                                String msg = provider + " supplied hint " + hint + " with invalid range " + range + ", topLevelSnapshot.length=" + this.topLevelSnapshot.getText().length() + ", file=" + this.topLevelSnapshot.getSource().getFileObject();
                                LOG.log(Level.FINE, msg);
                            }
                        }
                        if ((desc = GsfHintsProvider.this.computeErrors(doc, r, errors, desc)) == null) {
                            return;
                        }
                        descriptions.addAll(desc);
                    }
                    for (Embedding e : resultIterator.getEmbeddings()) {
                        if (GsfHintsProvider.this.isCanceled()) {
                            return;
                        }
                        this.run(resultIterator.getResultIterator(e));
                    }
                }
            });
        }
        catch (ParseException e) {
            LOG.log(Level.WARNING, null, e);
        }
        HintsController.setErrors((Document)doc, (String)"csl-hints", descriptions);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    static {
        errorKind2Severity.put(Severity.ERROR, org.netbeans.spi.editor.hints.Severity.ERROR);
        errorKind2Severity.put(Severity.WARNING, org.netbeans.spi.editor.hints.Severity.WARNING);
        errorKind2Severity.put(Severity.INFO, org.netbeans.spi.editor.hints.Severity.HINT);
    }
}

