/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.wizards.JSFValidationPanel;
import org.netbeans.modules.web.jsf.wizards.TemplatePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class TemplateIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private TemplatePanel templatePanel;
    private transient SourceGroup[] sourceGroups;
    private static final String CSS_FOLDER = "css";
    private static final String CSS_FOLDER2 = "resources/css";
    private static final String CSS_EXT = "css";
    private static final String XHTML_EXT = "xhtml";
    private static final String ENCODING = "UTF-8";
    private static String TEMPLATE_XHTML = "template.xhtml";
    private static String TEMPLATE_XHTML2 = "template-jsf2.xhtml";
    private static String FL_RESOURCE_FOLDER = "org/netbeans/modules/web/jsf/facelets/resources/templates/";

    static FileObject createTemplate(Project project, FileObject targetDir, boolean addJSFFrameworkIfNecessary) throws IOException {
        FileObject result = null;
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm != null) {
            FileObject dir = wm.getDocumentBase();
            if (dir.getFileObject(TEMPLATE_XHTML) != null) {
                return null;
            }
            if (addJSFFrameworkIfNecessary && !JSFConfigUtilities.hasJsfFramework(dir)) {
                JSFConfigUtilities.extendJsfFramework(dir, false);
            }
            boolean isJSF20 = JSFUtils.isJSF20(wm);
            String templateFile = TEMPLATE_XHTML;
            if (isJSF20) {
                templateFile = TEMPLATE_XHTML2;
            }
            String content = JSFFrameworkProvider.readResource(Thread.currentThread().getContextClassLoader().getResourceAsStream(FL_RESOURCE_FOLDER + templateFile), ENCODING);
            result = FileUtil.createData((FileObject)targetDir, (String)TEMPLATE_XHTML);
            JSFFrameworkProvider.createFile(result, content, ENCODING);
            DataObject dob = DataObject.find((FileObject)result);
            if (dob != null) {
                JSFPaletteUtilities.reformat(dob);
            }
        }
        return result;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        WebModule wm;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wiz);
        final String targetName = Templates.getTargetName((WizardDescriptor)wiz);
        final DataFolder df = DataFolder.findFolder((FileObject)dir);
        if (df != null && (wm = WebModule.getWebModule((FileObject)df.getPrimaryFile())) != null) {
            final FileObject docBase = wm.getDocumentBase();
            if (!JSFConfigUtilities.hasJsfFramework(docBase)) {
                JSFConfigUtilities.extendJsfFramework(dir, false);
            }
            final boolean isJSF20 = JSFUtils.isJSF20(wm);
            df.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    InputStream is;
                    String layoutName;
                    FileObject cssFile;
                    FileObject target = df.getPrimaryFile().createData(targetName, TemplateIterator.XHTML_EXT);
                    String folderName = isJSF20 ? TemplateIterator.CSS_FOLDER2 : "css";
                    FileObject cssFolder = docBase.getFileObject(folderName);
                    if (cssFolder == null) {
                        cssFolder = FileUtil.createFolder((FileObject)docBase, (String)folderName);
                    }
                    if ((cssFile = cssFolder.getFileObject(layoutName = TemplateIterator.this.templatePanel.getLayoutFileName(), "css")) == null) {
                        cssFile = cssFolder.createData(layoutName, "css");
                        is = TemplateIterator.this.templatePanel.getLayoutCSS();
                        JSFFrameworkProvider.createFile(cssFile, JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
                    }
                    String layoutPath = JSFUtils.getRelativePath(target, cssFile);
                    cssFile = cssFolder.getFileObject("default", "css");
                    if (cssFile == null) {
                        cssFile = cssFolder.createData("default", "css");
                        is = TemplateIterator.this.templatePanel.getDefaultCSS();
                        JSFFrameworkProvider.createFile(cssFile, JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING), TemplateIterator.ENCODING);
                    }
                    String defaultPath = JSFUtils.getRelativePath(target, cssFile);
                    is = TemplateIterator.this.templatePanel.getTemplate();
                    String content = JSFFrameworkProvider.readResource(is, TemplateIterator.ENCODING);
                    if (!isJSF20) {
                        content = content.replaceAll("h:head", "head").replaceAll("h:body", "body");
                    }
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("LAYOUT_CSS_PATH", layoutPath);
                    args.put("DEFAULT_CSS_PATH", defaultPath);
                    MapFormat formater = new MapFormat(args);
                    formater.setLeftBrace("__");
                    formater.setRightBrace("__");
                    formater.setExactMatch(false);
                    content = formater.format((Object)content);
                    JSFFrameworkProvider.createFile(target, content, TemplateIterator.ENCODING);
                }
            });
            FileObject target = df.getPrimaryFile().getFileObject(targetName, XHTML_EXT);
            DataObject dob = DataObject.find((FileObject)target);
            JSFPaletteUtilities.reformat(dob);
            return Collections.singleton(dob);
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(TemplateWizard wiz) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        this.panels = this.createPanels(project, wiz);
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(TemplateIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard wiz) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroups1 = sources.getSourceGroups("doc_root");
        SourceGroup[] sourceGroups = sourceGroups1.length < 2 ? new SourceGroup[]{sourceGroups1[0], sourceGroups1[0]} : sourceGroups1;
        this.templatePanel = new TemplatePanel((WizardDescriptor)wiz);
        JSFValidationPanel firstPanel = new JSFValidationPanel(Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.templatePanel));
        JComponent c = (JComponent)firstPanel.getComponent();
        Dimension d = c.getPreferredSize();
        d.setSize(d.getWidth(), d.getHeight() + 65.0);
        c.setPreferredSize(d);
        return new WizardDescriptor.Panel[]{firstPanel};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }
}

