/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFFrameworkProvider;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanelVisual;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class JSFConfigurationPanel
extends WebModuleExtender
implements WebModuleExtender.Savable {
    private final JSFFrameworkProvider framework;
    private final ExtenderController controller;
    private JSFConfigurationPanelVisual component;
    private static final String PREFERRED_LANGUAGE = "jsf.language";
    private Preferences preferences;
    private WebModule webModule;
    private LibraryType libraryType;
    private Library jsfCoreLibrary;
    private ServerLibrary serverLibrary;
    private String newLibraryName;
    private File installedFolder;
    private boolean enableFacelets;
    private boolean debugFacelets;
    private boolean skipComments;
    private boolean createExamples;
    private String facesSuffix;
    private String facesMapping;
    private boolean validateXml;
    private boolean verifyObjects;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean customizer;

    public JSFConfigurationPanel(JSFFrameworkProvider framework, ExtenderController controller, boolean customizer) {
        this.framework = framework;
        this.controller = controller;
        this.customizer = customizer;
        this.enableFacelets = false;
        this.debugFacelets = true;
        this.skipComments = true;
        this.createExamples = true;
        this.facesSuffix = ".xhtml";
        this.validateXml = true;
        this.verifyObjects = false;
        this.facesMapping = "/faces/*";
        this.getComponent();
    }

    public JSFConfigurationPanel(JSFFrameworkProvider framework, ExtenderController controller, boolean customizer, Preferences preferences, WebModule webModule) {
        this(framework, controller, customizer);
        this.preferences = preferences;
        this.webModule = webModule;
        this.enableFacelets = preferences.get(PREFERRED_LANGUAGE, "JSP").equals(PreferredLanguage.Facelets.getName());
    }

    public JSFConfigurationPanelVisual getComponent() {
        if (this.component == null) {
            this.component = new JSFConfigurationPanelVisual(this, this.customizer);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JSFConfigurationPanel.class);
    }

    public String getFacesSuffix() {
        return this.facesSuffix;
    }

    public String getFacesMapping() {
        return this.facesMapping;
    }

    private void setFacesMapping(String facesMapping) {
        this.facesMapping = facesMapping;
    }

    public void update() {
        this.component.update();
    }

    public boolean isValid() {
        this.getComponent();
        if (this.component.valid()) {
            this.setFacesMapping(this.component.getURLPattern());
            return true;
        }
        return false;
    }

    public Set extend(WebModule webModule) {
        Project project = FileOwnerQuery.getOwner((FileObject)webModule.getDocumentBase());
        this.preferences = ProjectUtils.getPreferences((Project)project, ProjectUtils.class, (boolean)true);
        PreferredLanguage preferredLang = this.component.getPreferredLanguage();
        if (preferredLang == PreferredLanguage.JSP || preferredLang == PreferredLanguage.Facelets) {
            this.preferences.put(PREFERRED_LANGUAGE, preferredLang.getName());
        }
        return this.framework.extendImpl(webModule, this.component.getJsfComponentCustomizers());
    }

    public ExtenderController getController() {
        return this.controller;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    public String getServletName() {
        return this.component.getServletName();
    }

    public void setServletName(String name) {
        this.component.setServletName(name);
    }

    @Deprecated
    public String getURLPattern() {
        return this.component.getURLPattern();
    }

    public void setURLPattern(String pattern) {
        if (this.component != null) {
            this.component.setURLPattern(pattern);
        }
    }

    public boolean validateXML() {
        return this.validateXml;
    }

    public void setValidateXML(boolean ver) {
        this.validateXml = ver;
    }

    public boolean verifyObjects() {
        return this.verifyObjects;
    }

    public void setVerifyObjects(boolean val) {
        this.verifyObjects = val;
    }

    public boolean packageJars() {
        return this.component.packageJars();
    }

    public String getNewLibraryName() {
        return this.newLibraryName;
    }

    public void setNewLibraryName(String version) {
        this.newLibraryName = version;
        this.fireChangeEvent();
    }

    public File getInstallFolder() {
        return this.installedFolder;
    }

    public void setInstallFolder(File folder) {
        this.installedFolder = folder;
        this.fireChangeEvent();
    }

    public boolean isDebugFacelets() {
        return this.debugFacelets;
    }

    public void setDebugFacelets(boolean value) {
        this.debugFacelets = value;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public void setSkipComments(boolean value) {
        this.skipComments = value;
    }

    public boolean isCreateExamples() {
        return this.createExamples;
    }

    public void setCreateExamples(boolean value) {
        this.createExamples = value;
    }

    public boolean isEnableFacelets() {
        return this.enableFacelets;
    }

    protected void updateEnableFacelets(boolean enableFacelets, boolean force) {
        if (this.enableFacelets != enableFacelets) {
            if (enableFacelets || force) {
                this.enableFacelets = enableFacelets;
            }
            PreferredLanguage preferredLanguage = this.component.getPreferredLanguage();
            if (this.preferences != null && preferredLanguage != null) {
                this.preferences.put(PREFERRED_LANGUAGE, preferredLanguage.getName());
            }
        }
    }

    protected void setEnableFacelets(boolean enableFacelets) {
        this.updateEnableFacelets(enableFacelets, false);
    }

    public LibraryType getLibraryType() {
        return this.libraryType;
    }

    public void setLibraryType(LibraryType value) {
        this.libraryType = value;
    }

    public Library getLibrary() {
        return this.jsfCoreLibrary;
    }

    protected void setLibrary(Library library) {
        this.jsfCoreLibrary = library;
        this.fireChangeEvent();
    }

    public ServerLibrary getServerLibrary() {
        return this.serverLibrary;
    }

    public WebModule getWebModule() {
        return this.webModule;
    }

    protected void setServerLibrary(ServerLibrary library) {
        this.serverLibrary = library;
        this.fireChangeEvent();
    }

    public List<? extends JsfComponentImplementation> getEnabledJsfDescriptors() {
        return this.component.getActivedJsfDescriptors();
    }

    public void save(WebModule webModule) {
        JSFConfigurationPanelVisual panel = this.getComponent();
        PreferredLanguage selectedLanguage = panel.getPreferredLanguage();
        if (PreferredLanguage.Facelets == selectedLanguage) {
            this.setEnableFacelets(true);
        } else {
            this.setEnableFacelets(false);
        }
        List<? extends JsfComponentImplementation> activedImplementations = panel.getActivedJsfDescriptors();
        ArrayList<JsfComponentImplementation> usedImplementations = new ArrayList<JsfComponentImplementation>();
        for (JsfComponentImplementation jsfComponentImplementation : panel.getAllJsfDescriptors()) {
            if (!jsfComponentImplementation.isInWebModule(webModule)) continue;
            usedImplementations.add(jsfComponentImplementation);
        }
        ArrayList<? extends JsfComponentImplementation> addedImplementations = new ArrayList<JsfComponentImplementation>(activedImplementations);
        addedImplementations.removeAll(usedImplementations);
        for (JsfComponentImplementation jsfComponentImplementation : addedImplementations) {
            jsfComponentImplementation.extend(webModule, jsfComponentImplementation.createJsfComponentCustomizer(null));
        }
        ArrayList arrayList = new ArrayList(usedImplementations);
        arrayList.removeAll(activedImplementations);
        for (JsfComponentImplementation jsfComponentImplementation : arrayList) {
            jsfComponentImplementation.remove(webModule);
        }
    }

    public static enum PreferredLanguage {
        JSP("JSP"),
        Facelets("Facelets");

        private String name;

        private PreferredLanguage(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum LibraryType {
        USED,
        NEW,
        SERVER;

    }
}

