/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;

public class SelectorsModule
extends CssEditorModule {
    private static final Collection<String> PSEUDO_CLASSES = Arrays.asList("link", "visited", "hover", "active", "focus", "target", "lang", "enabled", "disabled", "checked", "indeterminate", "root", "nth-child", "nth-last-child", "nth-of-type", "nth-last-of-type", "first-child", "last-child", "first-of-type", "last-of-type", "only-child", "only-of-type", "empty", "first-line", "first-letter", "before", "after");
    private static final Collection<String> PSEUDO_ELEMENTS = Arrays.asList("first-line", "first-letter", "before", "after");
    static ElementKind PSEUDO_ELEMENT_KIND = ElementKind.GLOBAL;
    static ElementKind PSEUDO_CLASS_KIND = ElementKind.GLOBAL;

    @Override
    public Collection<String> getPseudoClasses() {
        return PSEUDO_CLASSES;
    }

    @Override
    public Collection<String> getPseudoElements() {
        return PSEUDO_ELEMENTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Node activeNode = context.getActiveNode();
        Node errorNode = null;
        if (activeNode.type() == NodeType.recovery) {
            activeNode = activeNode.parent();
        }
        if (activeNode.type() == NodeType.error) {
            errorNode = activeNode;
            activeNode = activeNode.parent();
        }
        block0 : switch (activeNode.type()) {
            case simpleSelectorSequence: {
                if (errorNode == null) return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
                Node siblingBefore = errorNode;
                while ((siblingBefore = NodeUtil.getSibling((Node)siblingBefore, (boolean)true)) != null && siblingBefore.type() == NodeType.elementSubsequent) {
                }
                if (siblingBefore != null && siblingBefore.type() == NodeType.typeSelector) {
                    switch ((CssTokenId)context.getTokenSequence().token().id()) {
                        case COLON: {
                            proposals.addAll(SelectorsModule.getPseudoClasses(context));
                            return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
                        }
                        case DCOLON: {
                            proposals.addAll(SelectorsModule.getPseudoElements(context));
                        }
                    }
                }
                return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
            }
            case pseudo: {
                switch ((CssTokenId)context.getTokenSequence().token().id()) {
                    case COLON: {
                        proposals.addAll(SelectorsModule.getPseudoClasses(context));
                        break block0;
                    }
                    case DCOLON: {
                        proposals.addAll(SelectorsModule.getPseudoElements(context));
                        break block0;
                    }
                    case IDENT: {
                        if (!context.getTokenSequence().movePrevious()) return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
                        switch ((CssTokenId)context.getTokenSequence().token().id()) {
                            case COLON: {
                                proposals.addAll(SelectorsModule.getPseudoClasses(context));
                                break block0;
                            }
                            case DCOLON: {
                                proposals.addAll(SelectorsModule.getPseudoElements(context));
                            }
                        }
                    }
                }
            }
        }
        return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
    }

    private static List<CompletionProposal> getPseudoClasses(CompletionContext context) {
        return Utilities.createRAWCompletionProposals(CssModuleSupport.getPseudoClasses(), ElementKind.FIELD, context.getAnchorOffset());
    }

    private static List<CompletionProposal> getPseudoElements(CompletionContext context) {
        return Utilities.createRAWCompletionProposals(CssModuleSupport.getPseudoElements(), ElementKind.FIELD, context.getAnchorOffset());
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case pseudo: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CLASS_SET);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public <T extends Set<OffsetRange>> NodeVisitor<T> getMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result) {
        return Utilities.createMarkOccurrencesNodeVisitor(context, result, NodeType.pseudo);
    }
}

