/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.css.editor.module.spi.Browser;

public class DefaultBrowser
extends Browser {
    private static final String DEFAULT_ICONS_LOCATION = "/org/netbeans/modules/css/resources/icons/";
    private String iconBase;
    private String name;
    private String vendor;
    private String vendorSpecificPropertyId;
    private String renderingEngineId;
    private AtomicReference<URL> active = new AtomicReference();
    private AtomicReference<URL> inactive = new AtomicReference();

    public DefaultBrowser(String name, String vendor, String renderingEngineId, String vendorSpecificPropertyPrefix, String iconBase) {
        this.name = name;
        this.vendor = vendor;
        this.renderingEngineId = renderingEngineId;
        this.vendorSpecificPropertyId = vendorSpecificPropertyPrefix;
        this.iconBase = iconBase;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public URL getActiveIcon() {
        this.active.compareAndSet(null, DefaultBrowser.class.getResource(DEFAULT_ICONS_LOCATION + this.iconBase + ".png"));
        return this.active.get();
    }

    @Override
    public URL getInactiveIcon() {
        this.inactive.compareAndSet(null, DefaultBrowser.class.getResource(DEFAULT_ICONS_LOCATION + this.iconBase + "-disabled.png"));
        return this.inactive.get();
    }

    @Override
    public String getDescription() {
        return this.getVendor() + ' ' + this.getName();
    }

    @Override
    public String getVendorSpecificPropertyId() {
        return this.vendorSpecificPropertyId;
    }

    @Override
    public String getRenderingEngineId() {
        return this.renderingEngineId;
    }
}

