/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.editor.HtmlTags;
import org.netbeans.modules.css.editor.URLRetriever;
import org.netbeans.modules.css.editor.api.CssCslParserResult;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.csl.CssPropertyElement;
import org.netbeans.modules.css.editor.csl.CssValueElement;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Property;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.editor.properties.parser.GrammarElement;
import org.netbeans.modules.css.editor.properties.parser.PropertyModel;
import org.netbeans.modules.css.editor.properties.parser.PropertyValue;
import org.netbeans.modules.css.editor.properties.parser.ValueGrammarElement;
import org.netbeans.modules.css.indexing.CssIndex;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReferenceCompletion;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public class CssCompletion
implements CodeCompletionHandler {
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");
    private static char firstPrefixChar;
    private static final String EMPTY_STRING = "";
    private static final String UNIVERSAL_SELECTOR = "*";
    static String[] TEST_USED_COLORS;

    public CodeCompletionResult complete(CodeCompletionContext context) {
        int diff;
        String prefix;
        ArrayList<CompletionProposal> completionProposals = new ArrayList<CompletionProposal>();
        CssCslParserResult info = (CssCslParserResult)context.getParserResult();
        Snapshot snapshot = info.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        int caretOffset = context.getCaretOffset();
        String string = prefix = context.getPrefix() != null ? context.getPrefix() : EMPTY_STRING;
        if (firstPrefixChar != '\u0000') {
            prefix = firstPrefixChar + prefix;
        }
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(CssTokenId.language());
        assert (ts != null);
        CodeCompletionResult lexicalCompletionResult = this.handleLexicalBasedCompletion(file, (TokenSequence<CssTokenId>)ts, snapshot, caretOffset);
        if (lexicalCompletionResult != null) {
            return lexicalCompletionResult;
        }
        int offset = caretOffset - prefix.length();
        int astOffset = snapshot.getEmbeddedOffset(offset);
        int astCaretOffset = snapshot.getEmbeddedOffset(caretOffset);
        boolean unmappableClassOrId = false;
        if (astOffset == -1) {
            if (prefix.length() == 1 && prefix.charAt(0) == '.' || prefix.length() > 0 && prefix.charAt(0) == '#') {
                unmappableClassOrId = true;
            } else {
                return null;
            }
        }
        boolean tokenFound = (diff = ts.move(astCaretOffset)) == 0 ? ts.movePrevious() : ts.moveNext();
        Node root = info.getParseTree();
        if (root == null) {
            return CodeCompletionResult.NONE;
        }
        char charAfterCaret = snapshot.getText().length() > astCaretOffset + 1 ? (char)snapshot.getText().subSequence(astCaretOffset, astCaretOffset + 1).charAt(0) : (char)' ';
        Node tokenNode = NodeUtil.findNodeAtOffset((Node)root, (int)astCaretOffset);
        CssTokenId tokenNodeTokenId = tokenNode.type() == NodeType.token ? NodeUtil.getTokenNodeTokenId((Node)tokenNode) : null;
        Node node = NodeUtil.findNonTokenNodeAtOffset((Node)root, (int)astCaretOffset);
        CompletionContext completionContext = new CompletionContext(node, tokenNode, info.getWrappedCssParserResult(), (TokenSequence<CssTokenId>)ts, diff, context.getQueryType(), caretOffset, offset, astCaretOffset, astOffset, prefix);
        List<CompletionProposal> cssModulesCompletionProposals = CssModuleSupport.getCompletionProposals(completionContext);
        completionProposals.addAll(cssModulesCompletionProposals);
        this.completeClassSelectors(completionContext, completionProposals, unmappableClassOrId);
        this.completeIdSelectors(completionContext, completionProposals, unmappableClassOrId);
        this.completeAtRulesAndHtmlSelectors(completionContext, completionProposals);
        this.completeHtmlSelectors(completionContext, completionProposals, (TokenId)tokenNodeTokenId);
        this.completeKeywords(completionContext, completionProposals, tokenFound);
        this.completePropertyName(completionContext, completionProposals);
        this.completePropertyValue(completionContext, completionProposals, charAfterCaret);
        return new DefaultCompletionResult(completionProposals, false);
    }

    private List<? extends CompletionProposal> completeImport(FileObject base, int offset, String prefix, boolean addQuotes, boolean addSemicolon) {
        CssLinkCompletion fileCompletion = new CssLinkCompletion(addQuotes, addSemicolon);
        return fileCompletion.getItems(base, offset - prefix.length(), prefix);
    }

    private List<CompletionProposal> completeHtmlSelectors(String prefix, int offset) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(20);
        ArrayList<String> items = new ArrayList<String>(Arrays.asList(HtmlTags.getTags()));
        items.add(UNIVERSAL_SELECTOR);
        for (String tagName : items) {
            if (!tagName.startsWith(prefix.toLowerCase(Locale.ENGLISH))) continue;
            proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(tagName), tagName, offset, true));
        }
        return proposals;
    }

    private List<CompletionProposal> wrapPropertyValues(CompletionContext context, String prefix, Property propertyDescriptor, Collection<GrammarElement> props, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem, boolean extendedItemsOnly) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>(props.size());
        boolean colorChooserAdded = false;
        for (GrammarElement e : props) {
            if (e instanceof ValueGrammarElement && ((ValueGrammarElement)e).isUnit()) continue;
            CssValueElement handle = new CssValueElement(propertyDescriptor, e);
            String origin = e.getResolvedOrigin();
            if ("colors-list".equals(origin)) {
                if (!colorChooserAdded) {
                    proposals.add(CssCompletionItem.createColorChooserCompletionItem(anchor, origin, addSemicolon));
                    proposals.addAll(this.getUsedColorsItems(context, prefix, handle, origin, anchor, addSemicolon, addSpaceBeforeItem));
                    colorChooserAdded = true;
                }
                if (extendedItemsOnly) continue;
                proposals.add(CssCompletionItem.createColorValueCompletionItem(handle, e, anchor, addSemicolon, addSpaceBeforeItem));
                continue;
            }
            if (extendedItemsOnly) continue;
            proposals.add(CssCompletionItem.createValueCompletionItem(handle, e, anchor, addSemicolon, addSpaceBeforeItem));
        }
        return proposals;
    }

    private Collection<CompletionProposal> getUsedColorsItems(CompletionContext context, String prefix, CssElement element, String origin, int anchor, boolean addSemicolon, boolean addSpaceBeforeItem) {
        FileObject current;
        HashSet<CompletionProposal> proposals = new HashSet<CompletionProposal>();
        if (TEST_USED_COLORS != null) {
            for (String color : TEST_USED_COLORS) {
                proposals.add(CssCompletionItem.createHashColorCompletionItem(element, color, origin, anchor, addSemicolon, addSpaceBeforeItem, true));
            }
        }
        if ((current = context.getParserResult().getSnapshot().getSource().getFileObject()) == null) {
            return proposals;
        }
        CssProjectSupport support = CssProjectSupport.findFor(current);
        if (support == null) {
            return proposals;
        }
        CssIndex index = support.getIndex();
        Map<FileObject, Collection<String>> result = index.findAll(RefactoringElementType.COLOR);
        ArrayList<FileObject> resortedKeys = new ArrayList<FileObject>(result.keySet());
        if (resortedKeys.remove(current)) {
            resortedKeys.add(0, current);
        }
        for (FileObject file : resortedKeys) {
            Collection<String> colors = result.get(file);
            boolean usedInCurrentFile = file.equals(current);
            for (String color : colors) {
                if (!color.startsWith(prefix)) continue;
                proposals.add(CssCompletionItem.createHashColorCompletionItem(element, color, origin, anchor, addSemicolon, addSpaceBeforeItem, usedInCurrentFile));
            }
        }
        return proposals;
    }

    private Collection<String> filterStrings(Collection<String> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String value : values) {
            if (!value.toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private Collection<GrammarElement> filterElements(Collection<GrammarElement> values, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<GrammarElement> filtered = new ArrayList<GrammarElement>();
        for (GrammarElement value : values) {
            if (!value.toString().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    private Collection<Property> filterProperties(Collection<Property> props, String propertyNamePrefix) {
        propertyNamePrefix = propertyNamePrefix.toLowerCase();
        ArrayList<Property> filtered = new ArrayList<Property>();
        for (Property p : props) {
            if (!p.getName().toLowerCase().startsWith(propertyNamePrefix)) continue;
            filtered.add(p);
        }
        return filtered;
    }

    public String document(ParserResult info, ElementHandle element) {
        block4: {
            HelpResolver resolver = CssModuleSupport.getHelpResolver();
            if (element instanceof CssPropertyElement) {
                CssPropertyElement e = (CssPropertyElement)element;
                Property property = e.getPropertyDescriptor();
                return resolver.getHelp(property);
            }
            if (element instanceof ElementHandle.UrlHandle) {
                try {
                    return URLRetriever.getURLContentAndCache(new URL(element.getName()));
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
        }
        return null;
    }

    public ElementHandle resolveLink(String link, ElementHandle elementHandle) {
        if (elementHandle instanceof CssPropertyElement) {
            CssPropertyElement e = (CssPropertyElement)elementHandle;
            Property property = e.getPropertyDescriptor();
            URL url = CssModuleSupport.getHelpResolver().resolveLink(property, link);
            if (url != null) {
                return new ElementHandle.UrlHandle(url.toExternalForm());
            }
        }
        return null;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        Snapshot snapshot = info.getSnapshot();
        TokenHierarchy hi = snapshot.getTokenHierarchy();
        String prefix = this.getPrefix((TokenSequence<CssTokenId>)hi.tokenSequence(), snapshot.getEmbeddedOffset(caretOffset));
        if (prefix.length() > 0 && (prefix.charAt(0) == '.' || prefix.charAt(0) == '#')) {
            firstPrefixChar = prefix.charAt(0);
            return prefix.substring(1);
        }
        firstPrefixChar = '\u0000';
        return prefix;
    }

    private String getPrefix(TokenSequence<CssTokenId> ts, int caretOffset) {
        if (ts == null) {
            return null;
        }
        int diff = ts.move(caretOffset);
        if (diff == 0) {
            if (!ts.movePrevious()) {
                return EMPTY_STRING;
            }
        } else if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        switch (((CssTokenId)t.id()).getTokenCategory()) {
            case KEYWORDS: 
            case OPERATORS: 
            case BRACES: {
                return EMPTY_STRING;
            }
        }
        int skipPrefixChars = 0;
        switch ((CssTokenId)t.id()) {
            case COLON: 
            case DCOLON: 
            case COMMA: 
            case LBRACKET: {
                return EMPTY_STRING;
            }
            case STRING: {
                skipPrefixChars = 1;
            }
        }
        return ((Object)t.text().subSequence(skipPrefixChars, diff == 0 ? t.text().length() : diff)).toString().trim();
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int offset = component.getCaretPosition();
        if (typedText == null || typedText.length() == 0) {
            return CodeCompletionHandler.QueryType.NONE;
        }
        char c = typedText.charAt(typedText.length() - 1);
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)component.getDocument(), (int)offset, (Language)CssTokenId.language());
        if (ts != null) {
            int diff = ts.move(offset);
            TokenId currentTokenId = null;
            if (ts != null && (diff == 0 && ts.movePrevious() || ts.moveNext())) {
                currentTokenId = ts.token().id();
            }
            if (currentTokenId == CssTokenId.IDENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
            if (typedText.length() == 1 && c == ' ' && currentTokenId != CssTokenId.COMMENT) {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return CodeCompletionHandler.QueryType.STOP;
            }
            case '#': 
            case ',': 
            case '.': 
            case ':': {
                return CodeCompletionHandler.QueryType.COMPLETION;
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document doc, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        return ParameterInfo.NONE;
    }

    private CodeCompletionResult handleLexicalBasedCompletion(FileObject file, TokenSequence<CssTokenId> ts, Snapshot snapshot, int caretOffset) {
        int tokenDiff = ts.move(snapshot.getEmbeddedOffset(caretOffset));
        if (ts.moveNext() || ts.movePrevious()) {
            boolean addSemicolon = true;
            switch ((CssTokenId)ts.token().id()) {
                case SEMI: {
                    addSemicolon = false;
                }
                case WS: {
                    if (addSemicolon) {
                        Token semicolon = LexerUtils.followsToken(ts, (TokenId)CssTokenId.SEMI, (boolean)false, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.S});
                        boolean bl = addSemicolon = semicolon == null;
                    }
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{CssTokenId.S})) break;
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, EMPTY_STRING, true, addSemicolon);
                    int moveBack = (addSemicolon ? 1 : 0) + 1;
                    return new CssFileCompletionResult(imports, moveBack);
                }
                case STRING: {
                    Token originalToken = ts.token();
                    addSemicolon = false;
                    if (null == LexerUtils.followsToken(ts, (TokenId)CssTokenId.IMPORT_SYM, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{CssTokenId.S})) break;
                    String valuePrefix = ((Object)originalToken.text()).toString().substring(1, tokenDiff);
                    List<CompletionProposal> imports = this.completeImport(file, caretOffset, valuePrefix, false, addSemicolon);
                    int moveBack = addSemicolon ? 1 : 0;
                    return new CssFileCompletionResult(imports, moveBack);
                }
            }
        }
        return null;
    }

    private void completeClassSelectors(CompletionContext context, List<CompletionProposal> completionProposals, boolean unmappableClassOrId) {
        CssProjectSupport sup;
        Node node = context.getActiveNode();
        FileObject file = context.getSnapshot().getSource().getFileObject();
        String prefix = context.getPrefix();
        int offset = context.getAnchorOffset();
        NodeType nodeType = node.type();
        if ((nodeType == NodeType.cssClass || (unmappableClassOrId || nodeType == NodeType.error) && prefix.length() == 1 && prefix.charAt(0) == '.') && file != null && (sup = CssProjectSupport.findFor(file)) != null) {
            CssIndex index = sup.getIndex();
            DependenciesGraph deps = index.getDependencies(file);
            Collection refered = deps.getAllReferedFiles();
            if (prefix.length() == 1 && prefix.charAt(0) == '.') {
                prefix = EMPTY_STRING;
                ++offset;
            }
            Map<FileObject, Collection<String>> search = index.findClassesByPrefix(prefix);
            HashSet<String> refclasses = new HashSet<String>();
            HashSet<String> allclasses = new HashSet<String>();
            for (FileObject fo : search.keySet()) {
                allclasses.addAll(search.get(fo));
                if (!refered.contains(fo)) continue;
                refclasses.addAll(search.get(fo));
            }
            ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(refclasses.size());
            for (String clazz : allclasses) {
                proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(clazz), clazz, offset, refclasses.contains(clazz)));
            }
            completionProposals.addAll(proposals);
        }
    }

    private void completeIdSelectors(CompletionContext context, List<CompletionProposal> completionProposals, boolean unmappableClassOrId) {
        CssProjectSupport sup;
        Node node = context.getActiveNode();
        FileObject file = context.getSnapshot().getSource().getFileObject();
        String prefix = context.getPrefix();
        int offset = context.getAnchorOffset();
        NodeType nodeType = node.type();
        if (prefix.length() > 0 && (node.type() == NodeType.cssId || (unmappableClassOrId || nodeType == NodeType.error) && prefix.charAt(0) == '#') && file != null && (sup = CssProjectSupport.findFor(file)) != null) {
            CssIndex index = sup.getIndex();
            DependenciesGraph deps = index.getDependencies(file);
            Collection refered = deps.getAllReferedFiles();
            prefix = prefix.length() == 1 && prefix.charAt(0) == '#' ? EMPTY_STRING : prefix.substring(1);
            ++offset;
            Map<FileObject, Collection<String>> search = index.findIdsByPrefix(prefix);
            HashSet<String> allids = new HashSet<String>();
            HashSet<String> refids = new HashSet<String>();
            for (FileObject fo : search.keySet()) {
                allids.addAll(search.get(fo));
                if (!refered.contains(fo)) continue;
                refids.addAll(search.get(fo));
            }
            ArrayList<CssCompletionItem> proposals = new ArrayList<CssCompletionItem>(allids.size());
            for (String id : allids) {
                proposals.add(CssCompletionItem.createSelectorCompletionItem(new CssElement(id), id, offset, refids.contains(id)));
            }
            completionProposals.addAll(proposals);
        }
    }

    private void completeAtRulesAndHtmlSelectors(CompletionContext context, List<CompletionProposal> completionProposals) {
        Node node = context.getActiveNode();
        String prefix = context.getPrefix();
        int offset = context.getAnchorOffset();
        NodeType nodeType = node.type();
        if (NodeUtil.isOfType((Node)node, (NodeType[])new NodeType[]{NodeType.root, NodeType.styleSheet, NodeType.bodylist}) || nodeType == NodeType.error && NodeUtil.isOfType((Node)node.parent(), (NodeType[])new NodeType[]{NodeType.root, NodeType.styleSheet, NodeType.bodylist})) {
            ArrayList<CompletionProposal> all = new ArrayList<CompletionProposal>();
            all.addAll(Utilities.createRAWCompletionProposals(AT_RULES, ElementKind.FIELD, offset));
            all.addAll(this.completeHtmlSelectors(prefix, offset));
            completionProposals.addAll(all);
        }
    }

    private void completeHtmlSelectors(CompletionContext completionContext, List<CompletionProposal> completionProposals, TokenId tokenNodeTokenId) {
        NodeType nodeType = completionContext.getActiveNode().type();
        String prefix = completionContext.getPrefix();
        int caretOffset = completionContext.getCaretOffset();
        switch (nodeType) {
            case media: {
                completionProposals.addAll(this.completeHtmlSelectors(completionContext.getPrefix(), completionContext.getCaretOffset()));
                break;
            }
            case elementName: {
                completionProposals.addAll(this.completeHtmlSelectors(prefix, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
                break;
            }
            case typeSelector: 
            case elementSubsequent: {
                completionProposals.addAll(this.completeHtmlSelectors(prefix, caretOffset));
                break;
            }
            case selectorsGroup: 
            case combinator: 
            case selector: 
            case bodyset: {
                completionProposals.addAll(this.completeHtmlSelectors(prefix, caretOffset));
                break;
            }
            case error: {
                Node parentNode = completionContext.getActiveNode().parent();
                if (parentNode == null) break;
                switch ((CssTokenId)completionContext.getTokenSequence().token().id()) {
                    case WS: {
                        switch (parentNode.type()) {
                            case typeSelector: 
                            case simpleSelectorSequence: {
                                completionProposals.addAll(this.completeHtmlSelectors(prefix, caretOffset));
                            }
                        }
                    }
                }
            }
        }
    }

    private void completeKeywords(CompletionContext completionContext, List<CompletionProposal> completionProposals, boolean tokenFound) {
        TokenId id;
        NodeType nodeType = completionContext.getActiveNode().type();
        if (!(nodeType != NodeType.imports && nodeType != NodeType.media && nodeType != NodeType.page && nodeType != NodeType.charSet || !tokenFound || (id = completionContext.getTokenSequence().token().id()) != CssTokenId.IMPORT_SYM && id != CssTokenId.MEDIA_SYM && id != CssTokenId.PAGE_SYM && id != CssTokenId.CHARSET_SYM && id != CssTokenId.ERROR)) {
            Collection<String> possibleValues = this.filterStrings(AT_RULES, completionContext.getPrefix());
            completionProposals.addAll(Utilities.createRAWCompletionProposals(possibleValues, ElementKind.FIELD, completionContext.getSnapshot().getOriginalOffset(completionContext.getActiveNode().from())));
        }
    }

    private void completePropertyName(CompletionContext cc, List<CompletionProposal> completionProposals) {
        Node parent;
        NodeType nodeType = cc.getActiveNode().type();
        if (nodeType == NodeType.property && (cc.getPrefix().length() > 0 || cc.getEmbeddedCaretOffset() == cc.getActiveNode().from())) {
            Collection<Property> possibleProps = this.filterProperties(CssModuleSupport.getProperties(), cc.getPrefix());
            completionProposals.addAll(Utilities.wrapProperties(possibleProps, cc.getSnapshot().getOriginalOffset(cc.getActiveNode().from())));
        }
        if (!(nodeType != NodeType.recovery && nodeType != NodeType.error || (parent = cc.getActiveNode().parent()) == null || parent.type() != NodeType.ruleSet && parent.type() != NodeType.moz_document)) {
            Collection<Property> possibleProps = this.filterProperties(CssModuleSupport.getProperties(), cc.getPrefix());
            completionProposals.addAll(Utilities.wrapProperties(possibleProps, cc.getCaretOffset()));
        }
        if (nodeType == NodeType.ruleSet || nodeType == NodeType.moz_document || nodeType == NodeType.declarations) {
            completionProposals.addAll(Utilities.wrapProperties(CssModuleSupport.getProperties(), cc.getCaretOffset()));
        }
    }

    private void completePropertyValue(CompletionContext context, List<CompletionProposal> completionProposals, char charAfterCaret) {
        Node node = context.getActiveNode();
        String prefix = context.getPrefix();
        NodeType nodeType = node.type();
        if (nodeType == NodeType.declaration) {
            PropertyModel prop;
            final Node[] result = new Node[2];
            NodeVisitor propertySearch = new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node.type() == NodeType.property) {
                        result[0] = node;
                    } else if (node.type() == NodeType.error) {
                        result[1] = node;
                    }
                    return false;
                }
            };
            propertySearch.visitChildren(node);
            Node property = result[0];
            if (property == null) {
                return;
            }
            String expressionText = EMPTY_STRING;
            if (result[1] != null) {
                int eolIndex;
                int colonIndex;
                String propertyImage = ((Object)node.image()).toString().trim();
                if (propertyImage.endsWith("}")) {
                    propertyImage = propertyImage.substring(0, propertyImage.length() - 1);
                }
                if ((colonIndex = propertyImage.indexOf(58)) >= 0) {
                    expressionText = propertyImage.substring(colonIndex + 1);
                }
                if ((eolIndex = expressionText.indexOf(10)) > 0) {
                    expressionText = expressionText.substring(0, eolIndex);
                }
            }
            if ((prop = CssModuleSupport.getPropertyModel(((Object)property.image()).toString().trim())) != null) {
                PropertyValue propVal = new PropertyValue(prop, expressionText);
                Set<GrammarElement> alts = propVal.alternatives();
                Collection<GrammarElement> filteredByPrefix = this.filterElements(alts, prefix);
                int completionItemInsertPosition = prefix.trim().length() == 0 ? context.getCaretOffset() : context.getSnapshot().getOriginalOffset(node.from());
                boolean addSpaceBeforeItem = false;
                if (alts.size() > 0 && filteredByPrefix.isEmpty() && Character.isWhitespace(charAfterCaret)) {
                    completionItemInsertPosition = context.getCaretOffset();
                    filteredByPrefix = alts;
                    addSpaceBeforeItem = true;
                }
                completionProposals.addAll(this.wrapPropertyValues(context, prefix, prop.getPropertyDescriptor(), filteredByPrefix, completionItemInsertPosition, false, addSpaceBeforeItem, false));
            }
        } else if (nodeType == NodeType.term || nodeType == NodeType.expr || nodeType == NodeType.error && node.parent().type() == NodeType.declaration) {
            String expressionText;
            final Node[] result = new Node[1];
            NodeVisitor declarationSearch = new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node.type() == NodeType.declaration) {
                        result[0] = node;
                    }
                    return false;
                }
            };
            declarationSearch.visitAncestors(node);
            Node declaratioNode = result[0];
            result[0] = null;
            NodeVisitor propertySearch = new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node.type() == NodeType.property) {
                        result[0] = node;
                    }
                    return false;
                }
            };
            propertySearch.visitChildren(declaratioNode);
            Node property = result[0];
            Property propertyDescriptor = CssModuleSupport.getProperty(((Object)property.image()).toString());
            if (propertyDescriptor == null) {
                return;
            }
            if (nodeType == NodeType.term) {
                Node expression = node.parent();
                expressionText = ((Object)expression.image()).toString();
            } else {
                expressionText = EMPTY_STRING;
            }
            int eolIndex = expressionText.indexOf(10);
            if (eolIndex > 0) {
                expressionText = expressionText.substring(0, eolIndex);
            }
            PropertyModel propertyModel = CssModuleSupport.getPropertyModel(propertyDescriptor.getName());
            PropertyValue propVal = new PropertyValue(propertyModel, expressionText);
            Set<GrammarElement> alts = propVal.alternatives();
            Collection<GrammarElement> filteredByPrefix = this.filterElements(alts, prefix);
            int completionItemInsertPosition = prefix.trim().length() == 0 ? context.getCaretOffset() : context.getSnapshot().getOriginalOffset(node.from());
            boolean addSpaceBeforeItem = false;
            if (alts.size() > 0 && filteredByPrefix.isEmpty() && Character.isWhitespace(charAfterCaret)) {
                completionItemInsertPosition = context.getCaretOffset();
                filteredByPrefix = alts;
                addSpaceBeforeItem = true;
            }
            boolean extendedItemsOnly = false;
            if (prefix.equals("#")) {
                --completionItemInsertPosition;
                extendedItemsOnly = true;
            }
            completionProposals.addAll(this.wrapPropertyValues(context, prefix, propertyDescriptor, filteredByPrefix, completionItemInsertPosition, false, addSpaceBeforeItem, extendedItemsOnly));
        }
    }

    private static class CssLinkCompletion
    extends FileReferenceCompletion<CssCompletionItem> {
        private static final String GO_UP_TEXT = "../";
        private boolean addQuotes;
        private boolean addSemicolon;

        public CssLinkCompletion(boolean addQuotes, boolean addSemicolon) {
            this.addQuotes = addQuotes;
            this.addSemicolon = addSemicolon;
        }

        public CssCompletionItem createFileItem(int anchor, String name, Color color, ImageIcon icon) {
            return CssCompletionItem.createFileCompletionItem(new CssElement(name), name, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }

        public CssCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return CssCompletionItem.createFileCompletionItem(new CssElement(GO_UP_TEXT), GO_UP_TEXT, anchor, color, icon, this.addQuotes, this.addSemicolon);
        }
    }

    private static class CssFileCompletionResult
    extends DefaultCompletionResult {
        private int moveCaretBack;

        public CssFileCompletionResult(List<CompletionProposal> list, int moveCaretBack) {
            super(list, false);
            this.moveCaretBack = moveCaretBack;
        }

        public void afterInsert(CompletionProposal item) {
            Caret c = EditorRegistry.lastFocusedComponent().getCaret();
            c.setDot(c.getDot() - this.moveCaretBack);
        }
    }
}

