/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.api.CssCslParserResult;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.parsing.api.Snapshot;

public class CssBracketCompleter
implements KeystrokeHandler {
    private static final char[][] PAIRS = new char[][]{{'{', '}'}, {'\"', '\"'}, {'\'', '\''}};
    private char justAddedPair;
    private int justAddedPairOffset = -1;
    public static boolean unitTestingSupport = false;

    private int pairIndex(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            char pair = PAIRS[i][0];
            if (pair != ch) continue;
            return i;
        }
        return -1;
    }

    public boolean beforeCharInserted(Document doc, int dot, JTextComponent target, char ch) throws BadLocationException {
        TokenSequence<CssTokenId> ts;
        int pairIdx;
        TokenSequence<CssTokenId> ts2;
        Caret caret = target.getCaret();
        if (this.justAddedPair == ch && this.justAddedPairOffset == dot) {
            this.justAddedPair = '\u0000';
            this.justAddedPairOffset = -1;
            caret.setDot(dot + 1);
            return true;
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        if (ch == '}' && (ts2 = CssBracketCompleter.getCssTokenSequence(doc, dot)) != null) {
            ts2.move(dot);
            if (ts2.moveNext() && ts2.token().id() == CssTokenId.RBRACE) {
                caret.setDot(dot + 1);
                return true;
            }
        }
        if ((pairIdx = this.pairIndex(ch)) == -1) {
            return false;
        }
        if (target.getSelectionStart() != dot) {
            return false;
        }
        if ((ch == '\'' || ch == '\"') && (ts = CssBracketCompleter.getCssTokenSequence(doc, dot)) != null) {
            TokenSequence htmlts;
            TokenHierarchy hi;
            List embedded;
            Language top;
            Token t;
            int diff = ts.move(dot);
            if (ts.moveNext() && (t = ts.token()).id() == CssTokenId.STRING) {
                char front = t.text().charAt(diff);
                if (front == ch) {
                    caret.setDot(dot + 1);
                    return true;
                }
                return false;
            }
            LanguagePath langPath = ts.languagePath();
            LanguagePath parentPath = langPath.parent();
            if (parentPath != null && "text/html".equals((top = parentPath.topLanguage()).mimeType()) && (embedded = (hi = TokenHierarchy.get((Document)doc)).embeddedTokenSequences(dot, true)).size() > 1 && (htmlts = (TokenSequence)embedded.get(embedded.size() - 2)).languagePath().equals(parentPath)) {
                TokenId id;
                htmlts.move(dot);
                if ((htmlts.moveNext() || htmlts.movePrevious()) && (id = htmlts.token().id()).name().equals("VALUE_CSS")) {
                    return false;
                }
            }
            ts.move(dot);
            while (ts.movePrevious()) {
                Token t2 = ts.token();
                if (t2.text().charAt(0) == ch) {
                    if (t2.id() == CssTokenId.STRING) break;
                    return false;
                }
                if (t2.id() != CssTokenId.LBRACE && t2.id() != CssTokenId.RBRACE && t2.id() != CssTokenId.SEMI) continue;
                break;
            }
        }
        this.justAddedPair = PAIRS[pairIdx][1];
        this.justAddedPairOffset = dot + 1;
        doc.insertString(dot, String.valueOf(PAIRS[pairIdx][0]), null);
        doc.insertString(dot + 1, String.valueOf(this.justAddedPair), null);
        caret.setDot(dot + 1);
        return true;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        if ('}' != ch) {
            return false;
        }
        int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)((BaseDocument)doc), (int)caretOffset);
        if (lineStart != caretOffset) {
            return false;
        }
        this.reindentLater((BaseDocument)doc, caretOffset, caretOffset);
        return false;
    }

    public boolean charBackspaced(Document doc, int dot, JTextComponent target, char ch) throws BadLocationException {
        if (this.justAddedPairOffset - 1 == dot) {
            doc.remove(dot, 1);
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        return false;
    }

    public int beforeBreak(Document doc, int dot, JTextComponent jtc) throws BadLocationException {
        if (dot == 0 || dot == doc.getLength()) {
            return -1;
        }
        String context = doc.getText(dot - 1, 2);
        if ("{}".equals(context)) {
            BaseDocument bdoc = (BaseDocument)doc;
            doc.insertString(dot, "\n", null);
            jtc.getCaret().setDot(dot);
            this.reindentLater(bdoc, dot - 1, dot + 2);
        }
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        Node node;
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>(2);
        Node root = ((CssCslParserResult)info).getParseTree();
        Snapshot snapshot = info.getSnapshot();
        if (root != null && (node = NodeUtil.findNodeAtOffset((Node)root, (int)snapshot.getEmbeddedOffset(caretOffset))) != null) {
            block3: do {
                switch (node.type()) {
                    case declarations: 
                    case token: {
                        break;
                    }
                    default: {
                        OffsetRange last;
                        int[] trimmedNodeRange = NodeUtil.getTrimmedNodeRange((Node)node);
                        int from = snapshot.getOriginalOffset(trimmedNodeRange[0]);
                        int to = snapshot.getOriginalOffset(trimmedNodeRange[1]);
                        if (from == -1 || to == -1) continue block3;
                        OffsetRange offsetRange = last = ranges.isEmpty() ? null : ranges.get(ranges.size() - 1);
                        if (last != null && last.getEnd() - last.getStart() >= to - from) continue block3;
                        ranges.add(new OffsetRange(from, to));
                    }
                }
            } while ((node = node.parent()) != null);
        }
        return ranges;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }

    private void reindentLater(final BaseDocument doc, int start, int end) throws BadLocationException {
        final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)doc, (int)start));
        final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)doc, (int)end));
        Runnable rn = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Indent indent = Indent.get((Document)doc);
                indent.lock();
                try {
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                indent.reindent(from.getOffset(), to.getOffset());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    indent.unlock();
                }
            }
        };
        if (unitTestingSupport) {
            rn.run();
        } else {
            SwingUtilities.invokeLater(rn);
        }
    }

    private static TokenSequence<CssTokenId> getCssTokenSequence(Document doc, int offset) {
        TokenHierarchy hi = TokenHierarchy.get((Document)doc);
        TokenSequence<CssTokenId> ts = CssBracketCompleter.tokenSequenceList(hi, offset, false);
        if (ts == null) {
            ts = CssBracketCompleter.tokenSequenceList(hi, offset, true);
        }
        if (ts == null) {
            return null;
        }
        ts.moveStart();
        if (ts.moveNext() && ts.offset() > offset) {
            return null;
        }
        ts.moveEnd();
        if (ts.movePrevious() && ts.offset() + ts.token().length() < offset) {
            return null;
        }
        return ts;
    }

    private static TokenSequence<CssTokenId> tokenSequenceList(TokenHierarchy hi, int offset, boolean backwardBias) {
        List tsl = hi.embeddedTokenSequences(offset, backwardBias);
        if (tsl.size() > 0) {
            TokenSequence ts = (TokenSequence)tsl.get(tsl.size() - 1);
            if (ts.language() != CssTokenId.language()) {
                return null;
            }
            return ts;
        }
        return null;
    }
}

