/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.php.api.phpmodule.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.spi.editor.EditorExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpModuleActionsExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpModuleCustomizerExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpModuleExtender;
import org.netbeans.modules.php.symfony.SymfonyPhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandSupport;
import org.netbeans.modules.php.symfony.editor.SymfonyEditorExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class SymfonyPhpFrameworkProvider
extends PhpFrameworkProvider {
    public static final String FILE_CONFIG = "config/ProjectConfiguration.class.php";
    private static final String ICON_PATH = "org/netbeans/modules/php/symfony/ui/resources/symfony_badge_8.png";
    private static final SymfonyPhpFrameworkProvider INSTANCE = new SymfonyPhpFrameworkProvider();
    private static final Set<String> CONFIG_FILE_EXTENSIONS = new HashSet<String>();
    private final BadgeIcon badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/symfony/ui/resources/symfony_badge_8.png"), SymfonyPhpFrameworkProvider.class.getResource("/org/netbeans/modules/php/symfony/ui/resources/symfony_badge_8.png"));

    public static SymfonyPhpFrameworkProvider getInstance() {
        return INSTANCE;
    }

    private SymfonyPhpFrameworkProvider() {
        super("Symfony PHP Web Framework", NbBundle.getMessage(SymfonyPhpFrameworkProvider.class, (String)"LBL_FrameworkName"), NbBundle.getMessage(SymfonyPhpFrameworkProvider.class, (String)"LBL_FrameworkDescription"));
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public static FileObject locate(PhpModule phpModule, String relativePath, boolean subdirs) {
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        FileObject fileObject = sourceDirectory.getFileObject(relativePath);
        if (fileObject != null || !subdirs) {
            return fileObject;
        }
        for (FileObject child : sourceDirectory.getChildren()) {
            fileObject = child.getFileObject(relativePath);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public boolean isInPhpModule(PhpModule phpModule) {
        FileObject symfony = SymfonyPhpFrameworkProvider.locate(phpModule, "symfony", false);
        if (symfony != null && symfony.isData()) {
            return true;
        }
        FileObject config = SymfonyPhpFrameworkProvider.locate(phpModule, FILE_CONFIG, true);
        return config != null && config.isData();
    }

    public File[] getConfigurationFiles(PhpModule phpModule) {
        LinkedList<File> files = new LinkedList<File>();
        FileObject appConfig = phpModule.getSourceDirectory().getFileObject("config");
        if (appConfig != null) {
            List<FileObject> fileObjects = this.getConfigFilesRecursively(appConfig);
            Collections.sort(fileObjects, new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    String ext2;
                    boolean phpFile1 = FileUtils.isPhpFile((FileObject)o1);
                    boolean phpFile2 = FileUtils.isPhpFile((FileObject)o2);
                    if (phpFile1 && phpFile2) {
                        return o1.getNameExt().compareTo(o2.getNameExt());
                    }
                    if (phpFile1) {
                        return 1;
                    }
                    if (phpFile2) {
                        return -1;
                    }
                    String ext1 = o1.getExt();
                    if (ext1.equals(ext2 = o2.getExt())) {
                        return o1.getNameExt().compareToIgnoreCase(o2.getNameExt());
                    }
                    return ext1.compareToIgnoreCase(ext2);
                }
            });
            for (FileObject fo : fileObjects) {
                files.add(FileUtil.toFile((FileObject)fo));
            }
        }
        return files.toArray(new File[files.size()]);
    }

    private List<FileObject> getConfigFilesRecursively(FileObject parent) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (FileObject child : parent.getChildren()) {
            if (!VisibilityQuery.getDefault().isVisible(child)) continue;
            if (child.isData() && (CONFIG_FILE_EXTENSIONS.contains(child.getExt().toLowerCase()) || FileUtils.isPhpFile((FileObject)child))) {
                result.add(child);
                continue;
            }
            if (!child.isFolder()) continue;
            result.addAll(this.getConfigFilesRecursively(child));
        }
        return result;
    }

    public PhpModuleExtender createPhpModuleExtender(PhpModule phpModule) {
        return new SymfonyPhpModuleExtender();
    }

    public PhpModuleCustomizerExtender createPhpModuleCustomizerExtender(PhpModule phpModule) {
        return new SymfonyPhpModuleCustomizerExtender(phpModule);
    }

    public PhpModuleProperties getPhpModuleProperties(PhpModule phpModule) {
        FileObject testUnit;
        PhpModuleProperties properties = new PhpModuleProperties();
        FileObject web = SymfonyPhpFrameworkProvider.locate(phpModule, "web", true);
        if (web != null) {
            properties = properties.setWebRoot(web);
        }
        if ((testUnit = SymfonyPhpFrameworkProvider.locate(phpModule, "test/unit", true)) != null) {
            properties = properties.setTests(testUnit);
        }
        return properties;
    }

    public PhpModuleActionsExtender getActionsExtender(PhpModule phpModule) {
        return new SymfonyPhpModuleActionsExtender();
    }

    public PhpModuleIgnoredFilesExtender getIgnoredFilesExtender(PhpModule phpModule) {
        return new SymfonyPhpModuleIgnoredFilesExtender(phpModule);
    }

    public SymfonyCommandSupport getFrameworkCommandSupport(PhpModule phpModule) {
        return new SymfonyCommandSupport(phpModule);
    }

    public EditorExtender getEditorExtender(PhpModule phpModule) {
        return new SymfonyEditorExtender();
    }

    static {
        CONFIG_FILE_EXTENSIONS.add("ini");
        CONFIG_FILE_EXTENSIONS.add("yml");
    }
}

