/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.export.ComponentGroup;
import org.netbeans.modules.mobility.svgcore.export.SVGRasterizerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class SVGImageRasterizerPanel
extends SVGRasterizerPanel {
    private final ComponentGroup m_currentTime;
    private JSlider animationSlider;
    private ButtonGroup buttonGroup1;
    private JLabel compressionLabel;
    private JComboBox compressionLevelCombo;
    private JLabel compressionQualityLabel;
    private JSpinner compressionQualitySpinner;
    private JSpinner currentTimeSpinner;
    private JPanel exportPanel;
    private JComboBox formatComboBox;
    private JScrollPane imageHolder;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox keepRatio;
    private JPanel optionsPanel;
    private JTextField previewFileText;
    private JTextField previewFormatText;
    private JTextField previewSizeText;
    private JCheckBox progressiveCheckBox;
    private JRadioButton radioExportAll;
    private JRadioButton radioExportCurrent;
    private JComboBox reductionCombo;
    private JLabel reductionLabel;
    private JPanel sizePanel;
    private JSpinner spinnerHeight;
    private JSpinner spinnerWidth;
    private JPanel timeLinePanel;
    private JCheckBox transparentCheckBox;

    public SVGImageRasterizerPanel(SVGDataObject dObj, String elementId) throws IOException, BadLocationException {
        super(dObj, elementId);
        this.initComponents();
        this.m_currentTime = this.createTimeGroup(this.currentTimeSpinner, this.animationSlider, true);
        this.createCompressionGroup(this.compressionLevelCombo, this.compressionQualitySpinner);
        this.radioExportAll.setEnabled(this.isInProject() && this.m_elementId == null);
        this.radioExportCurrent.setEnabled(this.isInProject());
        this.m_ratio = this.m_dim.getHeight() / this.m_dim.getWidth();
        this.spinnerHeight.setModel(new SpinnerNumberModel((int)this.m_dim.getHeight(), 1, 2048, 1));
        this.spinnerWidth.setModel(new SpinnerNumberModel((int)this.m_dim.getWidth(), 1, 2048, 1));
        this.spinnerWidth.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SVGImageRasterizerPanel.this.keepRatio.isSelected()) {
                    SVGImageRasterizerPanel.this.spinnerHeight.setValue(new Integer((int)(((Integer)SVGImageRasterizerPanel.this.spinnerWidth.getValue()).doubleValue() * SVGImageRasterizerPanel.this.m_ratio)));
                }
                SVGImageRasterizerPanel.this.updateImage(SVGImageRasterizerPanel.this.spinnerWidth, true);
            }
        });
        this.updateImage(null, true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sizePanel = new JPanel();
        JLabel jLabel11 = new JLabel();
        this.spinnerWidth = new JSpinner();
        JLabel jLabel12 = new JLabel();
        this.spinnerHeight = new JSpinner();
        this.keepRatio = new JCheckBox();
        this.optionsPanel = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.progressiveCheckBox = new JCheckBox();
        this.compressionLabel = new JLabel();
        this.compressionLevelCombo = new JComboBox<AnimationRasterizer.CompressionLevel>(AnimationRasterizer.CompressionLevel.values());
        this.compressionQualityLabel = new JLabel();
        this.transparentCheckBox = new JCheckBox();
        this.compressionQualitySpinner = new JSpinner();
        this.reductionLabel = new JLabel();
        this.reductionCombo = new JComboBox<AnimationRasterizer.ColorReductionMethod>(AnimationRasterizer.ColorReductionMethod.values());
        this.timeLinePanel = new JPanel();
        this.currentTimeSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 30.0, 1.0));
        JLabel startTimeLabel = new JLabel();
        this.animationSlider = new JSlider();
        this.exportPanel = new JPanel();
        this.radioExportCurrent = new JRadioButton();
        this.radioExportAll = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.imageHolder = new JScrollPane();
        this.jPanel4 = new JPanel();
        JLabel previewFormatLabel = new JLabel();
        JLabel previewSizeLabel = new JLabel();
        JLabel previewFileLabel = new JLabel();
        this.previewFormatText = new JTextField();
        this.previewSizeText = new JTextField();
        this.previewFileText = new JTextField();
        this.sizePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageSize")));
        jLabel11.setLabelFor(this.spinnerWidth);
        Mnemonics.setLocalizedText((JLabel)jLabel11, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageWidth"));
        jLabel11.setName("");
        jLabel12.setLabelFor(this.spinnerHeight);
        Mnemonics.setLocalizedText((JLabel)jLabel12, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationImageHeight"));
        this.spinnerHeight.setEnabled(false);
        this.keepRatio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.keepRatio, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationKeepRatio"));
        this.keepRatio.setToolTipText("Images for other configurations are transformed using screen ratio.");
        this.keepRatio.setMargin(new Insets(0, 0, 0, 0));
        this.keepRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.keepRatioActionPerformed(evt);
            }
        });
        GroupLayout sizePanelLayout = new GroupLayout(this.sizePanel);
        this.sizePanel.setLayout(sizePanelLayout);
        sizePanelLayout.setHorizontalGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizePanelLayout.createSequentialGroup().addGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizePanelLayout.createSequentialGroup().addContainerGap().addGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel11).addComponent(jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerHeight, -2, 56, -2).addComponent(this.spinnerWidth, -2, 56, -2))).addGroup(sizePanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.keepRatio))).addContainerGap(180, Short.MAX_VALUE)));
        sizePanelLayout.setVerticalGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizePanelLayout.createSequentialGroup().addGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel11).addComponent(this.spinnerWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sizePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel12).addComponent(this.spinnerHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepRatio)));
        jLabel11.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_name"));
        jLabel11.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_description"));
        this.spinnerWidth.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jSpinner_name"));
        this.spinnerWidth.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jSpinner_descriprion"));
        jLabel12.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_panelHeight_name"));
        jLabel12.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_panelHeight_description"));
        this.spinnerHeight.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_spinnerHeight_name"));
        this.spinnerHeight.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_spinnerHeight_description"));
        this.keepRatio.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_keepRation_name"));
        this.keepRatio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_keepRation_name"));
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ImageOptions")));
        jLabel2.setLabelFor(this.formatComboBox);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsFormat"));
        this.formatComboBox.setModel(SVGImageRasterizerPanel.createImageTypeComboBoxModel());
        this.formatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.formatComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.progressiveCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsProgressive"));
        this.progressiveCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.compressionLabel.setLabelFor(this.compressionLevelCombo);
        Mnemonics.setLocalizedText((JLabel)this.compressionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsQuality"));
        this.compressionQualityLabel.setLabelFor(this.compressionQualitySpinner);
        Mnemonics.setLocalizedText((JLabel)this.compressionQualityLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsRate"));
        Mnemonics.setLocalizedText((AbstractButton)this.transparentCheckBox, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsTransparent"));
        this.transparentCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transparentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.transparencyChanged(evt);
            }
        });
        this.reductionLabel.setLabelFor(this.reductionCombo);
        Mnemonics.setLocalizedText((JLabel)this.reductionLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_OptionsColorReduction"));
        this.reductionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGImageRasterizerPanel.this.colorReductionChanged(evt);
            }
        });
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGap(245, 245, 245).addComponent(this.jPanel1, -1, 64, Short.MAX_VALUE)).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.transparentCheckBox).addContainerGap(186, Short.MAX_VALUE)).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.compressionLabel).addContainerGap(157, Short.MAX_VALUE)).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.reductionCombo, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.reductionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(124, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, optionsPanelLayout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.formatComboBox, 0, 83, Short.MAX_VALUE)).addComponent(this.progressiveCheckBox, GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.compressionLevelCombo, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compressionQualityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.compressionQualitySpinner, -2, 46, -2))).addGap(106, 106, 106)))));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.formatComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressiveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transparentCheckBox).addGap(14, 14, 14).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.reductionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addComponent(this.reductionCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compressionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.compressionQualitySpinner, -2, 25, -2).addComponent(this.compressionLevelCombo, -2, 25, -2).addComponent(this.compressionQualityLabel)).addContainerGap()));
        jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_name"));
        jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_descritpion"));
        this.formatComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_formatComboBox_name"));
        this.formatComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jLabel2_descritpion"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_name"));
        this.progressiveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_progressiveCheckBox_description"));
        this.compressionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLabel_name"));
        this.compressionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLabel_description"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_name"));
        this.compressionLevelCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionLevelCombo_description"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_name"));
        this.compressionQualityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailityLabel_description"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_name"));
        this.transparentCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_transpartenCheckBox_description"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_name"));
        this.compressionQualitySpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_compressionQuailitySpinner_description"));
        this.reductionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionLabel_name"));
        this.reductionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionLabel_descritpion"));
        this.reductionCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionCombo_name"));
        this.reductionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_reductionCombo_description"));
        this.timeLinePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_AnimationFrameTime")));
        startTimeLabel.setLabelFor(this.currentTimeSpinner);
        Mnemonics.setLocalizedText((JLabel)startTimeLabel, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationTime"));
        GroupLayout timeLinePanelLayout = new GroupLayout(this.timeLinePanel);
        this.timeLinePanel.setLayout(timeLinePanelLayout);
        timeLinePanelLayout.setHorizontalGroup(timeLinePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeLinePanelLayout.createSequentialGroup().addContainerGap().addGroup(timeLinePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeLinePanelLayout.createSequentialGroup().addComponent(startTimeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentTimeSpinner, -2, 56, -2)).addComponent(this.animationSlider, -1, 288, Short.MAX_VALUE)).addContainerGap()));
        timeLinePanelLayout.setVerticalGroup(timeLinePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timeLinePanelLayout.createSequentialGroup().addGroup(timeLinePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(startTimeLabel).addComponent(this.currentTimeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.animationSlider, -2, -1, -2)));
        this.currentTimeSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_currentTimeSpinner_name"));
        this.currentTimeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_currentTimeSpinner_description"));
        startTimeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_startTimeLabel_name"));
        startTimeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_stopTimeLabel_description"));
        this.animationSlider.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_animationSlider_name"));
        this.animationSlider.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_animationSlider_description"));
        this.exportPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_ExportLabel")));
        this.buttonGroup1.add(this.radioExportCurrent);
        this.radioExportCurrent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportCurrent, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationOnlyActiveConfiguration"));
        this.radioExportCurrent.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.radioExportAll);
        Mnemonics.setLocalizedText((AbstractButton)this.radioExportAll, (String)NbBundle.getBundle(SVGImageRasterizerPanel.class).getString("LBL_AnimationAllConfigurations"));
        this.radioExportAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout exportPanelLayout = new GroupLayout(this.exportPanel);
        this.exportPanel.setLayout(exportPanelLayout);
        exportPanelLayout.setHorizontalGroup(exportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exportPanelLayout.createSequentialGroup().addContainerGap().addGroup(exportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioExportCurrent).addComponent(this.radioExportAll)).addContainerGap(69, Short.MAX_VALUE)));
        exportPanelLayout.setVerticalGroup(exportPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exportPanelLayout.createSequentialGroup().addComponent(this.radioExportCurrent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.radioExportAll)));
        this.radioExportCurrent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportCurrent_name"));
        this.radioExportCurrent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportCurrent_description"));
        this.radioExportAll.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportAll_name"));
        this.radioExportAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_radioExportAll_description"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewTitle")));
        this.imageHolder.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        previewFormatLabel.setLabelFor(this.previewFormatText);
        Mnemonics.setLocalizedText((JLabel)previewFormatLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFormat"));
        previewSizeLabel.setLabelFor(this.previewSizeText);
        Mnemonics.setLocalizedText((JLabel)previewSizeLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewSize"));
        previewFileLabel.setLabelFor(this.previewFileText);
        Mnemonics.setLocalizedText((JLabel)previewFileLabel, (String)NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"LBL_PreviewFile"));
        this.previewFormatText.setEditable(false);
        this.previewFormatText.setText("JPEG");
        this.previewSizeText.setEditable(false);
        this.previewSizeText.setText("200 KBytes");
        this.previewFileText.setEditable(false);
        this.previewFileText.setText("C:\\Program Files\\about.svg");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(previewFormatLabel).addComponent(previewSizeLabel).addComponent(previewFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewSizeText, -2, 82, -2).addComponent(this.previewFileText, -1, 285, Short.MAX_VALUE).addComponent(this.previewFormatText, -2, 64, -2)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(previewFormatLabel).addComponent(this.previewFormatText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(previewSizeLabel).addComponent(this.previewSizeText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(previewFileLabel).addComponent(this.previewFileText, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        previewFormatLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_name"));
        previewFormatLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_description"));
        previewSizeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_name"));
        previewSizeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_description"));
        previewFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        previewFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        this.previewFormatText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_name"));
        this.previewFormatText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFormatlabel_description"));
        this.previewSizeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_name"));
        this.previewSizeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewSizelabel_description"));
        this.previewFileText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_name"));
        this.previewFileText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_previewFileLabel_description"));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageHolder, GroupLayout.Alignment.TRAILING, -1, 383, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.imageHolder, -1, 349, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        this.jPanel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel4_name"));
        this.jPanel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel4_description"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sizePanel, -1, -1, Short.MAX_VALUE).addComponent(this.timeLinePanel, -1, -1, Short.MAX_VALUE).addComponent(this.exportPanel, -1, -1, Short.MAX_VALUE).addComponent(this.optionsPanel, 0, 322, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.sizePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeLinePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportPanel, -2, -1, -2))).addContainerGap()));
        this.sizePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_name"));
        this.sizePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_sizePanel_description"));
        this.optionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_optionsPanel_name"));
        this.optionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_optionsPanel_description"));
        this.timeLinePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_timeLinePanel_name"));
        this.timeLinePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_timeLinePanel_description"));
        this.exportPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_exportPanel_name"));
        this.exportPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_exportPanel_description"));
        this.jPanel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel3_name"));
        this.jPanel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel3_description"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SVGImageRasterizerPanel.class, (String)"A11Y_jPanel_description"));
    }

    private void colorReductionChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void transparencyChanged(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void formatComboBoxActionPerformed(ActionEvent evt) {
        this.updateImage((JComponent)evt.getSource(), true);
    }

    private void keepRatioActionPerformed(ActionEvent evt) {
        this.spinnerHeight.setEnabled(!this.keepRatio.isSelected());
    }

    @Override
    public int getImageWidth() {
        return this.m_overrideWidth != -1 ? this.m_overrideWidth : (Integer)this.spinnerWidth.getValue();
    }

    @Override
    public int getImageHeight() {
        return this.m_overrideHeight != -1 ? this.m_overrideHeight : (Integer)this.spinnerHeight.getValue();
    }

    @Override
    public boolean isForAllConfigurations() {
        return this.radioExportAll.isSelected();
    }

    @Override
    public float getCompressionQuality() {
        int sliderValue = ((Number)this.compressionQualitySpinner.getValue()).intValue();
        return (float)sliderValue / 100.0f;
    }

    @Override
    public boolean isProgressive() {
        return this.progressiveCheckBox.isSelected();
    }

    @Override
    public boolean isTransparent() {
        return this.transparentCheckBox.isSelected();
    }

    @Override
    public AnimationRasterizer.ImageType getImageType() {
        return (AnimationRasterizer.ImageType)((Object)this.formatComboBox.getSelectedItem());
    }

    @Override
    public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
        return (AnimationRasterizer.ColorReductionMethod)this.reductionCombo.getSelectedItem();
    }

    @Override
    public float getStartTime() {
        return this.m_currentTime.getValue();
    }

    @Override
    public int getNumberFrames() {
        return 1;
    }

    @Override
    public boolean isInSingleImage() {
        return true;
    }

    @Override
    protected String getPreviewFileName() {
        return this.previewFileText.getText();
    }

    @Override
    protected void updateImage(JComponent source, boolean isOutputChanged) {
        final JLabel label = new JLabel("Updating image...");
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        this.imageHolder.setViewportView(label);
        AnimationRasterizer.ImageType imgType = this.getImageType();
        boolean supportsCompression = imgType.supportsCompression();
        this.compressionQualitySpinner.setEnabled(supportsCompression);
        this.compressionLevelCombo.setEnabled(supportsCompression);
        this.compressionLabel.setEnabled(supportsCompression);
        this.compressionQualityLabel.setEnabled(supportsCompression);
        boolean needsColorReduction = imgType.needsColorReduction();
        this.reductionCombo.setEnabled(needsColorReduction);
        this.reductionLabel.setEnabled(needsColorReduction);
        if (imgType.supportsTransparency()) {
            this.transparentCheckBox.setEnabled(true);
        } else {
            this.transparentCheckBox.setEnabled(false);
            this.transparentCheckBox.setSelected(false);
        }
        String filenameRoot = AnimationRasterizer.createFileNameRoot(this.m_dObj, this, null, true);
        final String fileName = AnimationRasterizer.createFileName(filenameRoot, this, -1, -1);
        final float currentTime = this.m_currentTime.getValue();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    SVGImage svgImage = SVGImageRasterizerPanel.this.getSVGImage();
                    if (svgImage != null) {
                        final AnimationRasterizer.PreviewInfo preview = AnimationRasterizer.previewFrame(svgImage, SVGImageRasterizerPanel.this, -1, currentTime);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String sizeText = preview.m_imageSize < 1024 ? preview.m_imageSize + " Bytes" : (double)Math.round((double)preview.m_imageSize / 102.4) / 10.0 + " KBytes";
                                SVGImageRasterizerPanel.this.previewSizeText.setText(sizeText);
                                SVGImageRasterizerPanel.this.previewFormatText.setText(preview.m_imageFormat);
                                SVGImageRasterizerPanel.this.previewFileText.setText(fileName);
                                label.setText(null);
                                label.setIcon(new ImageIcon(preview.m_image));
                                label.invalidate();
                                SVGImageRasterizerPanel.this.imageHolder.validate();
                                SVGImageRasterizerPanel.this.imageHolder.repaint();
                            }
                        });
                    } else {
                        label.setText("Load of SVG image failed");
                        label.setIcon(null);
                        label.invalidate();
                        SVGImageRasterizerPanel.this.imageHolder.validate();
                        SVGImageRasterizerPanel.this.imageHolder.repaint();
                    }
                }
                catch (Exception ex) {
                    SceneManager.log(Level.INFO, ex.getMessage(), ex);
                }
            }
        });
    }
}

