/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeSchemaTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;

public class SqlJetBtreeSchemaTable
extends SqlJetBtreeTable
implements ISqlJetBtreeSchemaTable {
    public SqlJetBtreeSchemaTable(ISqlJetBtree btree, boolean write) throws SqlJetException {
        super(btree, 1, write, false);
    }

    public String getTypeField() throws SqlJetException {
        return this.getString(0);
    }

    public String getNameField() throws SqlJetException {
        return this.getString(1);
    }

    public String getTableField() throws SqlJetException {
        return this.getString(2);
    }

    public int getPageField() throws SqlJetException {
        return (int)this.getInteger(3);
    }

    public String getSqlField() throws SqlJetException {
        return this.getString(4);
    }

    private void doInsertRecord(long rowId, String typeField, String nameField, String tableField, int pageField, String sqlField) throws SqlJetException {
        ISqlJetBtreeRecord record = SqlJetBtreeRecord.getRecord(this.getEncoding(), typeField, nameField, tableField, pageField, sqlField);
        ISqlJetMemoryPointer pData = record.getRawRecord();
        this.insert(null, rowId, pData, pData.remaining(), 0, false);
    }

    public long insertRecord(String typeField, String nameField, String tableField, int pageField, String sqlField) throws SqlJetException {
        long rowId = this.newRowId();
        this.doInsertRecord(rowId, typeField, nameField, tableField, pageField, sqlField);
        return rowId;
    }

    public void updateRecord(long rowId, String typeField, String nameField, String tableField, int pageField, String sqlField) throws SqlJetException {
        this.doInsertRecord(rowId, typeField, nameField, tableField, pageField, sqlField);
    }

    public boolean goToRow(long rowId) throws SqlJetException {
        if (this.getRowId() == rowId) {
            return true;
        }
        int moveTo = this.cursor.moveTo(null, rowId, false);
        if (moveTo < 0) {
            this.next();
        }
        return this.getRowId() == rowId;
    }

    public long getRowId() throws SqlJetException {
        return this.cursor.getKeySize();
    }
}

