/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFriendResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;

public final class CsmProjectContentResolver {
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private final CsmProject project;
    private final CsmFile startFile;
    private final Collection<CsmProject> libs;
    private static final NsContentResultsFilter NS_VARIABLE_FILTER = new NsContentResultsFilter(){

        @Override
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver resolver, CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
            return resolver.getNamespaceVariables(ns, strPrefix, match, searchNested);
        }
    };
    private static final NsContentResultsFilter NS_FUNCTION_FILTER = new NsContentResultsFilter(){

        @Override
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver resolver, CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
            return resolver.getNamespaceFunctions(ns, strPrefix, match, searchNested);
        }
    };
    private static final NsContentResultsFilter NS_CLASS_ENUM_FILTER = new NsContentResultsFilter(){

        @Override
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver resolver, CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
            return resolver.getNamespaceClassesEnums(ns, strPrefix, match, searchNested);
        }
    };
    private static final NsContentResultsFilter NS_ENUMERATOR_FILTER = new NsContentResultsFilter(){

        @Override
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver resolver, CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
            return resolver.getNamespaceEnumerators(ns, strPrefix, match, searchNested);
        }
    };
    private static final NsContentResultsFilter NS_NAMESPACES_FILTER = new NsContentResultsFilter(){

        @Override
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver resolver, CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
            return resolver.getGlobalNamespaces(strPrefix, match);
        }
    };
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private static final int INIT_INHERITANCE_LEVEL = 0;
    private static final int NO_INHERITANCE = 1;
    private static final int EXACT_CLASS = 2;
    private static final int CHILD_INHERITANCE = 3;

    public CsmProjectContentResolver() {
        this(false);
    }

    public CsmProjectContentResolver(boolean caseSensitive) {
        this(caseSensitive, false, false);
    }

    public CsmProjectContentResolver(boolean caseSensitive, boolean naturalSort) {
        this(caseSensitive, true, naturalSort);
    }

    public CsmProjectContentResolver(boolean caseSensitive, boolean needSort, boolean naturalSort) {
        this.caseSensitive = caseSensitive;
        this.naturalSort = naturalSort;
        this.sort = needSort;
        this.libs = null;
        this.project = null;
        this.startFile = null;
    }

    public CsmProjectContentResolver(CsmFile startFile, CsmProject project, boolean caseSensitive, boolean needSort, boolean naturalSort, Collection<CsmProject> libs) {
        this.caseSensitive = caseSensitive;
        this.naturalSort = naturalSort;
        this.sort = needSort;
        this.project = project;
        this.libs = libs;
        this.startFile = startFile;
    }

    public CsmFile getStartFile() {
        return this.startFile;
    }

    private List<CsmEnumerator> getEnumeratorsFromEnumsEnumeratorsAndTypedefs(List enumsEnumeratorsAndTypedefs, boolean match, String strPrefix, boolean sort) {
        ArrayList<CsmEnumerator> res = new ArrayList<CsmEnumerator>();
        if (enumsEnumeratorsAndTypedefs != null) {
            for (CsmObject ob : enumsEnumeratorsAndTypedefs) {
                CsmEnum elemEnum = null;
                if (CsmKindUtilities.isEnumerator((Object)ob)) {
                    CsmEnumerator elem = (CsmEnumerator)ob;
                    if (this.matchName(elem.getName(), strPrefix, match)) {
                        res.add((CsmEnumerator)ob);
                    }
                } else if (CsmKindUtilities.isEnum((CsmObject)ob)) {
                    elemEnum = (CsmEnum)ob;
                } else {
                    CsmType type;
                    assert (CsmKindUtilities.isTypedef((CsmObject)ob));
                    CsmTypedef td = (CsmTypedef)ob;
                    if (td.isTypeUnnamed() && td.getType() != null && CsmKindUtilities.isEnum((CsmObject)(type = td.getType()).getClassifier())) {
                        elemEnum = (CsmEnum)type.getClassifier();
                    }
                }
                if (elemEnum == null) continue;
                for (CsmEnumerator elem : elemEnum.getEnumerators()) {
                    if (!this.matchName(elem.getName(), strPrefix, match)) continue;
                    res.add(elem);
                }
            }
            if (sort && res != null) {
                CsmSortUtilities.sortMembers(res, (boolean)this.isCaseSensitive());
            }
        }
        return res;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean naturalSort) {
        this.naturalSort = naturalSort;
    }

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean sort) {
        this.sort = sort;
    }

    public List<CsmVariable> getGlobalVariables(String strPrefix, boolean match) {
        if (this.project == null) {
            return Collections.emptyList();
        }
        CsmNamespace globNS = this.project.getGlobalNamespace();
        List<CsmVariable> res = this.getNamespaceVariables(globNS, strPrefix, match, false, false);
        if (res != null && this.sort) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmFunction> getGlobalFunctions(String strPrefix, boolean match) {
        if (this.project == null) {
            return Collections.emptyList();
        }
        CsmNamespace globNS = this.project.getGlobalNamespace();
        List<CsmFunction> res = this.getNamespaceFunctions(globNS, strPrefix, match, false, false);
        if (res != null && this.sort) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmNamespace> getGlobalNamespaces(String strPrefix, boolean match) {
        if (this.project == null) {
            return Collections.emptyList();
        }
        CsmNamespace globNS = this.project.getGlobalNamespace();
        List<CsmNamespace> res = this.getNestedNamespaces(globNS, strPrefix, match);
        if (res != null && this.sort) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMacro> getFileLocalMacros(CsmContext context, String strPrefix, boolean match) {
        List<CsmMacro> res = CsmContextUtilities.findFileLocalMacros(context, strPrefix, match, this.isCaseSensitive());
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMacro> getFileIncludedProjectMacros(CsmContext context, String strPrefix, boolean match) {
        List<CsmMacro> res = CsmContextUtilities.findFileIncludedProjectMacros(context, strPrefix, match, this.isCaseSensitive());
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMacro> getFileIncludeLibMacros(CsmContext context, String strPrefix, boolean match) {
        List<CsmMacro> res = CsmContextUtilities.findFileIncludedLibMacros(context, strPrefix, match, this.isCaseSensitive());
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMacro> getProjectMacros(CsmContext context, String strPrefix, boolean match) {
        List<CsmMacro> res = CsmContextUtilities.findProjectMacros(context, strPrefix, match, this.isCaseSensitive());
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMacro> getLibMacros(CsmContext context, String strPrefix, boolean match) {
        List<CsmMacro> res = CsmContextUtilities.findLibMacros(context, strPrefix, match, this.isCaseSensitive());
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public Collection<CsmVariable> getLibVariables(String strPrefix, boolean match) {
        return this.getLibElements(NS_VARIABLE_FILTER, strPrefix, match, this.isSortNeeded(), false);
    }

    public Collection<CsmFunction> getLibFunctions(String strPrefix, boolean match) {
        return this.getLibElements(NS_FUNCTION_FILTER, strPrefix, match, this.isSortNeeded(), false);
    }

    public Collection<CsmClassifier> getLibClassesEnums(String strPrefix, boolean match) {
        return this.getLibElements(NS_CLASS_ENUM_FILTER, strPrefix, match, this.isSortNeeded(), false);
    }

    public Collection<CsmEnumerator> getLibEnumerators(String strPrefix, boolean match, boolean sort) {
        return this.getLibElements(NS_ENUMERATOR_FILTER, strPrefix, match, this.isSortNeeded(), false);
    }

    public Collection<CsmNamespace> getLibNamespaces(String strPrefix, boolean match) {
        return this.getLibElements(NS_NAMESPACES_FILTER, strPrefix, match, this.isSortNeeded(), false);
    }

    private Collection getLibElements(NsContentResultsFilter filter, String strPrefix, boolean match, boolean sort, boolean searchNested) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<CsmProject> handledLibs = new HashSet<CsmProject>();
        handledLibs.add(this.project);
        Map<String, CsmObject> res = new HashMap<String, CsmObject>();
        LinkedHashSet<? extends CsmObject> libElements = new LinkedHashSet<CsmObject>();
        for (CsmProject lib : this.libs) {
            if (handledLibs.contains(lib)) continue;
            handledLibs.add(lib);
            CsmProjectContentResolver libResolver = new CsmProjectContentResolver(this.startFile, lib, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort(), Collections.<CsmProject>emptyList());
            Collection<? extends CsmObject> results = filter.getResults(libResolver, lib.getGlobalNamespace(), strPrefix, match, searchNested);
            if (match) {
                libElements.addAll(results);
                continue;
            }
            res = this.mergeByFQN(res, results);
        }
        Collection<Object> out = match ? libElements : res.values();
        if (res != null && sort) {
            ArrayList sorted = new ArrayList(out);
            CsmSortUtilities.sortMembers(sorted, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
            out = sorted;
        }
        return out;
    }

    public List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext context, String strPrefix, boolean match) {
        List<CsmDeclaration> res = CsmContextUtilities.findFunctionLocalDeclarations(context, strPrefix, match, this.isCaseSensitive());
        if (this.isSortNeeded() && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmEnumerator> getFileLocalEnumerators(CsmContext context, String strPrefix, boolean match) {
        List<CsmEnumerator> res = CsmContextUtilities.findFileLocalEnumerators(context, strPrefix, match, this.isCaseSensitive());
        if (this.isSortNeeded() && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmVariable> getFileLocalVariables(CsmContext context, FileReferencesContext fileReferncesContext, String strPrefix, boolean match, boolean needFileLocalOrDeclFromUnnamedNS) {
        ArrayList<CsmVariable> out = new ArrayList<CsmVariable>();
        if (!context.isEmpty()) {
            Iterator<CsmContext.CsmContextEntry> it = context.iterator();
            while (it.hasNext()) {
                CsmContext.CsmContextEntry elem = it.next();
                if (!CsmKindUtilities.isFile((CsmObject)elem.getScope())) continue;
                CsmFile currentFile = (CsmFile)elem.getScope();
                this.fillFileLocalVariables(strPrefix, match, currentFile, needFileLocalOrDeclFromUnnamedNS, false, out);
                List<CsmVariable> cached = null;
                if (fileReferncesContext != null && !fileReferncesContext.isCleaned() && match) {
                    cached = fileReferncesContext.getFileLocalIncludeVariables(strPrefix);
                }
                if (cached != null) {
                    out.addAll(cached);
                } else {
                    this.fillFileLocalIncludeVariables(strPrefix, match, currentFile, out);
                }
                Iterator<CsmContext.CsmContextEntry> it2 = context.iterator();
                while (it2.hasNext()) {
                    CsmContext.CsmContextEntry elem2 = it2.next();
                    if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)elem2.getScope())) continue;
                    CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)elem2.getScope();
                    this.fillFileLocalIncludeNamespaceVariables(nsd.getNamespace(), strPrefix, match, currentFile, out, needFileLocalOrDeclFromUnnamedNS);
                }
                break block0;
            }
        }
        return out;
    }

    public List<CsmFunction> getFileLocalFunctions(CsmContext context, String strPrefix, boolean match, boolean needDeclFromUnnamedNS) {
        HashMap<CharSequence, CsmFunction> out = new HashMap<CharSequence, CsmFunction>();
        if (!context.isEmpty()) {
            Iterator<CsmContext.CsmContextEntry> it = context.iterator();
            while (it.hasNext()) {
                CsmContext.CsmContextEntry elem = it.next();
                if (!CsmKindUtilities.isFile((CsmObject)elem.getScope())) continue;
                CsmFile currentFile = (CsmFile)elem.getScope();
                this.fillFileLocalFunctions(strPrefix, match, currentFile, needDeclFromUnnamedNS, false, out);
                Iterator<CsmContext.CsmContextEntry> it2 = context.iterator();
                while (it2.hasNext()) {
                    CsmContext.CsmContextEntry elem2 = it2.next();
                    if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)elem2.getScope())) continue;
                    ArrayList<CsmFunction> funs = new ArrayList<CsmFunction>();
                    CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)elem2.getScope();
                    this.fillFileLocalIncludeNamespaceFunctions(nsd.getNamespace(), strPrefix, match, currentFile, funs, needDeclFromUnnamedNS);
                    for (CsmFunction fun : funs) {
                        out.put(fun.getSignature(), fun);
                    }
                }
                break block0;
            }
        }
        return new ArrayList<CsmFunction>(out.values());
    }

    private void fillFileLocalFunctions(String strPrefix, boolean match, CsmFile file, boolean needDeclFromUnnamedNS, boolean fromUnnamedNamespace, Map<CharSequence, CsmFunction> out) {
        CsmDeclaration.Kind[] kinds = needDeclFromUnnamedNS || fromUnnamedNamespace ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, fromUnnamedNamespace || needDeclFromUnnamedNS);
        Iterator it = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)it.next();
            if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                CsmFunction fun = (CsmFunction)decl;
                if (!fromUnnamedNamespace && !CsmBaseUtilities.isFileLocalFunction((CsmFunction)fun) || decl.getName().length() == 0 || !this.matchName(decl.getName(), strPrefix, match)) continue;
                out.put(fun.getSignature(), fun);
                continue;
            }
            if (!needDeclFromUnnamedNS || !CsmKindUtilities.isNamespaceDefinition((CsmObject)decl) || ((CsmNamespaceDefinition)decl).getName().length() != 0) continue;
            this.fillFileLocalFunctions(strPrefix, match, (CsmNamespaceDefinition)decl, needDeclFromUnnamedNS, true, out);
        }
    }

    private void fillFileLocalFunctions(String strPrefix, boolean match, CsmNamespaceDefinition ns, boolean needDeclFromUnnamedNS, boolean fromUnnamedNamespace, Map<CharSequence, CsmFunction> out) {
        CsmDeclaration.Kind[] kinds = fromUnnamedNamespace || needDeclFromUnnamedNS ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, fromUnnamedNamespace || needDeclFromUnnamedNS);
        Iterator it = CsmSelect.getDeclarations((CsmNamespaceDefinition)ns, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)it.next();
            if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                CsmFunction fun = (CsmFunction)decl;
                if (!fromUnnamedNamespace && !CsmBaseUtilities.isFileLocalFunction((CsmFunction)fun) || decl.getName().length() == 0 || !this.matchName(decl.getName(), strPrefix, match)) continue;
                out.put(fun.getSignature(), fun);
                continue;
            }
            if (!needDeclFromUnnamedNS || !CsmKindUtilities.isNamespaceDefinition((CsmObject)decl) || ((CsmNamespaceDefinition)decl).getName().length() != 0) continue;
            this.fillFileLocalFunctions(strPrefix, match, (CsmNamespaceDefinition)decl, needDeclFromUnnamedNS, true, out);
        }
    }

    private void fillFileLocalVariables(String strPrefix, boolean match, CsmFile file, boolean needDeclFromUnnamedNS, boolean fromUnnamedNamespace, Collection<CsmVariable> out) {
        CsmDeclaration.Kind[] kinds = fromUnnamedNamespace || needDeclFromUnnamedNS ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, true);
        Iterator it = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        this.fillFileLocalVariables(strPrefix, match, it, needDeclFromUnnamedNS, fromUnnamedNamespace, true, out);
    }

    private void fillUnionVariables(String strPrefix, boolean match, CsmClass union, Collection<CsmVariable> out) {
        Iterator i = CsmSelect.getClassMembers((CsmClass)union, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)strPrefix, match, this.caseSensitive, true));
        List filtered = CsmSortUtilities.filterList((Iterator)i, (CharSequence)strPrefix, (boolean)match, (boolean)this.caseSensitive);
        out.addAll(filtered);
    }

    private void fillNamespaceVariables(String strPrefix, boolean match, CsmNamespaceDefinition ns, boolean needDeclFromUnnamedNS, boolean fromUnnamedNamespace, Collection<CsmVariable> out) {
        CsmDeclaration.Kind[] kinds = fromUnnamedNamespace || needDeclFromUnnamedNS ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, true);
        Iterator it = CsmSelect.getDeclarations((CsmNamespaceDefinition)ns, (CsmSelect.CsmFilter)filter);
        this.fillFileLocalVariables(strPrefix, match, it, needDeclFromUnnamedNS, fromUnnamedNamespace, false, out);
    }

    private void fillFileLocalVariables(String strPrefix, boolean match, Iterator<CsmOffsetableDeclaration> it, boolean needDeclFromUnnamedNS, boolean fromUnnamedNamespace, boolean anyVariable, Collection<CsmVariable> out) {
        while (it.hasNext()) {
            CsmOffsetableDeclaration decl = it.next();
            if (CsmKindUtilities.isVariable((CsmObject)decl)) {
                CsmClassifier clsfr;
                CharSequence varName = decl.getName();
                if (!fromUnnamedNamespace && !anyVariable && !CsmKindUtilities.isFileLocalVariable((CsmObject)decl)) continue;
                if (varName.length() != 0) {
                    if (!this.matchName(varName, strPrefix, match)) continue;
                    out.add((CsmVariable)decl);
                    continue;
                }
                CsmVariable var = (CsmVariable)decl;
                CsmType type = var.getType();
                if (type == null || (clsfr = type.getClassifier()) == null || !CsmKindUtilities.isUnion((CsmObject)clsfr)) continue;
                this.fillUnionVariables(strPrefix, match, (CsmClass)clsfr, out);
                continue;
            }
            if (!needDeclFromUnnamedNS || !CsmKindUtilities.isNamespaceDefinition((CsmObject)decl) || ((CsmNamespaceDefinition)decl).getName().length() != 0) continue;
            this.fillNamespaceVariables(strPrefix, match, (CsmNamespaceDefinition)decl, needDeclFromUnnamedNS, true, out);
        }
    }

    private void fillFileLocalIncludeVariables(String strPrefix, boolean match, CsmFile file, Collection<CsmVariable> out) {
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, false);
        CsmProjectContentResolver.fillFileLocalVariablesByFilter(filter, file, out);
    }

    public static void fillFileLocalVariablesByFilter(CsmSelect.CsmFilter filter, CsmFile file, Collection<CsmVariable> out) {
        CsmProjectContentResolver.fillFileLocalIncludeVariables(filter, file, out, new HashSet<CsmFile>(), true);
    }

    private static void fillFileLocalIncludeVariables(CsmSelect.CsmFilter filter, CsmFile file, Collection<CsmVariable> out, Set<CsmFile> antiLoop, boolean first) {
        if (antiLoop.contains(file)) {
            return;
        }
        if (first) {
            List includeStack = CsmFileInfoQuery.getDefault().getIncludeStack(file);
            for (CsmInclude include : includeStack) {
                CsmOffsetableDeclaration decl;
                CsmFile srcFile = include.getContainingFile();
                int endOffset = include.getStartOffset();
                Iterator it = CsmSelect.getStaticVariables((CsmFile)srcFile, (CsmSelect.CsmFilter)filter);
                while (it.hasNext() && CsmOffsetUtilities.isAfterObject((CsmObject)(decl = (CsmOffsetableDeclaration)it.next()), endOffset)) {
                    if (!CsmKindUtilities.isFileLocalVariable((CsmObject)decl)) continue;
                    out.add((CsmVariable)decl);
                }
            }
        }
        antiLoop.add(file);
        for (CsmInclude incl : file.getIncludes()) {
            CsmFile f = incl.getIncludeFile();
            if (f == null) continue;
            CsmProjectContentResolver.fillFileLocalIncludeVariables(filter, f, out, antiLoop, false);
        }
        if (!first) {
            Iterator it = CsmSelect.getStaticVariables((CsmFile)file, (CsmSelect.CsmFilter)filter);
            while (it.hasNext()) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)it.next();
                if (!CsmKindUtilities.isFileLocalVariable((CsmObject)decl)) continue;
                out.add((CsmVariable)decl);
            }
        }
    }

    private void fillFileLocalIncludeNamespaceVariables(CsmNamespace ns, String strPrefix, boolean match, CsmFile file, Collection<CsmVariable> out, boolean needDeclFromUnnamedNS) {
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        ArrayList<CsmScopeElement> se = new ArrayList<CsmScopeElement>();
        this.getFileLocalIncludeNamespaceMembers(ns, file, se, needDeclFromUnnamedNS);
        List<CsmVariable> vars = new ArrayList<CsmVariable>();
        this.filterDeclarations(se.iterator(), vars, kinds, strPrefix, match, false);
        vars = this.filterVariables(vars);
        out.addAll(vars);
    }

    private void fillFileLocalIncludeNamespaceFunctions(CsmNamespace ns, String strPrefix, boolean match, CsmFile file, List<CsmFunction> out, boolean needDeclFromUnnamedNS) {
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        ArrayList<CsmScopeElement> se = new ArrayList<CsmScopeElement>();
        this.getFileLocalIncludeNamespaceMembers(ns, file, se, needDeclFromUnnamedNS);
        List<Object> funs = new ArrayList();
        this.filterDeclarations(se.iterator(), funs, kinds, strPrefix, match, false);
        funs = this.filterFunctionDefinitions(funs);
        out.addAll(funs);
    }

    private void getFileLocalIncludeNamespaceMembers(CsmNamespace ns, CsmFile file, Collection<CsmScopeElement> out, boolean needDeclFromUnnamedNS) {
        CsmSelect.CsmFilterBuilder builder = CsmSelect.getFilterBuilder();
        CsmSelect.CsmFilter filter = builder.createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
        Iterator itFile = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        while (itFile.hasNext()) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)itFile.next();
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) continue;
            CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)decl;
            if (nsd.getQualifiedName().equals(ns.getQualifiedName())) {
                out.addAll(nsd.getScopeElements());
            } else if (CharSequenceUtilities.startsWith((CharSequence)ns.getQualifiedName(), (CharSequence)nsd.getQualifiedName())) {
                this.getFileLocalIncludeNamespaceMembersFromNested(ns.getQualifiedName(), nsd, out, needDeclFromUnnamedNS);
            }
            if (!needDeclFromUnnamedNS || !CharSequenceUtilities.startsWith((CharSequence)ns.getQualifiedName(), (CharSequence)nsd.getQualifiedName())) continue;
            this.getFileLocalIncludeNamespaceMembersFromNested("<unnamed>", nsd, out, needDeclFromUnnamedNS);
        }
    }

    private void getFileLocalIncludeNamespaceMembersFromNested(CharSequence nsName, CsmNamespaceDefinition ns, Collection<CsmScopeElement> out, boolean needDeclFromUnnamedNS) {
        for (CsmOffsetableDeclaration decl : ns.getDeclarations()) {
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)decl)) continue;
            CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)decl;
            if (nsd.getQualifiedName().equals(nsName)) {
                out.addAll(nsd.getScopeElements());
            } else if (((Object)nsName).toString().startsWith(((Object)nsd.getQualifiedName()).toString())) {
                this.getFileLocalIncludeNamespaceMembersFromNested(nsName, nsd, out, needDeclFromUnnamedNS);
            }
            if (needDeclFromUnnamedNS && ((Object)nsName).toString().startsWith(((Object)nsd.getQualifiedName()).toString())) {
                this.getFileLocalIncludeNamespaceMembersFromNested("<unnamed>", nsd, out, needDeclFromUnnamedNS);
            }
            if (!needDeclFromUnnamedNS || nsd.getName().length() != 0) continue;
            out.addAll(nsd.getScopeElements());
            this.getFileLocalIncludeNamespaceMembersFromNested(nsName, nsd, out, needDeclFromUnnamedNS);
        }
    }

    public List<CsmVariable> getNamespaceVariables(CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
        return this.getNamespaceVariables(ns, strPrefix, match, this.isSortNeeded(), searchNested);
    }

    private List<CsmVariable> getNamespaceVariables(CsmNamespace ns, String strPrefix, boolean match, boolean sort, boolean searchNested) {
        List<CsmVariable> res = this.getNamespaceMembers(ns, CsmDeclaration.Kind.VARIABLE, strPrefix, match, searchNested, false);
        Collection used = CsmUsingResolver.getDefault().findUsedDeclarations(ns);
        this.filterDeclarations(used.iterator(), (Collection)res, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE}, strPrefix, match, false);
        res = this.filterVariables(res);
        if (sort && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmVariable> getFileLocalNamespaceVariables(CsmNamespace ns, CsmFile file, String strPrefix, boolean match) {
        ArrayList<CsmVariable> out = new ArrayList<CsmVariable>();
        this.fillFileLocalIncludeNamespaceVariables(ns, strPrefix, match, file, out, true);
        if (this.isSortNeeded() && out != null) {
            CsmSortUtilities.sortMembers(out, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return out;
    }

    public List<CsmFunction> getFileLocalNamespaceFunctions(CsmNamespace ns, CsmFile file, String strPrefix, boolean match) {
        ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
        this.fillFileLocalIncludeNamespaceFunctions(ns, strPrefix, match, file, out, true);
        if (this.isSortNeeded() && out != null) {
            CsmSortUtilities.sortMembers(out, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return out;
    }

    public List<CsmFunction> getNamespaceFunctions(CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
        return this.getNamespaceFunctions(ns, strPrefix, match, this.isSortNeeded(), searchNested);
    }

    private List<CsmFunction> getNamespaceFunctions(CsmNamespace ns, String strPrefix, boolean match, boolean sort, boolean searchNested) {
        CsmDeclaration.Kind[] memberKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        List<CsmDeclaration> res = this.getNamespaceMembers(ns, memberKinds, strPrefix, match, searchNested, false);
        Collection used = CsmUsingResolver.getDefault().findUsedDeclarations(ns);
        this.filterDeclarations(used.iterator(), res, memberKinds, strPrefix, match, false);
        res = this.filterFunctionDefinitions(res);
        if (sort && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmNamespaceAlias> getNamespaceAliases(CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
        return this.getNamespaceAliases(ns, strPrefix, match, this.isSortNeeded(), searchNested);
    }

    private List<CsmNamespaceAlias> getNamespaceAliases(CsmNamespace ns, String strPrefix, boolean match, boolean sort, boolean searchNested) {
        List res = this.getNamespaceMembers(ns, CsmDeclaration.Kind.NAMESPACE_ALIAS, strPrefix, match, searchNested, false);
        Collection used = CsmUsingResolver.getDefault().findUsedDeclarations(ns);
        this.filterDeclarations(used.iterator(), (Collection)res, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS}, strPrefix, match, false);
        if (sort && res != null) {
            CsmSortUtilities.sortMembers((List)res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmNamespace> getNestedNamespaces(CsmNamespace ns, String strPrefix, boolean match) {
        Map<CharSequence, CsmNamespace> set = this.getNestedNamespaces(ns, strPrefix, match, new HashSet<CsmNamespace>());
        ArrayList<CsmNamespace> res = set != null && set.size() > 0 ? new ArrayList<CsmNamespace>(set.values()) : new ArrayList<CsmNamespace>();
        if (this.sort && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    private Map<CharSequence, CsmNamespace> getNestedNamespaces(CsmNamespace ns, String strPrefix, boolean match, Set<CsmNamespace> handledNS) {
        handledNS.add(ns);
        LinkedHashMap<CharSequence, CsmNamespace> res = new LinkedHashMap<CharSequence, CsmNamespace>();
        for (CsmProject lib : ns.getProject().getLibraries()) {
            CsmNamespace n = lib.findNamespace(ns.getQualifiedName());
            if (n == null || handledNS.contains(n)) continue;
            res.putAll(this.getNestedNamespaces(n, strPrefix, match, handledNS));
        }
        for (CsmNamespace nestedNs : ns.getNestedNamespaces()) {
            if (nestedNs.getName().length() == 0 || !this.matchName(nestedNs.getName(), strPrefix, match)) continue;
            res.put(nestedNs.getQualifiedName(), nestedNs);
        }
        return res;
    }

    public List<CsmClassifier> getNamespaceClassesEnums(CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
        CsmDeclaration.Kind[] classKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List<CsmDeclaration> res = this.getNamespaceMembers(ns, classKinds, strPrefix, match, searchNested, false);
        Collection used = CsmUsingResolver.getDefault().findUsedDeclarations(ns);
        this.filterDeclarations(used.iterator(), res, classKinds, strPrefix, match, false);
        if (this.isSortNeeded() && res != null) {
            CsmSortUtilities.sortClasses(res, (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmEnumerator> getNamespaceEnumerators(CsmNamespace ns, String strPrefix, boolean match, boolean searchNested) {
        CsmDeclaration.Kind[] classKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List<CsmDeclaration> enumsAndTypedefs = this.getNamespaceMembers(ns, classKinds, "", false, searchNested, true);
        Collection used = CsmUsingResolver.getDefault().findUsedDeclarations(ns);
        CsmDeclaration.Kind[] classAndEnumeratorKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.ENUMERATOR};
        this.filterDeclarations(used.iterator(), enumsAndTypedefs, classAndEnumeratorKinds, "", false, true);
        List<CsmEnumerator> res = this.getEnumeratorsFromEnumsEnumeratorsAndTypedefs(enumsAndTypedefs, match, strPrefix, this.sort);
        return res;
    }

    public List<CsmClassifier> getNestedClassifiers(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses) {
        CsmDeclaration.Kind[] memberKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.ENUM};
        List<CsmMember> res = this.getClassMembers(clazz, contextDeclaration, memberKinds, strPrefix, false, match, inspectParentClasses, inspectOuterClasses, true, false);
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmMethod> getMethods(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean staticOnly, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses, boolean scopeAccessedClassifier) {
        CsmDeclaration.Kind[] memberKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        List<CsmMember> res = this.getClassMembers(clazz, contextDeclaration, memberKinds, strPrefix, staticOnly, match, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier, false);
        if (res != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmClass> getBaseClasses(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean match) {
        assert (clazz != null);
        CsmVisibility minVisibility = contextDeclaration == null ? CsmInheritanceUtilities.MAX_VISIBILITY : CsmInheritanceUtilities.getContextVisibility((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration, (CsmVisibility)CsmVisibility.PUBLIC, (boolean)true);
        Map<CharSequence, CsmClass> set = this.getBaseClasses(clazz, contextDeclaration, strPrefix, match, new AntiLoop(), minVisibility, 0, 15);
        ArrayList<Object> res = set != null && set.size() > 0 ? new ArrayList<CsmClass>(set.values()) : new ArrayList();
        if (CsmSortUtilities.matchName((CharSequence)clazz.getName(), (CharSequence)strPrefix, (boolean)true, (boolean)true)) {
            res.add(0, clazz);
        }
        return res;
    }

    public List<CsmField> getFields(CsmClass clazz, boolean staticOnly) {
        return this.getFields(clazz, (CsmOffsetableDeclaration)clazz, "", staticOnly, false, true, true, false);
    }

    public List<CsmField> getFields(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean staticOnly, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses, boolean scopeAccessedClassifier) {
        List res = this.getClassMembers(clazz, contextDeclaration, CsmDeclaration.Kind.VARIABLE, strPrefix, staticOnly, match, inspectParentClasses, scopeAccessedClassifier, inspectOuterClasses);
        if (this.isSortNeeded() && res != null) {
            CsmSortUtilities.sortMembers((List)res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    public List<CsmEnumerator> getEnumerators(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses, boolean scopeAccessedClassifier) {
        CsmDeclaration.Kind[] classKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List<CsmMember> enumsAndTypedefs = this.getClassMembers(clazz, contextDeclaration, classKinds, "", false, false, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier, true);
        List<CsmEnumerator> res = this.getEnumeratorsFromEnumsEnumeratorsAndTypedefs(enumsAndTypedefs, match, strPrefix, this.sort);
        return res;
    }

    public List<CsmMember> getFieldsAndMethods(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean staticOnly, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses, boolean scopeAccessedClassifier) {
        CsmDeclaration.Kind[] memberKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        List<CsmMember> res = this.getClassMembers(clazz, contextDeclaration, memberKinds, strPrefix, staticOnly, match, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier, false);
        if (this.isSortNeeded() && res != null) {
            CsmSortUtilities.sortMembers(res, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return res;
    }

    private List getClassMembers(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmDeclaration.Kind kind, String strPrefix, boolean staticOnly, boolean match, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean inspectOuterClasses) {
        return this.getClassMembers(clazz, contextDeclaration, new CsmDeclaration.Kind[]{kind}, strPrefix, staticOnly, match, inspectParentClasses, inspectOuterClasses, scopeAccessedClassifier, false);
    }

    private List<CsmMember> getClassMembers(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmDeclaration.Kind[] kinds, String strPrefix, boolean staticOnly, boolean match, boolean inspectParentClasses, boolean inspectOuterClasses, boolean scopeAccessedClassifier, boolean returnUnnamedMembers) {
        CsmVisibility minVisibility;
        assert (clazz != null);
        if (contextDeclaration == null) {
            minVisibility = CsmInheritanceUtilities.MAX_VISIBILITY;
        } else if (scopeAccessedClassifier) {
            minVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration, (CsmVisibility)CsmVisibility.PUBLIC, (boolean)inspectParentClasses);
            if (minVisibility == CsmVisibility.NONE) {
                staticOnly = true;
                minVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration);
            }
        } else {
            minVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration);
        }
        Map<CharSequence, CsmMember> set = this.getClassMembers(clazz, contextDeclaration, kinds, strPrefix, staticOnly, match, new AntiLoop(), minVisibility, 0, inspectParentClasses, inspectOuterClasses, returnUnnamedMembers);
        ArrayList<CsmMember> res = set != null && set.size() > 0 ? new ArrayList<CsmMember>(set.values()) : new ArrayList<CsmMember>();
        return res;
    }

    private Map<CharSequence, CsmMember> getClassMembers(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmDeclaration.Kind[] kinds, String strPrefix, boolean staticOnly, boolean match, AntiLoop handledClasses, CsmVisibility minVisibility, int inheritanceLevel, boolean inspectParentClasses, boolean inspectOuterClasses, boolean returnUnnamedMembers) {
        assert (clazz != null);
        if (handledClasses.contains((CsmClassifier)clazz)) {
            return Collections.emptyMap();
        }
        if (minVisibility == CsmVisibility.NONE) {
            return Collections.emptyMap();
        }
        VisibilityInfo visibilityInfo = this.getContextVisibility(clazz, contextDeclaration, minVisibility, inheritanceLevel);
        minVisibility = visibilityInfo.visibility;
        inheritanceLevel = visibilityInfo.inheritanceLevel;
        boolean friend = visibilityInfo.friend;
        Map<CharSequence, CsmMember> res = new LinkedHashMap<CharSequence, CsmMember>();
        CsmSelect.CsmFilter memberFilter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, returnUnnamedMembers);
        ArrayList<CsmClass> classesAskedForMembers = new ArrayList<CsmClass>(1);
        classesAskedForMembers.add(clazz);
        if (inspectOuterClasses) {
            CharSequence[] nameParts;
            CsmScope outerScope = clazz.getScope();
            while (CsmKindUtilities.isClass((CsmObject)outerScope)) {
                if (!handledClasses.contains((CsmClassifier)((CsmClass)outerScope))) {
                    classesAskedForMembers.add((CsmClass)outerScope);
                }
                outerScope = ((CsmClass)outerScope).getScope();
            }
            CsmProject classProject = clazz.getContainingFile().getProject();
            if (classProject != null && (nameParts = CsmProjectContentResolver.splitQualifiedName(((Object)clazz.getQualifiedName()).toString())).length > 1) {
                StringBuilder className = new StringBuilder("");
                for (CharSequence charSequence : nameParts) {
                    className.append(charSequence);
                    for (CsmClassifier cls : classProject.findClassifiers((CharSequence)className)) {
                        if (!CsmKindUtilities.isClass((CsmObject)cls)) continue;
                        classesAskedForMembers.add((CsmClass)cls);
                    }
                }
            }
        }
        for (CsmClass csmClass : classesAskedForMembers) {
            handledClasses.add((CsmClassifier)csmClass);
            Iterator it = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)memberFilter);
            int unnamedEnumCount = 0;
            while (it.hasNext()) {
                CharSequence qname;
                CharSequence memberName;
                CsmMember member = (CsmMember)it.next();
                if (!CsmProjectContentResolver.isKindOf(member.getKind(), kinds) || staticOnly && !member.isStatic() || !this.matchVisibility(member, minVisibility) || !this.matchName(memberName = member.getName(), strPrefix, match) && (memberName.length() != 0 || !returnUnnamedMembers)) continue;
                if (CsmKindUtilities.isFunction((CsmObject)member)) {
                    qname = ((CsmFunction)member).getSignature();
                } else {
                    qname = member.getQualifiedName();
                    if (member.getName().length() == 0 && CsmKindUtilities.isEnum((CsmObject)member)) {
                        qname = CharSequences.create((CharSequence)new StringBuilder(qname).append('$').append(++unnamedEnumCount));
                    }
                }
                if (res.containsKey(qname)) continue;
                res.put(qname, member);
            }
            CsmDeclaration.Kind[] memberKinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS};
            CsmSelect.CsmFilter nestedClassifierFilter = CsmContextUtilities.createFilter(memberKinds, "*", true, false, true);
            it = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)nestedClassifierFilter);
            while (it.hasNext()) {
                Map<CharSequence, CsmMember> set;
                CsmClass innerClass;
                CsmMember member = (CsmMember)it.next();
                CharSequence memberName = member.getName();
                if (memberName.length() != 0 || !CsmProjectContentResolver.isKindOf(member.getKind(), memberKinds) || !this.matchVisibility(member, minVisibility) || !(innerClass = (CsmClass)member).getEnclosingVariables().isEmpty() || (set = this.getClassMembers(innerClass, contextDeclaration, kinds, strPrefix, staticOnly, match, handledClasses, CsmVisibility.PUBLIC, 0, inspectParentClasses, inspectOuterClasses, returnUnnamedMembers)) == null || set.size() <= 0) continue;
                set.putAll(res);
                res = set;
            }
            CsmDeclaration.Kind[] usingKind = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION};
            CsmSelect.CsmFilter usingFilter = CsmSelect.getFilterBuilder().createKindFilter(usingKind);
            it = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)usingFilter);
            while (it.hasNext()) {
                CharSequence qname;
                CharSequence memberName;
                VisibilityInfo vInfo;
                CsmUsingDeclaration using;
                CsmDeclaration decl;
                CsmMember member = (CsmMember)it.next();
                if (!CsmProjectContentResolver.isKindOf(member.getKind(), usingKind) || !this.matchVisibility(member, minVisibility) || !CsmKindUtilities.isClassMember((CsmObject)(decl = (using = (CsmUsingDeclaration)member).getReferencedDeclaration())) || !this.matchVisibility((CsmMember)decl, (vInfo = this.getContextVisibility(((CsmMember)decl).getContainingClass(), (CsmOffsetableDeclaration)member, CsmVisibility.PROTECTED, 0)).visibility) || !CsmProjectContentResolver.isKindOf(decl.getKind(), kinds) || !this.matchName(memberName = decl.getName(), strPrefix, match) && (memberName.length() != 0 || !returnUnnamedMembers) || res.containsKey(qname = CsmKindUtilities.isFunction((CsmObject)decl) ? ((CsmFunction)decl).getSignature() : decl.getQualifiedName())) continue;
                res.put(qname, (CsmMember)decl);
            }
            if (!inspectParentClasses) continue;
            for (CsmInheritance inherit : csmClass.getBaseClasses()) {
                int nextInheritanceLevel;
                VisibilityInfo nextInfo;
                CsmVisibility nextMinVisibility;
                Map<CharSequence, CsmMember> baseRes;
                CsmClass baseClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inherit);
                if (baseClass == null || (baseRes = this.getClassMembers(baseClass, contextDeclaration, kinds, strPrefix, staticOnly, match, handledClasses, nextMinVisibility = (nextInfo = this.getNextInheritanceInfo(minVisibility, inherit, inheritanceLevel, friend)).visibility, nextInheritanceLevel = nextInfo.inheritanceLevel, inspectParentClasses, inspectOuterClasses, returnUnnamedMembers)) == null || baseRes.isEmpty()) continue;
                for (Map.Entry<CharSequence, CsmMember> entry : baseRes.entrySet()) {
                    if (res.containsKey(entry.getKey())) continue;
                    res.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return res;
    }

    private Map<CharSequence, CsmClass> getBaseClasses(CsmClass csmClass, CsmOffsetableDeclaration contextDeclaration, String strPrefix, boolean match, AntiLoop handledClasses, CsmVisibility minVisibility, int inheritanceLevel, int level) {
        assert (csmClass != null);
        if (handledClasses.contains((CsmClassifier)csmClass)) {
            return new HashMap<CharSequence, CsmClass>();
        }
        if (minVisibility == CsmVisibility.NONE) {
            return new HashMap<CharSequence, CsmClass>();
        }
        VisibilityInfo visibilityInfo = this.getContextVisibility(csmClass, contextDeclaration, minVisibility, inheritanceLevel);
        minVisibility = visibilityInfo.visibility;
        inheritanceLevel = visibilityInfo.inheritanceLevel;
        boolean friend = visibilityInfo.friend;
        Map<CharSequence, CsmClass> res = new HashMap<CharSequence, CsmClass>();
        for (CsmInheritance inherit : csmClass.getBaseClasses()) {
            CsmClass baseClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inherit);
            if (baseClass == null) continue;
            if (!baseClass.equals(csmClass) && level != 0) {
                VisibilityInfo nextInfo = this.getNextInheritanceInfo(minVisibility, inherit, inheritanceLevel, friend);
                CsmVisibility nextMinVisibility = nextInfo.visibility;
                int nextInheritanceLevel = nextInfo.inheritanceLevel;
                if (nextMinVisibility == CsmVisibility.NONE) continue;
                Map<CharSequence, CsmClass> baseRes = this.getBaseClasses(baseClass, contextDeclaration, strPrefix, match, handledClasses, nextMinVisibility, nextInheritanceLevel, level - 1);
                if (this.matchName(baseClass.getName(), strPrefix, match)) {
                    baseRes.put(baseClass.getQualifiedName(), baseClass);
                }
                baseRes.putAll(res);
                res = baseRes;
                continue;
            }
            CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + csmClass.getContainingFile() + " class " + csmClass));
        }
        return res;
    }

    private List getNamespaceMembers(CsmNamespace ns, CsmDeclaration.Kind kind, String strPrefix, boolean match, boolean searchNested, boolean returnUnnamedMembers) {
        return this.getNamespaceMembers(ns, new CsmDeclaration.Kind[]{kind}, strPrefix, match, searchNested, returnUnnamedMembers);
    }

    private List<CsmDeclaration> getNamespaceMembers(CsmNamespace ns, CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, boolean searchNested, boolean returnUnnamedMembers) {
        List<CsmDeclaration> res = this.getNamespaceMembers(ns, kinds, strPrefix, match, new HashSet<CsmNamespace>(), searchNested, returnUnnamedMembers);
        return res;
    }

    private List<CsmDeclaration> getNamespaceMembers(CsmNamespace ns, CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, Set<CsmNamespace> handledNS, boolean searchNested, boolean returnUnnamedMembers) {
        if (handledNS.contains(ns)) {
            return Collections.emptyList();
        }
        handledNS.add(ns);
        ArrayList<CsmDeclaration> res = new ArrayList<CsmDeclaration>();
        this.filterDeclarations(ns, res, kinds, strPrefix, match, returnUnnamedMembers);
        if (!ns.isGlobal()) {
            for (CsmProject lib : ns.getProject().getLibraries()) {
                CsmNamespace n = lib.findNamespace(ns.getQualifiedName());
                if (n == null || handledNS.contains(n)) continue;
                this.filterDeclarations(n, res, kinds, strPrefix, match, returnUnnamedMembers);
                handledNS.add(n);
            }
        }
        if (searchNested) {
            for (CsmNamespace nestedNs : ns.getNestedNamespaces()) {
                res.addAll(this.getNamespaceMembers(nestedNs, kinds, strPrefix, match, handledNS, true, returnUnnamedMembers));
            }
        }
        return res;
    }

    void filterDeclarations(CsmNamespace ns, Collection out, CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, boolean returnUnnamedMembers) {
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, strPrefix, match, this.caseSensitive, returnUnnamedMembers);
        Iterator it = CsmSelect.getDeclarations((CsmNamespace)ns, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CharSequence name;
            CsmDeclaration decl = (CsmDeclaration)it.next();
            if (!CsmProjectContentResolver.isKindOf(decl.getKind(), kinds) || !this.matchName(name = decl.getName(), strPrefix, match) && (name.length() != 0 || !returnUnnamedMembers)) continue;
            out.add(decl);
        }
    }

    void filterDeclarations(Iterator in, Collection out, CsmDeclaration.Kind[] kinds, String strPrefix, boolean match, boolean returnUnnamedMembers) {
        while (in.hasNext()) {
            CharSequence name;
            CsmDeclaration decl = (CsmDeclaration)in.next();
            if (!CsmProjectContentResolver.isKindOf(decl.getKind(), kinds) || !this.matchName(name = decl.getName(), strPrefix, match) && (name.length() != 0 || !returnUnnamedMembers)) continue;
            out.add(decl);
        }
    }

    private static boolean isKindOf(CsmDeclaration.Kind kind, CsmDeclaration.Kind[] kinds) {
        for (int i = 0; i < kinds.length; ++i) {
            if (kind != kinds[i]) continue;
            return true;
        }
        return false;
    }

    private boolean matchName(CharSequence name, String strPrefix, boolean match) {
        return CsmSortUtilities.matchName((CharSequence)name, (CharSequence)strPrefix, (boolean)match, (boolean)this.caseSensitive);
    }

    public boolean matchVisibility(CsmMember member, CsmVisibility minVisibility) {
        return CsmInheritanceUtilities.matchVisibility((CsmMember)member, (CsmVisibility)minVisibility);
    }

    private Map<String, CsmObject> mergeByFQN(Map<String, CsmObject> orig, Collection<? extends CsmObject> newList) {
        assert (orig != null);
        if (newList != null && newList.size() > 0) {
            for (CsmObject csmObject : newList) {
                assert (CsmKindUtilities.isQualified((CsmObject)csmObject));
                String fqn = ((Object)((CsmQualifiedNamedElement)csmObject).getQualifiedName()).toString();
                orig.put(fqn, csmObject);
            }
        }
        return orig;
    }

    private <T> Collection<T> merge(Collection<T> orig, Collection<T> newList) {
        return CsmUtilities.merge(orig, newList);
    }

    private List<CsmFunction> filterFunctionDefinitions(List funs) {
        ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
        if (funs != null && funs.size() > 0) {
            for (CsmObject fun : funs) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)fun) && ((CsmFunctionDefinition)fun).getDeclaration() != fun) continue;
                out.add((CsmFunction)fun);
            }
        }
        return out;
    }

    private List<CsmVariable> filterVariables(List<CsmVariable> res) {
        HashMap<String, CsmVariable> out = new HashMap<String, CsmVariable>(res.size());
        for (CsmVariable var : res) {
            String fqn = ((Object)var.getQualifiedName()).toString();
            CsmVariable old = (CsmVariable)out.get(fqn);
            if (old != null && CsmKindUtilities.isExternVariable((CsmDeclaration)var)) continue;
            out.put(fqn, var);
        }
        return new ArrayList<CsmVariable>(out.values());
    }

    private VisibilityInfo getContextVisibility(CsmClass clazz, CsmOffsetableDeclaration contextDeclaration, CsmVisibility minVisibility, int inheritanceLevel) {
        boolean friend = false;
        if (inheritanceLevel == 0) {
            inheritanceLevel = 1;
            CsmClass contextClass = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)contextDeclaration);
            if (clazz.equals(contextClass)) {
                inheritanceLevel = 2;
            } else if (contextClass != null) {
                while (contextClass != null) {
                    CsmScope nextScope;
                    if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)contextClass, (CsmClass)clazz)) {
                        inheritanceLevel = 3;
                    }
                    if ((nextScope = contextClass.getScope()) == null || !CsmKindUtilities.isClass((CsmObject)nextScope) || contextClass.equals((CsmClass)nextScope)) break;
                    contextClass = (CsmClass)nextScope;
                }
            }
            if (inheritanceLevel == 1 && contextDeclaration != null) {
                friend = CsmFriendResolver.getDefault().isFriend(contextDeclaration, clazz);
            }
        } else if (contextDeclaration != null) {
            CsmInheritanceUtilities.ContextVisibilityInfo cvi = CsmInheritanceUtilities.getContextVisibilityInfo((CsmClass)clazz, (CsmOffsetableDeclaration)contextDeclaration, (CsmVisibility)minVisibility, (inheritanceLevel == 3 ? 1 : 0) != 0);
            minVisibility = cvi.visibility;
            friend = cvi.friend;
        }
        return new VisibilityInfo(inheritanceLevel, minVisibility, friend);
    }

    private VisibilityInfo getNextInheritanceInfo(CsmVisibility curMinVisibility, CsmInheritance inherit, int curInheritanceLevel, boolean friend) {
        CsmVisibility nextMinVisibility;
        int nextInheritanceLevel = curInheritanceLevel;
        if (curInheritanceLevel == 1) {
            if (friend) {
                nextMinVisibility = CsmInheritanceUtilities.mergeInheritedVisibility((CsmVisibility)curMinVisibility, (CsmVisibility)inherit.getVisibility());
                nextInheritanceLevel = 3;
            } else {
                nextMinVisibility = CsmInheritanceUtilities.mergeExtInheritedVisibility((CsmVisibility)curMinVisibility, (CsmVisibility)inherit.getVisibility());
                nextInheritanceLevel = 1;
            }
        } else if (curInheritanceLevel == 2) {
            nextMinVisibility = CsmInheritanceUtilities.mergeInheritedVisibility((CsmVisibility)curMinVisibility, (CsmVisibility)inherit.getVisibility());
            nextInheritanceLevel = 3;
        } else {
            assert (curInheritanceLevel == 3);
            nextMinVisibility = CsmInheritanceUtilities.mergeChildInheritanceVisibility((CsmVisibility)curMinVisibility, (CsmVisibility)inherit.getVisibility());
            nextInheritanceLevel = 3;
        }
        return new VisibilityInfo(nextInheritanceLevel, nextMinVisibility, false);
    }

    public static CharSequence[] splitQualifiedName(String qualified) {
        ArrayList<String> v = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(qualified, ": \t\n\r\f", false);
        while (t.hasMoreTokens()) {
            v.add(t.nextToken());
        }
        return v.toArray(new CharSequence[v.size()]);
    }

    private static final class VisibilityInfo {
        private final int inheritanceLevel;
        private final CsmVisibility visibility;
        private final boolean friend;

        public VisibilityInfo(int inheritanceLevel, CsmVisibility visibility, boolean friend) {
            this.inheritanceLevel = inheritanceLevel;
            this.visibility = visibility;
            this.friend = friend;
        }

        public String toString() {
            return "inheritanceLevel=" + this.inheritanceLevel + ", visibility=" + this.visibility + ", friend=" + this.friend;
        }
    }

    private static interface NsContentResultsFilter {
        public Collection<? extends CsmObject> getResults(CsmProjectContentResolver var1, CsmNamespace var2, String var3, boolean var4, boolean var5);
    }
}

