/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.debug.util.JspNameUtil;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.text.NbDocument;

public class Utils {
    private static Logger err = Logger.getLogger("org.netbeans.modules.web.debug");
    private static final boolean LOG = err.isLoggable(Level.FINE);

    public static Logger getEM() {
        return err;
    }

    public static void log(String msg) {
        if (LOG) {
            err.log(Level.FINE, msg);
        }
    }

    public static FileObject getFileObjectFromUrl(String url) {
        FileObject fo = null;
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fo;
    }

    public static boolean isJsp(FileObject fo) {
        return fo != null && "text/x-jsp".equals(fo.getMIMEType());
    }

    public static boolean isJsp(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        return Utils.isJsp(fo);
    }

    public static boolean isTag(FileObject fo) {
        return fo != null && "text/x-tag".equals(fo.getMIMEType());
    }

    public static boolean isTag(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        return Utils.isTag(fo);
    }

    public static String getTargetServerID(FileObject fo) {
        J2eeModuleProvider mp;
        Project p;
        if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null && (mp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            String serverID = mp.getServerID();
            return serverID;
        }
        return null;
    }

    public static String getJspName(String url) {
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo != null) {
            return fo.getNameExt();
        }
        return url == null ? null : url.toString();
    }

    public static String getJspPath(String url) {
        JSPServletFinder finder;
        String translated;
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo == null) {
            return null;
        }
        String jspRelativePath = url;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null) {
            jspRelativePath = FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)fo);
        }
        if ((translated = (finder = JSPServletFinder.findJSPServletFinder((FileObject)fo)).getServletSourcePath(jspRelativePath)) != null) {
            return translated;
        }
        return jspRelativePath;
    }

    public static String getServletClass(String url) {
        String jspRelativePath;
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo == null) {
            return null;
        }
        JSPServletFinder finder = JSPServletFinder.findJSPServletFinder((FileObject)fo);
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm == null) {
            return null;
        }
        FileObject docBase = wm.getDocumentBase();
        if (docBase != null) {
            jspRelativePath = FileUtil.getRelativePath((FileObject)docBase, (FileObject)fo);
            if (jspRelativePath == null) {
                return null;
            }
        } else {
            jspRelativePath = fo.getPath();
        }
        String contextPath = wm.getContextPath();
        String servletPath = finder.getServletResourcePath(jspRelativePath);
        if (servletPath == null) {
            servletPath = JspNameUtil.getServletResourcePath(finder, contextPath, jspRelativePath);
        }
        if (servletPath != null) {
            servletPath = servletPath.substring(0, servletPath.length() - 5);
            servletPath = servletPath.replace('/', '.');
        }
        Utils.log("servlet class: " + servletPath);
        return servletPath;
    }

    public static String getClassFilter(String url) {
        int lastDot;
        FileObject fo = Utils.getFileObjectFromUrl(url);
        if (fo == null) {
            return null;
        }
        JSPServletFinder finder = JSPServletFinder.findJSPServletFinder((FileObject)fo);
        String filter = Utils.getServletClass(url);
        if (filter != null && (lastDot = filter.lastIndexOf(46)) > 0) {
            filter = filter.substring(0, lastDot) + ".*";
            String basePackageName = finder.getServletBasePackageName();
            if (basePackageName == null) {
                basePackageName = "org.apache.jsp";
            }
            if (filter.startsWith(basePackageName)) {
                filter = basePackageName + ".*";
            }
        }
        return filter;
    }

    public static String getContextPath(String url) {
        FileObject wmfo = Utils.getFileObjectFromUrl(url);
        if (wmfo == null) {
            return null;
        }
        WebModule wm = WebModule.getWebModule((FileObject)wmfo);
        if (wm != null) {
            return wm.getContextPath();
        }
        return null;
    }

    public static String getJavaIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static boolean isScriptlet(StyledDocument doc, JEditorPane ep, int offset) {
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            while (line > 0) {
                int lineLen;
                Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
                if (lineElem == null) continue;
                int lineStartOffset = lineElem.getStartOffset();
                String t = doc.getText(lineStartOffset, lineLen = lineElem.getEndOffset() - lineStartOffset);
                if (t != null && t.length() > 1) {
                    for (int identStart = line == NbDocument.findLineNumber((StyledDocument)doc, (int)offset) ? col : lineLen - 1; identStart > 0; --identStart) {
                        if (t.charAt(identStart) == '%' && t.charAt(identStart - 1) == '<') {
                            return true;
                        }
                        if (t.charAt(identStart) != '>' || t.charAt(identStart - 1) != '%') continue;
                        return false;
                    }
                }
                --line;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return false;
    }

    public static String getELIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            if (t.startsWith("$") && t.endsWith("}")) {
                return t;
            }
            return null;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && t.charAt(identStart) != '$'; --identStart) {
            }
            if (identStart > 0 && t.charAt(identStart) == '$' && t.charAt(identStart - 1) == '\\') {
                return null;
            }
            for (identEnd = col; identEnd < lineLen && identEnd > 0 && identEnd <= t.length() && t.charAt(identEnd - 1) != '}'; ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String outp = t.substring(identStart, identEnd);
            if (outp.startsWith("$") && outp.endsWith("}")) {
                return outp;
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public static String getJavaIdentifier() {
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return null;
        }
        return Utils.getJavaIdentifier((StyledDocument)ep.getDocument(), ep, ep.getCaret().getDot());
    }

    public static boolean isScriptlet() {
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return false;
        }
        return Utils.isScriptlet((StyledDocument)ep.getDocument(), ep, ep.getCaret().getDot());
    }
}

