/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.providers;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;

public class TargetPlatform {
    private static List supportedPlatforms = null;
    private String version;
    private String displayName;
    private String javaHome;
    private boolean defaultFlag;
    private boolean validFlag;

    public TargetPlatform(JavaPlatform platform) {
        this(platform, false);
    }

    public TargetPlatform(JavaPlatform platform, boolean setDefault) {
        this.defaultFlag = setDefault;
        try {
            String javaExe = platform.getPlatformJavaFile();
            this.displayName = platform.getDisplayName();
            this.version = platform.getVersion();
            this.javaHome = new File(javaExe).getParentFile().getParent();
            this.validFlag = true;
        }
        catch (Exception e) {
            this.validFlag = false;
        }
    }

    public static final List getPlatformList(boolean caching) {
        List platforms = TargetPlatform.getSupportedPlatforms(caching);
        return platforms;
    }

    public static final List getPlatformList(TargetPlatformFilter filter, boolean caching) {
        List platformList = TargetPlatform.getSupportedPlatforms(caching);
        Vector<TargetPlatform> newList = new Vector<TargetPlatform>();
        for (TargetPlatform platform : platformList) {
            if (!filter.isSupported(platform)) continue;
            newList.add(platform);
        }
        return newList;
    }

    public static void refresh() {
        TargetPlatform.getSupportedPlatforms(false);
    }

    public TargetPlatformEnum getAsEnum() {
        if (this.version.startsWith("1.5") || this.version.startsWith("5")) {
            return TargetPlatformEnum.JDK5;
        }
        if (this.version.startsWith("1.6") || this.version.startsWith("6")) {
            return TargetPlatformEnum.JDK6;
        }
        if (this.version.startsWith("1.7") || this.version.startsWith("7")) {
            return TargetPlatformEnum.JDK7;
        }
        return TargetPlatformEnum.JDK5;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public String getHomePath() {
        return this.javaHome;
    }

    public String getName() {
        return this.getAsEnum().toString();
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public boolean equals(Object otherPlatform) {
        if (this.getHomePath() == null || otherPlatform == null) {
            return false;
        }
        if (otherPlatform instanceof String) {
            return this.getHomePath().equals(otherPlatform) || this.toString().equals(otherPlatform);
        }
        if (!(otherPlatform instanceof TargetPlatform)) {
            return false;
        }
        return this.getHomePath().equals(((TargetPlatform)otherPlatform).getHomePath());
    }

    public int hashCode() {
        return this.getHomePath().hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    private static List getSupportedPlatforms(boolean cached) {
        if (supportedPlatforms == null || !cached) {
            supportedPlatforms = new LinkedList();
            try {
                JavaPlatform defaultPlatform = JavaPlatform.getDefaultPlatform();
                if (defaultPlatform != null) {
                    supportedPlatforms.add(new TargetPlatform(defaultPlatform, true));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List platforms = JavaPlatform.getPlatforms();
            for (JavaPlatform jp : platforms) {
                TargetPlatform platform = new TargetPlatform(jp);
                if (!platform.isValid() || supportedPlatforms.contains(platform)) continue;
                supportedPlatforms.add(platform);
            }
        }
        return supportedPlatforms;
    }

    public static interface TargetPlatformFilter {
        public boolean isSupported(TargetPlatform var1);
    }
}

