/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerModule;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.actions.ProfilingSupport;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class NBProfileDirectTask
extends Task {
    private static final String CALIBRATION_FAILED_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_CalibrationFailedMessage");
    private static final int INTERACTIVE_AUTO = 0;
    private static final int INTERACTIVE_YES = 1;
    private static final int INTERACTIVE_NO = 2;
    private static final String DEFAULT_AGENT_JVMARGS_PROPERTY = "profiler.info.jvmargs.agent";
    private static final String DEFAULT_JVM_PROPERTY = "profiler.info.jvm";
    private static final String EXTRA_JVM_ARGS = "profiler.info.jvmargs";
    private static final String EXTRA_RUN_ARGS = "run.args.extra";
    private Path classpath = null;
    private Path rootsPath = null;
    private String jvmArgsPrefix = "";
    private String jvmArgsProperty = "profiler.info.jvmargs.agent";
    private String jvmProperty = "profiler.info.jvm";
    private String mainClass = null;
    private int interactive = 0;

    public void setInteractive(YesNoAuto arg) {
        String value = arg.getValue();
        if (value.equals("auto")) {
            this.interactive = 0;
        } else if (value.equals("yes") || value.equals("true")) {
            this.interactive = 1;
        } else if (value.equals("no") || value.equals("false")) {
            this.interactive = 2;
        }
    }

    public void setJvmArgsPrefix(String value) {
        this.jvmArgsPrefix = value;
    }

    public void setJvmArgsProperty(String value) {
        this.jvmArgsProperty = value;
    }

    public void setJvmProperty(String value) {
        this.jvmProperty = value;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addRootspath(Path path) {
        if (this.rootsPath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.rootsPath = path;
    }

    public void execute() throws BuildException {
        org.apache.tools.ant.Project antProject = this.getProject();
        Hashtable props = antProject.getProperties();
        ProfilingSettings ps = new ProfilingSettings();
        SessionSettings ss = new SessionSettings();
        String projectDir = (String)props.get("profiler.info.project.dir");
        String singleFile = (String)props.get("profiler.info.single.file");
        boolean initializedInteractively = false;
        if ((props.get(DEFAULT_AGENT_JVMARGS_PROPERTY) == null || this.interactive == 1) && this.interactive != 2) {
            projectDir = this.initializeInteractively(ps, ss);
            initializedInteractively = true;
        }
        if (!initializedInteractively) {
            if (props.get(DEFAULT_AGENT_JVMARGS_PROPERTY) == null) {
                throw new BuildException("Missing context for nbprofiledirect task.\nPlease set the \"interactive\" attribute to \"true\" or set the required properties.");
            }
            if (!DEFAULT_AGENT_JVMARGS_PROPERTY.equals(this.jvmArgsProperty) || !"".equals(this.jvmArgsPrefix)) {
                String args = " " + (String)props.get(EXTRA_JVM_ARGS);
                args = args.replaceAll("\\s+(\\-)", " -J$1");
                String origArgs = antProject.getProperty(EXTRA_RUN_ARGS);
                origArgs = origArgs != null ? " " + origArgs + " " : "";
                antProject.setProperty(EXTRA_RUN_ARGS, origArgs + args);
                String usedAgentJvmArgs = this.jvmArgsPrefix + props.get(DEFAULT_AGENT_JVMARGS_PROPERTY);
                antProject.setProperty(this.jvmArgsProperty, usedAgentJvmArgs);
                antProject.log("Profiler agent JVM arguments: " + usedAgentJvmArgs, 3);
                antProject.log("Profiler agent JVM arguments stored in property " + this.jvmArgsProperty, 2);
                antProject.log("Extra JVM arguments: " + antProject.getProperty(EXTRA_RUN_ARGS));
            }
            ps.load((Map)props);
            try {
                ss.load((Map)props);
            }
            catch (IllegalArgumentException e) {
                ProfilerDialogs.displayWarning((String)e.getLocalizedMessage());
            }
            String projectWorkDir = (String)props.get("work.dir");
            ss.setWorkingDir(projectWorkDir != null && !"".equals(projectWorkDir.trim()) ? projectWorkDir : System.getProperty("user.dir"));
        }
        String profilerInfoDir = (String)props.get("profiler.info.dir");
        if (!initializedInteractively || profilerInfoDir == null || !"".equals(profilerInfoDir.trim())) {
            String overridenWorkingDirectory;
            String workingDirectory = ss.getWorkingDir();
            if (ps.getOverrideGlobalSettings() && (overridenWorkingDirectory = ps.getWorkingDir()) != null && !"".equals(overridenWorkingDirectory.trim())) {
                workingDirectory = overridenWorkingDirectory;
            }
            antProject.setProperty("profiler.info.dir", workingDirectory);
        }
        if (this.classpath != null) {
            ss.setMainClassPath(this.classpath.toString());
        }
        if (ps.getProfilingType() == 8) {
            antProject.log("Roots path: " + this.rootsPath, 3);
            if (this.rootsPath != null) {
                String[] paths = this.rootsPath.list();
                ArrayList al = new ArrayList();
                for (int i = 0; i < paths.length; ++i) {
                    this.addPackagesList(al, paths[i]);
                }
                ClientUtils.SourceCodeSelection[] ret = new ClientUtils.SourceCodeSelection[al.size()];
                for (int i = 0; i < al.size(); ++i) {
                    ret[i] = "".equals(al.get(i)) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection((String)al.get(i) + ".", "", "");
                }
                ps.setInstrumentationRootMethods(ret);
            }
        }
        antProject.log("Starting Profiled Application", 3);
        antProject.log("  mainClass: " + ss.getMainClass(), 3);
        antProject.log("  classpath: " + ss.getMainClassPath(), 3);
        antProject.log("  arguments: " + ss.getMainArgs(), 3);
        if (ps.getOverrideGlobalSettings()) {
            antProject.log("  jvm arguments: " + ps.getJVMArgs(), 3);
        } else {
            antProject.log("  jvm arguments: " + ss.getJVMArgs(), 3);
        }
        if (ps.getOverrideGlobalSettings()) {
            antProject.log("  working dir: " + ps.getWorkingDir(), 3);
        } else {
            antProject.log("  working dir: " + ss.getWorkingDir(), 3);
        }
        antProject.log("  profiling settings: " + ps.debug(), 4);
        antProject.log("  session settings: " + ss.debug(), 4);
        Project profiledProject = null;
        FileObject singleFO = null;
        if (projectDir != null) {
            String errorMessage = null;
            FileObject projectFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(projectDir)));
            if (projectFO != null) {
                try {
                    profiledProject = ProjectManager.getDefault().findProject(projectFO);
                }
                catch (IOException e) {
                    errorMessage = "IOException: " + e.getMessage();
                }
            } else {
                errorMessage = "Could not find project directory: " + projectDir;
            }
            if (errorMessage != null) {
                antProject.log("Could not determine project: " + errorMessage, 2);
                antProject.log("Using global (no project) attach context", 2);
            }
            if (singleFile != null) {
                singleFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(singleFile)));
            }
        } else {
            antProject.log("You can use property profiler.info.project.dir to specify project that is being profiled.", 3);
        }
        Project projectToUse = profiledProject;
        if (!CalibrationDataFileIO.validateCalibrationInput((String)ss.getJavaVersionString(), (String)ss.getJavaExecutable()) || !Profiler.getDefault().runCalibration(true, ss.getJavaExecutable(), ss.getJavaVersionString(), ss.getSystemArchitecture())) {
            ProfilerDialogs.displayError((String)CALIBRATION_FAILED_MESSAGE);
            throw new BuildException(CALIBRATION_FAILED_MESSAGE);
        }
        ProfilingSettings ps1 = ps;
        FileObject singleFO1 = singleFO;
        NetBeansProfiler.getDefaultNB().setProfiledProject((Lookup.Provider)projectToUse, singleFO1);
        Profiler.getDefault().connectToStartedApp(ps1, ss);
    }

    private void addPackagesForArchive(ArrayList list, String s, File f) {
        org.apache.tools.ant.Project antProject = this.getProject();
        antProject.log("Add root packages for archive: " + f.getName(), 3);
        try {
            JarFile jf = new JarFile(f);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String packageName;
                JarEntry je = e.nextElement();
                antProject.log("Checking jar entry: " + je.getName(), 3);
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                String name = je.getName();
                int idx = name.lastIndexOf(47);
                String string = packageName = idx == -1 ? name : name.substring(0, idx);
                if (list.contains(packageName = packageName.replace('/', '.'))) continue;
                antProject.log("Adding package: " + packageName, 3);
                list.add(packageName);
            }
        }
        catch (IOException e) {
            antProject.log("Failed to scan packages for archive: " + f.getName());
        }
    }

    private void addPackagesForDirectory(ArrayList packages, String prefix, File f) {
        File child;
        int i;
        if (!f.isDirectory()) {
            return;
        }
        this.getProject().log("Add root packages for directory: " + f.getName(), 3);
        File[] children = f.listFiles();
        if (!packages.contains(prefix)) {
            for (i = 0; i < children.length; ++i) {
                child = children[i];
                if (!child.getName().endsWith(".class")) continue;
                this.getProject().log("Addding package: " + prefix, 3);
                packages.add(prefix);
                break;
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            if (!child.isDirectory()) continue;
            if ("".equals(prefix)) {
                this.addPackagesForDirectory(packages, child.getName(), child);
                continue;
            }
            this.addPackagesForDirectory(packages, prefix + "." + child.getName(), child);
        }
    }

    private void addPackagesList(ArrayList list, String path) throws BuildException {
        File f = new File(path);
        if (!f.exists()) {
            this.getProject().log("Cannot find: " + path);
            return;
        }
        if (f.isDirectory()) {
            this.addPackagesForDirectory(list, "", f);
        } else if (f.getName().endsWith(".jar")) {
            this.addPackagesForArchive(list, "", f);
        }
    }

    private String initializeInteractively(ProfilingSettings ps, SessionSettings ss) throws BuildException {
        JavaPlatform platform;
        String projectDir = null;
        org.apache.tools.ant.Project antProject = this.getProject();
        antProject.log("Entering interactive mode of nbprofiledirect task...", 3);
        Project p = ProjectUtilities.getProjectForBuildScript((String)this.getLocation().getFileName());
        if (p != null) {
            antProject.log("Using project: " + ProjectUtilities.getProjectName((Project)p), 2);
            projectDir = FileUtil.toFile((FileObject)p.getProjectDirectory()).getAbsolutePath();
        }
        ss.setPortNo(ProfilerIDESettings.getInstance().getPortNo());
        if (this.mainClass != null) {
            ss.setMainClass(this.mainClass);
        }
        if ((platform = JavaPlatform.getJavaPlatformById((String)ProfilerIDESettings.getInstance().getJavaPlatformForProfiling())) == null && (platform = JavaPlatformSelector.getDefault().selectPlatformToUse()) == null) {
            throw new BuildException("Cancelled...");
        }
        String javaFile = platform.getPlatformJavaFile();
        if (javaFile == null) {
            throw new BuildException("Cannot determine Java executable for platform: " + platform.getDisplayName());
        }
        String javaVersion = platform.getPlatformJDKVersion();
        if (javaVersion == null) {
            throw new BuildException("Cannot determine Java version for the selected Java platform");
        }
        ss.setJavaExecutable(javaFile);
        ss.setJavaVersionString(javaVersion);
        ss.setSystemArchitecture(platform.getPlatformArchitecture());
        ps = ProfilingSupport.getDefault().selectTaskForProfiling((Lookup.Provider)p, ss, null, false);
        if (ps == null) {
            throw new BuildException("Cancelled by the user");
        }
        String usedJavaExecutable = null;
        String usedJvmArgs = null;
        String usedWorkDir = null;
        if (ps.getOverrideGlobalSettings()) {
            antProject.log("Global settings are overridden by the profiling configuration", 3);
            if (ps.getJavaPlatformName() != null) {
                usedJavaExecutable = Profiler.getDefault().getPlatformJavaFile(ps.getJavaPlatformName());
            }
            usedJvmArgs = ps.getJVMArgs();
            usedWorkDir = ps.getWorkingDir();
            if (usedJavaExecutable != null) {
                antProject.log("Overridden Java Executable: " + usedJavaExecutable + ", stored in property: " + this.jvmProperty, 3);
                antProject.setProperty(this.jvmProperty, usedJavaExecutable);
            }
            if (usedJvmArgs != null) {
                antProject.log("Overridden Working Directory: " + usedWorkDir, 3);
                antProject.setProperty(EXTRA_JVM_ARGS, usedJvmArgs);
            }
            if (usedWorkDir != null) {
                antProject.setProperty("profiler.info.dir", usedWorkDir);
            }
        }
        String usedAgentJvmArgs = this.jvmArgsPrefix + IDEUtils.getAntProfilerStartArgument15((int)ss.getPortNo(), (int)ss.getSystemArchitecture());
        antProject.setProperty(this.jvmArgsProperty, usedAgentJvmArgs);
        antProject.log("Profiler agent JVM arguments: " + usedAgentJvmArgs, 3);
        antProject.log("Profiler agent JVM arguments stored in property " + this.jvmArgsProperty, 2);
        return projectDir;
    }

    public static class YesNoAuto
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"yes", "true", "no", "false", "auto"};
        }
    }
}

