/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.FieldNamesCalculator;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.filesystems.FileObject;

public final class BeanIdCompletor
extends Completor {
    public BeanIdCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        return context.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(final CompletionContext context) throws IOException {
        final FileObject fileObject = context.getFileObject();
        JavaSource javaSource = JavaUtils.getJavaSource(fileObject);
        if (javaSource == null) {
            return;
        }
        final String typedPrefix = context.getTypedPrefix();
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                Map<String, String> tagAttributes = SpringXMLConfigEditorUtils.getTagAttributes(context.getTag());
                String beanClassName = new BeanClassFinder(tagAttributes, fileObject).findImplementationClass();
                if (beanClassName == null) {
                    return;
                }
                TypeElement beanType = JavaUtils.findClassElementByBinaryName(beanClassName, cc);
                if (beanType == null) {
                    return;
                }
                FieldNamesCalculator calculator = new FieldNamesCalculator(beanType.getSimpleName().toString(), BeanIdCompletor.this.getForbiddenNames(fileObject));
                List<String> names = calculator.calculate();
                int i = 10;
                for (String name : names) {
                    if (!name.startsWith(typedPrefix)) continue;
                    SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createBeanNameItem(BeanIdCompletor.this.getAnchorOffset(), name, i);
                    BeanIdCompletor.this.addCacheItem(item);
                    i += 10;
                }
            }
        }, true);
    }

    private Set<String> getForbiddenNames(final FileObject fileObject) throws IOException {
        SpringConfigModel model = SpringConfigModel.forFileObject(fileObject);
        if (model == null) {
            return Collections.emptySet();
        }
        final HashSet names = new HashSet();
        model.runReadAction(new Action<SpringBeans>(){

            @Override
            public void run(SpringBeans sb) {
                FileSpringBeans fileBeans = sb.getFileBeans(fileObject);
                if (fileBeans == null) {
                    return;
                }
                for (SpringBean bean : fileBeans.getBeans()) {
                    names.add(bean.getId());
                    names.addAll(bean.getNames());
                }
            }
        });
        return Collections.unmodifiableSet(names);
    }
}

