/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class RemoveInstanceAction
extends CookieAction {
    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance instance = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (instance == null || instance.isRemoveForbidden()) continue;
            String title = NbBundle.getMessage(RemoveInstanceAction.class, (String)"MSG_RemoveInstanceTitle", (Object)instance.getDisplayName());
            String msg = NbBundle.getMessage(RemoveInstanceAction.class, (String)"MSG_ReallyRemoveInstance", (Object)instance.getDisplayName());
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)msg, title, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) continue;
            instance.remove();
        }
    }

    protected boolean enable(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance instance = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (instance != null && !instance.isRemoveForbidden() && instance.getServerState() != 1) continue;
            return false;
        }
        return true;
    }

    protected Class[] cookieClasses() {
        return new Class[]{ServerInstance.class};
    }

    protected int mode() {
        return 4;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveInstanceAction.class, (String)"LBL_Remove");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

