/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.CCFSrcFileIterator;
import org.netbeans.modules.cnd.editor.filecreation.NewCndClassPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class CndClassWizardIterator
extends CCFSrcFileIterator {
    @Override
    public void initialize(WizardDescriptor wiz) {
        this.templateWizard = (TemplateWizard)wiz;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("generic");
        this.targetChooserDescriptorPanel = new NewCndClassPanel(project, groups, null);
    }

    @Override
    public Set<DataObject> instantiate() throws IOException {
        TemplateWizard wiz = this.templateWizard;
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        String sourceFileName = wiz.getTargetName();
        FileObject sourceTemplate = (FileObject)template.files().iterator().next();
        LinkedHashSet<DataObject> res = new LinkedHashSet<DataObject>();
        FileObject bro = FileUtil.findBrother((FileObject)sourceTemplate, (String)"h");
        if (bro != null) {
            DataObject dobjBro = DataObject.find((FileObject)bro);
            String headerFileName = (String)wiz.getProperty("headerFileName");
            DataFolder headerFolderName = (DataFolder)wiz.getProperty("headerFolder");
            res.add(dobjBro.createFromTemplate(headerFolderName, headerFileName));
        } else {
            String errmsg = NbBundle.getMessage(CndClassWizardIterator.class, (String)"MSG_missing_class_header_template", (Object)(sourceTemplate.getName() + ".h"));
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errmsg, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
        res.add(template.createFromTemplate(targetFolder, sourceFileName));
        return res;
    }

    @Override
    public String name() {
        return "CndClassWizardIterator";
    }
}

