/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntime
implements CommonConstants {
    protected static ExternalActionsHandler externalActionsHandler;
    protected static byte[] eventBuffer;
    protected static int globalEvBufPos;
    protected static int globalEvBufPosThreshold;
    protected static volatile boolean sendingBuffer;
    private static boolean printEvents;

    public static void createEventBuffer(int bufSize) {
        eventBuffer = new byte[bufSize];
        globalEvBufPosThreshold = bufSize - 51 - 1;
        globalEvBufPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEventBuffer() {
        if (eventBuffer == null) {
            return;
        }
        if (sendingBuffer) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            sendingBuffer = true;
            ThreadInfo[] tis = ThreadInfo.getThreadInfos();
            for (int i = 0; i < tis.length; ++i) {
                ThreadInfo ti = tis[i];
                if (ti == null || ti.evBuf == null || !ti.isInitialized()) continue;
                int curPos = ti.evBufPos;
                if (globalEvBufPos + curPos - ti.evBufDumpLastPos > globalEvBufPosThreshold) break;
                int evBufSize = curPos - ti.evBufDumpLastPos;
                if (evBufSize <= 0) continue;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(ti.threadId & 0xFF);
                System.arraycopy(ti.evBuf, ti.evBufDumpLastPos, eventBuffer, globalEvBufPos, evBufSize);
                globalEvBufPos += evBufSize;
                ti.evBufDumpLastPos = curPos;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void init(ExternalActionsHandler h) {
        externalActionsHandler = h;
    }

    public static void monitorEntry(Thread t, Object monitor) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(t)) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.monitorEntryCPU(ti, monitor);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.monitorEntryRegion(t, monitor);
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)3, timeStamp, monitor);
        --ti.inProfilingRuntimeMethod;
    }

    public static void monitorExit(Thread t, Object monitor) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(t)) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo(t);
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.monitorExitCPU(ti, monitor);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.monitorExitRegion(t, monitor);
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void profilePointHit(char id) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        if (eventBuffer == null) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        int[] ids = ProfilerServer.getProfilingSessionStatus().profilingPointIDs;
        int idx = Arrays.binarySearch(ids, (int)id);
        if (idx >= 0) {
            ProfilingPointServerHandler method = ProfilerServer.getProfilingSessionStatus().profilingPointHandlers[idx];
            try {
                method.profilingPointHit(id);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        --ti.inProfilingRuntimeMethod;
    }

    public static boolean profiledTargetAppThreadsExist() {
        return ThreadInfo.getNProfiledAppThreads() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors(int instrType) {
        if (instrType != 1 && eventBuffer != null) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                ProfilerRuntime.doResetProfilerCollectors(instrType);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            ProfilerRuntime.doResetProfilerCollectors(instrType);
        }
    }

    public static void sleepEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.sleepEntryCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)2, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void sleepExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.sleepExitCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void waitEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.waitEntryCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)4, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    public static void waitExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long timeStamp = -1L;
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++ti.inProfilingRuntimeMethod;
        ProfilingSessionStatus status = ProfilerServer.getProfilingSessionStatus();
        if (status != null) {
            switch (status.currentInstrType) {
                case 3: 
                case 4: {
                    timeStamp = ProfilerRuntimeCPU.waitExitCPU(ti);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(ti.thread, (byte)1, timeStamp, null);
        --ti.inProfilingRuntimeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfilingPointHitEvent(int id, long absTimeStamp) {
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        int tid = ti.threadId;
        if (ti.evBuf == null) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                int curPos = globalEvBufPos;
                if (curPos > globalEvBufPosThreshold) {
                    ProfilerRuntime.dumpEventBuffer();
                    curPos = 0;
                }
                globalEvBufPos = curPos = ProfilerRuntime.writePPointHitToBuffer(eventBuffer, absTimeStamp, curPos, id, tid);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            int curPos = ti.evBufPos;
            if (curPos > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntimeCPU.copyLocalBuffer(ti);
                curPos = ti.evBufPos;
            }
            byte[] evBuf = ti.evBuf;
            ti.evBufPos = ProfilerRuntime.writePPointHitToBuffer(evBuf, absTimeStamp, curPos, id, tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeThreadCreationEvent(Thread thread, int threadId) {
        String threadName = thread.getName();
        String threadClassName = thread.getClass().getName();
        int fullInfoLen = (threadName.length() + threadClassName.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + fullInfoLen > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 11;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadId & 0xFF);
            byte[] name = threadName.getBytes();
            int len = name.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            name = threadClassName.getBytes();
            len = name.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(len & 0xFF);
            System.arraycopy(name, 0, eventBuffer, globalEvBufPos, len);
            globalEvBufPos += len;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected static void changeAllThreadsInProfRuntimeMethodStatus(int val) {
        ThreadInfo.changeAllThreadsInProfRuntimeMethodStatus(val);
    }

    protected static void clearDataStructures() {
        eventBuffer = null;
        globalEvBufPos = 0;
        ThreadInfo.resetThreadInfoTable();
    }

    protected static void createNewDataStructures() {
        ThreadInfo.resetThreadInfoTable();
    }

    private static void doResetProfilerCollectors(int instrType) {
        ThreadInfo.resetThreadInfoTable();
        globalEvBufPos = 0;
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 10;
        }
        switch (instrType) {
            case 3: 
            case 4: {
                ProfilerRuntimeCPU.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.resetProfilerCollectors();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 5: 
            case 6: {
                ProfilerRuntimeMemory.resetProfilerCollectors(instrType);
            }
        }
    }

    private static int writePPointHitToBuffer(byte[] buf, long absTimeStamp, int curPos, int id, int tid) {
        buf[curPos++] = 26;
        buf[curPos++] = (byte)(id >> 8 & 0xFF);
        buf[curPos++] = (byte)(id & 0xFF);
        buf[curPos++] = (byte)(absTimeStamp >> 48 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 40 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 32 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 24 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 16 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp >> 8 & 0xFFL);
        buf[curPos++] = (byte)(absTimeStamp & 0xFFL);
        buf[curPos++] = (byte)(tid >> 8 & 0xFF);
        buf[curPos++] = (byte)(tid & 0xFF);
        return curPos;
    }

    public static interface ExternalActionsHandler {
        public void handleEventBufferDump(byte[] var1, int var2, int var3);

        public void handleFirstTimeMethodInvoke(char var1);

        public int handleFirstTimeVMObjectAlloc(String var1, int var2);

        public void handleReflectiveInvoke(Method var1);
    }
}

