/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

class AWTGrabHandler {
    private static final Logger logger = Logger.getLogger(AWTGrabHandler.class.getName());
    private JPDADebuggerImpl debugger;
    private Boolean doGrabCheck = null;

    AWTGrabHandler(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public boolean solveGrabbing(VirtualMachine vm) {
        if (vm == null) {
            return true;
        }
        if (Boolean.FALSE.equals(this.doGrabCheck)) {
            return true;
        }
        List<ThreadReference> allThreads = VirtualMachineWrapper.allThreads0(vm);
        for (ThreadReference t : allThreads) {
            boolean success;
            if (!t.isSuspended() || (success = this.solveGrabbing(t))) continue;
            return false;
        }
        return true;
    }

    public boolean solveGrabbing(ThreadReference t) {
        String name;
        if (Boolean.FALSE.equals(this.doGrabCheck)) {
            return true;
        }
        try {
            name = ThreadReferenceWrapper.name(t);
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return true;
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return true;
        }
        if (name.startsWith("AWT-EventQueue")) {
            if (this.doGrabCheck == null) {
                this.doGrabCheck = this.checkXServer(t);
                logger.fine("Doing the AWT grab check = " + this.doGrabCheck);
            }
            if (Boolean.TRUE.equals(this.doGrabCheck)) {
                ObjectReference grabbedWindow = AWTGrabHandler.getGrabbedWindow(t);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Thread " + t + ": some window is grabbed: " + grabbedWindow);
                }
                if (grabbedWindow != null) {
                    InputOutput io;
                    boolean successUngrab = this.ungrabWindow(t, grabbedWindow, 5000);
                    logger.fine("Grabbed window was ungrabbed: " + successUngrab);
                    if (!successUngrab && (io = this.debugger.getIO()) != null) {
                        OutputWriter ow = io.getErr();
                        ow.println(NbBundle.getMessage(AWTGrabHandler.class, (String)"MSG_GrabNotReleasedDbgContinue"));
                        ow.flush();
                        io.select();
                    }
                    return successUngrab;
                }
            }
        }
        return true;
    }

    public static ObjectReference getGrabbedWindow(ThreadReference t) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine(t);
            List<ReferenceType> classesByName = VirtualMachineWrapper.classesByName0(vm, "sun.awt.X11.XAwtState");
            if (classesByName.isEmpty()) {
                logger.fine("No XAwtState class found.");
                return null;
            }
            ReferenceType rt = classesByName.get(0);
            Field grabWindowRefField = ReferenceTypeWrapper.fieldByName(rt, "grabWindowRef");
            if (grabWindowRefField == null) {
                logger.info("No grabWindowRef field");
                return null;
            }
            Value grabWindowRef = ReferenceTypeWrapper.getValue(rt, grabWindowRefField);
            if (grabWindowRef == null) {
                logger.fine("grabWindowRef field is null.");
                return null;
            }
            classesByName = VirtualMachineWrapper.classesByName0(vm, "java.lang.ref.Reference");
            if (classesByName.isEmpty()) {
                logger.info("No Reference class found.");
                return null;
            }
            Field referenceField = ReferenceTypeWrapper.fieldByName(classesByName.get(0), "referent");
            if (referenceField == null) {
                logger.info("No referent field in Reference class");
                return null;
            }
            Value grabWindow = ObjectReferenceWrapper.getValue((ObjectReference)grabWindowRef, referenceField);
            if (grabWindow == null) {
                logger.fine("Grabbed window is null");
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Grabbed window is " + grabWindow);
            }
            return (ObjectReference)grabWindow;
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ungrabWindow(final ThreadReference tr, final ObjectReference grabbedWindow, int timeout) {
        final boolean[] success = new boolean[]{false};
        RequestProcessor.Task task = this.debugger.getRequestProcessor().create(new Runnable(){

            @Override
            public void run() {
                success[0] = AWTGrabHandler.this.ungrabWindow(tr, grabbedWindow);
            }
        });
        JPDAThreadImpl thread = this.debugger.getThread(tr);
        try {
            thread.notifyMethodInvoking();
            task.schedule(0);
            task.waitFinished((long)timeout);
        }
        catch (PropertyVetoException pvex) {
            logger.log(Level.INFO, "Method invoke vetoed", pvex);
            thread = null;
        }
        catch (InterruptedException ex) {
        }
        finally {
            if (thread != null) {
                thread.notifyMethodInvokeDone();
            }
        }
        if (!task.isFinished()) {
            this.debugger.finish();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AWTGrabHandler.class, (String)"MSG_GrabNotReleasedDbgKilled"), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            return true;
        }
        return success[0];
    }

    public boolean ungrabWindow(ThreadReference tr, ObjectReference grabbedWindow) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine(grabbedWindow);
            List<ReferenceType> xbaseWindowClassesByName = VirtualMachineWrapper.classesByName(vm, "sun.awt.X11.XBaseWindow");
            if (xbaseWindowClassesByName.isEmpty()) {
                logger.info("Unable to release X grab, no XBaseWindow class in target VM " + VirtualMachineWrapper.description(vm));
                return false;
            }
            ClassType XBaseWindowClass = (ClassType)xbaseWindowClassesByName.get(0);
            Method ungrabInput = XBaseWindowClass.concreteMethodByName("ungrabInput", "()V");
            if (ungrabInput == null) {
                logger.info("Unable to release X grab, method ungrabInput not found in target VM " + VirtualMachineWrapper.description(vm));
                return false;
            }
            XBaseWindowClass.invokeMethod(tr, ungrabInput, Collections.EMPTY_LIST, 1);
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unable to release X grab.", ex);
            return false;
        }
        return true;
    }

    private boolean checkXServer(ThreadReference t) {
        try {
            return this.checkXServerExc(t);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception thrown from checkXServer: ", ex);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private Boolean checkXServerExc(ThreadReference tr) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isAssignable(ClassType ct1, ClassType ct2) {
        if (ct1.equals(ct2)) {
            return true;
        }
        ClassType cts = ct2.superclass();
        if (cts != null) {
            return AWTGrabHandler.isAssignable(ct1, cts);
        }
        return false;
    }
}

