/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.refactoring;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RenameSupport;
import org.netbeans.modules.nbform.FormEditorSupport;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RADComponentRenameRefactoringSupport
implements RenameSupport.Refactoring {
    public void renameComponent(FormModel formModel, String currentName, String newName) {
        FormDataObject formDO = FormEditor.getFormDataObject((FormModel)formModel);
        JavaSource js = JavaSource.forFileObject((FileObject)formDO.getPrimaryFile());
        MemberVisitor scanner = new MemberVisitor(currentName, true);
        try {
            js.runUserActionTask((Task)scanner, true);
            RADComponentRenameRefactoringSupport.doRenameRefactoring(formDO, newName, scanner.getHandle());
        }
        catch (IOException e) {
            Logger.getLogger(RADComponentRenameRefactoringSupport.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static void doRenameRefactoring(FormDataObject dao, String newName, TreePathHandle handle) throws IOException {
        if (handle == null) {
            return;
        }
        FormEditorSupport fes = (FormEditorSupport)dao.getFormEditorSupport();
        if (fes.isModified()) {
            fes.saveDocument();
        }
        Lookup rnl = Lookups.singleton((Object)handle);
        RefactoringSession renameSession = RefactoringSession.create((String)"Change variable name");
        RenameRefactoring refactoring = new RenameRefactoring(rnl);
        Problem pre = refactoring.preCheck();
        if (pre != null && pre.isFatal()) {
            Logger.getLogger("global").log(Level.WARNING, "There were problems trying to perform the refactoring.");
        }
        Problem p = null;
        if (!(pre != null && pre.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(newName))) {
            refactoring.setNewName(newName);
            p = refactoring.prepare(renameSession);
        }
        if (!(p != null && p.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(newName))) {
            renameSession.doRefactoring(true);
        }
    }

    private static boolean emptyOrWhite(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() < 0;
    }

    private static class MemberVisitor
    extends TreePathScanner<Void, Void>
    implements CancellableTask<CompilationController> {
        private CompilationInfo info;
        private String member = null;
        private TreePathHandle handle = null;
        boolean findUsages;
        private Element variableElement;
        private List<Integer> usagesPositions;

        public TreePathHandle getHandle() {
            return this.handle;
        }

        public void setHandle(TreePathHandle handle) {
            this.handle = handle;
        }

        public MemberVisitor(String member, boolean findUsages) {
            this.member = member;
            this.findUsages = findUsages;
        }

        @Override
        public Void visitClass(ClassTree t, Void v) {
            if (this.variableElement == null) {
                List<? extends Tree> members = t.getMembers();
                for (Tree tree : members) {
                    String sname;
                    TreePath path;
                    Trees trees;
                    Element el;
                    if (tree.getKind() != Tree.Kind.VARIABLE || (el = (trees = this.info.getTrees()).getElement(path = new TreePath(this.getCurrentPath(), tree))) == null || !(sname = el.getSimpleName().toString()).equals(this.member)) continue;
                    this.handle = TreePathHandle.create((TreePath)path, (CompilationInfo)this.info);
                    this.variableElement = el;
                    if (!this.findUsages) continue;
                    this.usagesPositions = new ArrayList<Integer>();
                }
            }
            if (this.findUsages) {
                super.visitClass(t, v);
            }
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void v) {
            if (this.findUsages) {
                Element el = this.info.getTrees().getElement(this.getCurrentPath());
                if (this.variableElement != null && ((Object)this.variableElement).equals(el)) {
                    int pos = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
                    this.usagesPositions.add(pos);
                }
            }
            return (Void)super.visitIdentifier(tree, v);
        }

        public void cancel() {
        }

        public void run(CompilationController parameter) throws IOException {
            this.info = parameter;
            parameter.toPhase(JavaSource.Phase.RESOLVED);
            this.scan(parameter.getCompilationUnit(), null);
        }
    }
}

