/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlRenderer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class PlatformUiSupport {
    private static final SpecificationVersion JDK_1_5 = new SpecificationVersion("1.5");
    private static final Logger LOGGER = Logger.getLogger(PlatformUiSupport.class.getName());

    private PlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String activePlatform) {
        return new PlatformComboBoxModel(activePlatform);
    }

    public static ListCellRenderer createPlatformListCellRenderer() {
        return new PlatformListCellRenderer();
    }

    public static void storePlatform(EditableProperties props, UpdateHelper helper, String projectConfigurationNamespace, String platformName, SpecificationVersion sourceLevel) {
        Parameters.notNull((CharSequence)"props", (Object)props);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"sourceLevel", (Object)sourceLevel);
        PlatformKey platformKey = platformName != null ? new PlatformKey(PlatformUiSupport.findPlatform(platformName)) : new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
        PlatformUiSupport.storePlatform(props, helper, projectConfigurationNamespace, platformKey, new SourceLevelKey(sourceLevel));
    }

    public static void storePlatform(EditableProperties props, UpdateHelper helper, String projectConfigurationNamespace, Object platformKey, Object sourceLevelKey) {
        String javacSource;
        SpecificationVersion sourceLevel;
        Parameters.notNull((CharSequence)"props", (Object)props);
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"projectConfigurationNamespace", (Object)projectConfigurationNamespace);
        Parameters.notNull((CharSequence)"platformKey", (Object)platformKey);
        assert (platformKey instanceof PlatformKey);
        String javaPlatformKey = "platform.active";
        String javacSourceKey = "javac.source";
        String javacTargetKey = "javac.target";
        PlatformKey pk = (PlatformKey)platformKey;
        JavaPlatform platform = PlatformUiSupport.getPlatform(pk);
        if (platform == null) {
            return;
        }
        SpecificationVersion jdk13 = new SpecificationVersion("1.3");
        String platformAntName = (String)platform.getProperties().get("platform.ant.name");
        assert (platformAntName != null);
        props.put("platform.active", platformAntName);
        Element root = helper.getPrimaryConfigurationData(true);
        boolean changed = false;
        NodeList explicitPlatformNodes = root.getElementsByTagNameNS(projectConfigurationNamespace, "explicit-platform");
        if (pk.isDefaultPlatform()) {
            if (explicitPlatformNodes.getLength() == 1) {
                root.removeChild(explicitPlatformNodes.item(0));
                changed = true;
            }
        } else {
            Element explicitPlatform;
            switch (explicitPlatformNodes.getLength()) {
                case 0: {
                    explicitPlatform = root.getOwnerDocument().createElementNS(projectConfigurationNamespace, "explicit-platform");
                    NodeList nodes = root.getChildNodes();
                    Node insertBeforeMe = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (n.getNodeType() != 1 || n.getNodeName().equals("name") || n.getNodeName().equals("minimum-ant-version")) continue;
                        insertBeforeMe = n;
                        break;
                    }
                    if (insertBeforeMe != null) {
                        root.insertBefore(explicitPlatform, insertBeforeMe);
                    } else {
                        root.appendChild(explicitPlatform);
                    }
                    changed = true;
                    break;
                }
                case 1: {
                    explicitPlatform = (Element)explicitPlatformNodes.item(0);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Broken project.xml file");
                }
            }
            String explicitSourceAttrValue = explicitPlatform.getAttribute("explicit-source-supported");
            if (jdk13.compareTo((Object)platform.getSpecification().getVersion()) >= 0 && !"false".equals(explicitSourceAttrValue)) {
                explicitPlatform.setAttribute("explicit-source-supported", "false");
                changed = true;
            } else if (jdk13.compareTo((Object)platform.getSpecification().getVersion()) < 0 && !"true".equals(explicitSourceAttrValue)) {
                explicitPlatform.setAttribute("explicit-source-supported", "true");
                changed = true;
            }
        }
        if (sourceLevelKey == null) {
            sourceLevel = platform.getSpecification().getVersion();
        } else {
            assert (sourceLevelKey instanceof SourceLevelKey);
            sourceLevel = ((SourceLevelKey)sourceLevelKey).getSourceLevel();
        }
        String javacTarget = javacSource = sourceLevel.toString();
        if (jdk13.compareTo((Object)sourceLevel) >= 0) {
            javacTarget = "1.1";
        }
        if (!javacSource.equals(props.getProperty("javac.source"))) {
            props.setProperty("javac.source", javacSource);
        }
        if (!javacTarget.equals(props.getProperty("javac.target"))) {
            props.setProperty("javac.target", javacTarget);
        }
        if (changed) {
            helper.putPrimaryConfigurationData(root, true);
        }
    }

    public static JavaPlatform getPlatform(Object platformKey) {
        Parameters.notNull((CharSequence)"platformKey", (Object)platformKey);
        if (platformKey instanceof PlatformKey) {
            return PlatformUiSupport.getPlatform((PlatformKey)platformKey);
        }
        throw new IllegalArgumentException();
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel, SpecificationVersion minimalSpecificationVersion) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)platformComboBoxModel);
        return new SourceLevelComboBoxModel(platformComboBoxModel, initialSourceLevel, initialTargetLevel, minimalSpecificationVersion);
    }

    public static ComboBoxModel createSourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel) {
        Parameters.notNull((CharSequence)"platformComboBoxModel", (Object)platformComboBoxModel);
        return new SourceLevelComboBoxModel(platformComboBoxModel, initialSourceLevel, initialTargetLevel, null);
    }

    public static ListCellRenderer createSourceLevelListCellRenderer() {
        return new SourceLevelListCellRenderer();
    }

    private static JavaPlatform getPlatform(PlatformKey platformKey) {
        return platformKey == null ? null : platformKey.platform;
    }

    private static JavaPlatform findPlatform(String displayName) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(displayName, new Specification("j2se", null));
        if (platforms.length == 0) {
            return null;
        }
        return platforms[0];
    }

    private static final class SourceLevelListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String message;
            if (value == null || " ".equals(value)) {
                message = " ";
            } else {
                assert (value instanceof SourceLevelKey);
                SourceLevelKey key = (SourceLevelKey)value;
                message = key.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_InvalidSourceLevel", (Object)key.getDisplayName()) : key.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(list, message, index, isSelected, cellHasFocus);
        }
    }

    private static final class SourceLevelComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        private static final long serialVersionUID = 1L;
        private static final String VERSION_PREFIX = "1.";
        private static final int INITIAL_VERSION_MINOR = 2;
        private final ComboBoxModel platformComboBoxModel;
        private final SpecificationVersion minimalSpecificationVersion;
        private SpecificationVersion selectedSourceLevel;
        private SpecificationVersion originalSourceLevel;
        private SourceLevelKey[] sourceLevelCache;
        private PlatformKey activePlatform;

        public SourceLevelComboBoxModel(ComboBoxModel platformComboBoxModel, String initialSourceLevel, String initialTargetLevel, SpecificationVersion minimalSpecificationVersion) {
            this.platformComboBoxModel = platformComboBoxModel;
            this.activePlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            this.platformComboBoxModel.addListDataListener(this);
            if (initialSourceLevel != null && initialSourceLevel.length() > 0) {
                try {
                    this.originalSourceLevel = new SpecificationVersion(initialSourceLevel);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid javac.source: " + initialSourceLevel);
                }
            }
            if (initialTargetLevel != null && initialTargetLevel.length() > 0) {
                try {
                    SpecificationVersion originalTargetLevel = new SpecificationVersion(initialTargetLevel);
                    if (this.originalSourceLevel == null || this.originalSourceLevel.compareTo((Object)originalTargetLevel) < 0) {
                        this.originalSourceLevel = originalTargetLevel;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warning("Invalid javac.target: " + initialTargetLevel);
                }
            }
            this.selectedSourceLevel = this.originalSourceLevel;
            this.minimalSpecificationVersion = minimalSpecificationVersion;
        }

        @Override
        public int getSize() {
            SourceLevelKey[] sLevels = this.getSourceLevels();
            return sLevels.length;
        }

        @Override
        public Object getElementAt(int index) {
            SourceLevelKey[] sLevels = this.getSourceLevels();
            assert (index >= 0 && index < sLevels.length);
            return sLevels[index];
        }

        @Override
        public Object getSelectedItem() {
            for (SourceLevelKey key : this.getSourceLevels()) {
                if (!key.getSourceLevel().equals((Object)this.selectedSourceLevel)) continue;
                return key;
            }
            return null;
        }

        @Override
        public void setSelectedItem(Object obj) {
            this.selectedSourceLevel = obj == null ? null : ((SourceLevelKey)obj).getSourceLevel();
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
            JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
            if (!(platform == null || this.platformComboBoxModel instanceof PlatformComboBoxModel && ((PlatformComboBoxModel)this.platformComboBoxModel).inUpdate)) {
                SpecificationVersion version = platform.getSpecification().getVersion();
                if (this.selectedSourceLevel != null && this.selectedSourceLevel.compareTo((Object)version) > 0 && !this.shouldChangePlatform(this.selectedSourceLevel, version) && !selectedPlatform.equals(this.activePlatform)) {
                    this.platformComboBoxModel.setSelectedItem(this.activePlatform);
                    return;
                }
                this.originalSourceLevel = null;
            }
            this.activePlatform = selectedPlatform;
            this.resetCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetCache() {
            SourceLevelComboBoxModel sourceLevelComboBoxModel = this;
            synchronized (sourceLevelComboBoxModel) {
                this.sourceLevelCache = null;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        private SourceLevelKey[] getSourceLevels() {
            if (this.sourceLevelCache == null) {
                PlatformKey selectedPlatform = (PlatformKey)this.platformComboBoxModel.getSelectedItem();
                JavaPlatform platform = PlatformUiSupport.getPlatform(selectedPlatform);
                ArrayList<SourceLevelKey> sLevels = new ArrayList<SourceLevelKey>();
                boolean selSourceLevelValid = false;
                if (platform != null) {
                    SpecificationVersion version = platform.getSpecification().getVersion();
                    int index = this.getMinimalIndex(version);
                    SpecificationVersion template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index++));
                    boolean origSourceLevelValid = false;
                    while (template.compareTo((Object)version) <= 0) {
                        if (template.equals((Object)this.originalSourceLevel)) {
                            origSourceLevelValid = true;
                        }
                        if (template.equals((Object)this.selectedSourceLevel)) {
                            selSourceLevelValid = true;
                        }
                        sLevels.add(new SourceLevelKey(template));
                        template = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index++));
                    }
                    if (this.originalSourceLevel != null && !origSourceLevelValid) {
                        if (this.originalSourceLevel.equals((Object)this.selectedSourceLevel)) {
                            selSourceLevelValid = true;
                        }
                        sLevels.add(new SourceLevelKey(this.originalSourceLevel, true));
                    }
                }
                this.sourceLevelCache = sLevels.toArray(new SourceLevelKey[sLevels.size()]);
                if (!selSourceLevelValid) {
                    this.selectedSourceLevel = this.sourceLevelCache.length == 0 ? null : this.sourceLevelCache[this.sourceLevelCache.length - 1].getSourceLevel();
                }
            }
            return this.sourceLevelCache;
        }

        private int getMinimalIndex(SpecificationVersion platformVersion) {
            int index = 2;
            if (this.minimalSpecificationVersion != null) {
                SpecificationVersion min = new SpecificationVersion(VERSION_PREFIX + Integer.toString(index));
                while (min.compareTo((Object)platformVersion) <= 0) {
                    if (min.equals((Object)this.minimalSpecificationVersion)) {
                        return index;
                    }
                    min = new SpecificationVersion(VERSION_PREFIX + Integer.toString(++index));
                }
            }
            return index;
        }

        private boolean shouldChangePlatform(SpecificationVersion selectedSourceLevel, SpecificationVersion platformSourceLevel) {
            JButton changeOption = new JButton(NbBundle.getMessage(PlatformUiSupport.class, (String)"CTL_ChangePlatform"));
            changeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformUiSupport.class, (String)"AD_ChangePlatform"));
            String message = MessageFormat.format(NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatform"), selectedSourceLevel.toString(), platformSourceLevel.toString());
            return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_ChangePlatformTitle"), -1, 2, new Object[]{changeOption, NotifyDescriptor.CANCEL_OPTION}, (Object)changeOption)) == changeOption;
        }
    }

    private static final class PlatformListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer delegate = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name;
            if (value == null || " ".equals(value)) {
                name = " ";
            } else {
                assert (value instanceof PlatformKey) : "Wrong model";
                PlatformKey key = (PlatformKey)value;
                name = key.isBroken() ? "<html><font color=\"#A40000\">" + NbBundle.getMessage(PlatformUiSupport.class, (String)"TXT_BrokenPlatformFmt", (Object)key.getDisplayName()) : key.getDisplayName();
            }
            return this.delegate.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
        }
    }

    private static final class PlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private final JavaPlatformManager pm = JavaPlatformManager.getDefault();
        private PlatformKey[] platformNamesCache;
        private String initialPlatform;
        private PlatformKey selectedPlatform;
        private boolean inUpdate;

        public PlatformComboBoxModel(String initialPlatform) {
            this.pm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pm));
            this.initialPlatform = initialPlatform;
        }

        @Override
        public int getSize() {
            PlatformKey[] platformNames = this.getPlatformNames();
            return platformNames.length;
        }

        @Override
        public Object getElementAt(int index) {
            PlatformKey[] platformNames = this.getPlatformNames();
            assert (index >= 0 && index < platformNames.length);
            return platformNames[index];
        }

        @Override
        public Object getSelectedItem() {
            this.getPlatformNames();
            return this.selectedPlatform;
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (obj != null) {
                this.selectedPlatform = (PlatformKey)obj;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("installedPlatforms".equals(event.getPropertyName())) {
                PlatformComboBoxModel platformComboBoxModel = this;
                synchronized (platformComboBoxModel) {
                    this.platformNamesCache = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        PlatformComboBoxModel.this.inUpdate = true;
                        try {
                            PlatformComboBoxModel.this.fireContentsChanged(this, -1, -1);
                        }
                        finally {
                            PlatformComboBoxModel.this.inUpdate = false;
                        }
                    }
                });
            }
        }

        private synchronized PlatformKey[] getPlatformNames() {
            if (this.platformNamesCache == null) {
                JavaPlatform[] platforms = this.pm.getPlatforms(null, new Specification("j2se", null));
                TreeSet<PlatformKey> orderedNames = new TreeSet<PlatformKey>();
                boolean activeFound = false;
                for (JavaPlatform platform : platforms) {
                    String antName;
                    if (platform.getInstallFolders().size() <= 0) continue;
                    PlatformKey pk = new PlatformKey(platform);
                    orderedNames.add(pk);
                    if (activeFound || this.initialPlatform == null || !this.initialPlatform.equals(antName = (String)platform.getProperties().get("platform.ant.name"))) continue;
                    if (this.selectedPlatform == null) {
                        this.selectedPlatform = pk;
                        this.initialPlatform = null;
                    }
                    activeFound = true;
                }
                if (!activeFound) {
                    if (this.initialPlatform == null) {
                        if (this.selectedPlatform == null || !orderedNames.contains(this.selectedPlatform)) {
                            this.selectedPlatform = new PlatformKey(JavaPlatformManager.getDefault().getDefaultPlatform());
                        }
                    } else {
                        PlatformKey pk = new PlatformKey(this.initialPlatform);
                        orderedNames.add(pk);
                        if (this.selectedPlatform == null) {
                            this.selectedPlatform = pk;
                        }
                    }
                }
                this.platformNamesCache = orderedNames.toArray(new PlatformKey[0]);
                assert (this.selectedPlatform != null) : "platformNamesCache: " + orderedNames + " initialPlatform: " + this.initialPlatform;
            }
            return this.platformNamesCache;
        }
    }

    private static final class SourceLevelKey
    implements Comparable {
        private final SpecificationVersion sourceLevel;
        private final boolean broken;

        public SourceLevelKey(SpecificationVersion sourceLevel) {
            this(sourceLevel, false);
        }

        public SourceLevelKey(SpecificationVersion sourceLevel, boolean broken) {
            assert (sourceLevel != null) : "Source level cannot be null";
            this.sourceLevel = sourceLevel;
            this.broken = broken;
        }

        public SpecificationVersion getSourceLevel() {
            return this.sourceLevel;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public int compareTo(Object other) {
            assert (other instanceof SourceLevelKey) : "Illegal argument of SourceLevelKey.compareTo()";
            SourceLevelKey otherKey = (SourceLevelKey)other;
            return this.sourceLevel.compareTo((Object)otherKey.sourceLevel);
        }

        public boolean equals(Object other) {
            return other instanceof SourceLevelKey && ((SourceLevelKey)other).sourceLevel.equals((Object)this.sourceLevel);
        }

        public int hashCode() {
            return this.sourceLevel.hashCode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.broken) {
                buffer.append("Broken: ");
            }
            buffer.append(this.sourceLevel.toString());
            return buffer.toString();
        }

        public String getDisplayName() {
            String tmp = this.sourceLevel.toString();
            if (JDK_1_5.compareTo((Object)this.sourceLevel) <= 0) {
                tmp = tmp.replaceFirst("^1\\.([5-9]|\\d\\d+)$", "$1");
            }
            return NbBundle.getMessage(PlatformUiSupport.class, (String)"LBL_JDK", (Object)tmp);
        }
    }

    private static final class PlatformKey
    implements Comparable {
        private String name;
        private JavaPlatform platform;

        public PlatformKey(String name) {
            assert (name != null);
            this.name = name;
        }

        public PlatformKey(JavaPlatform platform) {
            assert (platform != null);
            this.platform = platform;
        }

        public int compareTo(Object o) {
            return this.getDisplayName().compareTo(((PlatformKey)o).getDisplayName());
        }

        public boolean equals(Object other) {
            if (other instanceof PlatformKey) {
                PlatformKey otherKey = (PlatformKey)other;
                boolean equals = this.platform == null ? otherKey.platform == null : this.platform.equals(otherKey.platform);
                return equals && otherKey.getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public String toString() {
            return this.getDisplayName();
        }

        public synchronized String getDisplayName() {
            if (this.name == null) {
                this.name = this.platform.getDisplayName();
            }
            return this.name;
        }

        public boolean isDefaultPlatform() {
            if (this.platform == null) {
                return false;
            }
            return this.platform.equals(JavaPlatformManager.getDefault().getDefaultPlatform());
        }

        public boolean isBroken() {
            return this.platform == null;
        }
    }
}

