/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.api.NBBugzillaUtils;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;

public class KenaiSupportImpl
extends KenaiSupport {
    public Repository createRepository(KenaiProject project) {
        if (project == null || project.getType() != KenaiSupport.BugtrackingType.BUGZILLA) {
            return null;
        }
        KenaiRepository repo = this.createKenaiRepository(project, project.getDisplayName(), project.getFeatureLocation());
        return repo;
    }

    public void setFilter(Query query, Filter filter) {
        if (query instanceof BugzillaQuery) {
            BugzillaQuery bq = (BugzillaQuery)query;
            bq.getController().selectFilter(filter);
        }
    }

    private KenaiRepository createKenaiRepository(KenaiProject kenaiProject, String displayName, String location) {
        URL loc;
        try {
            loc = new URL(location);
        }
        catch (MalformedURLException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
            return null;
        }
        String host = loc.getHost();
        int idx = location.indexOf("/buglist.cgi");
        if (idx <= 0) {
            Bugzilla.LOG.log(Level.WARNING, "can''t get issue tracker url from [{0}, {1}]", new Object[]{displayName, location});
            return null;
        }
        String url = location.substring(0, idx);
        if (url.startsWith("http:")) {
            url = "https" + url.substring(4);
        }
        String productParamUrl = null;
        String productAttribute = "product=";
        String product = null;
        int idxProductStart = location.indexOf(productAttribute);
        if (idxProductStart <= 0) {
            Bugzilla.LOG.log(Level.WARNING, "can''t get issue tracker product from [{0}, {1}]", new Object[]{displayName, location});
            return null;
        }
        int idxProductEnd = location.indexOf("&", idxProductStart);
        if (idxProductEnd > -1) {
            productParamUrl = location.substring(idxProductStart, idxProductEnd);
            product = location.substring(idxProductStart + productAttribute.length(), idxProductEnd);
        } else {
            productParamUrl = location.substring(idxProductStart);
            product = location.substring(idxProductStart + productAttribute.length());
        }
        return new KenaiRepository(kenaiProject, displayName, url, host, productParamUrl, product);
    }

    public Query getAllIssuesQuery(Repository repository) {
        assert (repository instanceof KenaiRepository);
        return ((KenaiRepository)repository).getAllIssuesQuery();
    }

    public Query getMyIssuesQuery(Repository repository) {
        assert (repository instanceof KenaiRepository);
        return ((KenaiRepository)repository).getMyIssuesQuery();
    }

    public KenaiSupport.BugtrackingType getType() {
        return KenaiSupport.BugtrackingType.BUGZILLA;
    }

    public boolean needsLogin(Query query) {
        return query == ((KenaiRepository)query.getRepository()).getMyIssuesQuery();
    }

    public void refresh(Query query, boolean synchronously) {
        assert (query instanceof BugzillaQuery);
        BugzillaQuery bq = (BugzillaQuery)query;
        if (synchronously) {
            bq.refresh();
        } else {
            bq.getController().onRefresh();
        }
    }

    public Repository findNBRepository() {
        return NBBugzillaUtils.findNBRepository();
    }
}

