/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.OpenRemoteProjectAction;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class OpenTerminalAction
extends SingleHostAction {
    private JMenu remotePopupMenu;
    private JMenuItem localPopupMenu;

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"OpenTerminalMenuItem");
    }

    @Override
    protected void performAction(ExecutionEnvironment env, Node node) {
        Node[] activatedNodes = this.getActivatedNodes();
        if (activatedNodes != null && activatedNodes.length == 1 && !this.isRemote(activatedNodes[0])) {
            ((AddHome)SystemAction.get(AddHome.class)).performAction(env, node);
        }
    }

    @Override
    public boolean isVisible(Node node) {
        return true;
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        JMenuItem out = this.localPopupMenu;
        Node[] activatedNodes = this.getActivatedNodes();
        if (activatedNodes != null && activatedNodes.length == 1 && this.isRemote(activatedNodes[0])) {
            out = this.remotePopupMenu;
        }
        return out;
    }

    private void createSubMenu() {
        if (this.remotePopupMenu == null) {
            this.remotePopupMenu = new JMenu(this.getName());
            this.remotePopupMenu.add(((AddHome)SystemAction.get(AddHome.class)).getPopupPresenter());
            this.remotePopupMenu.add(((AddMirror)SystemAction.get(AddMirror.class)).getPopupPresenter());
        }
        if (this.localPopupMenu == null) {
            this.localPopupMenu = super.getPopupPresenter();
        }
    }

    private static String getHomeDir(ExecutionEnvironment env) {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            if (hostInfo != null) {
                String userDir = env.isLocal() ? hostInfo.getUserDirFile().getAbsolutePath() : hostInfo.getUserDir();
                return userDir;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    static FileObject getRemoteFileObject(ExecutionEnvironment env, String title, String btn, Frame mainWindow) {
        JFileChooser fileChooser;
        int ret;
        String curDir = RemoteFileUtil.getCurrentChooserFile((ExecutionEnvironment)env);
        if (curDir == null) {
            curDir = OpenTerminalAction.getHomeDir(env);
        }
        if ((ret = (fileChooser = RemoteFileUtil.createFileChooser((ExecutionEnvironment)env, (String)title, (String)btn, (int)1, null, (String)curDir, (boolean)true)).showOpenDialog(mainWindow)) == 1) {
            return null;
        }
        FileObject fo = null;
        if (fileChooser instanceof FileChooserBuilder.JFileChooserEx) {
            fo = ((FileChooserBuilder.JFileChooserEx)fileChooser).getSelectedFileObject();
        } else {
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                fo = FileUtil.toFileObject((File)selectedFile);
            }
        }
        if (fo == null || !fo.isFolder()) {
            String msg;
            String string = msg = fileChooser.getSelectedFile() != null ? fileChooser.getSelectedFile().getPath() : null;
            if (msg != null) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"InvalidFolder", (Object)msg));
            }
            return null;
        }
        String lastPath = fo.getParent() == null ? fo.getPath() : fo.getParent().getPath();
        RemoteFileUtil.setCurrentChooserFile((String)lastPath, (ExecutionEnvironment)env);
        return fo;
    }

    private static final class AddOther
    extends AddPlace {
        private final Frame mainWindow = WindowManager.getDefault().getMainWindow();

        public AddOther() {
            super(PLACE.OTHER);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            String btn;
            String title = NbBundle.getMessage(OpenTerminalAction.class, (String)"SelectFolder");
            FileObject remoteFileObject = OpenTerminalAction.getRemoteFileObject(env, title, btn = NbBundle.getMessage(OpenTerminalAction.class, (String)"OpenText"), this.mainWindow);
            return remoteFileObject == null ? null : remoteFileObject.getPath();
        }
    }

    private static final class AddMirror
    extends AddPlace {
        public AddMirror() {
            super(PLACE.MIRROR);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot(env);
            return remoteSyncRoot;
        }
    }

    private static final class AddProjects
    extends AddPlace {
        public AddProjects() {
            super(PLACE.PROJECTS);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static final class AddHome
    extends AddPlace {
        public AddHome() {
            super(PLACE.HOME);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return OpenTerminalAction.getHomeDir(env);
        }
    }

    private static final class AddRoot
    extends AddPlace {
        public AddRoot() {
            super(PLACE.ROOT);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static abstract class AddPlace
    extends SingleHostAction {
        private final PLACE place;

        private AddPlace(PLACE place) {
            this.place = place;
            this.putProperty("noIconInMenu", Boolean.TRUE);
        }

        protected abstract String getPath(ExecutionEnvironment var1);

        @Override
        protected void performAction(final ExecutionEnvironment env, Node node) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenTerminalAction.class, (String)"OpenTerminalAction.opening"));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionManager.getInstance().connectTo(env);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    final String path = AddPlace.this.getPath(env);
                    if (path != null && path.length() > 0) {
                        Runnable openTask = new Runnable(){

                            @Override
                            public void run() {
                                TerminalSupport.openTerminal((String)env.getDisplayName(), (ExecutionEnvironment)env, (String)path);
                            }
                        };
                        SwingUtilities.invokeLater(openTask);
                    } else if (path != null) {
                        String msg = !ConnectionManager.getInstance().isConnectedTo(env) ? NbBundle.getMessage(OpenTerminalAction.class, (String)"NotConnected", (Object)path, (Object)env.getDisplayName()) : NbBundle.getMessage(OpenTerminalAction.class, (String)"NoRemotePath", (Object)path);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }

        public String getName() {
            return this.place.getName();
        }
    }

    private static enum PLACE {
        ROOT("OpenRoot"),
        HOME("OpenHome"),
        PROJECTS("OpenProjects"),
        OTHER("OpenOtherFolder"),
        MIRROR("OpenMirror");

        private final String name;

        private PLACE(String nameKey) {
            this.name = NbBundle.getMessage(OpenTerminalAction.class, (String)nameKey);
        }

        private String getName() {
            return this.name;
        }
    }
}

