/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.HostsListTableModel;
import org.netbeans.modules.cnd.remote.ui.wizard.PortTextField;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CreateHostVisualPanel1
extends JPanel {
    private final HostsListTableModel tableModel = new HostsListTableModel();
    private final CreateHostData data;
    private JScrollPane jScrollPane2;
    private JLabel lblHostName;
    private JLabel lblNeighbouthood;
    private JLabel lblPort;
    private JLabel lblUser;
    private JPanel pbarStatusPanel;
    private JTable tableHostsList;
    private JTextField textHostname;
    private PortTextField textPort;
    private JTextField textUser;

    public CreateHostVisualPanel1(CreateHostData data, final ChangeListener listener) {
        this.data = data;
        this.initComponents();
        this.lblUser.setVisible(data.isManagingUser());
        this.textUser.setVisible(data.isManagingUser());
        this.textPort.setText(Integer.toString(22));
        this.textHostname.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                listener.stateChanged(null);
            }
        });
        this.pbarStatusPanel.removeAll();
        this.pbarStatusPanel.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.tableModel.getProgressHandle()), "Center");
        this.pbarStatusPanel.validate();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                CreateHostVisualPanel1.this.tableModel.start(new Runnable(){

                    @Override
                    public void run() {
                        CreateHostVisualPanel1.this.pbarStatusPanel.setVisible(false);
                    }
                });
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                CreateHostVisualPanel1.this.tableModel.stop();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateHostVisualPanel1.this.textHostname.requestFocus();
                    }
                });
            }
        });
    }

    void init() {
        this.textUser.setText(this.data.getUserName());
        this.textPort.setText(Integer.toString(this.data.getPort()));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel1.Title");
    }

    public String getHostname() {
        return this.textHostname.getText().trim();
    }

    public String getUser() {
        return this.textUser.getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textUser.setEnabled(enabled);
        this.textHostname.setEnabled(enabled);
        this.textHostname.setEditable(enabled);
        this.textPort.setEnabled(enabled);
        this.textPort.setEditable(enabled);
        this.lblUser.setEnabled(enabled);
        this.lblHostName.setEnabled(enabled);
        this.lblNeighbouthood.setEnabled(enabled);
        this.lblPort.setEnabled(enabled);
        this.tableHostsList.setEnabled(enabled);
    }

    public Integer getPort() {
        if ("".equals(this.textPort.getText())) {
            return 22;
        }
        try {
            return Integer.parseInt(this.textPort.getText().trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.textHostname = new JTextField();
        this.lblNeighbouthood = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tableHostsList = new HostTable();
        this.pbarStatusPanel = new JPanel();
        this.lblPort = new JLabel();
        this.textPort = new PortTextField();
        this.lblUser = new JLabel();
        this.textUser = new JTextField();
        this.setPreferredSize(new Dimension(534, 409));
        this.setRequestFocusEnabled(false);
        this.lblHostName.setLabelFor(this.textHostname);
        Mnemonics.setLocalizedText((JLabel)this.lblHostName, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblHostName.text"));
        this.textHostname.setText(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.textHostname.text"));
        this.lblNeighbouthood.setLabelFor(this.tableHostsList);
        Mnemonics.setLocalizedText((JLabel)this.lblNeighbouthood, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblNeighbouthood.text"));
        this.tableHostsList.setModel(this.tableModel);
        this.tableHostsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CreateHostVisualPanel1.this.tableHostsListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tableHostsList);
        this.tableHostsList.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.tableHostsList.columnModel.title0"));
        this.tableHostsList.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.tableHostsList.columnModel.title1"));
        this.pbarStatusPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        this.pbarStatusPanel.setMinimumSize(new Dimension(100, 10));
        this.pbarStatusPanel.setLayout(new BorderLayout());
        this.lblPort.setLabelFor(this.textPort);
        Mnemonics.setLocalizedText((JLabel)this.lblPort, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblPort.text"));
        this.textPort.setText(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.textPort.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.lblUser.text"));
        this.textUser.setText(NbBundle.getMessage(CreateHostVisualPanel1.class, (String)"CreateHostVisualPanel1.textUser.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pbarStatusPanel, -1, 534, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 534, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblNeighbouthood).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblUser, -1, -1, Short.MAX_VALUE).addComponent(this.lblHostName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.textUser, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE).addComponent(this.textHostname, GroupLayout.Alignment.LEADING, -1, 329, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPort, -2, 68, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUser).addComponent(this.textUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textHostname, -2, -1, -2).addComponent(this.lblHostName).addComponent(this.lblPort).addComponent(this.textPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNeighbouthood).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 229, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.pbarStatusPanel, -2, 13, -2)));
    }

    private void tableHostsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int row = this.tableHostsList.rowAtPoint(evt.getPoint());
            this.textHostname.setText(((HostsListTableModel)this.tableHostsList.getModel()).getHostName(row));
        }
    }

    private class HostTable
    extends JTable {
        private final Color stdBackground = this.getBackground();
        private final Color stdForeground = this.getForeground();
        private final Color stdGrid = this.getGridColor();
        private final Color stdHeader = this.getTableHeader().getForeground();

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.setForeground(this.stdForeground);
                this.setBackground(this.stdBackground);
                this.setGridColor(this.stdGrid);
                this.getTableHeader().setForeground(this.stdHeader);
            } else {
                Color back = CreateHostVisualPanel1.this.textPort.getBackground();
                Color fore = Color.lightGray;
                this.setBackground(back);
                this.setForeground(fore);
                this.setGridColor(fore);
                this.getTableHeader().setForeground(fore);
            }
            this.invalidate();
            this.repaint();
        }
    }
}

