/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.FileState;
import org.netbeans.modules.cnd.remote.sync.RfsListenerSupportImpl;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.sync.download.HostUpdates;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class RfsLocalController
extends NamedRunnable {
    private final NativeProcess remoteControllerProcess;
    private final BufferedReader requestReader;
    private final PrintWriter responseStream;
    private final File[] files;
    private final ExecutionEnvironment execEnv;
    private final PrintWriter err;
    private final FileData fileData;
    private final RemotePathMap mapper;
    private final Set<File> remoteUpdates;
    private final File privProjectStorageDir;
    private final RemoteUtil.PrefixedLogger logger;
    private final String prefix;
    private final SharabilityFilter filter;
    private String timeStampFile;
    private static final boolean USE_TIMESTAMPS = DebugUtils.getBoolean((String)"cnd.rfs.timestamps", (boolean)true);
    private static final boolean CHECK_ALIVE = DebugUtils.getBoolean((String)"cnd.rfs.check.alive", (boolean)true);
    private final Map<String, String> canonicalToAbsolute = new HashMap<String, String>();

    public RfsLocalController(ExecutionEnvironment executionEnvironment, File[] files, NativeProcess remoteControllerProcess, BufferedReader requestStreamReader, PrintWriter responseStreamWriter, PrintWriter err, File privProjectStorageDir) {
        super("RFS local controller thread " + executionEnvironment);
        this.execEnv = executionEnvironment;
        this.files = files;
        this.remoteControllerProcess = remoteControllerProcess;
        this.requestReader = requestStreamReader;
        this.responseStream = responseStreamWriter;
        this.err = err;
        this.mapper = RemotePathMap.getPathMap(this.execEnv);
        this.remoteUpdates = new HashSet<File>();
        this.privProjectStorageDir = privProjectStorageDir;
        this.fileData = FileData.get(privProjectStorageDir, executionEnvironment);
        this.prefix = "LC[" + executionEnvironment + "]";
        this.logger = new RemoteUtil.PrefixedLogger(this.prefix);
        this.filter = new SharabilityFilter();
    }

    private void respond_ok() {
        this.responseStream.printf("1\n", new Object[0]);
        this.responseStream.flush();
    }

    private void respond_err(String tail) {
        this.responseStream.printf("0 %s\n", tail);
        this.responseStream.flush();
    }

    private RequestKind getRequestKind(String request) {
        switch (request.charAt(0)) {
            case 'r': {
                return RequestKind.REQUEST;
            }
            case 'w': {
                return RequestKind.WRITTEN;
            }
            case 'p': {
                return RequestKind.PING;
            }
        }
        if ("Killed".equals(request) && (this.remoteControllerProcess.getState() == NativeProcess.State.CANCELLED || this.remoteControllerProcess.getState() == NativeProcess.State.FINISHED)) {
            try {
                int exitStatus = this.remoteControllerProcess.waitFor();
                if (exitStatus != 0) {
                    return RequestKind.KILLED;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return RequestKind.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() {
        long totalCopyingTime = 0L;
        block9: while (true) {
            try {
                while (true) {
                    String localFilePath;
                    String request = this.requestReader.readLine();
                    this.logger.log(Level.FINEST, "REQ %s", request);
                    if (request == null) break block9;
                    RequestKind kind = this.getRequestKind(request);
                    if (kind == RequestKind.KILLED) {
                        this.err.append("\nRemote process is killed");
                        break block9;
                    }
                    if (kind == RequestKind.UNKNOWN) {
                        this.err.append("\nProtocol error: " + request);
                        continue;
                    }
                    if (kind == RequestKind.PING) {
                        this.logger.log(Level.FINEST, "PING from remote controller", new Object[0]);
                        continue;
                    }
                    if (request.charAt(1) != ' ') {
                        throw new IllegalArgumentException("Protocol error: " + request);
                    }
                    String remoteFile = request.substring(2);
                    String realPath = this.canonicalToAbsolute.get(remoteFile);
                    if (realPath != null) {
                        remoteFile = realPath;
                    }
                    if ((localFilePath = this.mapper.getLocalPath(remoteFile)) != null) {
                        File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                        if (kind == RequestKind.WRITTEN) {
                            this.fileData.setState(localFile, FileState.UNCONTROLLED);
                            this.remoteUpdates.add(localFile);
                            RfsListenerSupportImpl.getInstanmce(this.execEnv).fireFileChanged(localFile, remoteFile);
                            this.logger.log(Level.FINEST, "uncontrolled %s", localFile);
                            continue;
                        }
                        CndUtils.assertTrue((kind == RequestKind.REQUEST ? 1 : 0) != 0, (String)"kind should be RequestKind.REQUEST, but is ", (Object)((Object)kind));
                        if (localFile.exists() && !localFile.isDirectory()) {
                            this.logger.log(Level.FINEST, "uploading %s to %s started", localFile, remoteFile);
                            long fileTime = System.currentTimeMillis();
                            Future task = CommonTasksSupport.uploadFile((String)localFile.getAbsolutePath(), (ExecutionEnvironment)this.execEnv, (String)remoteFile, (int)511);
                            try {
                                CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)task.get();
                                fileTime = System.currentTimeMillis() - fileTime;
                                this.logger.log(Level.FINEST, "uploading %s to %s finished; rc=%d time = %d total time = %d ms", localFile, remoteFile, uploadStatus.getExitCode(), fileTime, totalCopyingTime += fileTime);
                                if (uploadStatus.isOK()) {
                                    this.fileData.setState(localFile, FileState.COPIED);
                                    this.respond_ok();
                                    continue;
                                }
                                if (this.err != null) {
                                    this.err.println(uploadStatus.getError());
                                }
                                this.respond_err("1");
                                continue;
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                break block9;
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                this.respond_err("2 execution exception\n");
                                continue;
                            }
                            finally {
                                this.responseStream.flush();
                                continue;
                            }
                        }
                        this.respond_ok();
                        continue;
                    }
                    this.respond_ok();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            break;
        }
        this.shutdown();
    }

    private void shutdown() {
        try {
            this.logger.log(Level.FINEST, "shutdown", new Object[0]);
            try {
                this.runNewFilesDiscovery(true);
                this.shutDownNewFilesDiscovery();
            }
            catch (ConnectionManager.CancellationException ex) {
            }
            catch (InterruptedIOException ex) {
            }
            catch (InterruptedException ex) {
            }
            catch (IOException ex) {
                this.logger.log(Level.INFO, "Error discovering newer files at remote host", ex);
            }
            catch (ExecutionException ex) {
                this.logger.log(Level.INFO, "Error discovering newer files at remote host", ex);
            }
            this.fileData.store();
            this.logger.log(Level.FINE, "registering %d updated files", this.remoteUpdates.size());
            if (!this.remoteUpdates.isEmpty()) {
                HostUpdates.register(this.remoteUpdates, this.execEnv, this.privProjectStorageDir);
                this.logger.log(Level.FINE, "registered  %d updated files", this.remoteUpdates.size());
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    private boolean initNewFilesDiscovery() {
        String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot(this.execEnv);
        ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)this.execEnv, (String)"mktemp", (String[])new String[]{"-p", remoteSyncRoot});
        if (res.isOK()) {
            this.timeStampFile = res.output.trim();
            return true;
        }
        this.timeStampFile = null;
        String errMsg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_Error_Running_Command", (Object)("mktemp -p " + remoteSyncRoot), (Object)this.execEnv, (Object)res.error, (Object)res.exitCode, (Object[])new Object[0]);
        this.logger.log(Level.INFO, errMsg, new Object[0]);
        if (this.err != null) {
            this.err.printf("%s\n", errMsg);
        }
        return false;
    }

    private void shutDownNewFilesDiscovery() throws InterruptedException, ExecutionException {
        if (this.timeStampFile != null) {
            CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.timeStampFile, (Writer)this.err).get();
        }
    }

    private void runNewFilesDiscovery(boolean srcOnly) throws IOException, InterruptedException, ConnectionManager.CancellationException {
        if (this.timeStampFile == null) {
            return;
        }
        long time = System.currentTimeMillis();
        int oldSize = this.remoteUpdates.size();
        StringBuilder remoteDirs = new StringBuilder();
        for (File file : this.files) {
            if (!file.isDirectory()) continue;
            String rPath = this.mapper.getRemotePath(file.getAbsolutePath(), false);
            if (rPath == null) {
                this.logger.log(Level.INFO, "Can't get remote path for %s at %s", file.getAbsolutePath(), this.execEnv);
                continue;
            }
            if (remoteDirs.length() > 0) {
                remoteDirs.append(' ');
            }
            remoteDirs.append('\"');
            remoteDirs.append(rPath);
            remoteDirs.append('\"');
        }
        StringBuilder extOptions = new StringBuilder();
        if (srcOnly) {
            ArrayList<Collection> values = new ArrayList<Collection>();
            values.add(MIMEExtensions.get((String)"text/x-c").getValues());
            values.add(MIMEExtensions.get((String)"text/x-c++").getValues());
            values.add(MIMEExtensions.get((String)"text/x-h").getValues());
            for (Collection v : values) {
                for (String ext : v) {
                    if (extOptions.length() > 0) {
                        extOptions.append(" -o ");
                    }
                    extOptions.append("-name \"*.");
                    extOptions.append(ext);
                    extOptions.append("\"");
                }
            }
            if (extOptions.length() > 0) {
                extOptions.append(" -o ");
            }
            extOptions.append(" -name Makefile");
        }
        String script = String.format("for F in `find %s %s -newer %s`; do test -f $F &&  echo $F;  done;", remoteDirs, extOptions.toString(), this.timeStampFile);
        final AtomicInteger lineCnt = new AtomicInteger();
        LineProcessor lp = new LineProcessor(){

            public void processLine(String remoteFile) {
                String localPath;
                lineCnt.incrementAndGet();
                RfsLocalController.this.logger.log(Level.FINEST, " Updates check: %s", remoteFile);
                String realPath = (String)RfsLocalController.this.canonicalToAbsolute.get(remoteFile);
                if (realPath != null) {
                    remoteFile = realPath;
                }
                if ((localPath = RfsLocalController.this.mapper.getLocalPath(remoteFile)) == null) {
                    RfsLocalController.this.logger.log(Level.FINE, "Can't find local path for %s", remoteFile);
                } else {
                    File localFile = CndFileUtils.createLocalFile((String)localPath);
                    if (RfsLocalController.this.fileData.getFileInfo(localFile) == null && RfsLocalController.this.filter.accept(localFile)) {
                        RfsLocalController.this.remoteUpdates.add(localFile);
                        RfsListenerSupportImpl.getInstanmce(RfsLocalController.this.execEnv).fireFileChanged(localFile, remoteFile);
                    }
                }
            }

            public void reset() {
            }

            public void close() {
            }
        };
        ShellScriptRunner ssr = new ShellScriptRunner(this.execEnv, script, lp);
        ssr.setErrorProcessor((LineProcessor)new ShellScriptRunner.LoggerLineProcessor(this.prefix));
        int rc = ssr.execute();
        if (rc != 0) {
            this.logger.log(Level.FINE, "Error %d running script \"%s\" at %s", rc, script, this.execEnv);
        }
        this.logger.log(Level.FINE, "New files discovery at %s took %d ms; %d lines processed; %d additional new files were discovered", this.execEnv, System.currentTimeMillis() - time, lineCnt.get(), this.remoteUpdates.size() - oldSize);
    }

    private boolean checkVersion(char version) throws IOException {
        String[] versionsArray;
        String versionsString = this.requestReader.readLine();
        if (versionsString == null) {
            return false;
        }
        String versionsPattern = "VERSIONS ";
        if (!versionsString.startsWith(versionsPattern)) {
            if (this.err != null) {
                this.err.printf("Protocol error, expected %s, got %s\n", versionsPattern, versionsString);
            }
            return false;
        }
        for (String v : versionsArray = versionsString.substring(versionsPattern.length()).split(" ")) {
            if (v.length() != 1) {
                if (this.err != null) {
                    this.err.printf("Protocol error: incorrect version format: %s\n", versionsString);
                }
                return false;
            }
            if (v.charAt(0) != version) continue;
            return true;
        }
        return true;
    }

    boolean init() throws IOException {
        char version;
        char c = version = USE_TIMESTAMPS ? (char)'4' : '3';
        if (!this.checkVersion(version)) {
            return false;
        }
        this.logger.log(Level.FINE, "Initialization. Version=%c", Character.valueOf(version));
        if (CHECK_ALIVE && !ProcessUtils.isAlive((Process)this.remoteControllerProcess)) {
            if (this.err != null) {
                this.err.printf("Process exited unexpectedly when initializing\n", new Object[0]);
            }
            return false;
        }
        this.responseStream.printf("VERSION=%c\n", Character.valueOf(version));
        this.responseStream.flush();
        long time = System.currentTimeMillis();
        long timeTotal = System.currentTimeMillis();
        ArrayList<FileGatheringInfo> filesToFeed = new ArrayList<FileGatheringInfo>(512);
        HashSet<File> topDirs = new HashSet<File>();
        for (File file : this.files) {
            if ((file = CndFileUtils.normalizeFile((File)file)).isDirectory()) {
                String toRemoteFilePathName = this.mapper.getRemotePath(file.getAbsolutePath());
                RfsLocalController.addFileGatheringInfo(filesToFeed, file, toRemoteFilePathName);
                File[] children = file.listFiles(this.filter);
                if (children != null) {
                    for (File child : children) {
                        RfsLocalController.gatherFiles(child, toRemoteFilePathName, this.filter, filesToFeed);
                    }
                }
                topDirs.add(file);
                continue;
            }
            File parentFile = file.getAbsoluteFile().getParentFile();
            String toRemoteFilePathName = this.mapper.getRemotePath(parentFile.getAbsolutePath());
            if (!topDirs.contains(parentFile)) {
                topDirs.add(parentFile);
                RfsLocalController.addFileGatheringInfo(filesToFeed, parentFile, toRemoteFilePathName);
            }
            RfsLocalController.gatherFiles(file, toRemoteFilePathName, this.filter, filesToFeed);
        }
        Collection<File> parents = this.gatherParents(topDirs);
        for (File file : parents) {
            file = CndFileUtils.normalizeFile((File)file);
            String toRemoteFilePathName = this.mapper.getRemotePath(file.getAbsolutePath());
            RfsLocalController.addFileGatheringInfo(filesToFeed, file, toRemoteFilePathName);
        }
        this.logger.log(Level.FINE, "gathered %d files in %d ms", filesToFeed.size(), System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        this.checkLinks(filesToFeed);
        this.logger.log(Level.FINE, "checking links took %d ms", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        Collections.sort(filesToFeed, new Comparator<FileGatheringInfo>(){

            @Override
            public int compare(FileGatheringInfo f1, FileGatheringInfo f2) {
                if (f1.file.isDirectory() || f2.file.isDirectory()) {
                    if (f1.file.isDirectory() && f2.file.isDirectory()) {
                        return f1.remotePath.compareTo(f2.remotePath);
                    }
                    return f1.file.isDirectory() ? -1 : 1;
                }
                long delta = f1.file.lastModified() - f2.file.lastModified();
                return delta == 0L ? 0 : (delta < 0L ? -1 : 1);
            }
        });
        this.logger.log(Level.FINE, "sorting file list took %d ms", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (FileGatheringInfo info : filesToFeed) {
            try {
                this.sendFileInitRequest(info);
            }
            catch (IOException ex) {
                if (this.err != null) {
                    this.err.printf("Process exited unexpectedly while file info was being sent\n", new Object[0]);
                }
                return false;
            }
        }
        if (CHECK_ALIVE && !ProcessUtils.isAlive((Process)this.remoteControllerProcess)) {
            if (this.err != null) {
                this.err.printf("Process exited unexpectedly\n", new Object[0]);
            }
            return false;
        }
        this.responseStream.printf("\n", new Object[0]);
        this.responseStream.flush();
        this.logger.log(Level.FINE, "sending file list took %d ms", System.currentTimeMillis() - time);
        try {
            time = System.currentTimeMillis();
            this.readFileInitResponse();
            this.logger.log(Level.FINE, "reading initial response took %d ms", System.currentTimeMillis() - time);
        }
        catch (IOException ex) {
            this.err.printf("%s\n", ex.getMessage());
            return false;
        }
        this.fileData.store();
        if (!this.initNewFilesDiscovery()) {
            return false;
        }
        this.logger.log(Level.FINE, "the entire initialization took %d ms", System.currentTimeMillis() - timeTotal);
        return true;
    }

    private Collection<File> gatherParents(Collection<File> files) {
        HashSet<File> parents = new HashSet<File>();
        for (File file : files) {
            this.gatherParents(file, parents);
        }
        return parents;
    }

    private void gatherParents(File file, Set<File> parents) {
        File parent = file.getAbsoluteFile().getParentFile();
        if (parent != null && parent.getParentFile() != null) {
            parents.add(parent);
            this.gatherParents(parent, parents);
        }
    }

    private void checkLinks(List<FileGatheringInfo> filesToFeed) {
        if (Utilities.isWindows()) {
            return;
        }
        int cnt = 0;
        int max = 16;
        Collection<FileGatheringInfo> filesToCheck = new ArrayList<FileGatheringInfo>(filesToFeed);
        while (!(filesToCheck = this.checkLinks(filesToCheck, filesToFeed)).isEmpty() && cnt++ < 16) {
        }
        this.logger.log(Level.FINE, "checkLinks done in %d passes", cnt);
        if (!filesToCheck.isEmpty()) {
            this.logger.log(Level.INFO, "checkLinks exited by count. Cyclic symlinks?", new Object[0]);
        }
    }

    private Collection<FileGatheringInfo> checkLinks(final Collection<FileGatheringInfo> filesToCheck, List<FileGatheringInfo> filesToAdd) {
        NativeProcess process;
        HashSet<FileGatheringInfo> addedInfos = new HashSet<FileGatheringInfo>();
        NativeProcessBuilder pb = NativeProcessBuilder.newLocalProcessBuilder();
        pb.setExecutable("sh");
        pb.setArguments(new String[]{"-c", "xargs ls -ld | grep '^l'"});
        try {
            process = pb.call();
        }
        catch (IOException ex) {
            this.logger.log(Level.INFO, "Error when checking links: %s", ex.getMessage());
            return addedInfos;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedWriter requestWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                try {
                    for (FileGatheringInfo info : filesToCheck) {
                        String path = "\"" + info.file.getAbsolutePath() + "\"";
                        requestWriter.append(path);
                        requestWriter.newLine();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        requestWriter.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){
            private final BufferedReader errorReader;
            {
                this.errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String errLine = this.errorReader.readLine();
                    while (errLine != null) {
                        RfsLocalController.this.logger.log(Level.INFO, errLine, new Object[0]);
                        errLine = this.errorReader.readLine();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        this.errorReader.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        HashMap<String, FileGatheringInfo> map = new HashMap<String, FileGatheringInfo>(filesToCheck.size());
        for (FileGatheringInfo info : filesToCheck) {
            map.put(info.file.getAbsolutePath(), info);
        }
        BufferedReader outputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            boolean errorReported = false;
            String line = outputReader.readLine();
            while (line != null) {
                String localLinkTarget;
                String[] parts = line.split(" +");
                if (parts.length <= 4 && !errorReported) {
                    errorReported = true;
                    this.logger.log(Level.WARNING, "Unexpected ls output: %s", line);
                }
                if ((localLinkTarget = parts[parts.length - 1]).endsWith("/")) {
                    localLinkTarget = localLinkTarget.substring(0, localLinkTarget.length() - 1);
                }
                String linkPath = parts[parts.length - 3];
                FileGatheringInfo info = (FileGatheringInfo)map.get(linkPath);
                CndUtils.assertNotNull((Object)info, (String)("Null FileGatheringInfo for " + linkPath));
                if (info != null) {
                    File localLinkTargetFile;
                    this.logger.log(Level.FINEST, "\tcheckLinks: %s -> %s", linkPath, localLinkTarget);
                    File linkParentFile = CndFileUtils.createLocalFile((String)linkPath).getParentFile();
                    if (CndPathUtilitities.isPathAbsolute((CharSequence)localLinkTarget)) {
                        String remoteLinkTarget = this.mapper.getRemotePath(localLinkTarget, false);
                        info.setLinkTarget(remoteLinkTarget);
                        localLinkTargetFile = CndFileUtils.createLocalFile((String)localLinkTarget);
                    } else {
                        info.setLinkTarget(localLinkTarget);
                        localLinkTargetFile = CndFileUtils.createLocalFile((File)linkParentFile, (String)localLinkTarget);
                    }
                    localLinkTargetFile = CndFileUtils.normalizeFile((File)localLinkTargetFile);
                    FileGatheringInfo targetInfo = (FileGatheringInfo)map.get(localLinkTargetFile.getAbsolutePath());
                    if (targetInfo == null) {
                        String remotePath = this.mapper.getRemotePath(localLinkTargetFile.getAbsolutePath(), false);
                        targetInfo = RfsLocalController.addFileGatheringInfo(filesToAdd, localLinkTargetFile, remotePath);
                        addedInfos.add(targetInfo);
                    }
                }
                line = outputReader.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return addedInfos;
    }

    private void readFileInitResponse() throws IOException {
        String request;
        while ((request = this.requestReader.readLine()) != null && request.length() != 0) {
            if (request.length() < 3) {
                throw new IllegalArgumentException("Protocol error: " + request);
            }
            if (request.startsWith("*")) {
                char charState = request.charAt(1);
                FileState state = FileState.fromId(charState);
                if (state == null) {
                    throw new IllegalArgumentException("Protocol error: unexpected state: '" + charState + "'");
                }
                String remotePath = request.substring(2);
                String remoteCanonicalPath = this.requestReader.readLine();
                if (remoteCanonicalPath == null) {
                    throw new IllegalArgumentException("Protocol error: no canoical path for " + remotePath);
                }
                String localFilePath = this.mapper.getLocalPath(remotePath);
                if (localFilePath != null) {
                    this.canonicalToAbsolute.put(remoteCanonicalPath, remotePath);
                    File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                    this.fileData.setState(localFile, state);
                    continue;
                }
                this.logger.log(Level.FINEST, "ERROR no local file for %s", remotePath);
                continue;
            }
            if (request.length() < 3 || !request.startsWith("t ")) {
                throw new IllegalArgumentException("Protocol error: " + request);
            }
            String remoteFile = request.substring(2);
            String localFilePath = this.mapper.getLocalPath(remoteFile);
            if (localFilePath != null) {
                File localFile = CndFileUtils.createLocalFile((String)localFilePath);
                this.fileData.setState(localFile, FileState.TOUCHED);
                continue;
            }
            this.logger.log(Level.FINEST, "ERROR no local file for %s", remoteFile);
        }
    }

    private void sendFileInitRequest(FileGatheringInfo fgi) throws IOException {
        block10: {
            FileState newState;
            String remotePath;
            File file;
            block13: {
                block12: {
                    block11: {
                        block9: {
                            if (CHECK_ALIVE && !ProcessUtils.isAlive((Process)this.remoteControllerProcess)) {
                                throw new IOException("process already exited");
                            }
                            if (!fgi.isLink()) break block9;
                            this.responseStream.printf("L %s\n%s\n", fgi.remotePath, fgi.getLinkTarget());
                            break block10;
                        }
                        if (!fgi.file.isDirectory()) break block11;
                        this.responseStream.printf("D %s\n", fgi.remotePath);
                        this.responseStream.flush();
                        break block10;
                    }
                    file = fgi.file;
                    remotePath = fgi.remotePath;
                    FileData.FileInfo info = this.fileData.getFileInfo(file);
                    if (!file.exists()) break block12;
                    switch (info == null ? FileState.INITIAL : info.state) {
                        case COPIED: 
                        case TOUCHED: {
                            newState = info.timestamp == file.lastModified() ? info.state : FileState.INITIAL;
                            break block13;
                        }
                        case ERROR: 
                        case INITIAL: {
                            newState = FileState.INITIAL;
                            break block13;
                        }
                        case UNCONTROLLED: 
                        case INEXISTENT: {
                            newState = info.state;
                            break block13;
                        }
                        default: {
                            CndUtils.assertTrue((boolean)false, (String)("Unexpected state: " + (Object)((Object)info.state)));
                            return;
                        }
                    }
                }
                newState = FileState.INEXISTENT;
            }
            CndUtils.assertTrue((newState == FileState.INITIAL || newState == FileState.COPIED || newState == FileState.TOUCHED || newState == FileState.UNCONTROLLED || newState == FileState.INEXISTENT ? 1 : 0) != 0, (String)"State shouldn't be ", (Object)((Object)newState));
            if (USE_TIMESTAMPS) {
                long fileTime = file.lastModified();
                long seconds = fileTime / 1000L;
                long microseconds = fileTime % 1000L * 1000L;
                this.responseStream.printf("%c %d %d %d %s\n", Character.valueOf(newState.id), file.length(), seconds, microseconds, remotePath);
            } else {
                this.responseStream.printf("%c %d %s\n", Character.valueOf(newState.id), file.length(), remotePath);
            }
            this.responseStream.flush();
            if (newState == FileState.INITIAL) {
                newState = FileState.TOUCHED;
            }
            this.fileData.setState(file, newState);
        }
    }

    private static void gatherFiles(File file, String base, FileFilter filter, List<FileGatheringInfo> files) {
        String remotePath = RfsLocalController.isEmpty(base) ? file.getName() : base + '/' + file.getName();
        files.add(new FileGatheringInfo(file, remotePath));
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles(filter)) {
                String newBase = RfsLocalController.isEmpty(base) ? file.getName() : base + "/" + file.getName();
                RfsLocalController.gatherFiles(child, newBase, filter, files);
            }
        }
    }

    private static FileGatheringInfo addFileGatheringInfo(List<FileGatheringInfo> filesToFeed, File file, String remoteFilePathName) {
        FileGatheringInfo info = new FileGatheringInfo(file, remoteFilePathName);
        filesToFeed.add(info);
        return info;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static class FileGatheringInfo {
        public final File file;
        public final String remotePath;
        private String linkTarget;
        private FileGatheringInfo linkTargetInfo;

        public FileGatheringInfo(File file, String remotePath) {
            this.file = file;
            this.remotePath = remotePath;
            CndUtils.assertTrue((boolean)remotePath.startsWith("/"), (String)"Non-absolute remote path: ", (Object)remotePath);
            this.linkTarget = null;
        }

        public String toString() {
            return (this.isLink() ? "L " : (this.file.isDirectory() ? "D " : "F ")) + this.file.getPath() + " -> " + this.remotePath;
        }

        public boolean isLink() {
            return this.linkTarget != null;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public void setLinkTarget(String link) {
            this.linkTarget = link;
        }

        public FileGatheringInfo getLinkTargetInfo() {
            return this.linkTargetInfo;
        }

        public void setLinkTargetInfo(FileGatheringInfo linkTargetInfo) {
            this.linkTargetInfo = linkTargetInfo;
        }
    }

    private static enum RequestKind {
        REQUEST,
        WRITTEN,
        PING,
        UNKNOWN,
        KILLED;

    }
}

