/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.actions.NewTestActionFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.CompileSingleAction;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.NodeActionFactory;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RefreshableItemsContainer;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

final class ViewItemNode
extends FilterNode
implements ChangeListener {
    private static final MessageFormat ITEM_VIEW_FLAVOR = new MessageFormat("application/x-org-netbeans-modules-cnd-makeproject-uidnd; class=org.netbeans.modules.cnd.makeproject.ui.ViewItemNode; mask={0}");
    private RefreshableItemsContainer childrenKeys;
    private Folder folder;
    private Item item;
    private final MakeProject project;
    private static final Map<BufferedImage, Image> grayImageCache = new WeakHashMap<BufferedImage, Image>();

    public ViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, DataObject dataObject, MakeProject project) {
        super(dataObject.getNodeDelegate());
        this.childrenKeys = childrenKeys;
        this.folder = folder;
        this.item = item;
        this.setShortDescription(item.getNormalizedPath());
        this.project = project;
    }

    public void setName(String s) {
        super.setName(s.trim());
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Item getItem() {
        return this.item;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        return this.addViewItemTransferable(super.clipboardCopy(), 1);
    }

    public Transferable clipboardCut() throws IOException {
        return this.addViewItemTransferable(super.clipboardCut(), 2);
    }

    public Transferable drag() throws IOException {
        return this.addViewItemTransferable(super.drag(), 0);
    }

    private ExTransferable addViewItemTransferable(Transferable t, int operation) {
        try {
            ExTransferable extT = ExTransferable.create((Transferable)t);
            ViewItemTransferable viewItem = new ViewItemTransferable(this, operation);
            extT.put((ExTransferable.Single)viewItem);
            return extT;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void destroy() throws IOException {
        super.destroy();
        this.folder.removeItemAction(this.item);
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.getFolder();
        }
        if (valstring.equals("Project")) {
            return this.project;
        }
        if (valstring.equals("Item")) {
            return this.getItem();
        }
        if (valstring.equals("This")) {
            return this;
        }
        return super.getValue(valstring);
    }

    public Action[] getActions(boolean context) {
        Action[] oldActions = super.getActions(false);
        ArrayList<Action> newActions = new ArrayList<Action>();
        if (this.getItem().getFolder() == null) {
            return oldActions;
        }
        if (this.getItem().getFolder().isDiskFolder()) {
            for (int i = 0; i < oldActions.length; ++i) {
                String key = null;
                if (oldActions[i] != null) {
                    key = (String)oldActions[i].getValue("key");
                }
                if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                    newActions.add(oldActions[i]);
                    newActions.add(null);
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PasteAction) {
                    newActions.add(oldActions[i]);
                    newActions.add((Action)SystemAction.get(CompileSingleAction.class));
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                    newActions.add((Action)((Object)NodeActionFactory.createRenameAction()));
                    NodeActionFactory.addSyncActions(newActions);
                    continue;
                }
                if (key != null && key.equals("delete")) {
                    newActions.add((Action)((Object)NodeActionFactory.createDeleteAction()));
                    continue;
                }
                if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                    newActions.add((Action)SystemAction.get(PropertiesItemAction.class));
                    continue;
                }
                newActions.add(oldActions[i]);
            }
            return newActions.toArray(new Action[newActions.size()]);
        }
        for (int i = 0; i < oldActions.length; ++i) {
            String key = null;
            if (oldActions[i] != null) {
                key = (String)oldActions[i].getValue("key");
            }
            if (oldActions[i] != null && oldActions[i] instanceof OpenAction) {
                newActions.add(oldActions[i]);
                newActions.add(null);
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof PasteAction) {
                newActions.add(oldActions[i]);
                newActions.add((Action)SystemAction.get(CompileSingleAction.class));
                if (this.getItem().getFolder().isTest()) continue;
                newActions.add(NewTestActionFactory.createNewTestsSubmenu());
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof RenameAction) {
                newActions.add((Action)((Object)NodeActionFactory.createRenameAction()));
                NodeActionFactory.addSyncActions(newActions);
                continue;
            }
            if (oldActions[i] != null && oldActions[i] instanceof PropertiesAction && this.getFolder().isProjectFiles()) {
                newActions.add((Action)SystemAction.get(PropertiesItemAction.class));
                continue;
            }
            if (key != null && key.equals("delete")) {
                newActions.add((Action)SystemAction.get(RemoveItemAction.class));
                newActions.add((Action)((Object)NodeActionFactory.createDeleteAction()));
                continue;
            }
            newActions.add(oldActions[i]);
        }
        return newActions.toArray(new Action[newActions.size()]);
    }

    public Image getIcon(int type) {
        Image image = super.getIcon(type);
        if (this.isExcluded() && image instanceof BufferedImage) {
            image = ViewItemNode.getGrayImage((BufferedImage)image);
        }
        return image;
    }

    private static Image getGrayImage(BufferedImage image) {
        Image gray = grayImageCache.get(image);
        if (gray == null) {
            ColorSpace gray_space = ColorSpace.getInstance(1003);
            ColorConvertOp convert_to_gray_op = new ColorConvertOp(gray_space, null);
            gray = convert_to_gray_op.filter(image, null);
            grayImageCache.put(image, gray);
        }
        return gray;
    }

    public String getHtmlDisplayName() {
        if (this.isExcluded()) {
            String baseName = super.getHtmlDisplayName();
            if (baseName != null && baseName.toLowerCase().contains("color=")) {
                return baseName;
            }
            baseName = baseName != null ? baseName : this.getDisplayName();
            return "<font color='!controlShadow'>" + baseName;
        }
        return super.getHtmlDisplayName();
    }

    private boolean isExcluded() {
        if (this.item == null || this.item.getFolder() == null || this.item.getFolder().getConfigurationDescriptor() == null || this.item.getFolder().getConfigurationDescriptor().getConfs() == null) {
            return false;
        }
        MakeConfiguration makeConfiguration = this.item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = this.item.getItemConfiguration(makeConfiguration);
        if (itemConfiguration == null) {
            return false;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        return excl.getValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        EventQueue.invokeLater(new VisualUpdater());
    }

    static final class ViewItemTransferable
    extends ExTransferable.Single {
        private ViewItemNode node;

        public ViewItemTransferable(ViewItemNode node, int operation) throws ClassNotFoundException {
            super(new DataFlavor(ITEM_VIEW_FLAVOR.format(new Object[]{operation}), null, MakeLogicalViewProvider.class.getClassLoader()));
            this.node = node;
        }

        protected Object getData() throws IOException, UnsupportedFlavorException {
            return this.node;
        }
    }

    private class VisualUpdater
    implements Runnable {
        private VisualUpdater() {
        }

        @Override
        public void run() {
            ViewItemNode.this.fireIconChange();
            ViewItemNode.this.fireOpenedIconChange();
            String displayName = ViewItemNode.this.getDisplayName();
            ViewItemNode.this.fireDisplayNameChange(displayName, "");
            ViewItemNode.this.fireDisplayNameChange("", displayName);
        }
    }
}

