/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.ui.LogicalViewNodeProviders;
import org.netbeans.modules.cnd.makeproject.ui.BaseMakeViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.BrokenViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.ExternalFilesNode;
import org.netbeans.modules.cnd.makeproject.ui.LoadingNode;
import org.netbeans.modules.cnd.makeproject.ui.LogicalFolderNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;

class LogicalViewChildren
extends BaseMakeViewChildren
implements PropertyChangeListener {
    public LogicalViewChildren(Folder folder, MakeLogicalViewProvider provider) {
        super(folder, provider);
        if (folder != null && folder.isDiskFolder()) {
            MakeOptions.getInstance().addPropertyChangeListener(this);
        }
    }

    @Override
    protected void onFolderChange(Folder folder) {
        if (folder != null && folder.isDiskFolder()) {
            MakeOptions.getInstance().addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (property.equals("viewBinaryFiles")) {
            this.stateChanged(new ChangeEvent(this));
        }
    }

    protected Node[] createNodes(Object key) {
        Object node = null;
        if (key instanceof LoadingNode) {
            node = (Node)key;
        } else if (key instanceof Node) {
            node = (Node)key;
        } else if (key instanceof Folder) {
            Folder folder = (Folder)key;
            if (folder.isProjectFiles() || folder.isTestLogicalFolder() || folder.isTest()) {
                FileObject srcFileObject = this.getProject().getProjectDirectory();
                DataObject srcDataObject = null;
                try {
                    if (srcFileObject.isValid()) {
                        srcDataObject = DataObject.find((FileObject)srcFileObject);
                    }
                }
                catch (DataObjectNotFoundException e) {
                    // empty catch block
                }
                if (srcDataObject != null) {
                    node = new LogicalFolderNode(((DataFolder)srcDataObject).getNodeDelegate(), folder, this.provider);
                }
            } else {
                node = new ExternalFilesNode(folder, this.provider);
            }
        } else if (key instanceof Item) {
            Item item = (Item)key;
            DataObject fileDO = item.getDataObject();
            node = fileDO != null ? new ViewItemNode(this, this.getFolder(), item, fileDO, this.provider.getProject()) : new BrokenViewItemNode(this, this.getFolder(), item, this.provider.getProject());
        } else if (key instanceof AbstractNode) {
            node = (AbstractNode)key;
        }
        if (node == null) {
            return new Node[0];
        }
        return new Node[]{node};
    }

    @Override
    protected Collection<Object> getKeys() {
        LogicalViewNodeProvider[] providers;
        List<Object> collection;
        if (this.getFolder().isDiskFolder()) {
            FileObject[] children;
            ArrayList<Object> collection2 = new ArrayList<Object>(this.getFolder().getElements());
            FileObject fileObject = RemoteFileUtil.getFileObject((FileObject)this.getFolder().getConfigurationDescriptor().getBaseDirFileObject(), (String)this.getFolder().getRootPath());
            if (fileObject != null && fileObject.isValid() && fileObject.isFolder() && (children = fileObject.getChildren()) != null) {
                for (FileObject child : children) {
                    if (child == null || !child.isValid() || child.isFolder() || this.getFolder().findItemByName(child.getNameExt()) != null || !VisibilityQuery.getDefault().isVisible(child) || !this.getFolder().isTestLogicalFolder() && !MakeOptions.getInstance().getViewBinaryFiles() && CndFileVisibilityQuery.getDefault().isIgnored(child.getNameExt())) continue;
                    Item item = Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), child.getPath());
                    Folder.insertItemElementInList(collection2, item);
                }
            }
            collection = collection2;
        } else {
            collection = this.getFolder().getElements();
        }
        switch (this.getFolder().getConfigurationDescriptor().getState()) {
            case READING: {
                if (!collection.isEmpty()) break;
                collection = Collections.singletonList(new LoadingNode());
                break;
            }
        }
        if ("root".equals(this.getFolder().getName()) && (providers = LogicalViewNodeProviders.getInstance().getProvidersAsArray()).length > 0) {
            for (int i = 0; i < providers.length; ++i) {
                AbstractNode node = providers[i].getLogicalViewNode(this.provider.getProject());
                if (node == null) continue;
                collection.add(node);
            }
        }
        return collection;
    }
}

