/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.runprofiles.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.runprofiles.ui.ListTableModel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EnvPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener,
ListSelectionListener {
    private RunProfile currentProfile;
    private ListTableModel envvarModel = null;
    private JTable envvarTable = null;
    private Env env;
    private PropertyEditorSupport editor;
    private JButton addButton;
    private JPanel buttonPanel;
    private JLabel environmentLabel;
    private JPanel environmentPanel;
    private JScrollPane envvarScrollPane;
    private JButton removeButton;
    private ResourceBundle bundle;

    public EnvPanel(Env env, PropertyEditorSupport editor, PropertyEnv propenv) {
        this.initComponents();
        this.env = env;
        this.editor = editor;
        this.envvarScrollPane.getViewport().setBackground(Color.WHITE);
        this.envvarModel = new ListTableModel(this.getString("EnvName"), this.getString("EnvValue"));
        this.envvarTable = new JTable(this.envvarModel);
        this.envvarModel.setTable(this.envvarTable);
        this.envvarScrollPane.setViewportView(this.envvarTable);
        this.initValues(env);
        propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propenv.addPropertyChangeListener((PropertyChangeListener)this);
        this.environmentLabel.setLabelFor(this.envvarTable);
        this.envvarTable.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_ENV_VAR_TABLE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_ADD_BUTTON"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getString("ACSD_REMOVE_BUTTON"));
        this.envvarTable.getSelectionModel().addListSelectionListener(this);
        this.validateButtons();
    }

    private void validateButtons() {
        int[] selRows = this.envvarTable.getSelectedRows();
        this.removeButton.setEnabled(this.envvarModel.getRowCount() > 0 && selRows != null && selRows.length > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.validateButtons();
    }

    public void initValues(Env env) {
        String[][] envvars = env.getenvAsPairs();
        if (envvars != null) {
            int n = envvars.length;
            ArrayList<String> col0 = new ArrayList<String>(n + 3);
            ArrayList<String> col1 = new ArrayList<String>(n + 3);
            for (int i = 0; i < n; ++i) {
                col0.add(envvars[i][0]);
                col1.add(envvars[i][1]);
            }
            this.envvarModel.setData(n, col0, col1);
        }
        this.initFocus();
    }

    public void initFocus() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Environment");
    }

    private void initComponents() {
        this.environmentPanel = new JPanel();
        this.environmentLabel = new JLabel();
        this.envvarScrollPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.environmentPanel.setLayout(new GridBagLayout());
        this.environmentLabel.setLabelFor(this.envvarScrollPane);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/runprofiles/ui/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.environmentLabel, (String)bundle.getString("ENVIRONMENT_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.environmentPanel.add((Component)this.environmentLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.environmentPanel.add((Component)this.envvarScrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("ADD_BUTTON"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnvPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("REMOVE_BUTTON"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnvPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.environmentPanel.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.environmentPanel, gridBagConstraints);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selRows = this.envvarTable.getSelectedRows();
        if (selRows != null && selRows.length > 0) {
            this.envvarModel.removeRows(selRows);
        }
        this.validateButtons();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.envvarModel.addRow();
        this.validateButtons();
    }

    private Object getPropertyValue() throws IllegalStateException {
        this.env.removeAll();
        int numRows = this.envvarModel.getRowCount();
        if (numRows > 0) {
            for (int j = 0; j < numRows; ++j) {
                String name = ((String)this.envvarModel.getValueAt(j, 0)).trim();
                if (name.length() == 0) continue;
                String value = ((String)this.envvarModel.getValueAt(j, 1)).trim();
                this.env.putenv(name, value);
            }
        }
        return this.env;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(EnvPanel.class);
        }
        return this.bundle.getString(s);
    }
}

