/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.RequestProcessor;

public enum ConnectionHelper implements ConnectionListener
{
    INSTANCE;

    private final RequestProcessor RP = new RequestProcessor("Check connection", 4);
    private final Set<ExecutionEnvironment> storage = new HashSet<ExecutionEnvironment>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private ConnectionHelper() {
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureConnection(final ExecutionEnvironment env) {
        if (env != null && env.isRemote()) {
            ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
            try {
                readLock.lock();
                if (this.storage.contains(env)) {
                    return;
                }
            }
            finally {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                if (this.storage.contains(env)) {
                    return;
                }
                this.storage.add(env);
                this.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConnectionManager.getInstance().connectTo(env);
                            ServerRecord rec = ServerList.get((ExecutionEnvironment)env);
                            if (rec != null) {
                                rec.checkSetupAfterConnection(null);
                            }
                        }
                        catch (IOException ex) {
                        }
                        catch (ConnectionManager.CancellationException cancellationException) {
                            // empty catch block
                        }
                    }
                });
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(ExecutionEnvironment env) {
        if (env != null && env.isRemote()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                this.storage.add(env);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(ExecutionEnvironment env) {
        if (env != null && env.isRemote()) {
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                this.storage.remove(env);
            }
            finally {
                writeLock.unlock();
            }
        }
    }
}

