/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.ui.actions.LogInAction;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.actions.ProjectAssociationAction;
import org.netbeans.modules.hudson.ui.actions.StartJobAction;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.nodes.Bundle;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobBuildNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonWorkspaceNode;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class HudsonJobNode
extends AbstractNode {
    private String htmlDisplayName;
    private HudsonJob job;

    public HudsonJobNode(HudsonJob job) {
        super(HudsonJobNode.makeChildren(job), Lookups.singleton((Object)job));
        this.setName(job.getName());
        this.setHudsonJob(job);
    }

    private static Children makeChildren(final HudsonJob job) {
        if (job.getColor() == HudsonJob.Color.secured) {
            return Children.LEAF;
        }
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object WORKSPACE = new Object();
            LinkedList<HudsonJobBuild> builds;

            protected boolean createKeys(List<Object> toPopulate) {
                if (Thread.interrupted()) {
                    return true;
                }
                if (this.builds == null) {
                    toPopulate.add(this.WORKSPACE);
                    this.builds = new LinkedList<HudsonJobBuild>(job.getBuilds());
                    return false;
                }
                if (this.builds.isEmpty()) {
                    return true;
                }
                HudsonJobBuild b = this.builds.removeFirst();
                b.getResult();
                toPopulate.add(b);
                return false;
            }

            protected Node createNodeForKey(Object key) {
                if (key == this.WORKSPACE) {
                    return new HudsonWorkspaceNode(job);
                }
                return new HudsonJobBuildNode((HudsonJobBuild)key);
            }
        }, (boolean)true);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean context) {
        if (this.job.getColor() == HudsonJob.Color.secured) {
            return new Action[]{new LogInAction((HudsonInstanceImpl)this.job.getInstance())};
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(SystemAction.get(StartJobAction.class));
        actions.add(new ProjectAssociationAction(this.job));
        actions.add(null);
        if (this.job instanceof OpenableInBrowser) {
            actions.add(OpenUrlAction.forOpenable((OpenableInBrowser)((Object)this.job)));
        }
        actions.add(SystemAction.get(PropertiesAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        s.put(((HudsonJobImpl)this.job).getSheetSet());
        return s;
    }

    private void setHudsonJob(HudsonJob job) {
        this.job = job;
        HudsonJob.Color color = job.getColor();
        this.setShortDescription(job.getUrl());
        this.setIconBaseWithExtension(color.iconBase());
        String oldHtmlDisplayName = this.getHtmlDisplayName();
        try {
            this.htmlDisplayName = color.colorizeDisplayName(XMLUtil.toElementContent((String)job.getDisplayName()));
        }
        catch (CharConversionException ex) {
            assert (false) : ex;
            return;
        }
        if (!job.isSalient()) {
            // empty if block
        }
        if (color.isRunning()) {
            this.htmlDisplayName = this.htmlDisplayName + " <font color='!controlShadow'>" + Bundle.HudsonJobNode_running() + "</font>";
        }
        if (color == HudsonJob.Color.secured) {
            this.htmlDisplayName = this.htmlDisplayName + " <font color='!controlShadow'>" + Bundle.HudsonJobNode_secured() + "</font>";
        }
        if (job.isInQueue()) {
            this.htmlDisplayName = this.htmlDisplayName + " <font color='!controlShadow'>" + Bundle.HudsonJobNode_in_queue() + "</font>";
        }
        this.fireDisplayNameChange(oldHtmlDisplayName, this.htmlDisplayName);
    }
}

