/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonInstanceProperties;
import org.netbeans.modules.hudson.impl.ProjectHIP;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class HudsonManagerImpl {
    private static final RequestProcessor RP = new RequestProcessor(HudsonManagerImpl.class);
    private static HudsonManagerImpl defaultInstance;
    private Map<String, HudsonInstanceImpl> instances;
    private final List<HudsonChangeListener> listeners = new ArrayList<HudsonChangeListener>();
    private PropertyChangeListener projectsListener;
    private Map<Project, HudsonInstanceImpl> projectInstances = new HashMap<Project, HudsonInstanceImpl>();
    private final RequestProcessor.Task checkOpenProjects = RP.create(new Runnable(){

        @Override
        public void run() {
            HudsonManagerImpl.this.checkOpenProjects();
        }
    });

    private HudsonManagerImpl() {
        this.projectsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("openProjects".equals(evt.getPropertyName())) {
                    HudsonManagerImpl.this.checkOpenProjects.schedule(0);
                }
            }
        };
    }

    public static synchronized HudsonManagerImpl getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new HudsonManagerImpl();
        }
        return defaultInstance;
    }

    public HudsonInstanceImpl addInstance(final HudsonInstanceImpl instance) {
        if (null == instance || null != this.getInstancesMap().get(instance.getUrl())) {
            return null;
        }
        if (null != this.getInstancesMap().put(instance.getUrl(), instance)) {
            return null;
        }
        this.fireChangeListeners();
        instance.storeDefinition();
        instance.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                instance.storeDefinition();
            }
        });
        return instance;
    }

    public HudsonInstanceImpl removeInstance(HudsonInstanceImpl instance) {
        if (null == instance || null == this.getInstancesMap().get(instance.getUrl())) {
            return null;
        }
        if (null == this.getInstancesMap().remove(instance.getUrl())) {
            return null;
        }
        instance.terminate();
        this.fireChangeListeners();
        if (instance.isPersisted()) {
            this.removeInstanceDefinition(instance);
        }
        return instance;
    }

    public HudsonInstanceImpl getInstance(String url) {
        return this.getInstancesMap().get(url);
    }

    public synchronized Collection<HudsonInstanceImpl> getInstances() {
        return Arrays.asList(this.getInstancesMap().values().toArray(new HudsonInstanceImpl[0]));
    }

    public HudsonInstance getInstanceByName(String name) {
        for (HudsonInstanceImpl h : this.getInstances()) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public void addHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.add(l);
    }

    public void removeHudsonChangeListener(HudsonChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListeners() {
        ArrayList<HudsonChangeListener> tempList;
        List<HudsonChangeListener> list = this.listeners;
        synchronized (list) {
            tempList = new ArrayList<HudsonChangeListener>(this.listeners);
        }
        for (HudsonChangeListener l : tempList) {
            l.stateChanged();
            l.contentChanged();
        }
    }

    public void terminate() {
        defaultInstance = null;
        OpenProjects.getDefault().removePropertyChangeListener(this.projectsListener);
        this.projectInstances.clear();
        for (HudsonInstanceImpl instance : this.getInstances()) {
            instance.terminate();
        }
    }

    static Preferences instancePrefs() {
        return NbPreferences.forModule(HudsonManagerImpl.class).node("instances");
    }

    public static String simplifyServerLocation(String name, boolean forKey) {
        String display = name.replaceFirst("https?://", "").replaceFirst("/$", "");
        return forKey ? display.replaceAll("[/:]", "_") : display;
    }

    private void removeInstanceDefinition(HudsonInstanceImpl instance) {
        try {
            instance.prefs().removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Map<String, HudsonInstanceImpl> getInstancesMap() {
        if (null == this.instances) {
            this.instances = new HashMap<String, HudsonInstanceImpl>();
            this.init();
        }
        return this.instances;
    }

    private void init() {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        for (String kid : HudsonManagerImpl.instancePrefs().childrenNames()) {
                            Preferences node = HudsonManagerImpl.instancePrefs().node(kid);
                            HashMap<String, String> m = new HashMap<String, String>();
                            for (String k : node.keys()) {
                                m.put(k, node.get(k, null));
                            }
                            if (!m.containsKey("name") || !m.containsKey("url") || !m.containsKey("sync_time")) continue;
                            HudsonInstanceImpl.createHudsonInstance(new HudsonInstanceProperties((Map<String, String>)m), false);
                        }
                    }
                    catch (BackingStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                finally {
                    HudsonManagerImpl.this.checkOpenProjects();
                    OpenProjects.getDefault().addPropertyChangeListener(HudsonManagerImpl.this.projectsListener);
                    HudsonManagerImpl.this.fireChangeListeners();
                }
            }
        });
    }

    private void checkOpenProjects() {
        try {
            Project[] prjs;
            Future fut = OpenProjects.getDefault().openProjects();
            for (Project project : prjs = (Project[])fut.get()) {
                HudsonInstanceImpl remove;
                ProjectHudsonProvider.Association assoc;
                boolean exists = false;
                if (this.projectInstances.containsKey(project)) {
                    exists = true;
                }
                if ((assoc = ProjectHudsonProvider.getDefault().findAssociation(project)) != null && !exists) {
                    ProjectHIP props;
                    String url = assoc.getServerUrl();
                    HudsonInstanceImpl in = this.getInstance(url);
                    if (in != null && in.getProperties() instanceof ProjectHIP) {
                        props = (ProjectHIP)in.getProperties();
                        props.addProvider(project);
                        this.projectInstances.put(project, in);
                        continue;
                    }
                    if (in != null) continue;
                    props = new ProjectHIP();
                    props.addProvider(project);
                    this.addInstance(HudsonInstanceImpl.createHudsonInstance(props, false));
                    HudsonInstanceImpl impl = this.getInstance((String)props.get("url"));
                    this.projectInstances.put(project, impl);
                    continue;
                }
                if (assoc != null || !exists || (remove = this.projectInstances.remove(project)) == null || !(remove.getProperties() instanceof ProjectHIP)) continue;
                ProjectHIP props = (ProjectHIP)remove.getProperties();
                props.removeProvider(project);
                if (!props.getProviders().isEmpty()) continue;
                this.removeInstance(remove);
            }
            ArrayList<Project> newprjs = new ArrayList<Project>(this.projectInstances.keySet());
            newprjs.removeAll(Arrays.asList(prjs));
            for (Project project : newprjs) {
                HudsonInstanceImpl remove = this.projectInstances.remove(project);
                if (remove == null || !(remove.getProperties() instanceof ProjectHIP)) continue;
                ProjectHIP props = (ProjectHIP)remove.getProperties();
                props.removeProvider(project);
                if (!props.getProviders().isEmpty()) continue;
                this.removeInstance(remove);
            }
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

