/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonConnector;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HudsonJobBuildImpl
implements HudsonJobBuild,
OpenableInBrowser {
    private static final Logger LOG = Logger.getLogger(HudsonJobBuildImpl.class.getName());
    private final HudsonJobImpl job;
    private final int build;
    private boolean building;
    private HudsonJobBuild.Result result;
    private final HudsonConnector connector;
    private Collection<? extends HudsonJobChangeItem> changes;

    HudsonJobBuildImpl(HudsonConnector connector, HudsonJobImpl job, int build, boolean building, HudsonJobBuild.Result result) {
        this.connector = connector;
        this.job = job;
        this.build = build;
        this.building = building;
        this.result = result;
    }

    @Override
    public HudsonJob getJob() {
        return this.job;
    }

    @Override
    public int getNumber() {
        return this.build;
    }

    @Override
    public String getUrl() {
        return this.job.getUrl() + this.build + "/";
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public boolean isBuilding() {
        this.getResult();
        return this.building;
    }

    @Override
    public synchronized HudsonJobBuild.Result getResult() {
        if (this.result == null && !this.building) {
            AtomicBoolean _building = new AtomicBoolean();
            AtomicReference<HudsonJobBuild.Result> _result = new AtomicReference<HudsonJobBuild.Result>(HudsonJobBuild.Result.NOT_BUILT);
            this.connector.loadResult(this, _building, _result);
            this.building = _building.get();
            this.result = _result.get();
        }
        return this.result;
    }

    @Override
    public Collection<? extends HudsonJobChangeItem> getChanges() {
        if (this.changes == null || this.changes.isEmpty()) {
            for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                this.changes = scm.parseChangeSet(this);
                if (this.changes == null) continue;
                break;
            }
            if (this.changes == null) {
                this.changes = this.parseChangeSetGeneric();
            }
        }
        return this.changes;
    }

    @Override
    public FileSystem getArtifacts() {
        return this.job.getInstance().getArtifacts(this);
    }

    @Override
    public Collection<? extends HudsonMavenModuleBuild> getMavenModules() {
        ArrayList<HudsonMavenModuleBuildImpl> modules = new ArrayList<HudsonMavenModuleBuildImpl>();
        for (HudsonJobImpl.HudsonMavenModule module : this.job.mavenModules) {
            modules.add(new HudsonMavenModuleBuildImpl(module));
        }
        return modules;
    }

    @Override
    public String getDisplayName() {
        return Bundle.HudsonJobBuildImpl_display_name(this.job.getDisplayName(), this.getNumber());
    }

    private Collection<? extends HudsonJobChangeItem> parseChangeSetGeneric() {
        Element changeSet;
        try {
            changeSet = XMLUtil.findElement((Element)new ConnectionBuilder().job(this.job).url(this.getUrl() + "api/xml?tree=changeSet[items[author[fullName],msg,affectedFile[path,editType]]]").parseXML().getDocumentElement(), (String)"changeSet", null);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "could not parse changelog for {0}: {1}", new Object[]{this, x});
            return Collections.emptyList();
        }
        class Item
        implements HudsonJobChangeItem {
            final Element itemXML;

            Item(Element itemXML) {
                this.itemXML = itemXML;
            }

            @Override
            public String getUser() {
                return Utilities.xpath("author/fullName", this.itemXML);
            }

            @Override
            public String getMessage() {
                return Utilities.xpath("msg", this.itemXML);
            }

            @Override
            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                class AffectedFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final Element fileXML;

                    AffectedFile(Element fileXML) {
                        this.fileXML = fileXML;
                    }

                    @Override
                    public String getName() {
                        return Utilities.xpath("path", this.fileXML);
                    }

                    @Override
                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return HudsonJobChangeItem.HudsonJobChangeFile.EditType.valueOf(Utilities.xpath("editType", this.fileXML));
                    }

                    @Override
                    public OutputListener hyperlink() {
                        return null;
                    }
                }
                ArrayList<AffectedFile> files = new ArrayList<AffectedFile>();
                NodeList nl = this.itemXML.getElementsByTagName("affectedFile");
                for (int i = 0; i < nl.getLength(); ++i) {
                    files.add(new AffectedFile((Element)nl.item(i)));
                }
                return files;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>();
        NodeList nl = changeSet.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            items.add(new Item((Element)nl.item(i)));
        }
        return items;
    }

    private final class HudsonMavenModuleBuildImpl
    implements HudsonMavenModuleBuild,
    OpenableInBrowser {
        private final HudsonJobImpl.HudsonMavenModule module;

        HudsonMavenModuleBuildImpl(HudsonJobImpl.HudsonMavenModule module) {
            this.module = module;
        }

        @Override
        public String getName() {
            return this.module.name;
        }

        @Override
        public String getDisplayName() {
            return this.module.displayName;
        }

        @Override
        public HudsonJob.Color getColor() {
            return this.module.color;
        }

        @Override
        public String getUrl() {
            return this.module.url + HudsonJobBuildImpl.this.build + "/";
        }

        @Override
        public HudsonJobBuild getBuild() {
            return HudsonJobBuildImpl.this;
        }

        @Override
        public FileSystem getArtifacts() {
            return HudsonJobBuildImpl.this.job.getInstance().getArtifacts(this);
        }

        public String toString() {
            return this.getUrl();
        }

        @Override
        public String getBuildDisplayName() {
            return Bundle.HudsonJobBuildImpl_display_name(this.getDisplayName(), HudsonJobBuildImpl.this.getNumber());
        }
    }
}

