/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categorization.api;

import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.categorization.api.Categorization;
import org.netbeans.modules.profiler.categorization.api.Category;
import org.netbeans.modules.profiler.categorization.api.CategoryBuilder;
import org.netbeans.modules.profiler.categorization.api.CategoryContainer;
import org.netbeans.modules.profiler.categorization.spi.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.Lookup;

public final class ProjectCategorization
extends Categorization {
    private Lookup.Provider project;

    public ProjectCategorization(Lookup.Provider project) {
        this.project = project;
    }

    @Override
    protected void buildCategories(CategoryContainer root) {
        for (CategoryBuilder builder : this.project.getLookup().lookupAll(CategoryBuilder.class)) {
            root.addAll(builder.getRootCategory().getSubcategories());
        }
    }

    @Override
    public boolean isAvailable() {
        return ProjectCategorization.isAvailable(this.project);
    }

    public static boolean isAvailable(Lookup.Provider project) {
        if (project == null) {
            return false;
        }
        return project.getLookup().lookup(CategoryBuilder.class) != null;
    }

    public MarkMapping[] getMappings() {
        CategoryDefinitionProcessor mp = (CategoryDefinitionProcessor)this.project.getLookup().lookup(CategoryDefinitionProcessor.class);
        if (mp != null) {
            this.getRoot().accept((Visitor)new Visitor<Visitable<Category>, Void, CategoryDefinitionProcessor>(){

                public Void visit(Visitable<Category> visitable, CategoryDefinitionProcessor parameter) {
                    ((Category)visitable.getValue()).processDefinitionsWith(parameter);
                    return null;
                }
            }, mp);
            return ((Marker)mp).getMappings();
        }
        return new MarkMapping[0];
    }
}

