/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.netbeans.modules.java.source.ant.CheckForCleanBuilds;
import org.netbeans.modules.java.source.ant.UserCancel;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.spi.project.support.ant.PropertyUtils;

public class JavacTask
extends Javac {
    private static final String CLASS_ZIP_FILE_INDEX = "com.sun.tools.javac.zip.ZipFileIndex";
    private static final String METHOD_CLOSE = "clearCache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        boolean ensureBuilt;
        Project p = this.getProject();
        p.log("Overridden Javac task called", 4);
        boolean bl = ensureBuilt = p.getProperty("ensure.built.source.roots") != null || Boolean.valueOf(p.getProperty("deploy.on.save")) != false;
        if (ensureBuilt) {
            String[] srcdir = this.getSrcdir().list();
            boolean noBin = false;
            boolean wasBuilt = false;
            for (String path : srcdir) {
                File f = PropertyUtils.resolveFile((File)p.getBaseDir().getAbsoluteFile(), (String)path);
                try {
                    Boolean built = BuildArtifactMapperImpl.ensureBuilt((URL)f.toURI().toURL(), (Object)this.getProject(), (boolean)false, (boolean)true);
                    if (built == null) {
                        noBin = true;
                        if (!wasBuilt) continue;
                        throw new BuildException("Cannot build classfiles for source directories: " + Arrays.asList(srcdir));
                    }
                    wasBuilt = true;
                    if (noBin) {
                        throw new BuildException("Cannot build classfiles for source directories: " + Arrays.asList(srcdir));
                    }
                    if (built.booleanValue()) continue;
                    throw new UserCancel();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            if (!wasBuilt) {
                try {
                    super.execute();
                }
                finally {
                    JavacTask.cleanUp(p);
                }
            }
        } else {
            if (((Boolean)CheckForCleanBuilds.cleanBuild.get()).booleanValue() && this.getSrcdir() != null) {
                File apSources = null;
                Iterator<String> it = Arrays.asList(this.getCurrentCompilerArgs()).iterator();
                while (it.hasNext()) {
                    if (!"-s".equals(it.next()) || !it.hasNext()) continue;
                    apSources = PropertyUtils.resolveFile((File)p.getBaseDir().getAbsoluteFile(), (String)it.next());
                    break;
                }
                for (String path : this.getSrcdir().list()) {
                    File f = PropertyUtils.resolveFile((File)p.getBaseDir().getAbsoluteFile(), (String)path);
                    if (f.equals(apSources)) {
                        p.log("Not forcing rescan for AP source output: " + f.getAbsolutePath(), 3);
                        continue;
                    }
                    try {
                        p.log("Forcing rescan of: " + f.getAbsolutePath(), 3);
                        IndexingManager.getDefault().refreshIndex(f.toURI().toURL(), null, false);
                    }
                    catch (MalformedURLException ex) {
                        p.log(ex.getMessage(), (Throwable)ex, 3);
                    }
                }
            }
            try {
                super.execute();
            }
            finally {
                JavacTask.cleanUp(p);
            }
        }
    }

    private static void cleanUp(Project p) {
        try {
            p.log("Cleaning ZipFileIndex cache", 4);
            Class<?> zipFileIndex = Class.forName(CLASS_ZIP_FILE_INDEX);
            Method clean = zipFileIndex.getDeclaredMethod(METHOD_CLOSE, new Class[0]);
            clean.setAccessible(true);
            clean.invoke(null, new Object[0]);
            p.log("ZipFileIndex cache cleaned", 4);
        }
        catch (ClassNotFoundException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 3);
        }
        catch (NoSuchMethodException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 3);
        }
        catch (SecurityException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 1);
        }
        catch (InvocationTargetException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 1);
        }
        catch (IllegalArgumentException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 1);
        }
        catch (IllegalAccessException e) {
            p.log("ZipFileIndex clearCache failed", (Throwable)e, 1);
        }
    }
}

