/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.util.RequestProcessor;

public class RunCheckerImpl
implements LateBoundPrerequisitesChecker {
    private static final String ACTION_PROFILE = "profile";
    private static final String ACTION_PROFILE_SINGLE = "profile-single";
    private static final String ACTION_PROFILE_TESTS = "profile-tests";
    private static final String PROFILER_ARGS = "${profiler.args}";
    private static final String PROFILER_ARGS_PREFIXED = "${profiler.args.prefixed}";
    private static final String PROFILER_JAVA = "${profiler.java}";
    private static final String PROFILER_JDKHOME_OPT = "${profiler.jdkhome.opt}";
    private final Project project;
    private static final Map<Project, Properties> properties = new WeakHashMap<Project, Properties>();
    private static final Map<Project, ProfilingSettings> profilingSettings = new WeakHashMap<Project, ProfilingSettings>();
    private static final Map<Project, SessionSettings> sessionSettings = new WeakHashMap<Project, SessionSettings>();

    public RunCheckerImpl(Project prj) {
        this.project = prj;
    }

    static void configureProject(Project project, Properties p, ProfilingSettings ps, SessionSettings ss) {
        properties.put(project, p);
        profilingSettings.put(project, ps);
        sessionSettings.put(project, ss);
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        Map configProperties = config.getProperties();
        if (ACTION_PROFILE.equals(config.getActionName()) || ACTION_PROFILE_TESTS.equals(config.getActionName()) || config.getActionName() != null && config.getActionName().startsWith(ACTION_PROFILE_SINGLE)) {
            Properties sessionProperties = properties.get(this.project);
            if (sessionProperties == null) {
                return false;
            }
            for (String k : configProperties.keySet()) {
                File binJava;
                String agentArg;
                String key = k;
                String value = (String)configProperties.get(key);
                if (value.contains(PROFILER_ARGS)) {
                    agentArg = this.fixAgentArg(sessionProperties.getProperty("profiler.info.jvmargs.agent"));
                    value = value.replace(PROFILER_ARGS, sessionProperties.getProperty("profiler.info.jvmargs") + " " + agentArg);
                    config.setProperty(key, value.trim());
                }
                if (value.contains(PROFILER_ARGS_PREFIXED)) {
                    agentArg = this.fixAgentArg(sessionProperties.getProperty("profiler.info.jvmargs.agent"));
                    value = value.replace(PROFILER_ARGS_PREFIXED, (sessionProperties.getProperty("profiler.info.jvmargs") + " " + agentArg).trim().replaceAll("^|(?<= +)(?! )", "-J"));
                    config.setProperty(key, value);
                }
                if (value.contains(PROFILER_JAVA)) {
                    String profilerJava = sessionProperties.getProperty("profiler.info.jvm");
                    value = value.replace(PROFILER_JAVA, profilerJava != null && new File(profilerJava).isFile() ? profilerJava : "java");
                    config.setProperty(key, value.trim());
                }
                if (!value.contains(PROFILER_JDKHOME_OPT)) continue;
                String opt = "";
                String profilerJava = sessionProperties.getProperty("profiler.info.jvm");
                if (profilerJava != null && (binJava = new File(profilerJava)).isFile() && binJava.getName().matches("java([.]exe)?") && binJava.getParentFile().getName().equals("bin")) {
                    opt = "--jdkhome " + binJava.getParentFile().getParent();
                }
                value = value.replace(PROFILER_JDKHOME_OPT, opt);
                config.setProperty(key, value.trim());
            }
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ProfilingSettings ps = (ProfilingSettings)profilingSettings.get(RunCheckerImpl.this.project);
                    SessionSettings ss = (SessionSettings)sessionSettings.get(RunCheckerImpl.this.project);
                    Profiler.getDefault().connectToStartedApp(ps, ss);
                }
            });
        }
        return true;
    }

    private String fixAgentArg(String agentArg) {
        if ((agentArg = agentArg.replace("\\", "/")).indexOf(32) != -1) {
            return "\"" + agentArg + "\"";
        }
        return agentArg;
    }
}

